/*
 * Decompiled with CFR 0.152.
 */
package edu.columbia.tjw.item.spark;

import edu.columbia.tjw.item.ItemModel;
import edu.columbia.tjw.item.ItemParameters;
import edu.columbia.tjw.item.base.SimpleRegressor;
import edu.columbia.tjw.item.base.SimpleStatus;
import edu.columbia.tjw.item.base.StandardCurveType;
import edu.columbia.tjw.item.fit.FitResult;
import edu.columbia.tjw.item.spark.ItemClassifierSettings;
import edu.columbia.tjw.item.util.random.RandomTool;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.List;
import java.util.zip.GZIPOutputStream;
import org.apache.spark.ml.classification.ProbabilisticClassificationModel;
import org.apache.spark.ml.linalg.DenseVector;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.param.ParamMap;

public class ItemClassificationModel
extends ProbabilisticClassificationModel<Vector, ItemClassificationModel> {
    private static final long serialVersionUID = -8323021126903883638L;
    private final int[] _offsetMap;
    private final ItemClassifierSettings _settings;
    private final FitResult<SimpleStatus, SimpleRegressor, StandardCurveType> _fitResult;
    private String _uid;
    private transient ItemModel<SimpleStatus, SimpleRegressor, StandardCurveType> _model;
    private transient double[] _rawRegressors;

    public ItemClassificationModel(FitResult<SimpleStatus, SimpleRegressor, StandardCurveType> fitResult_, ItemClassifierSettings settings_) {
        this._fitResult = fitResult_;
        this._settings = settings_;
        List paramFields = this.getParams().getUniqueRegressors();
        this._offsetMap = new int[paramFields.size()];
        this._offsetMap[0] = -1;
        for (int i = 1; i < paramFields.size(); ++i) {
            SimpleRegressor next = (SimpleRegressor)paramFields.get(i);
            if (next == this.getParams().getEntryRegressor(this.getParams().getInterceptIndex(), 0)) {
                this._offsetMap[i] = -1;
                continue;
            }
            int index = this._settings.getRegressors().indexOf(next);
            if (-1 == index) {
                throw new IllegalArgumentException("Missing regressors from fields.");
            }
            this._offsetMap[i] = index;
        }
    }

    public ItemClassifierSettings getSettings() {
        return this._settings;
    }

    public Vector raw2probabilityInPlace(Vector rawProbabilities_) {
        return rawProbabilities_;
    }

    public int numClasses() {
        return ((SimpleStatus)this.getParams().getStatus()).getReachableCount();
    }

    public Vector predictRaw(Vector allRegressors_) {
        ItemModel<SimpleStatus, SimpleRegressor, StandardCurveType> model = this.getModel();
        for (int i = 0; i < this.getParams().getUniqueRegressors().size(); ++i) {
            int fieldIndex = this._offsetMap[i];
            this._rawRegressors[i] = -1 == fieldIndex ? 1.0 : allRegressors_.apply(fieldIndex);
        }
        double[] probabilities = new double[((SimpleStatus)this.getParams().getStatus()).getReachableCount()];
        model.transitionProbability(this._rawRegressors, probabilities);
        return new DenseVector(probabilities);
    }

    public ItemClassificationModel copy(ParamMap arg0) {
        return (ItemClassificationModel)this.defaultCopy(arg0);
    }

    public synchronized String uid() {
        if (null == this._uid) {
            this._uid = RandomTool.randomString((int)64);
        }
        return this._uid;
    }

    public FitResult<SimpleStatus, SimpleRegressor, StandardCurveType> getFitResult() {
        return this._fitResult;
    }

    public final ItemParameters<SimpleStatus, SimpleRegressor, StandardCurveType> getParams() {
        return this.getFitResult().getParams();
    }

    private ItemModel<SimpleStatus, SimpleRegressor, StandardCurveType> getModel() {
        if (null == this._model) {
            this._model = new ItemModel(this.getParams());
            this._rawRegressors = new double[this.getParams().getUniqueRegressors().size()];
        }
        return this._model;
    }

    public void save(String fileName_) throws IOException {
        try (FileOutputStream fout = new FileOutputStream(fileName_);
             GZIPOutputStream zipOut = new GZIPOutputStream(fout);
             ObjectOutputStream oOut = new ObjectOutputStream(zipOut);){
            oOut.writeObject((Object)this);
        }
    }

    /*
     * Exception decompiling
     */
    public static ItemClassificationModel load(String filename_) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

