/*
 * Decompiled with CFR 0.152.
 */
package edu.columbia.tjw.item.spark;

import edu.columbia.tjw.item.ItemRegressorReader;
import edu.columbia.tjw.item.base.SimpleRegressor;
import edu.columbia.tjw.item.base.SimpleStatus;
import edu.columbia.tjw.item.base.raw.RawReader;
import edu.columbia.tjw.item.data.ItemStatusGrid;
import edu.columbia.tjw.item.util.EnumFamily;
import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;

public class SparkGridAdapter
implements ItemStatusGrid<SimpleStatus, SimpleRegressor>,
Serializable {
    private final SimpleStatus _fromStatus;
    private final EnumFamily<SimpleRegressor> _regFamily;
    private final int[] _toLabels;
    private final ItemRegressorReader[] _readers;

    public SparkGridAdapter(Dataset<?> data_, String labelColumn_, String featureColumn_, List<SimpleRegressor> regressors_, SimpleStatus fromStatus_, EnumFamily<SimpleRegressor> regFamily_) {
        this._fromStatus = fromStatus_;
        int rowCount = (int)data_.count();
        int regCount = regressors_.size();
        this._regFamily = regFamily_;
        this._readers = new ItemRegressorReader[this._regFamily.size()];
        Iterator rowForm = data_.select(featureColumn_, new String[]{labelColumn_}).toLocalIterator();
        double[][] transposed = new double[regCount][rowCount];
        this._toLabels = new int[rowCount];
        int pointer = 0;
        while (rowForm.hasNext()) {
            Row next = (Row)rowForm.next();
            Vector vec = (Vector)next.get(next.fieldIndex(featureColumn_));
            Number numericLabel = (Number)next.getAs(next.fieldIndex(labelColumn_));
            String label = Integer.toString(numericLabel.intValue());
            if (vec.size() != regCount) {
                throw new IllegalArgumentException("Size mismatch.");
            }
            for (int i = 0; i < regCount; ++i) {
                transposed[i][pointer] = vec.apply(i);
            }
            SimpleStatus toStatus = (SimpleStatus)this._fromStatus.getFamily().getFromName(label);
            if (null == toStatus) {
                throw new NullPointerException("Unable to find status label: '" + label + "'");
            }
            this._toLabels[pointer] = toStatus.ordinal();
            ++pointer;
        }
        for (int i = 0; i < regCount; ++i) {
            SimpleRegressor reg = regressors_.get(i);
            RawReader wrapped = new RawReader(transposed[i]);
            this._readers[reg.ordinal()] = wrapped;
        }
    }

    public EnumFamily<SimpleStatus> getStatusFamily() {
        return this._fromStatus.getFamily();
    }

    public int getStatus(int index_) {
        return this._fromStatus.ordinal();
    }

    public int getNextStatus(int index_) {
        return this._toLabels[index_];
    }

    public boolean hasNextStatus(int index_) {
        return true;
    }

    public Set<SimpleRegressor> getAvailableRegressors() {
        return this._regFamily.getMembers();
    }

    public ItemRegressorReader getRegressorReader(SimpleRegressor field_) {
        return this._readers[field_.ordinal()];
    }

    public int size() {
        return this._toLabels.length;
    }

    public EnumFamily<SimpleRegressor> getRegressorFamily() {
        return this._regFamily;
    }
}

