/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.ann;

import breeze.linalg.DenseMatrix;
import breeze.linalg.DenseVector;
import edu.columbia.tjw.item.algo.DoubleVector;
import edu.columbia.tjw.item.util.IceTools;
import java.io.Serializable;
import org.apache.spark.ml.ann.GeneralIceLayer;
import org.apache.spark.ml.ann.GeneralIceLayerModel;
import org.apache.spark.ml.ann.IceFeedForwardModel$;
import org.apache.spark.ml.ann.IceFeedForwardTopology;
import org.apache.spark.ml.ann.IceLossFunction;
import org.apache.spark.ml.ann.Layer;
import org.apache.spark.ml.ann.LayerModel;
import org.apache.spark.ml.ann.TopologyModel;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.linalg.Vectors$;
import scala.Function1;
import scala.Predef$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005uh!B\u0017/\u0001AB\u0004\u0002C\"\u0001\u0005\u000b\u0007I\u0011A#\t\u00111\u0003!\u0011!Q\u0001\n\u0019C\u0001\"\u0014\u0001\u0003\u0006\u0004%\tA\u0014\u0005\t%\u0002\u0011\t\u0011)A\u0005\u001f\"A1\u000b\u0001BC\u0002\u0013\u0005A\u000b\u0003\u0005Y\u0001\t\u0005\t\u0015!\u0003V\u0011!I\u0006A!A!\u0002\u0013Q\u0006\"B/\u0001\t\u0013q\u0006b\u00023\u0001\u0005\u0004%\t!\u001a\u0005\u0007Y\u0002\u0001\u000b\u0011\u00024\t\u000f5\u0004!\u0019!C\u0001]\"11\u000f\u0001Q\u0001\n=Dq\u0001\u001e\u0001C\u0002\u0013\u0005Q\u000f\u0003\u0004{\u0001\u0001\u0006IA\u001e\u0005\bw\u0002\u0011\r\u0011\"\u0001}\u0011\u001d\t\u0019\u0001\u0001Q\u0001\nuD\u0011\"!\u0002\u0001\u0001\u0004%I!a\u0002\t\u0013\u0005=\u0001\u00011A\u0005\n\u0005E\u0001\u0002CA\u000f\u0001\u0001\u0006K!!\u0003\t\u0013\u0005}\u0001\u00011A\u0005\n\u0005\u0005\u0002\"CA\u0019\u0001\u0001\u0007I\u0011BA\u001a\u0011!\t9\u0004\u0001Q!\n\u0005\r\u0002\"CA\u001d\u0001\u0001\u0007I\u0011BA\u001e\u0011%\t)\u0005\u0001a\u0001\n\u0013\t9\u0005\u0003\u0005\u0002L\u0001\u0001\u000b\u0015BA\u001f\u0011%\ti\u0005\u0001a\u0001\n\u0013\tY\u0004C\u0005\u0002P\u0001\u0001\r\u0011\"\u0003\u0002R!A\u0011Q\u000b\u0001!B\u0013\ti\u0004C\u0005\u0002X\u0001\u0001\r\u0011\"\u0003\u0002<!I\u0011\u0011\f\u0001A\u0002\u0013%\u00111\f\u0005\t\u0003?\u0002\u0001\u0015)\u0003\u0002>!9\u0011\u0011\r\u0001\u0005B\u0005\r\u0004bBA:\u0001\u0011\u0005\u0013Q\u000f\u0005\b\u0003\u000b\u0003A\u0011AAD\u0011\u001d\t9\n\u0001C!\u00033Cq!!(\u0001\t\u0003\ny\nC\u0004\u0002$\u0002!\t%!*\b\u0011\u0005%f\u0006#\u0001/\u0003W3q!\f\u0018\t\u00029\ni\u000b\u0003\u0004^O\u0011\u0005\u0011Q\u0017\u0005\b\u0003o;C\u0011AA]\u0011\u001d\t9l\nC\u0001\u0003\u000bD\u0011\"!5(#\u0003%\t!a5\t\u0013\u0005%x%!A\u0005\n\u0005-(aE%dK\u001a+W\r\u001a$pe^\f'\u000fZ'pI\u0016d'BA\u00181\u0003\r\tgN\u001c\u0006\u0003cI\n!!\u001c7\u000b\u0005M\"\u0014!B:qCJ\\'BA\u001b7\u0003\u0019\t\u0007/Y2iK*\tq'A\u0002pe\u001e\u001c2\u0001A\u001d@!\tQT(D\u0001<\u0015\u0005a\u0014!B:dC2\f\u0017B\u0001 <\u0005\u0019\te.\u001f*fMB\u0011\u0001)Q\u0007\u0002]%\u0011!I\f\u0002\u000e)>\u0004x\u000e\\8hs6{G-\u001a7\u0002\u000f],\u0017n\u001a5ug\u000e\u0001Q#\u0001$\u0011\u0005\u001dSU\"\u0001%\u000b\u0005%\u0003\u0014A\u00027j]\u0006dw-\u0003\u0002L\u0011\n1a+Z2u_J\f\u0001b^3jO\"$8\u000fI\u0001\ti>\u0004x\u000e\\8hsV\tq\n\u0005\u0002A!&\u0011\u0011K\f\u0002\u0017\u0013\u000e,g)Z3e\r>\u0014x/\u0019:e)>\u0004x\u000e\\8hs\u0006IAo\u001c9pY><\u0017\u0010I\u0001\fg\u0006l\u0007\u000f\\3D_VtG/F\u0001V!\tQd+\u0003\u0002Xw\t!Aj\u001c8h\u00031\u0019\u0018-\u001c9mK\u000e{WO\u001c;!\u0003\u001dI7-Z'vYR\u0004\"AO.\n\u0005q[$A\u0002#pk\ndW-\u0001\u0004=S:LGO\u0010\u000b\u0006?\u0002\f'm\u0019\t\u0003\u0001\u0002AQa\u0011\u0005A\u0002\u0019CQ!\u0014\u0005A\u0002=CQa\u0015\u0005A\u0002UCQ!\u0017\u0005A\u0002i\u000b1\u0002^=qK\u0012d\u0015-_3sgV\ta\rE\u0002;O&L!\u0001[\u001e\u0003\u000b\u0005\u0013(/Y=\u0011\u0005\u0001S\u0017BA6/\u0005=9UM\\3sC2L5-\u001a'bs\u0016\u0014\u0018\u0001\u0004;za\u0016$G*Y=feN\u0004\u0013\u0001\u0005;za\u0016$G*Y=fe6{G-\u001a7t+\u0005y\u0007c\u0001\u001ehaB\u0011\u0001)]\u0005\u0003e:\u0012AcR3oKJ\fG.S2f\u0019\u0006LXM]'pI\u0016d\u0017!\u0005;za\u0016$G*Y=fe6{G-\u001a7tA\u00051A.Y=feN,\u0012A\u001e\t\u0004u\u001d<\bC\u0001!y\u0013\tIhFA\u0003MCf,'/A\u0004mCf,'o\u001d\u0011\u0002\u00171\f\u00170\u001a:N_\u0012,Gn]\u000b\u0002{B\u0019!h\u001a@\u0011\u0005\u0001{\u0018bAA\u0001]\tQA*Y=fe6{G-\u001a7\u0002\u00191\f\u00170\u001a:N_\u0012,Gn\u001d\u0011\u0002\r=4gm]3u+\t\tI\u0001E\u0002;\u0003\u0017I1!!\u0004<\u0005\rIe\u000e^\u0001\u000b_\u001a47/\u001a;`I\u0015\fH\u0003BA\n\u00033\u00012AOA\u000b\u0013\r\t9b\u000f\u0002\u0005+:LG\u000fC\u0005\u0002\u001cI\t\t\u00111\u0001\u0002\n\u0005\u0019\u0001\u0010J\u0019\u0002\u000f=4gm]3uA\u0005Y1-\u001e:s/\u0016Lw\r\u001b;t+\t\t\u0019\u0003E\u0003\u0002&\u00055\",\u0004\u0002\u0002()\u0019\u0011*!\u000b\u000b\u0005\u0005-\u0012A\u00022sK\u0016TX-\u0003\u0003\u00020\u0005\u001d\"a\u0003#f]N,g+Z2u_J\fqbY;se^+\u0017n\u001a5ug~#S-\u001d\u000b\u0005\u0003'\t)\u0004C\u0005\u0002\u001cU\t\t\u00111\u0001\u0002$\u0005a1-\u001e:s/\u0016Lw\r\u001b;tA\u00059q.\u001e;qkR\u001cXCAA\u001f!\u0011Qt-a\u0010\u0011\u000b\u0005\u0015\u0012\u0011\t.\n\t\u0005\r\u0013q\u0005\u0002\f\t\u0016t7/Z'biJL\u00070A\u0006pkR\u0004X\u000f^:`I\u0015\fH\u0003BA\n\u0003\u0013B\u0011\"a\u0007\u0019\u0003\u0003\u0005\r!!\u0010\u0002\u0011=,H\u000f];ug\u0002\na\u0001Z3mi\u0006\u001c\u0018A\u00033fYR\f7o\u0018\u0013fcR!\u00111CA*\u0011%\tYbGA\u0001\u0002\u0004\ti$A\u0004eK2$\u0018m\u001d\u0011\u0002\r\u001d\fW.\\1t\u0003)9\u0017-\\7bg~#S-\u001d\u000b\u0005\u0003'\ti\u0006C\u0005\u0002\u001cy\t\t\u00111\u0001\u0002>\u00059q-Y7nCN\u0004\u0013a\u00024pe^\f'\u000f\u001a\u000b\u0007\u0003{\t)'!\u001b\t\u000f\u0005\u001d\u0004\u00051\u0001\u0002@\u0005!A-\u0019;b\u0011\u001d\tY\u0007\ta\u0001\u0003[\n\u0001#\u001b8dYV$W\rT1ti2\u000b\u00170\u001a:\u0011\u0007i\ny'C\u0002\u0002rm\u0012qAQ8pY\u0016\fg.A\bd_6\u0004X\u000f^3He\u0006$\u0017.\u001a8u)%Q\u0016qOA=\u0003{\n\t\tC\u0004\u0002h\u0005\u0002\r!a\u0010\t\u000f\u0005m\u0014\u00051\u0001\u0002@\u00051A/\u0019:hKRDa!a \"\u0001\u00041\u0015aC2v[\u001e\u0013\u0018\rZ5f]RDq!a!\"\u0001\u0004\tI!A\u0007sK\u0006d')\u0019;dQNK'0Z\u0001\u0013G>l\u0007/\u001e;f\u000fJ\fG-[3oiJ\u000bw\u000fF\u0005[\u0003\u0013\u000bY)!$\u0002\u0014\"9\u0011q\r\u0012A\u0002\u0005}\u0002bBA>E\u0001\u0007\u0011q\b\u0005\b\u0003\u001f\u0013\u0003\u0019AAI\u0003A\u0019W/\\$sC\u0012LWM\u001c;BeJ\f\u0017\u0010E\u0002;OjCq!!&#\u0001\u0004\t\t*\u0001\u0006dk6<%'\u0011:sCf\fq\u0001\u001d:fI&\u001cG\u000fF\u0002G\u00037Ca!a\u001a$\u0001\u00041\u0015A\u00039sK\u0012L7\r\u001e*boR\u0019a)!)\t\r\u0005\u001dD\u00051\u0001G\u0003Y\u0011\u0018m\u001e\u001aQe>\u0014\u0017MY5mSRL\u0018J\u001c)mC\u000e,Gc\u0001$\u0002(\"1\u0011qM\u0013A\u0002\u0019\u000b1#S2f\r\u0016,GMR8so\u0006\u0014H-T8eK2\u0004\"\u0001Q\u0014\u0014\t\u001dJ\u0014q\u0016\t\u0004u\u0005E\u0016bAAZw\ta1+\u001a:jC2L'0\u00192mKR\u0011\u00111V\u0001\u0006CB\u0004H.\u001f\u000b\n?\u0006m\u0016QXA`\u0003\u0007DQ!T\u0015A\u0002=CQaQ\u0015A\u0002\u0019Ca!!1*\u0001\u0004)\u0016AC:b[BdWmU5{K\")\u0011,\u000ba\u00015RIq,a2\u0002J\u00065\u0017q\u001a\u0005\u0006\u001b*\u0002\ra\u0014\u0005\t\u0003\u0017T\u0003\u0013!a\u0001+\u0006!1/Z3e\u0011\u0019\t\tM\u000ba\u0001+\")\u0011L\u000ba\u00015\u0006y\u0011\r\u001d9ms\u0012\"WMZ1vYR$#'\u0006\u0002\u0002V*\u001aQ+a6,\u0005\u0005e\u0007\u0003BAn\u0003Kl!!!8\u000b\t\u0005}\u0017\u0011]\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a9<\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003O\fiNA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\f1B]3bIJ+7o\u001c7wKR\u0011\u0011Q\u001e\t\u0005\u0003_\fI0\u0004\u0002\u0002r*!\u00111_A{\u0003\u0011a\u0017M\\4\u000b\u0005\u0005]\u0018\u0001\u00026bm\u0006LA!a?\u0002r\n1qJ\u00196fGR\u0004")
public class IceFeedForwardModel
implements TopologyModel {
    private final Vector weights;
    private final IceFeedForwardTopology topology;
    private final long sampleCount;
    private final double iceMult;
    private final GeneralIceLayer[] typedLayers;
    private final GeneralIceLayerModel[] typedLayerModels;
    private final Layer[] layers;
    private final LayerModel[] layerModels;
    private int offset;
    private DenseVector<Object> currWeights;
    private DenseMatrix<Object>[] outputs;
    private DenseMatrix<Object>[] deltas;
    private DenseMatrix<Object>[] gammas;

    public static long apply$default$2() {
        return IceFeedForwardModel$.MODULE$.apply$default$2();
    }

    public static IceFeedForwardModel apply(IceFeedForwardTopology iceFeedForwardTopology, long l, long l2, double d) {
        return IceFeedForwardModel$.MODULE$.apply(iceFeedForwardTopology, l, l2, d);
    }

    public static IceFeedForwardModel apply(IceFeedForwardTopology iceFeedForwardTopology, Vector vector, long l, double d) {
        return IceFeedForwardModel$.MODULE$.apply(iceFeedForwardTopology, vector, l, d);
    }

    public Vector weights() {
        return this.weights;
    }

    public IceFeedForwardTopology topology() {
        return this.topology;
    }

    public long sampleCount() {
        return this.sampleCount;
    }

    public GeneralIceLayer[] typedLayers() {
        return this.typedLayers;
    }

    public GeneralIceLayerModel[] typedLayerModels() {
        return this.typedLayerModels;
    }

    public Layer[] layers() {
        return this.layers;
    }

    public LayerModel[] layerModels() {
        return this.layerModels;
    }

    private int offset() {
        return this.offset;
    }

    private void offset_$eq(int x$1) {
        this.offset = x$1;
    }

    private DenseVector<Object> currWeights() {
        return this.currWeights;
    }

    private void currWeights_$eq(DenseVector<Object> x$1) {
        this.currWeights = x$1;
    }

    private DenseMatrix<Object>[] outputs() {
        return this.outputs;
    }

    private void outputs_$eq(DenseMatrix<Object>[] x$1) {
        this.outputs = x$1;
    }

    private DenseMatrix<Object>[] deltas() {
        return this.deltas;
    }

    private void deltas_$eq(DenseMatrix<Object>[] x$1) {
        this.deltas = x$1;
    }

    private DenseMatrix<Object>[] gammas() {
        return this.gammas;
    }

    private void gammas_$eq(DenseMatrix<Object>[] x$1) {
        this.gammas = x$1;
    }

    public DenseMatrix<Object>[] forward(DenseMatrix<Object> data, boolean includeLastLayer) {
        int currentBatchSize = data.cols();
        if (this.outputs() == null || this.outputs()[0].cols() != currentBatchSize) {
            this.outputs_$eq(new DenseMatrix[this.layers().length]);
            IntRef inputSize = IntRef.create((int)data.rows());
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.layers().length).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                if (this.layers()[i].inPlace()) {
                    $this.outputs()[i] = this.outputs()[i - 1];
                } else {
                    int outputSize = this.layers()[i].getOutputSize(inputSize$1.elem);
                    $this.outputs()[i] = new DenseMatrix.mcD.sp(outputSize, currentBatchSize, ClassTag$.MODULE$.Double());
                    inputSize$1.elem = outputSize;
                }
            });
        }
        this.layerModels()[0].eval(data, this.outputs()[0]);
        int end = includeLastLayer ? this.layerModels().length : this.layerModels().length - 1;
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(1), end).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> this.layerModels()[i].eval(this.outputs()[i - 1], this.outputs()[i]));
        return this.outputs();
    }

    public double computeGradient(DenseMatrix<Object> data, DenseMatrix<Object> target, Vector cumGradient, int realBatchSize) {
        double[] cumGradientArray = cumGradient.toArray();
        double[] cumG2Array = (double[])cumGradientArray.clone();
        return this.computeGradientRaw(data, target, cumGradient.toArray(), cumG2Array);
    }

    public double computeGradientRaw(DenseMatrix<Object> data, DenseMatrix<Object> target, double[] cumGradientArray, double[] cumG2Array) {
        DenseMatrix<Object>[] outputs = this.forward(data, true);
        int currentBatchSize = data.cols();
        if (this.deltas() == null || this.deltas()[0].cols() != currentBatchSize) {
            this.deltas_$eq(new DenseMatrix[this.layerModels().length]);
            this.gammas_$eq(new DenseMatrix[this.layerModels().length]);
            IntRef inputSize = IntRef.create((int)data.rows());
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.layerModels().length - 1).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                int outputSize = this.layers()[i].getOutputSize(inputSize$2.elem);
                $this.deltas()[i] = new DenseMatrix.mcD.sp(outputSize, currentBatchSize, ClassTag$.MODULE$.Double());
                $this.gammas()[i] = new DenseMatrix.mcD.sp(outputSize, currentBatchSize, ClassTag$.MODULE$.Double());
                inputSize$2.elem = outputSize;
            });
        }
        int L = this.layerModels().length - 1;
        LayerModel layerModel = (LayerModel)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.layerModels())).last();
        if (!(layerModel instanceof IceLossFunction)) {
            throw new UnsupportedOperationException("Top layer is required to have objective.");
        }
        LayerModel layerModel2 = layerModel;
        double d = ((IceLossFunction)layerModel2).loss((DenseMatrix<Object>)((DenseMatrix)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])outputs)).last()), target, this.deltas()[L - 1], this.gammas()[L - 1]);
        double loss = d;
        RichInt$.MODULE$.to$extension1(Predef$.MODULE$.intWrapper(L - 2), 0, -1).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> this.typedLayerModels()[i + 1].computePrevDeltaExpanded(this.deltas()[i + 1], this.deltas()[i + 2], this.gammas()[i + 1], (DenseMatrix<Object>)outputs[i + 2], (DenseMatrix<Object>)outputs[i + 1], this.deltas()[i], this.gammas()[i]));
        IntRef offset = IntRef.create((int)0);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), L).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            DenseMatrix input = i == 0 ? data : outputs[i - 1];
            DenseVector.mcD.sp g2Vec = new DenseVector.mcD.sp(cumG2Array, offset$1.elem, 1, this.layers()[i].weightSize());
            this.typedLayerModels()[i].grad2(this.deltas()[i], this.deltas()[i + 1], this.gammas()[i], (DenseMatrix<Object>)input, (DenseMatrix<Object>)outputs[i], (DenseVector<Object>)g2Vec);
            offset$1.elem += this.layers()[i].weightSize();
        });
        DoubleVector g2Weights = IceTools.computeJWeight((DoubleVector)DoubleVector.of((double[])cumG2Array, (boolean)false)).collapse();
        offset.elem = 0;
        DoubleVector g2Vec = DoubleVector.of((double[])cumG2Array, (boolean)false);
        DenseMatrix[] weightGradArray = new DenseMatrix[this.layerModels().length];
        DenseVector[] biasGradArray = new DenseVector[this.layerModels().length];
        double[] tmpGradArray = new double[cumGradientArray.length];
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.layerModels().length).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            int weightSize = this.layers()[i].weightSize();
            if (weightSize != 0) {
                int outputSize = this.layers()[i].getOutputSize(1);
                int inputSize = weightSize / outputSize - 1;
                weightGradArray$1[i] = new DenseMatrix.mcD.sp(outputSize, inputSize, tmpGradArray, offset$1.elem);
                biasGradArray$1[i] = new DenseVector.mcD.sp(tmpGradArray, offset$1.elem + inputSize * outputSize, 1, outputSize);
            }
            offset$1.elem += weightSize;
        });
        offset.elem = 0;
        double invObsCount = 1.0 / (double)this.sampleCount();
        double invBlockCount = 1.0 / (double)data.cols();
        double lossAdj = 0.0;
        for (int m = 0; m < data.cols(); ++m) {
            int i2;
            for (i2 = 0; i2 < this.layerModels().length; ++i2) {
                DenseMatrix<Object> input = i2 == 0 ? data : outputs[i2 - 1];
                this.typedLayerModels()[i2].singleGrad(this.deltas()[i2], input, m, (DenseMatrix<Object>)weightGradArray[i2], (DenseVector<Object>)biasGradArray[i2]);
            }
            double iceAdjustment = invObsCount * IceTools.computeIce3Sum((double[])tmpGradArray, (DoubleVector)g2Vec, (DoubleVector)g2Weights, (boolean)false, (boolean)true);
            lossAdj += this.iceMult * iceAdjustment;
            double adjScale = 2.0 * this.iceMult * iceAdjustment;
            i2 = 0;
            while (i2 < tmpGradArray.length) {
                double nextGrad = invBlockCount * tmpGradArray[i2];
                double gradAdj = nextGrad + nextGrad * adjScale;
                int n = i2++;
                cumGradientArray[n] = cumGradientArray[n] + gradAdj;
            }
        }
        double iceLoss = loss + (lossAdj *= invBlockCount);
        return iceLoss;
    }

    public Vector predict(Vector data) {
        int size = data.size();
        DenseMatrix<Object>[] result = this.forward((DenseMatrix<Object>)new DenseMatrix.mcD.sp(size, 1, data.toArray()), true);
        return Vectors$.MODULE$.dense(((DenseMatrix)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])result)).last()).toArray$mcD$sp());
    }

    public Vector predictRaw(Vector data) {
        DenseMatrix<Object>[] result = this.forward((DenseMatrix<Object>)new DenseMatrix.mcD.sp(data.size(), 1, data.toArray()), false);
        return Vectors$.MODULE$.dense(result[result.length - 2].toArray$mcD$sp());
    }

    public Vector raw2ProbabilityInPlace(Vector data) {
        DenseMatrix.mcD.sp dataMatrix = new DenseMatrix.mcD.sp(data.size(), 1, data.toArray());
        ((LayerModel)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.layerModels())).last()).eval((DenseMatrix)dataMatrix, (DenseMatrix)dataMatrix);
        return data;
    }

    public IceFeedForwardModel(Vector weights, IceFeedForwardTopology topology, long sampleCount, double iceMult) {
        this.weights = weights;
        this.topology = topology;
        this.sampleCount = sampleCount;
        this.iceMult = iceMult;
        this.typedLayers = topology.layers();
        this.typedLayerModels = new GeneralIceLayerModel[this.typedLayers().length];
        this.layers = new Layer[this.typedLayers().length];
        this.layerModels = new LayerModel[this.layers().length];
        this.offset = 0;
        this.currWeights = new DenseVector.mcD.sp(weights.toArray(), this.offset(), 1, 0);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.typedLayers().length).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            $this.layers()[i] = this.typedLayers()[i];
            int weightSize = this.typedLayers()[i].weightSize();
            if (weightSize > 0) {
                this.currWeights_$eq((DenseVector<Object>)new DenseVector.mcD.sp(this.weights().toArray(), this.offset(), 1, this.typedLayers()[i].weightSize()));
            }
            $this.typedLayerModels()[i] = this.typedLayers()[i].createModel(this.currWeights());
            if (i > 0) {
                this.typedLayerModels()[i - 1].setNextLayer(this.typedLayerModels()[i]);
            }
            $this.layerModels()[i] = this.typedLayerModels()[i];
            this.offset_$eq(this.offset() + weightSize);
        });
        this.outputs = null;
        this.deltas = null;
        this.gammas = null;
    }
}

