/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.classification;

import java.io.IOException;
import java.io.Serializable;
import org.apache.spark.ml.PipelineStage;
import org.apache.spark.ml.ann.FeedForwardTrainer;
import org.apache.spark.ml.ann.IceFeedForwardTopology;
import org.apache.spark.ml.ann.IceFeedForwardTopology$;
import org.apache.spark.ml.ann.IcePerceptronClassificationModel;
import org.apache.spark.ml.ann.Topology;
import org.apache.spark.ml.ann.TopologyModel;
import org.apache.spark.ml.classification.IcePerceptronClassifier$;
import org.apache.spark.ml.classification.MultilayerPerceptronClassificationModel;
import org.apache.spark.ml.classification.MultilayerPerceptronParams;
import org.apache.spark.ml.classification.ProbabilisticClassifier;
import org.apache.spark.ml.feature.OneHotEncoderModel;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.param.DoubleParam;
import org.apache.spark.ml.param.IntArrayParam;
import org.apache.spark.ml.param.IntParam;
import org.apache.spark.ml.param.LongParam;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.ParamValidators$;
import org.apache.spark.ml.param.Params;
import org.apache.spark.ml.param.shared.HasBlockSize;
import org.apache.spark.ml.param.shared.HasMaxIter;
import org.apache.spark.ml.param.shared.HasSeed;
import org.apache.spark.ml.param.shared.HasSolver;
import org.apache.spark.ml.param.shared.HasStepSize;
import org.apache.spark.ml.param.shared.HasTol;
import org.apache.spark.ml.util.DefaultParamsWritable;
import org.apache.spark.ml.util.Identifiable;
import org.apache.spark.ml.util.Identifiable$;
import org.apache.spark.ml.util.Instrumentation$;
import org.apache.spark.ml.util.MLReader;
import org.apache.spark.ml.util.MLWritable;
import org.apache.spark.ml.util.MLWriter;
import org.apache.spark.mllib.optimization.LBFGS;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005mg\u0001B\u000f\u001f\u0001%B\u0001\"\u0011\u0001\u0003\u0006\u0004%\tE\u0011\u0005\t3\u0002\u0011\t\u0011)A\u0005\u0007\")1\f\u0001C\u00019\"9\u0001\r\u0001b\u0001\n\u000b\t\u0007B\u00025\u0001A\u00035!\rC\u0003j\u0001\u0011\u0005!\u000eC\u0003\\\u0001\u0011\u0005!\u000fC\u0003u\u0001\u0011\u0005Q\u000fC\u0003\u007f\u0001\u0011\u0005q\u0010C\u0004\u0002\u0006\u0001!\t!a\u0002\t\u000f\u0005E\u0001\u0001\"\u0001\u0002\u0014!9\u0011\u0011\u0004\u0001\u0005\u0002\u0005m\u0001bBA\u0011\u0001\u0011\u0005\u00111\u0005\u0005\b\u0003_\u0001A\u0011AA\u0019\u0011\u001d\t9\u0004\u0001C\u0001\u0003sAq!a\u0010\u0001\t\u0003\n\t\u0005C\u0004\u0002P\u0001!\t&!\u0015\b\u000f\u0005%e\u0004#\u0001\u0002\f\u001a1QD\bE\u0001\u0003\u001bCaaW\n\u0005\u0002\u0005\u0005\u0006BCAR'\t\u0007I\u0011\u0001\u0010\u0002&\"A\u0011QW\n!\u0002\u0013\t9\u000b\u0003\u0006\u00028N\u0011\r\u0011\"\u0001\u001f\u0003KC\u0001\"!/\u0014A\u0003%\u0011q\u0015\u0005\u000b\u0003w\u001b\"\u0019!C\u0001=\u0005u\u0006\u0002CAa'\u0001\u0006I!a0\t\u000f\u0005\r7\u0003\"\u0011\u0002F\"I\u0011QZ\n\u0002\u0002\u0013%\u0011q\u001a\u0002\u0018\u0013\u000e,\u0007+\u001a:dKB$(o\u001c8DY\u0006\u001c8/\u001b4jKJT!a\b\u0011\u0002\u001d\rd\u0017m]:jM&\u001c\u0017\r^5p]*\u0011\u0011EI\u0001\u0003[2T!a\t\u0013\u0002\u000bM\u0004\u0018M]6\u000b\u0005\u00152\u0013AB1qC\u000eDWMC\u0001(\u0003\ry'oZ\u0002\u0001'\u0011\u0001!\u0006O\u001e\u0011\u000b-bc\u0006N\u001b\u000e\u0003yI!!\f\u0010\u0003/A\u0013xNY1cS2L7\u000f^5d\u00072\f7o]5gS\u0016\u0014\bCA\u00183\u001b\u0005\u0001$BA\u0019!\u0003\u0019a\u0017N\\1mO&\u00111\u0007\r\u0002\u0007-\u0016\u001cGo\u001c:\u0011\u0005-\u0002\u0001CA\u00167\u0013\t9dDA\u0014Nk2$\u0018\u000e\\1zKJ\u0004VM]2faR\u0014xN\\\"mCN\u001c\u0018NZ5dCRLwN\\'pI\u0016d\u0007CA\u0016:\u0013\tQdD\u0001\u000eNk2$\u0018\u000e\\1zKJ\u0004VM]2faR\u0014xN\u001c)be\u0006l7\u000f\u0005\u0002=\u007f5\tQH\u0003\u0002?A\u0005!Q\u000f^5m\u0013\t\u0001UHA\u000bEK\u001a\fW\u000f\u001c;QCJ\fWn],sSR\f'\r\\3\u0002\u0007ULG-F\u0001D!\t!UJ\u0004\u0002F\u0017B\u0011a)S\u0007\u0002\u000f*\u0011\u0001\nK\u0001\u0007yI|w\u000e\u001e \u000b\u0003)\u000bQa]2bY\u0006L!\u0001T%\u0002\rA\u0013X\rZ3g\u0013\tquJ\u0001\u0004TiJLgn\u001a\u0006\u0003\u0019&C3!A)X!\t\u0011V+D\u0001T\u0015\t!&%\u0001\u0006b]:|G/\u0019;j_:L!AV*\u0003\u000bMKgnY3\"\u0003a\u000bQ!\r\u00186]A\nA!^5eA!\u001a!!U,\u0002\rqJg.\u001b;?)\t!T\fC\u0003B\u0007\u0001\u00071\tK\u0002^#^C3aA)X\u0003!I7-Z*dC2,W#\u00012\u0011\u0005\r4W\"\u00013\u000b\u0005\u0015\u0004\u0013!\u00029be\u0006l\u0017BA4e\u0005-!u.\u001e2mKB\u000b'/Y7\u0002\u0013%\u001cWmU2bY\u0016\u0004\u0013\u0001D:fi&\u001bWMR1di>\u0014HCA6m\u001b\u0005\u0001\u0001\"B7\u0007\u0001\u0004q\u0017!\u0002<bYV,\u0007CA8q\u001b\u0005I\u0015BA9J\u0005\u0019!u.\u001e2mKR\tA\u0007K\u0002\b#^\u000b\u0011b]3u\u0019\u0006LXM]:\u0015\u0005-4\b\"B7\t\u0001\u00049\bcA8yu&\u0011\u00110\u0013\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0003_nL!\u0001`%\u0003\u0007%sG\u000fK\u0002\t#^\u000bAb]3u\u00052|7m[*ju\u0016$2a[A\u0001\u0011\u0015i\u0017\u00021\u0001{Q\rI\u0011kV\u0001\ng\u0016$8k\u001c7wKJ$2a[A\u0005\u0011\u0015i'\u00021\u0001DQ\u0011Q\u0011+!\u0004\"\u0005\u0005=\u0011!\u0002\u001a/a9\u0002\u0014AC:fi6\u000b\u00070\u0013;feR\u00191.!\u0006\t\u000b5\\\u0001\u0019\u0001>)\u0007-\tv+\u0001\u0004tKR$v\u000e\u001c\u000b\u0004W\u0006u\u0001\"B7\r\u0001\u0004q\u0007f\u0001\u0007R/\u000691/\u001a;TK\u0016$GcA6\u0002&!1Q.\u0004a\u0001\u0003O\u00012a\\A\u0015\u0013\r\tY#\u0013\u0002\u0005\u0019>tw\rK\u0002\u000e#^\u000b\u0011c]3u\u0013:LG/[1m/\u0016Lw\r\u001b;t)\rY\u00171\u0007\u0005\u0006[:\u0001\rA\f\u0015\u0005\u001dE\u000bi!A\u0006tKR\u001cF/\u001a9TSj,GcA6\u0002<!)Qn\u0004a\u0001]\"\"q\"UA\u0007\u0003\u0011\u0019w\u000e]=\u0015\u0007Q\n\u0019\u0005C\u0004\u0002FA\u0001\r!a\u0012\u0002\u000b\u0015DHO]1\u0011\u0007\r\fI%C\u0002\u0002L\u0011\u0014\u0001\u0002U1sC6l\u0015\r\u001d\u0015\u0004!E;\u0016!\u0002;sC&tG\u0003BA*\u0003?\u0002B!!\u0016\u0002\\5\u0011\u0011q\u000b\u0006\u0004\u00033\u0002\u0013aA1o]&!\u0011QLA,\u0005\u0001J5-\u001a)fe\u000e,\u0007\u000f\u001e:p]\u000ec\u0017m]:jM&\u001c\u0017\r^5p]6{G-\u001a7\t\u000f\u0005\u0005\u0014\u00031\u0001\u0002d\u00059A-\u0019;bg\u0016$\b\u0007BA3\u0003k\u0002b!a\u001a\u0002n\u0005ETBAA5\u0015\r\tYGI\u0001\u0004gFd\u0017\u0002BA8\u0003S\u0012q\u0001R1uCN,G\u000f\u0005\u0003\u0002t\u0005UD\u0002\u0001\u0003\r\u0003o\ny&!A\u0001\u0002\u000b\u0005\u0011\u0011\u0010\u0002\u0004?\u0012\n\u0014\u0003BA>\u0003\u0003\u00032a\\A?\u0013\r\ty(\u0013\u0002\b\u001d>$\b.\u001b8h!\ry\u00171Q\u0005\u0004\u0003\u000bK%aA!os\"\u001a\u0001!U,\u0002/%\u001bW\rU3sG\u0016\u0004HO]8o\u00072\f7o]5gS\u0016\u0014\bCA\u0016\u0014'\u001d\u0019\u0012qRAK\u00037\u00032a\\AI\u0013\r\t\u0019*\u0013\u0002\u0007\u0003:L(+\u001a4\u0011\tq\n9\nN\u0005\u0004\u00033k$!\u0006#fM\u0006,H\u000e\u001e)be\u0006l7OU3bI\u0006\u0014G.\u001a\t\u0004_\u0006u\u0015bAAP\u0013\na1+\u001a:jC2L'0\u00192mKR\u0011\u00111R\u0001\u0006\u0019\n3uiU\u000b\u0003\u0003O\u0003B!!+\u000246\u0011\u00111\u0016\u0006\u0005\u0003[\u000by+\u0001\u0003mC:<'BAAY\u0003\u0011Q\u0017M^1\n\u00079\u000bY+\u0001\u0004M\u0005\u001a;5\u000bI\u0001\u0003\u000f\u0012\u000b1a\u0012#!\u0003A\u0019X\u000f\u001d9peR,GmU8mm\u0016\u00148/\u0006\u0002\u0002@B!q\u000e_AT\u0003E\u0019X\u000f\u001d9peR,GmU8mm\u0016\u00148\u000fI\u0001\u0005Y>\fG\rF\u00025\u0003\u000fDa!!3\u001c\u0001\u0004\u0019\u0015\u0001\u00029bi\"DCaG)\u0002\u000e\u0005Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\t\t\u000e\u0005\u0003\u0002*\u0006M\u0017\u0002BAk\u0003W\u0013aa\u00142kK\u000e$\b\u0006B\nR\u0003\u001bACAE)\u0002\u000e\u0001")
public class IcePerceptronClassifier
extends ProbabilisticClassifier<Vector, IcePerceptronClassifier, MultilayerPerceptronClassificationModel>
implements MultilayerPerceptronParams,
DefaultParamsWritable {
    private final String uid;
    private final DoubleParam iceScale;
    private final IntArrayParam layers;
    private final Param<String> solver;
    private final Param<Vector> initialWeights;
    private final IntParam blockSize;
    private final DoubleParam stepSize;
    private final DoubleParam tol;
    private final IntParam maxIter;
    private final LongParam seed;

    public static IcePerceptronClassifier load(String string) {
        return IcePerceptronClassifier$.MODULE$.load(string);
    }

    public static MLReader<IcePerceptronClassifier> read() {
        return IcePerceptronClassifier$.MODULE$.read();
    }

    public MLWriter write() {
        return DefaultParamsWritable.write$((DefaultParamsWritable)this);
    }

    public void save(String path) throws IOException {
        MLWritable.save$((MLWritable)this, (String)path);
    }

    public final int[] getLayers() {
        return MultilayerPerceptronParams.getLayers$((MultilayerPerceptronParams)this);
    }

    public final Vector getInitialWeights() {
        return MultilayerPerceptronParams.getInitialWeights$((MultilayerPerceptronParams)this);
    }

    public final int getBlockSize() {
        return HasBlockSize.getBlockSize$((HasBlockSize)this);
    }

    public final String getSolver() {
        return HasSolver.getSolver$((HasSolver)this);
    }

    public final double getStepSize() {
        return HasStepSize.getStepSize$((HasStepSize)this);
    }

    public final double getTol() {
        return HasTol.getTol$((HasTol)this);
    }

    public final int getMaxIter() {
        return HasMaxIter.getMaxIter$((HasMaxIter)this);
    }

    public final long getSeed() {
        return HasSeed.getSeed$((HasSeed)this);
    }

    public final IntArrayParam layers() {
        return this.layers;
    }

    public final Param<String> solver() {
        return this.solver;
    }

    public final Param<Vector> initialWeights() {
        return this.initialWeights;
    }

    public final void org$apache$spark$ml$classification$MultilayerPerceptronParams$_setter_$layers_$eq(IntArrayParam x$1) {
        this.layers = x$1;
    }

    public final void org$apache$spark$ml$classification$MultilayerPerceptronParams$_setter_$solver_$eq(Param<String> x$1) {
        this.solver = x$1;
    }

    public final void org$apache$spark$ml$classification$MultilayerPerceptronParams$_setter_$initialWeights_$eq(Param<Vector> x$1) {
        this.initialWeights = x$1;
    }

    public final IntParam blockSize() {
        return this.blockSize;
    }

    public final void org$apache$spark$ml$param$shared$HasBlockSize$_setter_$blockSize_$eq(IntParam x$1) {
        this.blockSize = x$1;
    }

    public void org$apache$spark$ml$param$shared$HasSolver$_setter_$solver_$eq(Param<String> x$1) {
    }

    public DoubleParam stepSize() {
        return this.stepSize;
    }

    public void org$apache$spark$ml$param$shared$HasStepSize$_setter_$stepSize_$eq(DoubleParam x$1) {
        this.stepSize = x$1;
    }

    public final DoubleParam tol() {
        return this.tol;
    }

    public final void org$apache$spark$ml$param$shared$HasTol$_setter_$tol_$eq(DoubleParam x$1) {
        this.tol = x$1;
    }

    public final IntParam maxIter() {
        return this.maxIter;
    }

    public final void org$apache$spark$ml$param$shared$HasMaxIter$_setter_$maxIter_$eq(IntParam x$1) {
        this.maxIter = x$1;
    }

    public final LongParam seed() {
        return this.seed;
    }

    public final void org$apache$spark$ml$param$shared$HasSeed$_setter_$seed_$eq(LongParam x$1) {
        this.seed = x$1;
    }

    public String uid() {
        return this.uid;
    }

    public final DoubleParam iceScale() {
        return this.iceScale;
    }

    public IcePerceptronClassifier setIceFactor(double value) {
        return (IcePerceptronClassifier)this.set((Param)this.iceScale(), BoxesRunTime.boxToDouble((double)value));
    }

    public IcePerceptronClassifier setLayers(int[] value) {
        return (IcePerceptronClassifier)this.set((Param)this.layers(), value);
    }

    public IcePerceptronClassifier setBlockSize(int value) {
        return (IcePerceptronClassifier)this.set((Param)this.blockSize(), BoxesRunTime.boxToInteger((int)value));
    }

    public IcePerceptronClassifier setSolver(String value) {
        return (IcePerceptronClassifier)this.set(this.solver(), value);
    }

    public IcePerceptronClassifier setMaxIter(int value) {
        return (IcePerceptronClassifier)this.set((Param)this.maxIter(), BoxesRunTime.boxToInteger((int)value));
    }

    public IcePerceptronClassifier setTol(double value) {
        return (IcePerceptronClassifier)this.set((Param)this.tol(), BoxesRunTime.boxToDouble((double)value));
    }

    public IcePerceptronClassifier setSeed(long value) {
        return (IcePerceptronClassifier)this.set((Param)this.seed(), BoxesRunTime.boxToLong((long)value));
    }

    public IcePerceptronClassifier setInitialWeights(Vector value) {
        return (IcePerceptronClassifier)this.set(this.initialWeights(), value);
    }

    public IcePerceptronClassifier setStepSize(double value) {
        return (IcePerceptronClassifier)this.set((Param)this.stepSize(), BoxesRunTime.boxToDouble((double)value));
    }

    public IcePerceptronClassifier copy(ParamMap extra) {
        return (IcePerceptronClassifier)this.defaultCopy(extra);
    }

    public IcePerceptronClassificationModel train(Dataset<?> dataset) {
        IcePerceptronClassificationModel icePerceptronClassificationModel;
        Object object = new Object();
        try {
            icePerceptronClassificationModel = (IcePerceptronClassificationModel)((Object)Instrumentation$.MODULE$.instrumented((Function1 & Serializable & scala.Serializable)instr -> {
                LBFGS lBFGS;
                instr.logPipelineStage((PipelineStage)this);
                instr.logDataset(dataset);
                instr.logParams((Params)this, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Param[]{this.labelCol(), this.featuresCol(), this.predictionCol(), this.layers(), this.maxIter(), this.tol(), this.blockSize(), this.solver(), this.stepSize(), this.seed()}));
                double iceMult = BoxesRunTime.unboxToDouble((Object)this.get((Param)this.iceScale()).getOrElse((Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> 1.0));
                int[] myLayers = (int[])this.$((Param)this.layers());
                int labels = BoxesRunTime.unboxToInt((Object)new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(myLayers)).last());
                instr.logNumClasses((long)labels);
                instr.logNumFeatures((long)BoxesRunTime.unboxToInt((Object)new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(myLayers)).head()));
                String encodedLabelCol = new StringBuilder(8).append("_encoded").append(this.$(this.labelCol())).toString();
                OneHotEncoderModel encodeModel = new OneHotEncoderModel(this.uid(), new int[]{labels}).setInputCols((String[])((Object[])new String[]{(String)this.$(this.labelCol())})).setOutputCols((String[])((Object[])new String[]{encodedLabelCol})).setDropLast(false);
                Dataset encodedDataset = encodeModel.transform(dataset);
                RDD data = encodedDataset.select((String)this.$(this.featuresCol()), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{encodedLabelCol})).rdd().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    Vector vector;
                    Object encodedLabel;
                    block3: {
                        Row row;
                        block2: {
                            row = x0$1;
                            Some some = Row$.MODULE$.unapplySeq(row);
                            if (some.isEmpty() || some.get() == null || ((SeqLike)some.get()).lengthCompare(2) != 0) break block2;
                            Object features = ((SeqLike)some.get()).apply(0);
                            encodedLabel = ((SeqLike)some.get()).apply(1);
                            if (!(features instanceof Vector)) break block2;
                            vector = (Vector)features;
                            if (encodedLabel instanceof Vector) break block3;
                        }
                        throw new MatchError((Object)row);
                    }
                    Vector vector2 = (Vector)encodedLabel;
                    Tuple2 tuple2 = new Tuple2((Object)vector, (Object)vector2);
                    return tuple2;
                }, ClassTag$.MODULE$.apply(Tuple2.class));
                IceFeedForwardTopology topology = IceFeedForwardTopology$.MODULE$.multiLayerPerceptron(myLayers, dataset.count(), iceMult);
                FeedForwardTrainer trainer = new FeedForwardTrainer((Topology)topology, myLayers[0], BoxesRunTime.unboxToInt((Object)new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(myLayers)).last()));
                FeedForwardTrainer feedForwardTrainer = this.isDefined(this.initialWeights()) ? trainer.setWeights((Vector)this.$(this.initialWeights())) : trainer.setSeed(BoxesRunTime.unboxToLong((Object)this.$((Param)this.seed())));
                Object object = this.$(this.solver());
                String string = IcePerceptronClassifier$.MODULE$.LBFGS();
                if (!(object != null ? !object.equals(string) : string != null)) {
                    lBFGS = trainer.LBFGSOptimizer().setConvergenceTol(BoxesRunTime.unboxToDouble((Object)this.$((Param)this.tol()))).setNumIterations(BoxesRunTime.unboxToInt((Object)this.$((Param)this.maxIter())));
                } else {
                    Object object2 = this.$(this.solver());
                    String string2 = IcePerceptronClassifier$.MODULE$.GD();
                    if (!(object2 != null ? !object2.equals(string2) : string2 != null)) {
                        lBFGS = trainer.SGDOptimizer().setNumIterations(BoxesRunTime.unboxToInt((Object)this.$((Param)this.maxIter()))).setConvergenceTol(BoxesRunTime.unboxToDouble((Object)this.$((Param)this.tol()))).setStepSize(BoxesRunTime.unboxToDouble((Object)this.$((Param)this.stepSize())));
                    } else {
                        throw new IllegalArgumentException(new StringBuilder(63).append("The solver ").append(this.solver()).append(" is not supported by MultilayerPerceptronClassifier.").toString());
                    }
                }
                trainer.setStackSize(BoxesRunTime.unboxToInt((Object)this.$((Param)this.blockSize())));
                TopologyModel mlpModel = trainer.train(data);
                throw new NonLocalReturnControl(object, (Object)new IcePerceptronClassificationModel(this.uid(), myLayers, mlpModel.weights(), BoxesRunTime.unboxToInt((Object)this.$((Param)this.blockSize()))));
            }));
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                icePerceptronClassificationModel = (IcePerceptronClassificationModel)((Object)ex.value());
            }
            throw ex;
        }
        return icePerceptronClassificationModel;
    }

    public IcePerceptronClassifier(String uid) {
        this.uid = uid;
        HasSeed.$init$((HasSeed)this);
        HasMaxIter.$init$((HasMaxIter)this);
        HasTol.$init$((HasTol)this);
        HasStepSize.$init$((HasStepSize)this);
        HasSolver.$init$((HasSolver)this);
        HasBlockSize.$init$((HasBlockSize)this);
        MultilayerPerceptronParams.$init$((MultilayerPerceptronParams)this);
        MLWritable.$init$((MLWritable)this);
        DefaultParamsWritable.$init$((DefaultParamsWritable)this);
        this.iceScale = new DoubleParam((Identifiable)this, "iceScale", "Ice effect scale, in [0, 1] where 0 is MLE and 1.0 is full ICE.", ParamValidators$.MODULE$.inRange(0.0, 1.0));
    }

    public IcePerceptronClassifier() {
        this(Identifiable$.MODULE$.randomUID("mlpc"));
    }
}

