/*
 * Decompiled with CFR 0.152.
 */
package edu.msudenver.cs.jclo;

import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Properties;

public class JCLO {
    private Field[] fields;
    private Object object;
    private boolean doubleDashes;
    private boolean hasEquals;
    private String prefix = "";
    private String[][] aliases;

    public JCLO(Object object) {
        this(null, object, null);
    }

    public JCLO(Object object, String[][] aliases) {
        this(null, object, aliases);
    }

    public JCLO(String prefix, Object object) {
        this(prefix, object, null);
    }

    public JCLO(String prefix, Object object, String[][] aliases) {
        this.object = object;
        this.prefix = prefix;
        this.aliases = aliases;
        this.fields = object.getClass().getDeclaredFields();
        for (int i = 0; i < this.fields.length; ++i) {
            this.fields[i].setAccessible(true);
        }
    }

    private Object getObject(Field f) {
        try {
            return f.get(this.object);
        }
        catch (IllegalAccessException iae) {
            iae.printStackTrace();
            System.exit(1);
            return null;
        }
    }

    private Field getField(String key) {
        Object f = null;
        if (this.prefix != null) {
            key = this.prefix + key;
        }
        for (int i = 0; i < this.fields.length; ++i) {
            String name = this.fields[i].getName();
            if (!name.equals(key)) continue;
            return this.fields[i];
        }
        return null;
    }

    public Object getValue(String key) {
        Field f = this.getField(key);
        if (f == null) {
            System.out.println("Field not found: " + key);
            return null;
        }
        return this.getObject(f);
    }

    private void setObject(Field f, Object o) {
        try {
            f.set(this.object, o);
        }
        catch (IllegalAccessException iae) {
            iae.printStackTrace();
        }
    }

    private String getArrayType(Class type) {
        return type.getComponentType().toString().replaceFirst("class.*\\.", "");
    }

    public String toString() {
        String r = "";
        boolean first = true;
        for (int i = 0; i < this.fields.length; ++i) {
            Field field = this.fields[i];
            String key = field.getName();
            Class<?> type = field.getType();
            Object object = this.getObject(field);
            if (!first) {
                r = r + "\n";
            }
            first = false;
            if (type.isArray()) {
                r = r + this.getArrayType(type) + "[]" + ": " + key + " = ";
                r = r + Arrays.toString((Object[])object);
                continue;
            }
            r = r + type.toString().replaceFirst("class java.lang.", "") + ": " + key + " = " + object;
        }
        return r;
    }

    private String getUsageType(Class type) {
        if (type.getName().equals("boolean")) {
            return this.doubleDashes ? "[=boolean]" : "";
        }
        if (type.isArray()) {
            return (this.doubleDashes ? "=" : " ") + this.getArrayType(type) + "...";
        }
        return (this.doubleDashes ? "=" : " ") + type.getName().replaceFirst("java.lang.", "");
    }

    public String usage() {
        boolean additional = false;
        Object[] a = new String[this.fields.length];
        int count = 0;
        for (int i = 0; i < this.fields.length; ++i) {
            Field field = this.fields[i];
            String key = field.getName();
            Class<?> type = field.getType();
            if (key.equals("additional")) continue;
            if (this.prefix != null) {
                if (!key.startsWith(this.prefix)) continue;
                key = key.replaceFirst("^" + this.prefix, "");
            }
            if (Modifier.isFinal(field.getModifiers())) continue;
            key = key.replaceFirst("^_([0-9])", "$1");
            key = key.replaceAll("__", "-");
            key = key.replaceAll("_\\$", ".");
            a[count++] = (this.doubleDashes ? "--" : "-") + key + this.getUsageType(type) + "\n";
        }
        String r = "";
        Arrays.sort(a, 0, count);
        for (int i = 0; i < a.length; ++i) {
            if (a[i] == null) continue;
            r = r + (String)a[i];
        }
        return r;
    }

    private void parseAdditional(String[] args, int i) {
        int number = args.length - i;
        String[] add = new String[number];
        int j = 0;
        while (j < number) {
            add[j] = args[i];
            ++j;
            ++i;
        }
        Field f = this.getField("additional");
        if (f != null) {
            this.setObject(f, add);
        } else {
            System.err.println("No varible 'additional' found");
        }
    }

    private Object addToArray(Field field, Object o) {
        Object ret;
        Object orig = this.getObject(field);
        Class<?> componentType = field.getType().getComponentType();
        if (orig == null) {
            ret = Array.newInstance(componentType, 1);
            Array.set(ret, 0, o);
        } else {
            int j;
            int length = Array.getLength(orig);
            ret = Array.newInstance(componentType, length + 1);
            for (j = 0; j < length; ++j) {
                Array.set(ret, j, Array.get(orig, j));
            }
            Array.set(ret, j, o);
        }
        return ret;
    }

    private String getKey(String arg) {
        if (this.hasEquals) {
            arg = arg.replaceFirst("=.*", "");
        }
        arg = this.doubleDashes ? arg.substring(2) : arg.substring(1);
        arg = arg.replaceAll("^([0-9])", "_$1");
        arg = arg.replaceAll("-", "__");
        arg = arg.replaceAll("\\.", "_\\$");
        if (this.aliases != null) {
            for (int i = 0; i < this.aliases.length; ++i) {
                if (!this.aliases[i][0].equals(arg)) continue;
                arg = this.aliases[i][1];
            }
        }
        return arg;
    }

    private String getBooleanValue(String arg) {
        if (this.hasEquals) {
            if ((arg = arg.replaceFirst("[^=]*=", "")).equalsIgnoreCase("true") || arg.equalsIgnoreCase("yes")) {
                return "true";
            }
            return "false";
        }
        return "true";
    }

    private Object makeObject(String type, String val) {
        if (type.equals("boolean")) {
            return new Boolean(val);
        }
        if (type.equals("byte")) {
            return new Byte(val);
        }
        if (type.equals("short")) {
            return new Short(val);
        }
        if (type.equals("int")) {
            return new Integer(val);
        }
        if (type.equals("float")) {
            return new Float(val);
        }
        if (type.equals("double")) {
            return new Double(val);
        }
        if (type.equals("long")) {
            return new Long(val);
        }
        if (type.equals("java.lang.String")) {
            return val;
        }
        if (type.equals("char")) {
            return new Character(val.charAt(0));
        }
        return null;
    }

    private String getEqualsValue(String arg) {
        if (arg.indexOf("=") == -1) {
            throw new IllegalArgumentException("'" + arg + "' requires '=VALUE'");
        }
        return arg.replaceFirst("[^=]*=", "");
    }

    public void parse(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            if (!args[i].startsWith("-")) {
                this.parseAdditional(args, i);
                return;
            }
            this.doubleDashes = args[i].startsWith("--");
            this.hasEquals = args[i].indexOf("=") != -1;
            String key = this.getKey(args[i]);
            Field field = this.getField(key);
            if (field == null) {
                throw new IllegalArgumentException("No such option: \"" + key + "\"");
            }
            Class<?> type = field.getType();
            String name = type.getName();
            if (type.isArray()) {
                name = type.getComponentType().getName();
            }
            String value = null;
            value = name.equals("boolean") ? this.getBooleanValue(args[i]) : (this.doubleDashes || this.hasEquals ? this.getEqualsValue(args[i]) : args[++i]);
            Object o = this.makeObject(name, value);
            if (o == null) continue;
            if (type.isArray()) {
                o = this.addToArray(field, o);
            }
            this.setObject(field, o);
        }
    }

    public boolean getBoolean(String key) {
        return (Boolean)this.getValue(key);
    }

    public byte getByte(String key) {
        return (Byte)this.getValue(key);
    }

    public char getChar(String key) {
        return ((Character)this.getValue(key)).charValue();
    }

    public short getShort(String key) {
        return (Short)this.getValue(key);
    }

    public int getInt(String key) {
        return (Integer)this.getValue(key);
    }

    public float getFloat(String key) {
        return ((Float)this.getValue(key)).floatValue();
    }

    public double getDouble(String key) {
        return (Double)this.getValue(key);
    }

    public long getLong(String key) {
        return (Long)this.getValue(key);
    }

    public String getString(String key) {
        return (String)this.getValue(key);
    }

    public byte[] getBytes(String key) {
        return (byte[])this.getValue(key);
    }

    public char[] getChars(String key) {
        return (char[])this.getValue(key);
    }

    public short[] getShorts(String key) {
        return (short[])this.getValue(key);
    }

    public int[] getInts(String key) {
        return (int[])this.getValue(key);
    }

    public float[] getFloats(String key) {
        return (float[])this.getValue(key);
    }

    public double[] getDoubles(String key) {
        return (double[])this.getValue(key);
    }

    public long[] getLongs(String key) {
        return (long[])this.getValue(key);
    }

    public String[] getStrings(String key) {
        return (String[])this.getValue(key);
    }

    public static void main(String[] args) throws IOException {
        Properties properties = new Properties();
        FileInputStream in = new FileInputStream("version.properties");
        properties.load(in);
        in.close();
        String version = properties.getProperty("version");
        System.out.println("Version: " + version);
    }
}

