/*
 * Decompiled with CFR 0.152.
 */
package edu.msudenver.cs.jclo;

import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Properties;

public class JCLO {
    private final Field[] fields;
    private final Object object;
    private boolean doubleDashes;
    private boolean hasEquals;
    private String prefix = "";
    private final String[][] aliases;

    public JCLO(Object object) {
        this(null, object, null);
    }

    public JCLO(Object object, String[][] aliases) {
        this(null, object, aliases);
    }

    public JCLO(String prefix, Object object) {
        this(prefix, object, null);
    }

    public JCLO(String prefix, Object object, String[][] aliases) {
        this.object = object;
        this.prefix = prefix;
        this.aliases = aliases;
        for (Field field : this.fields = object.getClass().getDeclaredFields()) {
            field.setAccessible(true);
        }
    }

    private Object getObject(Field f) {
        try {
            return f.get(this.object);
        }
        catch (IllegalAccessException iae) {
            iae.printStackTrace();
            System.exit(1);
            return null;
        }
    }

    private Field getField(String key) {
        if (this.prefix != null) {
            key = this.prefix + key;
        }
        for (Field field : this.fields) {
            String name = field.getName();
            if (!name.equals(key)) continue;
            return field;
        }
        return null;
    }

    private void setObject(Field f, Object o) {
        try {
            f.set(this.object, o);
        }
        catch (IllegalAccessException iae) {
            iae.printStackTrace();
        }
    }

    private String getArrayType(Class type) {
        return type.getComponentType().toString().replaceFirst("class.*\\.", "");
    }

    public String toString() {
        String r = "";
        boolean first = true;
        for (Field field : this.fields) {
            String key = field.getName();
            Class<?> type = field.getType();
            Object object = this.getObject(field);
            if (!first) {
                r = r + "\n";
            }
            first = false;
            if (type.isArray()) {
                r = r + this.getArrayType(type) + "[]" + ": " + key + " = ";
                r = r + Arrays.toString((Object[])object);
                continue;
            }
            r = r + type.toString().replaceFirst("class java.lang.", "") + ": " + key + " = " + object;
        }
        return r;
    }

    private String getUsageType(Class type) {
        String dd;
        String string = dd = this.doubleDashes ? "=" : " ";
        if (type.getName().equals("boolean") || type.getName().equals("java.lang.Boolean")) {
            return this.doubleDashes ? "[=boolean]" : "";
        }
        if (type.isArray()) {
            return dd + this.getArrayType(type) + "...";
        }
        if (type.isEnum()) {
            return dd + Arrays.toString(type.getEnumConstants());
        }
        return dd + type.getName().replaceFirst("java.lang.", "");
    }

    public String usage() {
        ArrayList<String> list = new ArrayList<String>();
        for (Field field : this.fields) {
            String key = field.getName();
            Class<?> type = field.getType();
            if (key.equals("additional")) continue;
            if (this.prefix != null) {
                if (!key.startsWith(this.prefix)) continue;
                key = key.replaceFirst("^" + this.prefix, "");
            }
            if (Modifier.isFinal(field.getModifiers())) continue;
            key = key.replaceFirst("^_([0-9])", "$1");
            key = key.replaceAll("__", "-");
            key = key.replaceAll("_\\$", ".");
            list.add((this.doubleDashes ? "--" : "-") + key + this.getUsageType(type) + "\n");
        }
        Collections.sort(list);
        String r = "";
        for (String l : list) {
            r = r + l;
        }
        return r;
    }

    private void parseAdditional(String[] args, int i) {
        int number = args.length - i;
        String[] add = new String[number];
        int j = 0;
        while (j < number) {
            add[j] = args[i];
            ++j;
            ++i;
        }
        Field f = this.getField("additional");
        if (f != null) {
            this.setObject(f, add);
        } else {
            System.err.println("No varible 'additional' found");
        }
    }

    private Object addToArray(Field field, Object o) {
        Object ret;
        Object orig = this.getObject(field);
        Class<?> componentType = field.getType().getComponentType();
        if (orig == null) {
            ret = Array.newInstance(componentType, 1);
            Array.set(ret, 0, o);
        } else {
            int j;
            int length = Array.getLength(orig);
            ret = Array.newInstance(componentType, length + 1);
            for (j = 0; j < length; ++j) {
                Array.set(ret, j, Array.get(orig, j));
            }
            Array.set(ret, j, o);
        }
        return ret;
    }

    private String getKey(String arg) {
        if (this.hasEquals) {
            arg = arg.replaceFirst("=.*", "");
        }
        arg = this.doubleDashes ? arg.substring(2) : arg.substring(1);
        arg = arg.replaceAll("^([0-9])", "_$1");
        arg = arg.replaceAll("-", "__");
        arg = arg.replaceAll("\\.", "_\\$");
        if (this.aliases != null) {
            for (String[] aliase : this.aliases) {
                if (!aliase[0].equals(arg)) continue;
                arg = aliase[1];
            }
        }
        return arg;
    }

    private String getBooleanValue(String arg) {
        if (this.hasEquals) {
            if ((arg = arg.replaceFirst("[^=]*=", "")).equalsIgnoreCase("true") || arg.equalsIgnoreCase("yes")) {
                return "true";
            }
            return "false";
        }
        return "true";
    }

    private Object makeObject(String type, String val) {
        switch (type) {
            case "boolean": 
            case "java.lang.Boolean": {
                return Boolean.valueOf(val);
            }
            case "byte": {
                return Byte.valueOf(val);
            }
            case "short": {
                return Short.valueOf(val);
            }
            case "int": {
                return Integer.valueOf(val);
            }
            case "float": {
                return Float.valueOf(val);
            }
            case "double": {
                return Double.valueOf(val);
            }
            case "long": {
                return Long.valueOf(val);
            }
            case "string": {
                return val;
            }
            case "char": {
                return Character.valueOf(val.charAt(0));
            }
        }
        throw new IllegalArgumentException("Unknown type: " + type);
    }

    private String getEqualsValue(String arg) {
        if (!arg.contains("=")) {
            throw new IllegalArgumentException("'" + arg + "' requires '=VALUE'");
        }
        return arg.replaceFirst("[^=]*=", "");
    }

    public void parse(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            Object o;
            if (!args[i].startsWith("-")) {
                this.parseAdditional(args, i);
                return;
            }
            this.doubleDashes = args[i].startsWith("--");
            this.hasEquals = args[i].contains("=");
            String key = this.getKey(args[i]);
            Field field = this.getField(key);
            if (field == null) {
                throw new IllegalArgumentException("No such option: \"" + key + "\"");
            }
            Class<?> type = field.getType();
            String name = type.getName();
            if (type.isArray()) {
                name = type.getComponentType().getName();
            }
            String value = name.equals("boolean") || name.equals("java.lang.Boolean") ? this.getBooleanValue(args[i]) : (this.doubleDashes || this.hasEquals ? this.getEqualsValue(args[i]) : args[++i]);
            if (!type.isPrimitive()) {
                name = name.replaceFirst("java.lang.", "").toLowerCase();
            }
            Object object = o = type.isEnum() ? Enum.valueOf(type, value) : this.makeObject(name, value);
            if (type.isArray()) {
                o = this.addToArray(field, o);
            }
            this.setObject(field, o);
        }
    }

    public static void main(String[] args) throws IOException {
        Properties properties = new Properties();
        FileInputStream in = new FileInputStream("version.properties");
        properties.load(in);
        in.close();
        String version = properties.getProperty("version");
        System.out.println("Version: " + version);
    }
}

