/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.fst.semi_supervised.constraints;

import cc.mallet.fst.semi_supervised.StateLabelMap;
import cc.mallet.fst.semi_supervised.constraints.GEConstraint;
import cc.mallet.fst.semi_supervised.constraints.TwoLabelGEConstraints;
import gnu.trove.TIntIntHashMap;
import java.util.ArrayList;

public class TwoLabelKLGEConstraints
extends TwoLabelGEConstraints {
    public TwoLabelKLGEConstraints() {
    }

    private TwoLabelKLGEConstraints(ArrayList<TwoLabelGEConstraints.TwoLabelGEConstraint> constraintsList, TIntIntHashMap constraintsMap, StateLabelMap map) {
        super(constraintsList, constraintsMap, map);
    }

    @Override
    public GEConstraint copy() {
        return new TwoLabelKLGEConstraints(this.constraintsList, this.constraintsMap, this.map);
    }

    @Override
    public void addConstraint(int fi, double[][] target, double weight) {
        this.constraintsList.add(new TwoLabelKLGEConstraint(target, weight));
        this.constraintsMap.put(fi, this.constraintsList.size() - 1);
    }

    @Override
    public double getValue() {
        double value = 0.0;
        for (int fi : this.constraintsMap.keys()) {
            TwoLabelGEConstraints.TwoLabelGEConstraint constraint = (TwoLabelGEConstraints.TwoLabelGEConstraint)this.constraintsList.get(this.constraintsMap.get(fi));
            if (!(constraint.count > 0.0)) continue;
            double constraintValue = 0.0;
            for (int prevLi = 0; prevLi < this.map.getNumLabels(); ++prevLi) {
                for (int currLi = 0; currLi < this.map.getNumLabels(); ++currLi) {
                    if (!(constraint.target[prevLi][currLi] > 0.0)) continue;
                    if (constraint.expectation[prevLi][currLi] == 0.0) {
                        return Double.NEGATIVE_INFINITY;
                    }
                    constraintValue += constraint.target[prevLi][currLi] * (Math.log(constraint.expectation[prevLi][currLi] / constraint.count) - Math.log(constraint.target[prevLi][currLi]));
                }
            }
            assert (!Double.isNaN(constraintValue) && !Double.isInfinite(constraintValue));
            value += constraintValue * constraint.weight;
        }
        return value;
    }

    protected class TwoLabelKLGEConstraint
    extends TwoLabelGEConstraints.TwoLabelGEConstraint {
        public TwoLabelKLGEConstraint(double[][] target, double weight) {
            super(TwoLabelKLGEConstraints.this, target, weight);
        }

        @Override
        public double getValue(int liPrev, int liCurr) {
            assert (this.count != 0.0);
            if (this.target[liPrev][liCurr] == 0.0 && this.expectation[liPrev][liCurr] == 0.0) {
                return 0.0;
            }
            return this.weight * (this.target[liPrev][liCurr] / this.expectation[liPrev][liCurr]);
        }
    }
}

