/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.grmm.test;

import cc.mallet.grmm.inference.TRP;
import cc.mallet.grmm.types.Assignment;
import cc.mallet.grmm.types.BoltzmannUnaryFactor;
import cc.mallet.grmm.types.Factor;
import cc.mallet.grmm.types.FactorGraph;
import cc.mallet.grmm.types.PottsTableFactor;
import cc.mallet.grmm.types.UniformFactor;
import cc.mallet.grmm.types.Variable;
import cc.mallet.util.Randoms;
import java.util.ArrayList;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class TestAbstractBeliefPropagation
extends TestCase {
    public TestAbstractBeliefPropagation(String name) {
        super(name);
    }

    public static TestSuite suite() {
        return new TestSuite((Class<? extends TestCase>)TestAbstractBeliefPropagation.class);
    }

    public void testBadVariable() {
        FactorGraph fg = TestAbstractBeliefPropagation.createBoltzmannChain(5);
        Assignment assn = fg.sampleContinuousVars(new Randoms(23423));
        FactorGraph sliced = (FactorGraph)fg.slice(assn);
        TRP bp = new TRP();
        bp.computeMarginals(sliced);
        try {
            bp.lookupMarginal(new Variable(2));
            TestAbstractBeliefPropagation.fail("Expected exception");
        }
        catch (IllegalArgumentException e) {
            System.out.println("OK: As expected, got exception " + e);
        }
    }

    static FactorGraph createBoltzmannChain(int len) {
        int i;
        Randoms r = new Randoms(3241321);
        ArrayList<Variable> vars = new ArrayList<Variable>();
        for (int i2 = 0; i2 < len; ++i2) {
            Variable x_i = new Variable(2);
            x_i.setLabel("X_" + i2);
            vars.add(x_i);
        }
        ArrayList<Factor> factors = new ArrayList<Factor>(vars.size());
        for (i = 0; i < len; ++i) {
            double u = r.nextUniform(-4.0, 4.0);
            factors.add(new BoltzmannUnaryFactor((Variable)vars.get(i), u));
        }
        for (i = 0; i < len - 1; ++i) {
            Variable alpha = new Variable(-1);
            alpha.setLabel("ALPHA_" + i);
            factors.add(new UniformFactor(alpha, -4.0, 4.0));
            factors.add(new PottsTableFactor((Variable)vars.get(i), (Variable)vars.get(i + 1), alpha));
        }
        return new FactorGraph(factors);
    }

    public static void main(String[] args) {
        TestSuite theSuite;
        if (args.length > 0) {
            theSuite = new TestSuite();
            for (int i = 0; i < args.length; ++i) {
                theSuite.addTest(new TestAbstractBeliefPropagation(args[i]));
            }
        } else {
            theSuite = TestAbstractBeliefPropagation.suite();
        }
        TestRunner.run(theSuite);
    }
}

