/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.grmm.test;

import cc.mallet.grmm.types.Assignment;
import cc.mallet.grmm.types.AssignmentIterator;
import cc.mallet.grmm.types.Factor;
import cc.mallet.grmm.types.PottsTableFactor;
import cc.mallet.grmm.types.TableFactor;
import cc.mallet.grmm.types.Variable;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class TestAssignmentIterator
extends TestCase {
    public TestAssignmentIterator(String name) {
        super(name);
    }

    public void testSum() {
        Variable[] vars = new Variable[]{new Variable(2), new Variable(2)};
        double[] probs = new double[]{0.1, 10.3, 17.0, 0.5};
        TableFactor ptl = new TableFactor(vars, probs);
        AssignmentIterator it = ptl.assignmentIterator();
        double total = 0.0;
        while (it.hasNext()) {
            total += ptl.value(it);
            it.advance();
        }
        TestAssignmentIterator.assertEquals(27.9, total, 0.01);
    }

    public void testLazyAssignment() {
        Variable[] vars = new Variable[]{new Variable(2), new Variable(2)};
        double[] probs = new double[]{0.1, 10.3, 17.0, 0.5};
        TableFactor ptl = new TableFactor(vars, probs);
        AssignmentIterator it = ptl.assignmentIterator();
        it.advance();
        it.advance();
        Assignment assn = it.assignment();
        TestAssignmentIterator.assertEquals(2, assn.size());
        TestAssignmentIterator.assertEquals(1, assn.get(vars[0]));
        TestAssignmentIterator.assertEquals(0, assn.get(vars[1]));
    }

    public void testSparseMatrixN() {
        Variable x1 = new Variable(2);
        Variable x2 = new Variable(2);
        Variable alpha = new Variable(-1);
        PottsTableFactor potts = new PottsTableFactor(x1, x2, alpha);
        Assignment alphAssn = new Assignment(alpha, 1.0);
        Factor tbl = potts.slice(alphAssn);
        System.out.println(tbl.dumpToString());
        int j = 0;
        double[] vals = new double[]{0.0, -1.0, -1.0, 0.0};
        AssignmentIterator it = tbl.assignmentIterator();
        while (it.hasNext()) {
            TestAssignmentIterator.assertEquals(vals[j++], tbl.logValue(it), 1.0E-5);
            it.advance();
        }
    }

    public static Test suite() {
        return new TestSuite((Class<? extends TestCase>)TestAssignmentIterator.class);
    }

    public static void main(String[] args) throws Exception {
        TestSuite theSuite;
        if (args.length > 0) {
            theSuite = new TestSuite();
            for (int i = 0; i < args.length; ++i) {
                theSuite.addTest(new TestAssignmentIterator(args[i]));
            }
        } else {
            theSuite = (TestSuite)TestAssignmentIterator.suite();
        }
        TestRunner.run(theSuite);
    }
}

