/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.grmm.test;

import cc.mallet.grmm.types.HashVarSet;
import cc.mallet.grmm.types.Variable;
import java.util.Arrays;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class TestHashClique
extends TestCase {
    public TestHashClique(String name) {
        super(name);
    }

    public void testEqualsHashCode() {
        Variable[] vars = new Variable[4];
        for (int i = 0; i < vars.length; ++i) {
            vars[i] = new Variable(3);
        }
        HashVarSet c1 = new HashVarSet(vars);
        HashVarSet c2 = new HashVarSet(vars);
        TestHashClique.assertTrue(c1.equals(c2));
        TestHashClique.assertTrue(c2.equals(c1));
        TestHashClique.assertEquals(c1.hashCode(), c2.hashCode());
    }

    public void testAddAllOrdering() {
        for (int rep = 0; rep < 1000; ++rep) {
            Variable[] vars = new Variable[]{new Variable(2), new Variable(2)};
            HashVarSet vs = new HashVarSet(vars);
            this.checkOrdering(vs, vars);
        }
    }

    public void testAddAllOrdering2() {
        for (int rep = 0; rep < 1000; ++rep) {
            Variable[] vars = new Variable[]{new Variable(2), new Variable(2)};
            HashVarSet vs = new HashVarSet();
            vs.addAll(Arrays.asList(vars));
            this.checkOrdering(vs, vars);
        }
    }

    public void testAddAllOrdering3() {
        for (int rep = 0; rep < 1000; ++rep) {
            Variable[] vars = new Variable[]{new Variable(2), new Variable(2)};
            HashVarSet vsOld = new HashVarSet(vars);
            HashVarSet vs = new HashVarSet(vsOld);
            this.checkOrdering(vs, vars);
        }
    }

    private void checkOrdering(HashVarSet vs, Variable[] vars) {
        TestHashClique.assertEquals(vars.length, vs.size());
        for (int i = 0; i < vars.length; ++i) {
            TestHashClique.assertEquals(vars[i], vs.get(i));
        }
    }

    public static Test suite() {
        return new TestSuite((Class<? extends TestCase>)TestHashClique.class);
    }

    public static void main(String[] args) throws Throwable {
        TestSuite theSuite;
        if (args.length > 0) {
            theSuite = new TestSuite();
            for (int i = 0; i < args.length; ++i) {
                theSuite.addTest(new TestHashClique(args[i]));
            }
        } else {
            theSuite = (TestSuite)TestHashClique.suite();
        }
        TestRunner.run(theSuite);
    }
}

