/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.grmm.test;

import cc.mallet.grmm.inference.BruteForceInferencer;
import cc.mallet.grmm.inference.LoopyBP;
import cc.mallet.grmm.inference.RandomGraphs;
import cc.mallet.grmm.inference.TRP;
import cc.mallet.grmm.types.Assignment;
import cc.mallet.grmm.types.AssignmentIterator;
import cc.mallet.grmm.types.Factor;
import cc.mallet.grmm.types.FactorGraph;
import cc.mallet.grmm.types.TableFactor;
import cc.mallet.grmm.types.UndirectedGrid;
import cc.mallet.grmm.types.Variable;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.Random;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class TestRandomGraphs
extends TestCase {
    public TestRandomGraphs(String name) {
        super(name);
    }

    public static Test suite() {
        return new TestSuite((Class<? extends TestCase>)TestRandomGraphs.class);
    }

    public void testAttractiveGraphs() throws IOException {
        Random r = new Random(31421L);
        for (int rep = 0; rep < 5; ++rep) {
            UndirectedGrid mdl = RandomGraphs.randomAttractiveGrid(5, 0.5, r);
            System.out.println("************");
            mdl.dump();
            TRP trp = TRP.createForMaxProduct();
            trp.computeMarginals(mdl);
            Assignment assn = trp.bestAssignment();
            PrintWriter out = new PrintWriter(new FileWriter(new File("attract." + rep + ".dot")));
            mdl.printAsDot(out, assn);
            out.close();
        }
    }

    public void testRepulsiveGraphs() throws IOException {
        Random r = new Random(31421L);
        for (int rep = 0; rep < 5; ++rep) {
            UndirectedGrid mdl = RandomGraphs.randomRepulsiveGrid(5, 0.5, r);
            TRP trp = TRP.createForMaxProduct();
            trp.computeMarginals(mdl);
            Assignment assn = trp.bestAssignment();
            PrintWriter out = new PrintWriter(new FileWriter(new File("repulse." + rep + ".dot")));
            mdl.printAsDot(out, assn);
            out.close();
        }
    }

    public void testFrustratedGraphs() throws IOException {
        Random r = new Random(31421L);
        for (int rep = 0; rep < 5; ++rep) {
            UndirectedGrid mdl = RandomGraphs.randomFrustratedGrid(5, 0.5, r);
            TRP trp = TRP.createForMaxProduct();
            trp.computeMarginals(mdl);
            Assignment assn = trp.bestAssignment();
            PrintWriter out = new PrintWriter(new FileWriter(new File("mixed." + rep + ".dot")));
            mdl.printAsDot(out, assn);
            out.close();
        }
    }

    public void testFrustratedIsGrid() throws IOException {
        Random r = new Random(0L);
        for (int rep = 0; rep < 100; ++rep) {
            UndirectedGrid mdl = RandomGraphs.randomFrustratedGrid(10, 1.0, r);
            TestRandomGraphs.assertEquals(280, mdl.factors().size());
            TestRandomGraphs.assertEquals(100, mdl.numVariables());
            int[] counts = new int[6];
            for (int i = 0; i < mdl.numVariables(); ++i) {
                Variable var = mdl.get(i);
                int degree = mdl.getDegree(var);
                TestRandomGraphs.assertTrue("Variable " + var + " has degree " + degree, degree >= 3 && degree <= 5);
                int n = degree;
                counts[n] = counts[n] + 1;
            }
            TestRandomGraphs.assertEquals(counts[0], 0);
            TestRandomGraphs.assertEquals(counts[1], 0);
            TestRandomGraphs.assertEquals(counts[2], 0);
            TestRandomGraphs.assertEquals(counts[3], 4);
            TestRandomGraphs.assertEquals(counts[4], 32);
            TestRandomGraphs.assertEquals(counts[5], 64);
        }
    }

    public void testUniformGrid() {
        UndirectedGrid grid = (UndirectedGrid)RandomGraphs.createUniformGrid(3);
        TestRandomGraphs.assertEquals(9, grid.numVariables());
        TestRandomGraphs.assertEquals(12, grid.factors().size());
        BruteForceInferencer inf = new BruteForceInferencer();
        TableFactor joint = (TableFactor)inf.joint(grid);
        AssignmentIterator it = joint.assignmentIterator();
        while (it.hasNext()) {
            TestRandomGraphs.assertEquals(-9.0 * Math.log(2.0), joint.logValue(it), 0.001);
            it.advance();
        }
    }

    public void testUniformGridWithObservations() {
        FactorGraph grid = RandomGraphs.createGridWithObs(new RandomGraphs.UniformFactorGenerator(), new RandomGraphs.UniformFactorGenerator(), 3);
        TestRandomGraphs.assertEquals(18, grid.numVariables());
        TestRandomGraphs.assertEquals(21, grid.factors().size());
        LoopyBP inf = new LoopyBP();
        inf.computeMarginals(grid);
        Iterator it = grid.variablesIterator();
        while (it.hasNext()) {
            Variable var = (Variable)it.next();
            Factor marg = inf.lookupMarginal(var);
            AssignmentIterator assnIt = marg.assignmentIterator();
            while (assnIt.hasNext()) {
                TestRandomGraphs.assertEquals(-Math.log(2.0), marg.logValue(assnIt), 0.001);
                assnIt.advance();
            }
        }
    }

    public static void main(String[] args) throws Throwable {
        TestSuite theSuite;
        if (args.length > 0) {
            theSuite = new TestSuite();
            for (int i = 0; i < args.length; ++i) {
                theSuite.addTest(new TestRandomGraphs(args[i]));
            }
        } else {
            theSuite = (TestSuite)TestRandomGraphs.suite();
        }
        TestRunner.run(theSuite);
    }
}

