/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.grmm.test;

import cc.mallet.grmm.types.Assignment;
import cc.mallet.grmm.types.UniNormalFactor;
import cc.mallet.grmm.types.Variable;
import cc.mallet.types.MatrixOps;
import cc.mallet.util.Randoms;
import gnu.trove.TDoubleArrayList;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class TestUniNormalFactor
extends TestCase {
    public TestUniNormalFactor(String name) {
        super(name);
    }

    public void testVarSet() {
        Variable var = new Variable(-1);
        UniNormalFactor f = new UniNormalFactor(var, -1.0, 1.5);
        TestUniNormalFactor.assertEquals(1, f.varSet().size());
        TestUniNormalFactor.assertTrue(f.varSet().contains(var));
    }

    public void testValue() {
        Variable var = new Variable(-1);
        UniNormalFactor f = new UniNormalFactor(var, -1.0, 2.0);
        Assignment assn1 = new Assignment(var, -1.0);
        TestUniNormalFactor.assertEquals(0.2821, f.value(assn1), 1.0E-4);
        TestUniNormalFactor.assertEquals(Math.log(0.2821), f.logValue(assn1), 1.0E-4);
        Assignment assn2 = new Assignment(var, 1.5);
        TestUniNormalFactor.assertEquals(0.05913, f.value(assn2), 1.0E-4);
        TestUniNormalFactor.assertEquals(Math.log(0.05913), f.logValue(assn2), 1.0E-4);
    }

    public void testSample() {
        Variable var = new Variable(-1);
        Randoms r = new Randoms(2343);
        UniNormalFactor f = new UniNormalFactor(var, -1.0, 2.0);
        TDoubleArrayList lst = new TDoubleArrayList();
        for (int i = 0; i < 10000; ++i) {
            Assignment assn = f.sample(r);
            lst.add(assn.getDouble(var));
        }
        double[] vals = lst.toNativeArray();
        double mean = MatrixOps.mean(vals);
        double std = MatrixOps.stddev(vals);
        TestUniNormalFactor.assertEquals(-1.0, mean, 0.025);
        TestUniNormalFactor.assertEquals(Math.sqrt(2.0), std, 0.01);
    }

    public static TestSuite suite() {
        return new TestSuite((Class<? extends TestCase>)TestUniNormalFactor.class);
    }

    public static void main(String[] args) {
        TestSuite theSuite;
        if (args.length > 0) {
            theSuite = new TestSuite();
            for (int i = 0; i < args.length; ++i) {
                theSuite.addTest(new TestUniNormalFactor(args[i]));
            }
        } else {
            theSuite = TestUniNormalFactor.suite();
        }
        TestRunner.run(theSuite);
    }
}

