/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.pipe.tests;

import cc.mallet.pipe.Input2CharSequence;
import cc.mallet.pipe.Pipe;
import cc.mallet.pipe.SGML2TokenSequence;
import cc.mallet.pipe.SerialPipes;
import cc.mallet.pipe.iterator.ArrayIterator;
import cc.mallet.types.Instance;
import cc.mallet.types.Token;
import cc.mallet.types.TokenSequence;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class TestSGML2TokenSequence
extends TestCase {
    String[] dataWithTags = new String[]{"zeroth test string", "<tag>first</tag> test string", "second <tag>test</tag> string", "third test <tag>string</tag>"};
    String[] data = new String[]{"zeroth test string", "first test string", "second test string", "third test string"};
    String[] tags = new String[]{"O O O", "tag O O ", "O tag O", "O O tag"};

    public TestSGML2TokenSequence(String name) {
        super(name);
    }

    public void testOne() {
        SerialPipes p = new SerialPipes(new Pipe[]{new Input2CharSequence(), new SGML2TokenSequence()});
        for (int i = 0; i < this.dataWithTags.length; ++i) {
            Instance inst = p.instanceFrom(new Instance(this.dataWithTags[i], null, null, null));
            TokenSequence input = (TokenSequence)inst.getData();
            TokenSequence target = (TokenSequence)inst.getTarget();
            String[] oginput = this.data[i].split("\\s+");
            String[] ogtags = this.tags[i].split("\\s+");
            assert (input.size() == target.size());
            assert (input.size() == oginput.length);
            for (int j = 0; j < oginput.length; ++j) {
                assert (oginput[j].equals(((Token)input.get(j)).getText()));
                assert (ogtags[j].equals(((Token)target.get(j)).getText()));
            }
        }
    }

    public static Test suite() {
        return new TestSuite((Class<? extends TestCase>)TestSGML2TokenSequence.class);
    }

    @Override
    protected void setUp() {
    }

    public static void main(String[] args) {
        TestRunner.run(TestSGML2TokenSequence.suite());
    }

    public static class Array2ArrayIterator
    extends Pipe {
        @Override
        public Instance pipe(Instance carrier) {
            carrier.setData(new ArrayIterator((Object[])carrier.getData()));
            return carrier;
        }
    }
}

