/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.types.tests;

import cc.mallet.types.DenseVector;
import cc.mallet.types.SparseVector;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class TestSparseVector
extends TestCase {
    double[] dbl1 = new double[]{1.0, 2.0, 3.0, 4.0, 5.0};
    double[] dbl2 = new double[]{1.0, 1.5, 2.0, 1.0, 1.0};
    double[] dbl3 = new double[]{2.0, 2.5, 3.0, 4.7, 3.5, 3.6, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
    double[] dbl4 = new double[]{1.0, 2.0, 3.0, 4.0, Double.NEGATIVE_INFINITY};
    int[] idxs = new int[]{3, 5, 7, 13, 15};
    SparseVector s1 = new SparseVector(this.idxs, this.dbl1, this.dbl1.length, this.dbl1.length, true, true, true);
    SparseVector s2 = new SparseVector(this.idxs, this.dbl2, this.dbl2.length, this.dbl2.length, true, true, true);
    DenseVector d1 = new DenseVector(this.dbl3, true);
    private static int[] idx2 = new int[]{3, 7, 12, 15, 18};

    public TestSparseVector(String name) {
        super(name);
    }

    private void checkAnswer(SparseVector actual, double[] ans) {
        TestSparseVector.assertEquals("Wrong number of locations:", ans.length, actual.numLocations());
        for (int i = 0; i < actual.numLocations(); ++i) {
            TestSparseVector.assertEquals("Value incorrect at location " + i + ": ", ans[i], actual.valueAtLocation(i), 0.0);
        }
    }

    public void testPlusEquals() {
        SparseVector s = (SparseVector)this.s1.cloneMatrix();
        s.plusEqualsSparse(this.s2, 2.0);
        this.checkAnswer(s, new double[]{3.0, 5.0, 7.0, 6.0, 7.0});
        SparseVector s2p = new SparseVector(new int[]{13}, new double[]{0.8});
        s.plusEqualsSparse(s2p, 1.0);
        this.checkAnswer(s, new double[]{3.0, 5.0, 7.0, 6.8, 7.0});
        SparseVector s3p = new SparseVector(new int[]{14}, new double[]{0.8});
        s.plusEqualsSparse(s3p, 1.0);
        this.checkAnswer(s, new double[]{3.0, 5.0, 7.0, 6.8, 7.0});
        SparseVector s4 = new SparseVector(new int[]{7, 14, 15}, new double[]{0.2, 0.8, 1.2});
        s.plusEqualsSparse(s4, 1.0);
        this.checkAnswer(s, new double[]{3.0, 5.0, 7.2, 6.8, 8.2});
        SparseVector s5 = new SparseVector(new int[]{7}, new double[]{0.2});
        s5.plusEqualsSparse(this.s1);
        for (int i = 0; i < s5.numLocations(); ++i) {
            TestSparseVector.assertEquals(7, s5.indexAtLocation(i));
            TestSparseVector.assertEquals(3.2, s5.valueAtLocation(i), 0.0);
        }
        SparseVector s6 = new SparseVector(new int[]{7}, new double[]{0.2});
        s6.plusEqualsSparse(this.s1, 3.5);
        for (int i = 0; i < s6.numLocations(); ++i) {
            TestSparseVector.assertEquals(7, s6.indexAtLocation(i));
            TestSparseVector.assertEquals(10.7, s6.valueAtLocation(i), 0.0);
        }
    }

    public void testDotProduct() {
        SparseVector t1 = new SparseVector(new int[]{7}, new double[]{0.2});
        TestSparseVector.assertEquals(0.6, t1.dotProduct(this.s1), 1.0E-5);
        TestSparseVector.assertEquals(0.6, this.s1.dotProduct(t1), 1.0E-5);
        TestSparseVector.assertEquals(19.0, this.s1.dotProduct(this.s2), 1.0E-5);
        TestSparseVector.assertEquals(19.0, this.s2.dotProduct(this.s1), 1.0E-5);
        TestSparseVector.assertEquals(11.9, this.s1.dotProduct(this.d1), 1.0E-5);
        TestSparseVector.assertEquals(10.1, this.s2.dotProduct(this.d1), 1.0E-5);
        SparseVector t2 = new SparseVector(new int[]{3, 30}, new double[]{0.2, 3.5});
        SparseVector t3 = new SparseVector(null, new double[]{1.0, 1.0, 1.0, 1.0});
        TestSparseVector.assertEquals(0.2, t3.dotProduct(t2), 1.0E-5);
    }

    public void testIncrementValue() {
        SparseVector s = (SparseVector)this.s1.cloneMatrix();
        s.incrementValue(5, 0.75);
        double[] ans = new double[]{1.0, 2.75, 3.0, 4.0, 5.0};
        for (int i = 0; i < s.numLocations(); ++i) {
            TestSparseVector.assertTrue(s.valueAtLocation(i) == ans[i]);
        }
    }

    public void testSetValue() {
        SparseVector s = (SparseVector)this.s1.cloneMatrix();
        s.setValue(5, 0.3);
        double[] ans = new double[]{1.0, 0.3, 3.0, 4.0, 5.0};
        for (int i = 0; i < s.numLocations(); ++i) {
            TestSparseVector.assertTrue(s.valueAtLocation(i) == ans[i]);
        }
    }

    public void testDenseSparseVector() {
        SparseVector svDense = new SparseVector(null, this.dbl3);
        double sdot = svDense.dotProduct(svDense);
        double ddot = this.d1.dotProduct(this.d1);
        TestSparseVector.assertEquals(sdot, ddot, 1.0E-4);
        svDense.plusEqualsSparse(this.s1);
        this.checkAnswer(svDense, new double[]{2.0, 2.5, 3.0, 5.7, 3.5, 5.6, 0.0, 3.0, 0.0, 0.0, 0.0, 0.0, 0.0, 4.0, 0.0, 5.0});
        svDense.plusEqualsSparse(this.s1, 2.0);
        this.checkAnswer(svDense, new double[]{2.0, 2.5, 3.0, 7.7, 3.5, 9.6, 0.0, 9.0, 0.0, 0.0, 0.0, 0.0, 0.0, 12.0, 0.0, 15.0});
        double[] dbl4 = new double[this.dbl3.length + 1];
        for (int i = 0; i < dbl4.length; ++i) {
            dbl4[i] = 2.0;
        }
        SparseVector sv4 = new SparseVector(null, dbl4);
        svDense.plusEqualsSparse(sv4);
        this.checkAnswer(svDense, new double[]{4.0, 4.5, 5.0, 9.7, 5.5, 11.6, 2.0, 11.0, 2.0, 2.0, 2.0, 2.0, 2.0, 14.0, 2.0, 17.0});
    }

    public void testBinaryVector() {
        SparseVector binary1 = new SparseVector(this.idxs, null, this.idxs.length, this.idxs.length, false, false, false);
        SparseVector binary2 = new SparseVector(idx2, null, idx2.length, idx2.length, false, false, false);
        TestSparseVector.assertEquals(3.0, binary1.dotProduct(binary2), 1.0E-4);
        TestSparseVector.assertEquals(3.0, binary2.dotProduct(binary1), 1.0E-4);
        TestSparseVector.assertEquals(15.0, binary1.dotProduct(this.s1), 1.0E-4);
        TestSparseVector.assertEquals(15.0, this.s1.dotProduct(binary1), 1.0E-4);
        TestSparseVector.assertEquals(9.0, binary2.dotProduct(this.s1), 1.0E-4);
        TestSparseVector.assertEquals(9.0, this.s1.dotProduct(binary2), 1.0E-4);
        SparseVector dblVec = (SparseVector)this.s1.cloneMatrix();
        dblVec.plusEqualsSparse(binary1);
        this.checkAnswer(dblVec, new double[]{2.0, 3.0, 4.0, 5.0, 6.0});
        SparseVector dblVec2 = (SparseVector)this.s1.cloneMatrix();
        dblVec2.plusEqualsSparse(binary2);
        this.checkAnswer(dblVec2, new double[]{2.0, 2.0, 4.0, 4.0, 6.0});
    }

    public void testCloneMatrixZeroed() {
        SparseVector s = (SparseVector)this.s1.cloneMatrixZeroed();
        for (int i = 0; i < s.numLocations(); ++i) {
            TestSparseVector.assertTrue(s.valueAtLocation(i) == 0.0);
            TestSparseVector.assertTrue(s.indexAtLocation(i) == this.idxs[i]);
        }
    }

    public void testPrint() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream out = new PrintStream(baos);
        PrintStream oldOut = System.out;
        System.setOut(out);
        SparseVector standard = new SparseVector(this.idxs, this.dbl2);
        standard.print();
        TestSparseVector.assertEquals("SparseVector[3] = 1.0\nSparseVector[5] = 1.5\nSparseVector[7] = 2.0\nSparseVector[13] = 1.0\nSparseVector[15] = 1.0\n", baos.toString());
        baos.reset();
        SparseVector dense = new SparseVector(null, this.dbl2);
        dense.print();
        TestSparseVector.assertEquals("SparseVector[0] = 1.0\nSparseVector[1] = 1.5\nSparseVector[2] = 2.0\nSparseVector[3] = 1.0\nSparseVector[4] = 1.0\n", baos.toString());
        baos.reset();
        SparseVector binary = new SparseVector(this.idxs, null, this.idxs.length, this.idxs.length, false, false, false);
        binary.print();
        TestSparseVector.assertEquals("SparseVector[3] = 1.0\nSparseVector[5] = 1.0\nSparseVector[7] = 1.0\nSparseVector[13] = 1.0\nSparseVector[15] = 1.0\n", baos.toString());
        baos.reset();
    }

    public void testExtendedDotProduct() {
        SparseVector v1 = new SparseVector(null, this.dbl3);
        SparseVector vInf = new SparseVector(null, this.dbl4);
        double dp = v1.dotProduct(vInf);
        TestSparseVector.assertTrue(!Double.isNaN(dp));
        dp = vInf.dotProduct(v1);
        TestSparseVector.assertTrue(!Double.isNaN(dp));
    }

    public static Test suite() {
        return new TestSuite((Class<? extends TestCase>)TestSparseVector.class);
    }

    @Override
    protected void setUp() {
    }

    public static void main(String[] args) {
        TestRunner.run(TestSparseVector.suite());
    }
}

