/*
 * Decompiled with CFR 0.152.
 */
package edu.nyu.jet;

import edu.nyu.jet.Console;
import edu.nyu.jet.JetTest;
import edu.nyu.jet.chunk.Chunker;
import edu.nyu.jet.chunk.Onoma;
import edu.nyu.jet.lex.Lexicon;
import edu.nyu.jet.lex.Tokenizer;
import edu.nyu.jet.parser.AddSyntacticRelations;
import edu.nyu.jet.parser.DepParser;
import edu.nyu.jet.parser.ParseTreeNode;
import edu.nyu.jet.parser.Parsers;
import edu.nyu.jet.parser.StatParser;
import edu.nyu.jet.refres.CorefFilter;
import edu.nyu.jet.refres.EntityView;
import edu.nyu.jet.refres.Resolve;
import edu.nyu.jet.tipster.Annotation;
import edu.nyu.jet.tipster.Document;
import edu.nyu.jet.tipster.ExternalDocument;
import edu.nyu.jet.tipster.Span;
import edu.nyu.jet.tipster.View;
import edu.nyu.jet.zoner.SentenceSplitter;
import edu.nyu.jet.zoner.SpeechSplitter;
import java.io.BufferedWriter;
import java.io.IOException;
import java.util.StringTokenizer;
import java.util.Vector;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormatter;

public class Control {
    public static void processDocument(Document doc, BufferedWriter writer, boolean viewable, int docNo) throws IOException {
        String script = JetTest.config.getProperty("processDocument");
        if (script == null || script.length() == 0) {
            Console.println("*** System error: no processDocument script.");
            return;
        }
        if (JetTest.nameTagger != null) {
            JetTest.nameTagger.newDocument();
        }
        Control.applyScript(doc, new Span(0, doc.length()), script);
        String type = JetTest.config.getProperty("WriteSGML.type");
        if (type != null) {
            System.out.println("Writing document " + docNo);
            String sgml = Control.toSGML(doc, type);
            ExternalDocument.writeWithSystemNewlines(writer, sgml);
            writer.newLine();
        }
        if (viewable) {
            View view = new View(doc, docNo);
            JetTest.views.add(view);
            Vector<Annotation> v = doc.annotationsOfType("entity");
            if (v != null && v.size() > 0) {
                EntityView eview = new EntityView(doc, docNo);
                JetTest.views.add(eview);
            }
        }
    }

    public static void processSentence(Document doc, Span sentenceSpan) {
        String script = JetTest.config.getProperty("processSentence");
        if (script == null || script.length() == 0) {
            Console.println("*** No processSentence script.");
        } else {
            Control.applyScript(doc, sentenceSpan, script);
        }
    }

    public static void applyScript(Document doc, Span span, String script) {
        String[] actions = Control.splitAtComma(script);
        for (int j = 0; j < actions.length; ++j) {
            String tagName;
            String action = actions[j].intern();
            int colon = action.indexOf(58);
            if (colon > 0 && colon < action.length() - 1) {
                String zoneType = action.substring(0, colon).trim();
                String scriptName = action.substring(colon + 1).trim();
                String zoneScript = JetTest.config.getProperty(scriptName);
                if (zoneScript == null || zoneScript.length() == 0) {
                    Console.println("*** No script for " + scriptName);
                    continue;
                }
                Vector<Annotation> zones = doc.annotationsOfType(zoneType, span);
                if (zones == null) continue;
                for (int i = 0; i < zones.size(); ++i) {
                    Annotation zone = zones.get(i);
                    Control.applyScript(doc, zone.span(), zoneScript);
                }
                continue;
            }
            if (action.startsWith("tag(") && action.endsWith(")")) {
                tagName = action.substring(4, action.length() - 1).trim();
                doc.annotateWithTag(tagName);
                continue;
            }
            if (action.startsWith("shrink(") && action.endsWith(")")) {
                tagName = action.substring(7, action.length() - 1).trim();
                doc.shrink(tagName);
                continue;
            }
            if (action.startsWith("erase(") && action.endsWith(")")) {
                tagName = action.substring(6, action.length() - 1).trim();
                doc.removeAnnotationsOfType(tagName);
                continue;
            }
            if (action == "tokenize") {
                Tokenizer.tokenize(doc, span);
                continue;
            }
            if (action == "sentenceSplit") {
                SentenceSplitter.split(doc, span);
                continue;
            }
            if (action == "speechSplit") {
                SpeechSplitter.split(doc, span);
                continue;
            }
            if (action == "lexLookup") {
                Lexicon.annotateWithDefinitions(doc, span.start(), span.end());
                continue;
            }
            if (action == "tagPOS") {
                if (JetTest.tagger == null) {
                    Console.println("Error:  no POS model loaded");
                    continue;
                }
                JetTest.tagger.tagPenn(doc, span);
                continue;
            }
            if (action == "tagJet") {
                if (JetTest.tagger == null) {
                    Console.println("Error:  no POS model loaded");
                    continue;
                }
                JetTest.tagger.tagJet(doc, span);
                continue;
            }
            if (action == "pruneTags") {
                if (JetTest.tagger == null) {
                    Console.println("Error:  no POS model loaded");
                    continue;
                }
                JetTest.tagger.prune(doc, span);
                continue;
            }
            if (action == "tagNames") {
                if (JetTest.nameTagger == null) {
                    Console.println("Error:  no name model loaded");
                    continue;
                }
                JetTest.nameTagger.tag(doc, span);
                continue;
            }
            if (action == "tagNamesFromOnoma") {
                if (!Onoma.loaded) {
                    Console.println("Error:  no onoma file loaded");
                    continue;
                }
                Onoma.tagNames(doc, span);
                continue;
            }
            if (action == "chunk") {
                if (Chunker.model == null) {
                    Console.println("Error:  no chunker model loaded");
                    continue;
                }
                Chunker.chunk(doc, span);
                continue;
            }
            if (action == "parse") {
                Vector parses = Parsers.parse(doc, 0, doc.length(), JetTest.gram);
                for (int i = 0; i < parses.size(); ++i) {
                    ParseTreeNode parse = (ParseTreeNode)parses.elementAt(i);
                    if (parse == null) continue;
                    ParseTreeNode.makeParseAnnotations(doc, parse);
                    if (parses.size() == 1) {
                        Console.println("Parse:");
                    } else {
                        Console.println("Parse " + (i + 1) + ":");
                    }
                    parse.printTree();
                }
                continue;
            }
            if (action == "statParse") {
                if (!StatParser.isInitialized()) {
                    Console.println("Error:  no grammar for parser");
                    continue;
                }
                StatParser.parse(doc, span);
                continue;
            }
            if (action == "depParse") {
                DepParser.parseSentence(doc, span, doc.relations);
                continue;
            }
            if (action == "syntacticRelations") {
                AddSyntacticRelations.annotate(doc, span);
                continue;
            }
            if (action.startsWith("pat(") && action.endsWith(")")) {
                String patternSetName = action.substring(4, action.length() - 1).trim();
                JetTest.pc.apply(patternSetName, doc, span);
                continue;
            }
            if (action == "resolve") {
                Resolve.references(doc, span);
                continue;
            }
            if (action == "mentions(coindexed)") {
                CorefFilter.buildMentionsFromEntities(doc);
                continue;
            }
            if (action == "mentions(linked)") {
                CorefFilter.buildLinkedMentionsFromEntities(doc);
                continue;
            }
            if (action == "tagENE") {
                JetTest.extendedNameTagger.annotate(doc, span);
                continue;
            }
            if (action == "tagTimex") {
                Control.tagTimex(doc, span);
                continue;
            }
            if (action == "setReferenceTime") {
                Control.setReferenceTime(doc, span);
                continue;
            }
            System.out.println("Unknown Jet.processSentence action: " + action);
        }
    }

    private static String[] splitAtComma(String str) {
        StringTokenizer tok = new StringTokenizer(str, ",");
        int tokenCount = tok.countTokens();
        String[] result = new String[tokenCount];
        for (int i = 0; i < tokenCount; ++i) {
            result[i] = tok.nextToken().trim();
        }
        return result;
    }

    private static String toSGML(Document doc, String type) {
        if (type.equalsIgnoreCase("all")) {
            return doc.writeSGML(null).toString();
        }
        String[] types = Control.splitAtComma(type);
        if (types.length == 1) {
            return doc.writeSGML(types[0]).toString();
        }
        Document copied = new Document(doc.text());
        for (String annType : types) {
            Vector<Annotation> anns = doc.annotationsOfType(annType);
            if (anns == null) continue;
            for (Annotation o : anns) {
                copied.addAnnotation(o);
            }
        }
        return copied.writeSGML(null).toString();
    }

    private static void setReferenceTime(Document doc, Span span) {
        String str = doc.normalizedText(span);
        DateTimeFormatter format = JetTest.getReferenceTimeFormat();
        if (format == null) {
            System.err.println("setRefernceTime requires Timex.refFormat");
            return;
        }
        DateTime ref = format.parseDateTime(str);
        JetTest.setReferenceTime(ref);
    }

    private static void tagTimex(Document doc, Span span) {
        DateTime ref = JetTest.getReferenceTime();
        if (ref == null) {
            System.err.println("tagTimex requires refernce time.");
            return;
        }
        JetTest.getNumberAnnotator().annotate(doc, span);
        JetTest.getTimeAnnotator().annotate(doc, span, ref);
    }
}

