/*
 * Decompiled with CFR 0.152.
 */
package edu.nyu.jet;

import edu.nyu.jet.Console;
import edu.nyu.jet.Control;
import edu.nyu.jet.JetTest;
import edu.nyu.jet.lisp.FeatureSet;
import edu.nyu.jet.pat.Pat;
import edu.nyu.jet.refres.Resolve;
import edu.nyu.jet.scorer.SGMLProcessor;
import edu.nyu.jet.tipster.Annotation;
import edu.nyu.jet.tipster.Document;
import edu.nyu.jet.tipster.Span;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.Vector;

public class EntityFinder {
    static final int MaxProcessSentences = 100;

    static void writeDocRaw(Document doc, PrintStream out) throws IOException {
        out.println(doc.writeSGML(null).toString());
        out.flush();
    }

    static void writeDoc1(Document doc, PrintStream out) throws IOException {
        Vector<Annotation> entities = doc.annotationsOfType("entity");
        if (entities == null) {
            System.err.println("No Entity: " + doc);
            return;
        }
        Iterator<Annotation> entityIt = entities.iterator();
        int i = 0;
        while (entityIt.hasNext()) {
            Annotation entity = entityIt.next();
            Vector mentions = (Vector)entity.get("mentions");
            Iterator mentionIt = mentions.iterator();
            String nameType = (String)entity.get("nameType");
            while (mentionIt.hasNext()) {
                Annotation mention1 = (Annotation)mentionIt.next();
                Annotation mention2 = new Annotation("refobj", mention1.span(), new FeatureSet());
                mention2.put("objid", Integer.toString(i));
                if (nameType != null) {
                    mention2.put("netype", nameType);
                }
                doc.addAnnotation(mention2);
            }
            ++i;
        }
        String[] annotypes = doc.getAnnotationTypes();
        for (i = 0; i < annotypes.length; ++i) {
            String t = annotypes[i];
            if (t.equals("tagger") || t.equals("refobj") || t.equals("ENAMEX")) continue;
            doc.removeAnnotationsOfType(t);
        }
        EntityFinder.writeDocRaw(doc, out);
    }

    static void processDoc1(Document doc, int docno) throws IOException {
        String script = JetTest.config.getProperty("processDocument");
        if (JetTest.nameTagger != null) {
            JetTest.nameTagger.newDocument();
        }
        Span all = new Span(0, doc.length());
        Control.applyScript(doc, all, script);
    }

    static void processFile(String fname, PrintStream out) throws IOException {
        System.err.println("Processing: " + fname);
        FileInputStream fio = new FileInputStream(new File(fname));
        InputStreamReader fread = new InputStreamReader((InputStream)fio, JetTest.encoding);
        BufferedReader fp = new BufferedReader(fread);
        StringBuffer buf = new StringBuffer();
        int docno = 0;
        int allsents = 0;
        int processedsents = 0;
        while (true) {
            String line;
            if ((line = fp.readLine()) == null || line.equals("")) {
                if (0 < buf.length()) {
                    SGMLProcessor.allTags = true;
                    Document doc = SGMLProcessor.sgmlToDoc(buf.toString(), (String[])null);
                    doc.setSGMLwrapMargin(0);
                    System.err.println("Doc-" + docno + ": sents=" + allsents + ", processed=" + processedsents);
                    EntityFinder.processDoc1(doc, docno);
                    EntityFinder.writeDoc1(doc, out);
                    out.flush();
                    buf = new StringBuffer();
                    ++docno;
                    allsents = 0;
                    processedsents = 0;
                }
                if (line != null) continue;
                break;
            }
            if (line.startsWith("#")) {
                buf.append(line + "\n");
                continue;
            }
            ++allsents;
            if (processedsents >= 100) continue;
            buf.append("<sentence>");
            String[] words = line.split(" ");
            for (int i = 0; i < words.length; ++i) {
                if (0 == words[i].length()) continue;
                buf.append("<token>" + words[i] + " </token>");
            }
            buf.append("</sentence>\n");
            ++processedsents;
        }
        fp.close();
        fread.close();
        fio.close();
    }

    public static void main(String[] args) throws IOException, ClassNotFoundException {
        if (args.length < 2) {
            System.err.println("usage: java EntityFinder propfile datapath files ...");
            System.exit(2);
        }
        JetTest.initializeFromConfig(args[0], args[1]);
        Pat.trace = false;
        Resolve.trace = false;
        String script = JetTest.config.getProperty("processDocument");
        if (script == null || script.length() == 0) {
            Console.println("*** System error: no processDocument script.");
            return;
        }
        for (int i = 2; i < args.length; ++i) {
            EntityFinder.processFile(args[i], System.out);
        }
    }
}

