/*
 * Decompiled with CFR 0.152.
 */
package edu.nyu.jet;

import edu.nyu.jet.aceJet.Datum;
import edu.nyu.jet.chunk.LBFGSTrainer;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import opennlp.maxent.BasicEventStream;
import opennlp.maxent.GIS;
import opennlp.maxent.GISModel;
import opennlp.maxent.PlainTextByLineDataStream;
import opennlp.maxent.io.PlainTextGISModelReader;
import opennlp.maxent.io.PlainTextGISModelWriter;
import opennlp.maxent.io.SuffixSensitiveGISModelReader;
import opennlp.maxent.io.SuffixSensitiveGISModelWriter;
import opennlp.model.AbstractModel;
import opennlp.model.EventStream;

public class MaxEntModel {
    String featureFileName;
    String modelFileName;
    PrintStream featureWriter = null;
    GISModel model = null;
    boolean USE_L2 = true;
    int cutoff = 4;
    int iterations = 100;

    public MaxEntModel() {
    }

    public MaxEntModel(String featureFileName, String modelFileName) {
        this.featureFileName = featureFileName;
        this.modelFileName = modelFileName;
    }

    public void initializeForTraining(String featureFileName) {
        this.featureFileName = featureFileName;
        this.initializeForTraining();
    }

    public void initializeForTraining() {
        if (this.featureFileName == null) {
            System.out.println("MaxEntModel.initializeForTraining: no featureFileName specified");
        } else {
            try {
                this.featureWriter = new PrintStream(new FileOutputStream(this.featureFileName));
            }
            catch (IOException e) {
                System.out.print("Unable to create feature file: ");
                System.out.println(e);
            }
        }
    }

    public void addEvent(Datum d) {
        if (this.featureWriter == null) {
            this.initializeForTraining();
        }
        this.featureWriter.println(d.toString());
    }

    public void setCutoff(int cutoff) {
        this.cutoff = cutoff;
    }

    public void setIterations(int iterations) {
        this.iterations = iterations;
    }

    private static GISModel trainL2Model(EventStream eventStream, int cutoff, double c) throws IOException {
        LBFGSTrainer trainer = new LBFGSTrainer(c);
        return trainer.trainModel(eventStream, 100, cutoff);
    }

    public void buildModel() {
        boolean USE_SMOOTHING = false;
        double SMOOTHING_OBSERVATION = 0.1;
        boolean PRINT_MESSAGES = true;
        try {
            this.featureWriter.close();
            FileReader datafr = new FileReader(new File(this.featureFileName));
            BasicEventStream es = new BasicEventStream(new PlainTextByLineDataStream(datafr));
            GIS.SMOOTHING_OBSERVATION = SMOOTHING_OBSERVATION;
            this.model = this.USE_L2 ? MaxEntModel.trainL2Model(es, 0, 2.0) : GIS.trainModel(es, this.iterations, this.cutoff, USE_SMOOTHING, PRINT_MESSAGES);
        }
        catch (Exception e) {
            System.out.print("Unable to create model due to exception: ");
            System.out.println(e);
        }
    }

    public void saveModel() {
        if (this.modelFileName == null) {
            System.out.println("MaxEntModel.saveModel:  no modelFileName specified");
        } else {
            this.saveModel(this.modelFileName);
        }
    }

    public void saveModel(String modelFileName) {
        try {
            File outputFile = new File(modelFileName);
            SuffixSensitiveGISModelWriter modelWriter = new SuffixSensitiveGISModelWriter(this.model, outputFile);
            modelWriter.persist();
        }
        catch (IOException e) {
            System.out.print("Unable to save model: ");
            System.out.println(e);
        }
    }

    public void saveModel(BufferedWriter writer) {
        try {
            PlainTextGISModelWriter modelWriter = new PlainTextGISModelWriter((AbstractModel)this.model, writer);
            modelWriter.persist();
        }
        catch (IOException e) {
            System.out.print("Unable to save model: ");
            System.out.println(e);
        }
    }

    public void loadModel() {
        if (this.modelFileName == null) {
            System.out.println("MaxEntModel.loadModel:  no modelFileName specified");
        } else {
            this.loadModel(this.modelFileName);
        }
    }

    public void loadModel(String modelFileName) {
        try {
            File f = new File(modelFileName);
            this.model = (GISModel)new SuffixSensitiveGISModelReader(f).getModel();
            System.out.println("GIS model " + f.getName() + " loaded.");
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(0);
        }
    }

    public void loadModel(BufferedReader reader) {
        try {
            this.model = (GISModel)new PlainTextGISModelReader(reader).getModel();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(0);
        }
    }

    public boolean isLoaded() {
        return this.model != null;
    }

    public double prob(Datum d, String value) {
        return this.model.eval(d.toArray())[this.model.getIndex(value)];
    }

    public String bestOutcome(Datum d) {
        return this.model.getBestOutcome(this.model.eval(d.toArray())).intern();
    }

    public int getNumOutcomes() {
        return this.model.getNumOutcomes();
    }

    public String getOutcome(int i) {
        return this.model.getOutcome(i);
    }

    public double[] getOutcomeProbabilities(Datum d) {
        return this.model.eval(d.toArray());
    }
}

