/*
 * Decompiled with CFR 0.152.
 */
package edu.nyu.jet.aceJet;

import edu.nyu.jet.aceJet.AceDocument;
import edu.nyu.jet.aceJet.AceEntity;
import edu.nyu.jet.aceJet.AceEntityMention;
import edu.nyu.jet.lisp.FeatureSet;
import edu.nyu.jet.tipster.Document;
import edu.nyu.jet.tipster.ExternalDocument;
import edu.nyu.jet.tipster.Span;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;

class APFtoCorefXML {
    static String ACEdir;
    static String outputDir;
    static String apfExtension;
    static boolean showTypes;

    APFtoCorefXML() {
    }

    public static void main(String[] args) throws IOException {
        if (args.length != 4 && args.length != 5) {
            System.err.println("APFtoCorefXML requires 4 or 5 arguments:");
            System.err.println("  year apf-directory  output-directory  filelist [showTypes]");
            System.exit(1);
        }
        String year = args[0];
        apfExtension = ".apf.xml";
        AceDocument.ace2004 = false;
        AceDocument.ace2005 = false;
        if (year.equals("2002")) {
            apfExtension = ".sgm.tmx.rdc.xml";
        } else if (!year.equals("2003")) {
            if (year.equals("2004")) {
                AceDocument.ace2004 = true;
            } else if (year.equals("2005")) {
                AceDocument.ace2004 = true;
                AceDocument.ace2005 = true;
            } else {
                System.err.println("Invalid year:  must be 2002-2005");
                System.exit(1);
            }
        }
        ACEdir = args[1];
        if (!ACEdir.endsWith("/")) {
            ACEdir = ACEdir + "/";
        }
        if (!(outputDir = args[2]).endsWith("/")) {
            outputDir = outputDir + "/";
        }
        String fileList = args[3];
        showTypes = args.length == 5;
        APFtoCorefXML.processFileList(fileList);
    }

    private static void processFileList(String fileList) throws IOException {
        String currentDoc;
        BufferedReader reader = new BufferedReader(new FileReader(fileList));
        int docCount = 0;
        while ((currentDoc = reader.readLine()) != null) {
            System.out.println("\nProcessing document " + ++docCount + ": " + currentDoc);
            String textFileName = ACEdir + currentDoc + ".sgm";
            ExternalDocument doc = new ExternalDocument("sgml", textFileName);
            doc.setAllTags(true);
            doc.open();
            String APFfileName = ACEdir + currentDoc + apfExtension;
            AceDocument aceDoc = new AceDocument(textFileName, APFfileName);
            APFtoCorefXML.addMentionTags(doc, aceDoc);
            doc.setSGMLwrapMargin(0);
            doc.saveAs(outputDir, currentDoc + ".co.txt");
        }
    }

    static void addMentionTags(Document doc, AceDocument aceDoc) {
        ArrayList<AceEntity> entities = aceDoc.entities;
        for (int i = 0; i < entities.size(); ++i) {
            AceEntity entity = entities.get(i);
            ArrayList<AceEntityMention> mentions = entity.mentions;
            for (int j = 0; j < mentions.size(); ++j) {
                AceEntityMention mention = mentions.get(j);
                Span aceSpan = mention.head;
                Span jetSpan = new Span(aceSpan.start(), aceSpan.end() + 1);
                FeatureSet features = new FeatureSet("entity", new Integer(i));
                if (showTypes) {
                    features.put("type", entity.type.substring(0, 3));
                    if (entity.subtype != null) {
                        features.put("subtype", entity.subtype);
                    }
                }
                doc.annotate("mention", jetSpan, features);
            }
        }
    }
}

