/*
 * Decompiled with CFR 0.152.
 */
package edu.nyu.jet.aceJet;

import edu.nyu.jet.aceJet.AceDocument;
import edu.nyu.jet.aceJet.AceEntity;
import edu.nyu.jet.aceJet.AceEventArgumentValue;
import edu.nyu.jet.aceJet.AceMention;
import edu.nyu.jet.lex.Tokenizer;
import edu.nyu.jet.tipster.Span;
import java.io.PrintWriter;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class AceEntityMention
extends AceMention {
    public String type;
    public Span head;
    public Span jetHead;
    public String headText;
    String role;
    public AceEntity entity;

    public AceEntityMention(String id, String type, Span extent, Span head, String fileText) {
        this.id = id;
        this.type = type;
        this.extent = AceEntityMention.convertSpan(extent, fileText);
        this.jetExtent = extent;
        this.head = AceEntityMention.convertSpan(head, fileText);
        this.jetHead = head;
        this.entity = null;
        this.text = fileText.substring(this.extent.start(), this.extent.end() + 1);
        this.headText = fileText.substring(this.head.start(), this.head.end() + 1);
    }

    public AceEntityMention(Element mentionElement, String fileText) {
        this.id = mentionElement.getAttribute("ID");
        this.type = mentionElement.getAttribute("TYPE");
        this.role = mentionElement.getAttribute("ROLE");
        if (this.role == null) {
            this.role = "";
        }
        NodeList heads = mentionElement.getElementsByTagName("head");
        Element headElement = (Element)heads.item(0);
        this.head = AceEntityMention.decodeCharseq(headElement);
        this.jetHead = AceEntityMention.aceSpanToJetSpan(this.head, fileText);
        this.headText = fileText.substring(this.head.start(), this.head.end() + 1);
        NodeList extents = mentionElement.getElementsByTagName("extent");
        Element extentElement = (Element)extents.item(0);
        if (extentElement == null) {
            this.extent = this.head;
            this.jetExtent = this.jetHead;
            this.text = this.headText;
        } else {
            this.extent = AceEntityMention.decodeCharseq(extentElement);
            this.jetExtent = AceEntityMention.aceSpanToJetSpan(this.extent, fileText);
            this.text = fileText.substring(this.extent.start(), this.extent.end() + 1);
        }
    }

    public static Span convertSpan(Span jetSpan, String fileText) {
        int end;
        int start = jetSpan.start();
        for (end = jetSpan.end() - 1; end > start && Character.isWhitespace(fileText.charAt(end)); --end) {
        }
        return new Span(start, end);
    }

    static Span aceSpanToJetSpan(Span aceSpan, String fileText) {
        if (aceSpan == null) {
            return null;
        }
        int start = aceSpan.start();
        int aceEnd = aceSpan.end();
        int jetEnd = Tokenizer.skipWS(fileText, aceEnd + 1, fileText.length());
        Span jetSpan = new Span(start, jetEnd);
        return jetSpan;
    }

    public AceEventArgumentValue getParent() {
        return this.entity;
    }

    public String getType() {
        return this.entity.type;
    }

    public Span getJetHead() {
        return this.jetHead;
    }

    public String getHeadText() {
        return this.headText;
    }

    void write(PrintWriter w) {
        String apfType = AceDocument.ace2004 ? this.type.substring(0, 3) : this.type;
        w.print("    <entity_mention TYPE=\"" + apfType + "\" ID=\"" + this.id + "\"");
        if (this.role != null && !this.role.equals("")) {
            w.print(" ROLE=\"" + this.role + "\"");
        }
        w.println(">");
        w.println("      <extent>");
        AceEntityMention.writeCharseq(w, this.extent, this.text);
        w.println("      </extent>");
        w.println("      <head>");
        AceEntityMention.writeCharseq(w, this.head, this.headText);
        w.println("      </head>");
        w.println("    </entity_mention>");
    }

    static Span decodeCharseq(Element e) {
        String endS;
        String startS;
        if (AceDocument.ace2004) {
            NodeList charseqs = e.getElementsByTagName("charseq");
            Element charseq = (Element)charseqs.item(0);
            startS = charseq.getAttribute("START");
            endS = charseq.getAttribute("END");
        } else {
            startS = AceDocument.getElementText(e, "start");
            endS = AceDocument.getElementText(e, "end");
        }
        int start = Integer.parseInt(startS);
        int end = Integer.parseInt(endS);
        Span span = new Span(start, end);
        return span;
    }

    static void writeCharseq(PrintWriter w, Span s, String txt) {
        if (AceDocument.ace2004) {
            w.print("        <charseq START=\"" + s.start() + "\"" + " END=\"" + s.end() + "\">");
            w.print(AceEntityMention.addXmlEscapes(txt));
            w.println("</charseq>");
        } else {
            w.println("        <charseq>");
            w.println("          <start>" + s.start() + "</start>");
            w.println("          <!-- string = \"" + txt + "\" -->");
            w.println("          <end>" + s.end() + "</end>");
            w.println("        </charseq>");
        }
    }

    static String addXmlEscapes(String txt) {
        txt = txt.replaceAll("&", "&amp;");
        txt = txt.replaceAll("<", "&lt;");
        txt = txt.replaceAll(">", "&gt;");
        txt = txt.replaceAll("\"", "&quot;");
        txt = txt.replaceAll("'", "&apos;");
        return txt;
    }

    public boolean equals(Object o) {
        return o instanceof AceEntityMention && ((AceEntityMention)o).head.equals(this.head);
    }
}

