/*
 * Decompiled with CFR 0.152.
 */
package edu.nyu.jet.aceJet;

import edu.nyu.jet.aceJet.AceDocument;
import edu.nyu.jet.aceJet.AceEventArgument;
import edu.nyu.jet.aceJet.AceEventMention;
import java.io.PrintWriter;
import java.util.ArrayList;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class AceEvent {
    public String type;
    public String subtype;
    public String modality = "Asserted";
    public String polarity = "Positive";
    public String genericity = "Specific";
    public String tense = "Past";
    public String id;
    public ArrayList<AceEventArgument> arguments = new ArrayList();
    public ArrayList<AceEventMention> mentions = new ArrayList();

    public AceEvent(String id, String type, String subtype) {
        this.id = id;
        this.type = type;
        this.subtype = subtype;
    }

    public AceEvent(Element eventElement, AceDocument acedoc, String fileText) {
        this.id = eventElement.getAttribute("ID");
        this.type = eventElement.getAttribute("TYPE");
        this.subtype = eventElement.getAttribute("SUBTYPE");
        this.modality = eventElement.getAttribute("MODALITY");
        this.polarity = eventElement.getAttribute("POLARITY");
        this.genericity = eventElement.getAttribute("GENERICITY");
        this.tense = eventElement.getAttribute("TENSE");
        NodeList arguments = eventElement.getElementsByTagName("event_argument");
        for (int j = 0; j < arguments.getLength(); ++j) {
            Element argumentElement = (Element)arguments.item(j);
            AceEventArgument argument = new AceEventArgument(argumentElement, acedoc);
            this.addArgument(argument);
        }
        NodeList mentionElements = eventElement.getElementsByTagName("event_mention");
        for (int j = 0; j < mentionElements.getLength(); ++j) {
            Element mentionElement = (Element)mentionElements.item(j);
            AceEventMention mention = new AceEventMention(mentionElement, acedoc, fileText);
            this.addMention(mention);
        }
    }

    void setId(String id) {
        this.id = id;
    }

    public void addMention(AceEventMention mention) {
        this.mentions.add(mention);
    }

    void addArgument(AceEventArgument argument) {
        this.arguments.add(argument);
    }

    public void write(PrintWriter w) {
        int i;
        w.print("  <event ID=\"" + this.id + "\" TYPE=\"" + this.type + "\"");
        if (this.subtype != null && !this.subtype.equals("")) {
            w.print(" SUBTYPE=\"" + this.subtype + "\"");
        }
        w.print(" MODALITY=\"" + this.modality + "\"");
        w.print(" POLARITY=\"" + this.polarity + "\"");
        w.print(" GENERICITY=\"" + this.genericity + "\"");
        w.print(" TENSE=\"" + this.tense + "\"");
        w.println(">");
        for (i = 0; i < this.arguments.size(); ++i) {
            AceEventArgument argument = this.arguments.get(i);
            argument.write(w);
        }
        for (i = 0; i < this.mentions.size(); ++i) {
            AceEventMention mention = this.mentions.get(i);
            mention.write(w);
        }
        w.println("  </event>");
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("event ");
        buf.append(this.type);
        buf.append(".");
        buf.append(this.subtype);
        buf.append("{");
        for (int i = 0; i < this.mentions.size(); ++i) {
            AceEventMention mention = this.mentions.get(i);
            buf.append(mention.toString());
        }
        buf.append("} ");
        return buf.toString();
    }
}

