/*
 * Decompiled with CFR 0.152.
 */
package edu.nyu.jet.aceJet;

import edu.nyu.jet.aceJet.Ace;
import edu.nyu.jet.aceJet.AceDocument;
import edu.nyu.jet.aceJet.AceMention;
import java.io.PrintWriter;
import org.w3c.dom.Element;

public class AceEventMentionArgument {
    public String role;
    public AceMention value;
    public double confidence = 1.0;
    public double roleConfidence = 1.0;

    public AceEventMentionArgument(AceMention value, String role) {
        this.value = value;
        this.role = role;
    }

    public AceEventMentionArgument(Element argumentElement, AceDocument acedoc) {
        this.role = argumentElement.getAttribute("ROLE");
        String mentionid = argumentElement.getAttribute("REFID");
        this.value = acedoc.findMention(mentionid);
    }

    public void write(PrintWriter w) {
        w.print("      <event_mention_argument REFID=\"" + this.value.id + "\" ROLE=\"" + this.role + "\"");
        if (Ace.writeEventConfidence) {
            w.format(" p=\"%5.3f\"", this.confidence);
            w.format(" pRole=\"%5.3f\"", this.roleConfidence);
        }
        w.println("/>");
    }

    public String toString() {
        return this.role + ":" + (this.value == null ? "?" : this.value.getHeadText());
    }

    public boolean equals(Object o) {
        if (!(o instanceof AceEventMentionArgument)) {
            return false;
        }
        AceEventMentionArgument p = (AceEventMentionArgument)o;
        return this.role.equals(p.role) && this.value.id.equals(p.value.id);
    }
}

