/*
 * Decompiled with CFR 0.152.
 */
package edu.nyu.jet.aceJet;

import edu.nyu.jet.aceJet.AceEntityMention;
import edu.nyu.jet.tipster.Annotation;
import edu.nyu.jet.tipster.Document;
import edu.nyu.jet.tipster.Span;
import java.io.PrintWriter;
import java.util.Vector;

public class AcePlus {
    static int nodeNo;

    static void write(Document doc, PrintWriter w) {
        Vector<Annotation> sentences = doc.annotationsOfType("sentence");
        if (sentences == null) {
            return;
        }
        int sentNo = 0;
        for (Annotation sentence : sentences) {
            Annotation root;
            ++sentNo;
            Span sentenceSpan = new Span(sentence.span().start(), sentence.span().end());
            doc.shrink(sentence);
            Span shrunkSentenceSpan = sentence.span();
            String sentenceID = (String)sentence.get("ID");
            if (sentenceID == null) {
                sentenceID = "S." + sentNo;
                System.out.println("Generating sentence ID " + sentenceID);
            }
            String sourceSentIdFeature = "";
            String sourceSentID = (String)sentence.get("SOURCESENTID");
            if (sourceSentID != null) {
                sourceSentIdFeature = " SOURCESENTID=\"" + sourceSentID + "\"";
            }
            w.println("  <sentence ID=\"" + sentenceID + "\"" + sourceSentIdFeature + ">");
            w.println("    <charseq START=\"" + shrunkSentenceSpan.start() + "\"" + " END=\"" + (shrunkSentenceSpan.end() - 1) + "\"></charseq>");
            Vector<Annotation> tokens = doc.annotationsOfType("token", sentenceSpan);
            int tokenNo = 0;
            if (tokens != null) {
                for (Annotation token : tokens) {
                    doc.shrink(token);
                    Span tokenSpan = token.span();
                    Span aceTokenSpan = new Span(tokenSpan.start(), tokenSpan.end() - 1);
                    w.println("    <token ID=\"" + sentenceID + "." + ++tokenNo + "\">");
                    AceEntityMention.writeCharseq(w, aceTokenSpan, doc.text(tokenSpan));
                    w.println("    </token>");
                }
            }
            if ((root = (Annotation)sentence.get("parse")) != null) {
                w.println("    <parse>");
                nodeNo = 0;
                AcePlus.writeParseNode(doc, root, 0, sentNo, w);
                w.println("    </parse>");
            }
            w.println("  </sentence>");
        }
    }

    static void writeParseNode(Document doc, Annotation node, int level, int sentNo, PrintWriter w) {
        if (node == null) {
            return;
        }
        ++nodeNo;
        w.print("      ");
        for (int i = 0; i < level; ++i) {
            w.print("  ");
        }
        String cat = (String)node.get("cat");
        String id = "N-" + sentNo + "-" + nodeNo;
        w.println("<node cat=\"" + cat + "\" ID=\"" + id + "\">");
        Annotation[] children = (Annotation[])node.get("children");
        if (children != null) {
            for (Annotation child : children) {
                AcePlus.writeParseNode(doc, child, level + 1, sentNo, w);
            }
        } else {
            for (int i = 0; i < level; ++i) {
                w.print("  ");
            }
            doc.shrink(node);
            Span aceNodeSpan = new Span(node.start(), node.end() - 1);
            AceEntityMention.writeCharseq(w, aceNodeSpan, doc.text(node));
        }
        w.print("      ");
        for (int i = 0; i < level; ++i) {
            w.print("  ");
        }
        w.println("</node>");
    }
}

