/*
 * Decompiled with CFR 0.152.
 */
package edu.nyu.jet.aceJet;

import edu.nyu.jet.aceJet.AceDocument;
import edu.nyu.jet.aceJet.AceEntity;
import edu.nyu.jet.aceJet.AceRelationMention;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashSet;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class AceRelation {
    public String type;
    public String subtype;
    public String id;
    public String relClass;
    public AceEntity arg1;
    public AceEntity arg2;
    public ArrayList mentions = new ArrayList();
    static HashSet timeRoles = new HashSet();

    public AceRelation(String id, String type, String subtype, String relClass, AceEntity arg1, AceEntity arg2) {
        this.id = id;
        this.type = type;
        this.subtype = subtype;
        this.relClass = relClass;
        this.arg1 = arg1;
        this.arg2 = arg2;
    }

    public AceRelation(Element relationElement, AceDocument acedoc, String fileText) {
        String entityid;
        Element argument;
        int j;
        NodeList arguments;
        this.id = relationElement.getAttribute("ID");
        this.type = relationElement.getAttribute("TYPE");
        this.subtype = relationElement.getAttribute("SUBTYPE");
        this.relClass = relationElement.getAttribute("CLASS");
        if (AceDocument.ace2005) {
            arguments = relationElement.getElementsByTagName("relation_argument");
            for (j = 0; j < arguments.getLength(); ++j) {
                argument = (Element)arguments.item(j);
                entityid = argument.getAttribute("REFID");
                String role = argument.getAttribute("ROLE");
                if (role.equals("Arg-1")) {
                    this.arg1 = acedoc.findEntity(entityid);
                    continue;
                }
                if (role.equals("Arg-2")) {
                    this.arg2 = acedoc.findEntity(entityid);
                    continue;
                }
                if (timeRoles.contains(role)) continue;
                System.err.println("*** invalid ROLE \"" + role + "\" for relation");
            }
        } else {
            arguments = relationElement.getElementsByTagName("rel_entity_arg");
            for (j = 0; j < arguments.getLength(); ++j) {
                argument = (Element)arguments.item(j);
                entityid = argument.getAttribute("ENTITYID");
                String argnum = argument.getAttribute("ARGNUM");
                if (argnum.equals("1")) {
                    this.arg1 = acedoc.findEntity(entityid);
                    continue;
                }
                if (argnum.equals("2")) {
                    this.arg2 = acedoc.findEntity(entityid);
                    continue;
                }
                System.err.println("*** invalid ARGNUM for relation");
            }
        }
        NodeList mentionElements = relationElement.getElementsByTagName("relation_mention");
        for (j = 0; j < mentionElements.getLength(); ++j) {
            Element mentionElement = (Element)mentionElements.item(j);
            AceRelationMention mention = new AceRelationMention(mentionElement, acedoc, fileText);
            this.addMention(mention);
        }
    }

    public void addMention(AceRelationMention mention) {
        this.mentions.add(mention);
        mention.relation = this;
    }

    public void write(PrintWriter w) {
        w.print("  <relation ID=\"" + this.id + "\" TYPE=\"" + this.type + "\"");
        if (this.subtype != null && !this.subtype.equals("")) {
            w.print(" SUBTYPE=\"" + this.subtype + "\"");
        }
        if (!AceDocument.ace2004) {
            w.print(" CLASS=\"" + this.relClass + "\"");
        }
        w.println(">");
        if (AceDocument.ace2005) {
            w.println("    <relation_argument REFID=\"" + this.arg1.id + "\" ROLE=\"Arg-1\" />");
            w.println("    <relation_argument REFID=\"" + this.arg2.id + "\" ROLE=\"Arg-2\" />");
        } else {
            w.println("    <rel_entity_arg ENTITYID=\"" + this.arg1.id + "\" ARGNUM=\"1\" />");
            w.println("    <rel_entity_arg ENTITYID=\"" + this.arg2.id + "\" ARGNUM=\"2\" />");
        }
        if (!AceDocument.ace2004) {
            w.println("    <relation_mentions>");
        }
        for (int i = 0; i < this.mentions.size(); ++i) {
            AceRelationMention mention = (AceRelationMention)this.mentions.get(i);
            mention.write(w);
        }
        if (!AceDocument.ace2004) {
            w.println("    </relation_mentions>");
        }
        w.println("  </relation>");
    }

    public String toString() {
        StringBuffer sbuf = new StringBuffer();
        for (int i = 0; i < this.mentions.size(); ++i) {
            sbuf.append(this.mentions.get(i).toString());
            sbuf.append(" ");
        }
        return sbuf.toString();
    }

    static {
        timeRoles.add("Time-Within");
        timeRoles.add("Time-Starting");
        timeRoles.add("Time-Ending");
        timeRoles.add("Time-Before");
        timeRoles.add("Time-After");
        timeRoles.add("Time-Holds");
        timeRoles.add("Time-At-Beginning");
        timeRoles.add("Time-At-End");
    }
}

