/*
 * Decompiled with CFR 0.152.
 */
package edu.nyu.jet.aceJet;

import edu.nyu.jet.aceJet.AceEntityMention;
import edu.nyu.jet.aceJet.AceEventArgumentValue;
import edu.nyu.jet.aceJet.AceMention;
import edu.nyu.jet.aceJet.AceValue;
import edu.nyu.jet.tipster.Span;
import java.io.PrintWriter;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class AceValueMention
extends AceMention {
    public AceValue value;

    public AceValueMention(String id, Span extent, String fileText) {
        this.id = id;
        this.extent = AceEntityMention.convertSpan(extent, fileText);
        this.jetExtent = extent;
        this.text = fileText.substring(this.extent.start(), this.extent.end() + 1);
    }

    public AceValueMention(Element mentionElement, String fileText) {
        this.id = mentionElement.getAttribute("ID");
        NodeList extents = mentionElement.getElementsByTagName("extent");
        Element extentElement = (Element)extents.item(0);
        if (extentElement == null) {
            System.err.println("*** AceValueMention:  no extent.");
        } else {
            this.extent = AceEntityMention.decodeCharseq(extentElement);
            this.jetExtent = AceEntityMention.aceSpanToJetSpan(this.extent, fileText);
            this.text = fileText.substring(this.extent.start(), this.extent.end() + 1);
        }
    }

    public AceEventArgumentValue getParent() {
        return this.value;
    }

    public String getType() {
        return this.value.type;
    }

    public boolean equals(Object o) {
        return o instanceof AceValueMention && ((AceValueMention)o).extent.equals(this.extent);
    }

    void write(PrintWriter w) {
        w.println("    <value_mention ID=\"" + this.id + "\">");
        w.println("      <extent>");
        AceEntityMention.writeCharseq(w, this.extent, this.text);
        w.println("      </extent>");
        w.println("    </value_mention>");
    }
}

