/*
 * Decompiled with CFR 0.152.
 */
package edu.nyu.jet.aceJet;

import edu.nyu.jet.aceJet.AceDocument;
import edu.nyu.jet.aceJet.AceEvent;
import edu.nyu.jet.aceJet.AceEventMention;
import edu.nyu.jet.aceJet.AceEventMentionArgument;
import edu.nyu.jet.aceJet.AceMention;
import edu.nyu.jet.tipster.ExternalDocument;
import edu.nyu.jet.tipster.Span;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventScorer {
    static String textDirectory;
    static String textExtension;
    static String systemApfDirectory;
    static String systemApfExtension;
    static String keyApfDirectory;
    static String keyApfExtension;
    static int correctTriggers;
    static int spuriousTriggers;
    static int missingTriggers;
    static float triggerRecall;
    static float triggerPrecision;
    static float triggerF;
    static int correctArguments;
    static int spuriousArguments;
    static int missingArguments;
    static float argumentRecall;
    static float argumentPrecision;
    static float argumentF;
    static int correctRoles;
    static int spuriousRoles;
    static int missingRoles;
    static float roleRecall;
    static float rolePrecision;
    static float roleF;

    public static void main(String[] args) throws IOException {
        String docName;
        if (args.length != 7) {
            System.out.println("EventScorer requires 7 args:  ");
            System.out.print("    docList textDirectory textExtension ");
            System.out.println("systemApfDirectory systemApfExtension keyApfDirectory keyApfExtension");
            System.exit(1);
        }
        String docListFile = args[0];
        textDirectory = args[1];
        textExtension = args[2];
        systemApfDirectory = args[3];
        systemApfExtension = args[4];
        keyApfDirectory = args[5];
        keyApfExtension = args[6];
        BufferedReader docListReader = new BufferedReader(new FileReader(docListFile));
        while ((docName = docListReader.readLine()) != null) {
            EventScorer.scoreDocument(docName);
        }
        EventScorer.computeScores();
        EventScorer.reportScores();
    }

    public static void scoreDocument(String docName) {
        String textFileName = textDirectory + "/" + docName + "." + textExtension;
        ExternalDocument doc = new ExternalDocument("sgml", textFileName);
        doc.setAllTags(true);
        doc.open();
        HashSet<String> systemTriggers = new HashSet<String>();
        HashSet<String> systemArguments = new HashSet<String>();
        HashSet<String> systemRoles = new HashSet<String>();
        String systemApfFileName = systemApfDirectory + "/" + docName + "." + systemApfExtension;
        EventScorer.readApf(textFileName, systemApfFileName, systemTriggers, systemArguments, systemRoles);
        HashSet<String> keyTriggers = new HashSet<String>();
        HashSet<String> keyArguments = new HashSet<String>();
        HashSet<String> keyRoles = new HashSet<String>();
        String keyApfFileName = keyApfDirectory + "/" + docName + "." + keyApfExtension;
        EventScorer.readApf(textFileName, keyApfFileName, keyTriggers, keyArguments, keyRoles);
        int docCorrectTriggers = EventScorer.sizeOfSetIntersection(systemTriggers, keyTriggers);
        int docSpuriousTriggers = EventScorer.sizeOfSetDifference(systemTriggers, keyTriggers);
        int docMissingTriggers = EventScorer.sizeOfSetDifference(keyTriggers, systemTriggers);
        int docCorrectArguments = EventScorer.sizeOfSetIntersection(systemArguments, keyArguments);
        int docSpuriousArguments = EventScorer.sizeOfSetDifference(systemArguments, keyArguments);
        int docMissingArguments = EventScorer.sizeOfSetDifference(keyArguments, systemArguments);
        int docCorrectRoles = EventScorer.sizeOfSetIntersection(systemRoles, keyRoles);
        int docSpuriousRoles = EventScorer.sizeOfSetDifference(systemRoles, keyRoles);
        int docMissingRoles = EventScorer.sizeOfSetDifference(keyRoles, systemRoles);
        correctTriggers += docCorrectTriggers;
        spuriousTriggers += docSpuriousTriggers;
        missingTriggers += docMissingTriggers;
        correctArguments += docCorrectArguments;
        spuriousArguments += docSpuriousArguments;
        missingArguments += docMissingArguments;
        correctRoles += docCorrectRoles;
        spuriousRoles += docSpuriousRoles;
        missingRoles += docMissingRoles;
    }

    static void readApf(String textFileName, String apfFileName, Set<String> triggers, Set<String> arguments, Set<String> roles) {
        AceDocument aceDoc = new AceDocument(textFileName, apfFileName);
        for (AceEvent event : aceDoc.events) {
            String eType = event.type + ":" + event.subtype;
            for (AceEventMention mention : event.mentions) {
                Span triggerSpan = mention.anchorJetExtent;
                triggers.add(eType + ":" + triggerSpan);
                for (AceEventMentionArgument argument : mention.arguments) {
                    AceMention arg = argument.value;
                    arguments.add(eType + ":" + arg.getJetHead());
                    roles.add(eType + ":" + argument.role + ":" + arg.getJetHead());
                }
            }
        }
    }

    static void computeScores() {
        triggerRecall = (float)correctTriggers / (float)(correctTriggers + missingTriggers);
        triggerPrecision = (float)correctTriggers / (float)(correctTriggers + spuriousTriggers);
        triggerF = 2.0f * triggerPrecision * triggerRecall / (triggerPrecision + triggerRecall);
        argumentRecall = (float)correctArguments / (float)(correctArguments + missingArguments);
        argumentPrecision = (float)correctArguments / (float)(correctArguments + spuriousArguments);
        argumentF = 2.0f * argumentPrecision * argumentRecall / (argumentPrecision + argumentRecall);
        roleRecall = (float)correctRoles / (float)(correctRoles + missingRoles);
        rolePrecision = (float)correctRoles / (float)(correctRoles + spuriousRoles);
        roleF = 2.0f * rolePrecision * roleRecall / (rolePrecision + roleRecall);
    }

    static int sizeOfSetIntersection(Set a, Set b) {
        HashSet intersection = new HashSet(a);
        intersection.retainAll(b);
        return intersection.size();
    }

    static int sizeOfSetDifference(Set a, Set b) {
        HashSet difference = new HashSet(a);
        difference.removeAll(b);
        return difference.size();
    }

    static void reportScores() {
        System.out.printf("Triggers:   R = %6.2f   P = %6.2f   F = %6.2f\n", Float.valueOf(triggerRecall * 100.0f), Float.valueOf(triggerPrecision * 100.0f), Float.valueOf(triggerF * 100.0f));
        System.out.printf("Arguments:  R = %6.2f   P = %6.2f   F = %6.2f\n", Float.valueOf(argumentRecall * 100.0f), Float.valueOf(argumentPrecision * 100.0f), Float.valueOf(argumentF * 100.0f));
        System.out.printf("Roles:      R = %6.2f   P = %6.2f   F = %6.2f\n", Float.valueOf(roleRecall * 100.0f), Float.valueOf(rolePrecision * 100.0f), Float.valueOf(roleF * 100.0f));
    }

    static {
        correctTriggers = 0;
        spuriousTriggers = 0;
        missingTriggers = 0;
        correctArguments = 0;
        spuriousArguments = 0;
        missingArguments = 0;
        correctRoles = 0;
        spuriousRoles = 0;
        missingRoles = 0;
    }
}

