/*
 * Decompiled with CFR 0.152.
 */
package edu.nyu.jet.aceJet;

import edu.nyu.jet.aceJet.AceDocument;
import edu.nyu.jet.aceJet.AceEntityMention;
import edu.nyu.jet.aceJet.AceEventArgument;
import edu.nyu.jet.aceJet.AceEventMentionArgument;
import edu.nyu.jet.aceJet.AceMention;
import edu.nyu.jet.aceJet.AcePatternNode;
import edu.nyu.jet.aceJet.EventPattern;
import edu.nyu.jet.parser.SyntacticRelation;
import edu.nyu.jet.parser.SyntacticRelationSet;
import edu.nyu.jet.tipster.Document;
import edu.nyu.jet.tipster.Span;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventSyntacticPattern {
    static final Logger logger = LoggerFactory.getLogger(EventSyntacticPattern.class);
    public static final int radius = 4;

    static SyntacticRelationSet buildPattern(String patternType, int anchorStart, int[] argumentPosn, SyntacticRelationSet relations) {
        HashMap<Integer, Integer> indexMap = new HashMap<Integer, Integer>();
        for (int i = 0; i < argumentPosn.length; ++i) {
            indexMap.put(argumentPosn[i], i);
        }
        HashMap<Integer, String> wordMap = new HashMap<Integer, String>();
        HashMap path = new HashMap();
        int argsToConnect = argumentPosn.length - 1;
        int variable = 0;
        LinkedList<Integer> todo = new LinkedList<Integer>();
        todo.add(anchorStart);
        path.put(anchorStart, new HashSet());
        while (todo.size() > 0 && argsToConnect > 0) {
            Integer from = (Integer)todo.removeFirst();
            if (((HashSet)path.get(from)).size() >= 4) continue;
            logger.trace("from = " + from);
            int fromIndex = (Integer)indexMap.get(from);
            SyntacticRelationSet fromSet = relations.getRelationsFrom(from);
            logger.trace("fromSet = " + fromSet);
            for (int ifrom = 0; ifrom < fromSet.size(); ++ifrom) {
                SyntacticRelation r = fromSet.get(ifrom);
                if (patternType == "SYNTAX" && EventSyntacticPattern.isPaRelation(r)) continue;
                Integer to = new Integer(r.targetPosn);
                logger.trace("to = " + to);
                if (path.get(to) == null) {
                    todo.add(to);
                    wordMap.put(to, r.targetWord);
                    if (indexMap.get(to) != null && (Integer)indexMap.get(to) >= 0) {
                        --argsToConnect;
                    } else {
                        indexMap.put(to, --variable);
                    }
                }
                SyntacticRelation rp = new SyntacticRelation(fromIndex, r.sourceWord, r.type, (Integer)indexMap.get(to), r.targetWord);
                HashSet<SyntacticRelation> topath = new HashSet<SyntacticRelation>((Collection)path.get(from));
                topath.add(rp);
                logger.trace("topath = " + topath);
                HashSet oldpath = (HashSet)path.get(to);
                if (oldpath != null && (patternType != "PA" || topath.size() > oldpath.size() || EventSyntacticPattern.paRelationCount(topath) <= EventSyntacticPattern.paRelationCount(oldpath))) continue;
                path.put(to, topath);
            }
        }
        SyntacticRelationSet pattern = new SyntacticRelationSet();
        for (int i = 0; i < argumentPosn.length; ++i) {
            HashSet h = (HashSet)path.get(argumentPosn[i]);
            if (h == null) continue;
            pattern.addAll(h);
        }
        return pattern;
    }

    static boolean isPaRelation(SyntacticRelation r) {
        return r.type.startsWith("ARG");
    }

    static int paRelationCount(HashSet<SyntacticRelation> path) {
        int count = 0;
        for (SyntacticRelation r : path) {
            if (!EventSyntacticPattern.isPaRelation(r)) continue;
            ++count;
        }
        return count;
    }

    public static String buildSyntacticPath(int anchorStart, int argumentPosn, SyntacticRelationSet relations) {
        HashMap<Integer, String> path = new HashMap<Integer, String>();
        boolean variable = false;
        LinkedList<Integer> todo = new LinkedList<Integer>();
        todo.add(new Integer(anchorStart));
        path.put(new Integer(anchorStart), "");
        while (todo.size() > 0) {
            Integer from = (Integer)todo.removeFirst();
            logger.trace("from = " + from);
            SyntacticRelationSet fromSet = relations.getRelationsFrom(from);
            logger.trace("fromSet = " + fromSet);
            for (int ifrom = 0; ifrom < fromSet.size(); ++ifrom) {
                SyntacticRelation r = fromSet.get(ifrom);
                Integer to = new Integer(r.targetPosn);
                if (path.get(to) != null) continue;
                logger.trace("to = " + to);
                if (to == argumentPosn) {
                    logger.trace("TO is an argument");
                    return ((String)path.get(from) + ":" + r.type).substring(1);
                }
                path.put(to, (String)path.get(from) + ":" + r.type + ":" + r.targetWord);
                todo.add(to);
            }
        }
        return null;
    }

    public static String buildSyntacticPath(int anchorStart, int argumentPosn, SyntacticRelationSet relations, List<AceEntityMention> localMentions) {
        HashMap<Integer, String> path = new HashMap<Integer, String>();
        boolean variable = false;
        LinkedList<Integer> todo = new LinkedList<Integer>();
        todo.add(new Integer(anchorStart));
        path.put(new Integer(anchorStart), "");
        while (todo.size() > 0) {
            Integer from = (Integer)todo.removeFirst();
            logger.trace("from = " + from);
            SyntacticRelationSet fromSet = relations.getRelationsFrom(from);
            logger.trace("fromSet = " + fromSet);
            for (int ifrom = 0; ifrom < fromSet.size(); ++ifrom) {
                SyntacticRelation r = fromSet.get(ifrom);
                Integer to = new Integer(r.targetPosn);
                if (path.get(to) != null || to != argumentPosn && EventSyntacticPattern.matchMention(to, localMentions)) continue;
                logger.trace("to = " + to);
                if (to == argumentPosn) {
                    logger.trace("TO is an argument");
                    return ((String)path.get(from) + ":" + r.type).substring(1);
                }
                path.put(to, (String)path.get(from) + ":" + r.type + ":" + r.targetWord);
                todo.add(to);
            }
        }
        return null;
    }

    public static String buildSyntacticPathOnSpans(int fromPosn, int toPosn, SyntacticRelationSet relations, List<Span> localSpans) {
        HashMap<Integer, String> path = new HashMap<Integer, String>();
        boolean variable = false;
        LinkedList<Integer> todo = new LinkedList<Integer>();
        todo.add(new Integer(fromPosn));
        path.put(new Integer(fromPosn), "");
        while (todo.size() > 0) {
            Integer from = (Integer)todo.removeFirst();
            logger.trace("from = " + from);
            SyntacticRelationSet fromSet = relations.getRelationsFrom(from);
            logger.trace("fromSet = " + fromSet);
            for (int ifrom = 0; ifrom < fromSet.size(); ++ifrom) {
                SyntacticRelation r = fromSet.get(ifrom);
                Integer to = new Integer(r.targetPosn);
                if (path.get(to) != null || to != toPosn && EventSyntacticPattern.matchSpan(to, localSpans)) continue;
                logger.trace("to = " + to);
                if (to == toPosn) {
                    logger.trace("TO is an argument");
                    return ((String)path.get(from) + ":" + r.type).substring(1);
                }
                path.put(to, (String)path.get(from) + ":" + r.type + ":" + r.targetWord);
                todo.add(to);
            }
        }
        return null;
    }

    private static boolean matchSpan(int posn, List<Span> spans) {
        for (Span span : spans) {
            if (span.start() != posn) continue;
            return true;
        }
        return false;
    }

    private static boolean matchMention(int posn, List<AceEntityMention> mentions) {
        for (AceMention aceMention : mentions) {
            if (aceMention.jetExtent.start() != posn) continue;
            return true;
        }
        return false;
    }

    static ArrayList match(EventPattern pattern, int anchorStart, Document doc, SyntacticRelationSet relations, AceDocument aceDoc) {
        pattern.syntaxMatchScore = 0;
        if (pattern.syntax == null || pattern.syntax.size() == 0) {
            return null;
        }
        ArrayList<AceEventMentionArgument> argumentValue = new ArrayList<AceEventMentionArgument>();
        HashMap<Integer, ArrayList<Integer>> offsetMap = new HashMap<Integer, ArrayList<Integer>>();
        EventSyntacticPattern.addToMap(offsetMap, pattern.anchorPosn, anchorStart);
        LinkedList<Integer> todo = new LinkedList<Integer>();
        todo.add(pattern.anchorPosn);
        HashSet<AceMention> mentionsUsed = new HashSet<AceMention>();
        while (todo.size() > 0) {
            int from = (Integer)todo.removeFirst();
            logger.trace("from = " + from);
            ArrayList<Integer> fromOffsets = offsetMap.get(from);
            SyntacticRelationSet fromPatternSet = pattern.syntax.getRelationsFrom(from);
            logger.trace("fromPatternSet = " + fromPatternSet);
            for (int i = 0; i < fromOffsets.size(); ++i) {
                int fromOffset = fromOffsets.get(i);
                logger.trace("fromOffset = " + fromOffset);
                SyntacticRelationSet fromSet = relations.getRelationsFrom(fromOffset);
                logger.trace("fromSet = " + fromSet);
                block2: for (int ifromPat = 0; ifromPat < fromPatternSet.size(); ++ifromPat) {
                    SyntacticRelation rp = fromPatternSet.get(ifromPat);
                    for (int ifrom = 0; ifrom < fromSet.size(); ++ifrom) {
                        SyntacticRelation r = fromSet.get(ifrom);
                        if (!rp.type.equals(r.type)) continue;
                        int to = rp.targetPosn;
                        logger.trace("to = " + to);
                        int toOffset = r.targetPosn;
                        EventSyntacticPattern.addToMap(offsetMap, to, toOffset);
                        if (to >= 0) {
                            AceMention mention;
                            ArrayList roleSet;
                            String role0;
                            AcePatternNode node = (AcePatternNode)pattern.nodes.get(to);
                            int nodeScore = node.matchOnHead(toOffset, doc, aceDoc);
                            if (nodeScore < 10100 || !AceEventArgument.isValid(pattern.eventSubtype, role0 = (String)(roleSet = pattern.roles[to]).get(0), mention = node.getMatchedMention()) || mentionsUsed.contains(mention)) continue block2;
                            pattern.syntaxMatchScore += nodeScore;
                            for (int irole = 0; irole < roleSet.size(); ++irole) {
                                String role = (String)roleSet.get(irole);
                                argumentValue.add(new AceEventMentionArgument(mention, role));
                            }
                            mentionsUsed.add(mention);
                        } else if (!r.targetWord.equals(rp.targetWord)) continue block2;
                        if (todo.contains(to)) continue;
                        todo.add(to);
                    }
                }
            }
        }
        return argumentValue;
    }

    static void addToMap(HashMap<Integer, ArrayList<Integer>> map, int index, int value) {
        ArrayList<Integer> y = map.get(index);
        if (y == null) {
            y = new ArrayList();
        }
        if (!y.contains(value)) {
            y.add(value);
        }
        map.put(index, y);
    }
}

