/*
 * Decompiled with CFR 0.152.
 */
package edu.nyu.jet.aceJet;

import edu.nyu.jet.Control;
import edu.nyu.jet.JetTest;
import edu.nyu.jet.aceJet.Ace;
import edu.nyu.jet.aceJet.AceDocument;
import edu.nyu.jet.aceJet.AceEvent;
import edu.nyu.jet.aceJet.AceEventAnchor;
import edu.nyu.jet.aceJet.AceEventArgument;
import edu.nyu.jet.aceJet.AceEventArgumentValue;
import edu.nyu.jet.aceJet.AceEventMention;
import edu.nyu.jet.aceJet.AceEventMentionArgument;
import edu.nyu.jet.aceJet.AceMention;
import edu.nyu.jet.aceJet.ChunkPath;
import edu.nyu.jet.aceJet.Datum;
import edu.nyu.jet.aceJet.EventPattern;
import edu.nyu.jet.aceJet.EventSyntacticPattern;
import edu.nyu.jet.parser.DepParser;
import edu.nyu.jet.parser.SyntacticRelationSet;
import edu.nyu.jet.pat.Pat;
import edu.nyu.jet.refres.Resolve;
import edu.nyu.jet.tipster.Annotation;
import edu.nyu.jet.tipster.Document;
import edu.nyu.jet.tipster.ExternalDocument;
import edu.nyu.jet.tipster.Span;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;
import opennlp.maxent.GISModel;
import opennlp.maxent.io.SuffixSensitiveGISModelReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventTagger {
    static final Logger logger = LoggerFactory.getLogger(EventTagger.class);
    static boolean useArgumentModel = true;
    static double EVENT_PROBABILITY_THRESHOLD = 0.5;
    static double MIN_ARG_PROBABILITY = 0.1;
    static double ARGUMENT_PROBABILITY_THRESHOLD = 0.1;
    static double COREF_CONFIDENCE = 0.1;
    static double COREF_THRESHOLD = 0.4;
    TreeMap<String, List<EventPattern>> anchorMap;
    PrintStream eventFeatureWriter;
    PrintStream argFeatureWriter;
    PrintStream roleFeatureWriter;
    PrintStream corefFeatureWriter;
    static GISModel eventModel;
    static GISModel argModel;
    static GISModel roleModel;
    static GISModel corefModel;
    static String triplesSuffix;
    static boolean usePA;
    static boolean useParser;
    String[] patternTypeList = new String[]{"CHUNK", "SYNTAX", "PA"};
    private static boolean evalTrace;
    private static int eventWeight;
    AceEventMention correctEventMention = null;
    private static double CONFIDENT_ARG;
    EventPattern patternMatched;
    static String docDir;
    static String modelDir;
    static String outputDir;
    static String glarfDir;

    public EventTagger() {
        this.anchorMap = new TreeMap();
    }

    public void acquirePatterns(Document doc, AceDocument aceDoc, String docId) {
        SyntacticRelationSet relations = new SyntacticRelationSet();
        if (DepParser.isInitialized()) {
            relations = DepParser.parseDocument(doc);
        } else if (usePA) {
            relations.readRelations(glarfDir + docId + triplesSuffix);
        } else {
            relations.addRelations(doc);
        }
        ArrayList<AceEvent> events = aceDoc.events;
        for (int i = 0; i < events.size(); ++i) {
            AceEvent event = events.get(i);
            ArrayList<AceEventMention> mentions = event.mentions;
            for (int j = 0; j < mentions.size(); ++j) {
                AceEventMention m = mentions.get(j);
                System.out.println("\nProcessing event mention " + m.id + " = " + m.text);
                Span anchorExtent = m.anchorJetExtent;
                String anchor = EventPattern.normalizedAnchor(anchorExtent, m.anchorText, doc, relations);
                for (String patternType : this.patternTypeList) {
                    EventPattern ep = new EventPattern(patternType, doc, relations, event, m);
                    if (ep.empty()) continue;
                    System.out.println(patternType + " pattern = " + ep);
                    this.addPattern(anchor, ep);
                    AceEvent builtEvent = ep.match(anchorExtent, anchor, doc, relations, aceDoc);
                    if (builtEvent != null) continue;
                    System.err.println("**** match failed ****");
                }
                this.trainArgClassifier(event, m, doc, aceDoc, relations);
            }
        }
    }

    private void addPattern(String anchor, EventPattern ep) {
        String relatedForm;
        List<EventPattern> patternList = this.anchorMap.get(anchor);
        if (patternList == null) {
            patternList = new ArrayList<EventPattern>();
            this.anchorMap.put(anchor, patternList);
        }
        if (!patternList.contains(ep)) {
            patternList.add(ep);
        }
        if ((relatedForm = (String)SyntacticRelationSet.nomVmap.get(anchor)) != null) {
            EventPattern epClone = new EventPattern(ep);
            epClone.anchor = relatedForm;
            epClone.paths = null;
            patternList = this.anchorMap.get(relatedForm);
            if (patternList == null) {
                patternList = new ArrayList<EventPattern>();
                this.anchorMap.put(relatedForm, patternList);
            }
            if (!patternList.contains(epClone)) {
                patternList.add(epClone);
            }
        }
    }

    private void addBasicPattern(String anchor, EventPattern ep) {
        List<EventPattern> patternList = this.anchorMap.get(anchor);
        if (patternList == null) {
            patternList = new ArrayList<EventPattern>();
            this.anchorMap.put(anchor, patternList);
        }
        if (!patternList.contains(ep)) {
            patternList.add(ep);
        }
    }

    private void trainArgClassifier(AceEvent event, AceEventMention eventMention, Document doc, AceDocument aceDoc, SyntacticRelationSet relations) {
        Span anchorExtent = eventMention.anchorJetExtent;
        String anchorText = eventMention.anchorText;
        String anchor = EventPattern.normalizedAnchor(anchorExtent, anchorText, doc, relations);
        AceEventAnchor anchorMention = new AceEventAnchor(anchorExtent, anchorExtent, anchorText, doc);
        Annotation sentence = this.findContainingSentence(doc, anchorExtent);
        if (sentence == null) {
            return;
        }
        Span sentenceSpan = sentence.span();
        ArrayList<AceMention> mentions = aceDoc.getAllMentions();
        for (int im = 0; im < mentions.size(); ++im) {
            AceMention mention = mentions.get(im);
            if (!mention.jetExtent.within(sentenceSpan)) continue;
            ArrayList<AceEventMentionArgument> arguments = eventMention.arguments;
            String role = "noArg";
            for (int ia = 0; ia < arguments.size(); ++ia) {
                AceEventMentionArgument argument = arguments.get(ia);
                if (!argument.value.equals(mention)) continue;
                role = argument.role;
                break;
            }
            Datum d = this.argumentFeatures(doc, anchor, event, mention, anchorMention, relations);
            if (role == "noArg") {
                d.setOutcome("noArg");
                this.argFeatureWriter.println(d.toString());
                continue;
            }
            d.setOutcome("arg");
            this.argFeatureWriter.println(d.toString());
            d.setOutcome(role);
            this.roleFeatureWriter.println(d.toString());
        }
    }

    private Datum argumentFeatures(Document doc, String anchor, AceEvent event, AceMention mention, AceMention anchorMention, SyntacticRelationSet relations) {
        ChunkPath cpath;
        String direction;
        if (anchorMention.getJetHead().start() < mention.getJetHead().start()) {
            direction = "follow";
            cpath = new ChunkPath(doc, anchorMention, mention);
        } else {
            direction = "precede";
            cpath = new ChunkPath(doc, mention, anchorMention);
        }
        String spath = EventSyntacticPattern.buildSyntacticPath(anchorMention.getJetHead().start(), mention.getJetHead().start(), relations);
        Datum d = new Datum();
        d.addFV("anchor", anchor);
        d.addFV("evType", event.type);
        d.addFV("menType", mention.getType());
        String headText = Resolve.normalizeName(mention.getHeadText()).replace(' ', '_');
        d.addFV("arg", headText);
        d.addFV("evTypeArg", event.subtype + ":" + headText);
        int pos = mention.jetExtent.start();
        Annotation token = doc.tokenEndingAt(pos);
        if (token != null) {
            d.addFV("prevToken", doc.text(token).trim());
            d.addFV("prevTokenAndType", event.type + "_" + doc.text(token).trim());
        }
        if (cpath == null || cpath.toString() == null) {
            d.addFV("noChunkPath", null);
        } else {
            String cpathString = cpath.toString().replace(' ', '_');
            d.addFV("chunkPath", direction + "_" + cpathString);
            d.addFV("chunkPathAndType", event.type + "_" + direction + "_" + cpathString);
            d.addFV("dist", Integer.toString(cpath.size()));
        }
        if (spath == null) {
            d.addF("noSynPath");
        } else {
            d.addFV("synPath", spath);
            d.addFV("synPathEvType", event.type + "_" + spath);
            d.addFV("synPathTypes", event.type + "_" + mention.getType() + "_" + spath);
        }
        return d;
    }

    private Annotation findContainingSentence(Document doc, Span span) {
        Vector<Annotation> sentences = doc.annotationsOfType("sentence");
        if (sentences == null) {
            System.err.println("findContainingSentence:  no sentences found");
            return null;
        }
        Annotation sentence = null;
        for (int i = 0; i < sentences.size(); ++i) {
            Annotation s = sentences.get(i);
            if (!span.within(s.span())) continue;
            sentence = s;
            break;
        }
        if (sentence == null) {
            System.err.println("findContainingSentence:  can't find sentence with span");
            return null;
        }
        return sentence;
    }

    static GISModel loadClassifierModel(String modelFileName) {
        try {
            File f = new File(modelFileName);
            GISModel m = (GISModel)new SuffixSensitiveGISModelReader(f).getModel();
            System.err.println("GIS model " + f.getName() + " loaded.");
            return m;
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(0);
            return null;
        }
    }

    private void collectArguments(AceEvent event, AceEventMention eventMention, Document doc, AceDocument aceDoc, SyntacticRelationSet relations) {
        Span anchorExtent = eventMention.anchorJetExtent;
        String anchorText = eventMention.anchorText;
        String anchor = EventPattern.normalizedAnchor(anchorExtent, anchorText, doc, relations);
        AceEventAnchor anchorMention = new AceEventAnchor(anchorExtent, eventMention.anchorJetExtent, anchorText, doc);
        Set<String> rolesFilled = this.rolesFilledInEvent(event);
        Annotation sentence = this.findContainingSentence(doc, anchorExtent);
        if (sentence == null) {
            return;
        }
        Span sentenceSpan = sentence.span();
        HashSet<AceEventArgumentValue> argumentsUsed = this.argumentValues(event);
        HashMap<String, Double> bestRoleProb = new HashMap<String, Double>();
        HashMap<String, AceMention> bestRoleFiller = new HashMap<String, AceMention>();
        HashMap<String, Double> bestRoleRoleProb = new HashMap<String, Double>();
        ArrayList<AceMention> mentions = aceDoc.getAllMentions();
        for (int im = 0; im < mentions.size(); ++im) {
            AceMention mention = mentions.get(im);
            if (!mention.jetExtent.within(sentenceSpan) || mention.getJetHead().within(anchorExtent)) continue;
            Datum d = this.argumentFeatures(doc, anchor, event, mention, anchorMention, relations);
            double argProb = argModel.eval(d.toArray())[argModel.getIndex("arg")];
            String role = roleModel.getBestOutcome(roleModel.eval(d.toArray())).intern();
            double roleProb = roleModel.eval(d.toArray())[roleModel.getIndex(role)];
            if (rolesFilled.contains(role) || !AceEventArgument.isValid(event.subtype, role, mention) || !(argProb > MIN_ARG_PROBABILITY) || bestRoleProb.get(role) != null && !(argProb > (Double)bestRoleProb.get(role))) continue;
            bestRoleProb.put(role, argProb);
            bestRoleRoleProb.put(role, roleProb);
            bestRoleFiller.put(role, mention);
        }
        for (String role : bestRoleFiller.keySet()) {
            AceMention mention = (AceMention)bestRoleFiller.get(role);
            AceEventArgumentValue argValue = mention.getParent();
            if (argumentsUsed.contains(argValue)) continue;
            double argProb = (Double)bestRoleProb.get(role);
            AceEventMentionArgument mentionArg = new AceEventMentionArgument(mention, role);
            mentionArg.confidence = argProb;
            mentionArg.roleConfidence = (Double)bestRoleRoleProb.get(role);
            eventMention.arguments.add(mentionArg);
            AceEventArgument eventArg = new AceEventArgument(argValue, role);
            eventArg.confidence = argProb;
            event.arguments.add(eventArg);
            argumentsUsed.add(argValue);
        }
    }

    public void evaluatePatterns(Document doc, AceDocument aceDoc, String docId) {
        SyntacticRelationSet relations = new SyntacticRelationSet();
        if (DepParser.isInitialized()) {
            relations = DepParser.parseDocument(doc);
        } else if (usePA) {
            relations.readRelations(glarfDir + docId + triplesSuffix);
        } else {
            relations.addRelations(doc);
        }
        ArrayList<AceEvent> events = aceDoc.events;
        Vector<Annotation> constituents = doc.annotationsOfType("constit");
        for (int i = 0; i < constituents.size(); ++i) {
            Annotation constit = constituents.get(i);
            String cat = (String)constit.get("cat");
            if (cat != "n" && cat != "v" && cat != "tv" && cat != "ven" && cat != "ving" && cat != "adj") continue;
            String anchor = EventPattern.normalizedAnchor(constit, doc, relations);
            Span anchorExtent = constit.span();
            List<EventPattern> patterns = this.anchorMap.get(anchor);
            if (patterns == null) continue;
            String eventType = null;
            for (int j = 0; j < patterns.size(); ++j) {
                AceEvent keyEvent;
                EventPattern ep = patterns.get(j);
                AceEvent event = ep.match(anchorExtent, anchor, doc, relations, aceDoc);
                if (event == null) continue;
                if (evalTrace) {
                    System.out.println("Evaluating " + ep);
                }
                if (evalTrace) {
                    System.out.println("  for matched event " + event);
                }
                AceEventMention mention = event.mentions.get(0);
                if (evalTrace) {
                    System.out.println("  with extent " + doc.text(mention.jetExtent));
                }
                if ((keyEvent = this.correctEvent(anchorExtent, event, events)) != null) {
                    ArrayList<AceEventMentionArgument> arguments = mention.arguments;
                    ArrayList<AceEventMentionArgument> keyArguments = this.correctEventMention.arguments;
                    ArrayList<AceEventMentionArgument> correctArguments = new ArrayList<AceEventMentionArgument>(arguments);
                    correctArguments.retainAll(keyArguments);
                    ArrayList<AceEventMentionArgument> spuriousArguments = new ArrayList<AceEventMentionArgument>(arguments);
                    spuriousArguments.removeAll(keyArguments);
                    int successCount = eventWeight + correctArguments.size();
                    int failureCount = spuriousArguments.size();
                    ep.evaluation.recordSuccess(mention.arguments, successCount);
                    ep.evaluation.recordFailure(mention.arguments, failureCount);
                    if (evalTrace) {
                        System.out.println("    a success");
                    }
                    eventType = event.type + ":" + event.subtype;
                    continue;
                }
                int failureCount = eventWeight + mention.arguments.size();
                ep.evaluation.recordFailure(mention.arguments, failureCount);
                if (!evalTrace) continue;
                System.out.println("    a failure");
            }
        }
    }

    private AceEvent correctEvent(Span anchorExtent, AceEvent event, ArrayList keyEvents) {
        AceEventMention mention = event.mentions.get(0);
        for (int i = 0; i < keyEvents.size(); ++i) {
            AceEvent keyEvent = (AceEvent)keyEvents.get(i);
            ArrayList<AceEventMention> keyMentions = keyEvent.mentions;
            for (int j = 0; j < keyMentions.size(); ++j) {
                AceEventMention keyMention = keyMentions.get(j);
                Span keyExtent = keyMention.jetExtent;
                if (!anchorExtent.within(keyExtent) || !event.type.equals(keyEvent.type) || !event.subtype.equals(keyEvent.subtype)) continue;
                this.correctEventMention = keyMention;
                return keyEvent;
            }
        }
        return null;
    }

    void trainEventModel(Document doc, AceDocument aceDoc, String docId) {
        SyntacticRelationSet relations = new SyntacticRelationSet();
        if (DepParser.isInitialized()) {
            relations = DepParser.parseDocument(doc);
        } else if (usePA) {
            relations.readRelations(glarfDir + docId + triplesSuffix);
        } else {
            relations.addRelations(doc);
        }
        ArrayList<AceEvent> events = aceDoc.events;
        Vector<Annotation> constituents = doc.annotationsOfType("constit");
        for (int i = 0; i < constituents.size(); ++i) {
            Annotation constit = constituents.get(i);
            String cat = (String)constit.get("cat");
            if (cat != "n" && cat != "v" && cat != "tv" && cat != "ven" && cat != "ving" && cat != "adj") continue;
            String anchor = EventPattern.normalizedAnchor(constit, doc, relations);
            Span anchorExtent = constit.span();
            List<EventPattern> patterns = this.anchorMap.get(anchor);
            if (patterns == null) continue;
            CONFIDENT_ARG = 0.1;
            AceEvent event = this.eventAnchoredByConstituent(constit, doc, aceDoc, docId, relations, 0);
            if (event == null) continue;
            EventPattern pattern = this.patternMatched;
            Datum d = this.eventFeatures(doc, anchor, constit, event, pattern);
            boolean isEvent = this.correctEvent(anchorExtent, event, events) != null;
            d.setOutcome(isEvent ? "event" : "noEvent");
            this.eventFeatureWriter.println(d.toString());
        }
    }

    private Datum eventFeatures(Document doc, String anchor, Annotation anchorAnn, AceEvent event, EventPattern pattern) {
        Datum d = new Datum();
        d.addF(anchor);
        int patmatch = pattern.evaluation.test(event.arguments, 1.0);
        if (patmatch > 0) {
            d.addFV("patmatch", Integer.toString(patmatch / 10));
        } else {
            d.addFV("patmatch", "N");
        }
        return d;
    }

    void trainCorefModel(Document doc, AceDocument aceDoc, String docId) {
        SyntacticRelationSet relations = new SyntacticRelationSet();
        if (DepParser.isInitialized()) {
            relations = DepParser.parseDocument(doc);
        } else if (usePA) {
            relations.readRelations(glarfDir + docId + triplesSuffix);
        } else {
            relations.addRelations(doc);
        }
        ArrayList<AceEvent> events = aceDoc.events;
        ArrayList<AceEvent> systemEvents = new ArrayList<AceEvent>();
        HashMap<String, Integer> keyIdToSystemEventMap = new HashMap<String, Integer>();
        int aceEventNo = 1;
        Vector<Annotation> constituents = doc.annotationsOfType("constit");
        for (int i = 0; i < constituents.size(); ++i) {
            AceEvent keyEvent;
            Annotation constit = constituents.get(i);
            String cat = (String)constit.get("cat");
            if (cat != "n" && cat != "v" && cat != "tv" && cat != "ven" && cat != "ving" && cat != "adj") continue;
            String anchor = EventPattern.normalizedAnchor(constit, doc, relations);
            Span anchorExtent = constit.span();
            AceEvent event = this.eventAnchoredByConstituent(constit, doc, aceDoc, docId, relations, aceEventNo);
            if ((event = this.pruneEvent(event, constit, doc, relations)) == null || (keyEvent = this.correctEvent(anchorExtent, event, events)) == null) continue;
            String keyEventId = keyEvent.id;
            Integer I = (Integer)keyIdToSystemEventMap.get(keyEventId);
            int systemEventIndex = I == null ? -1 : I;
            for (int iEvent = 0; iEvent < systemEvents.size(); ++iEvent) {
                AceEvent priorEvent = (AceEvent)systemEvents.get(iEvent);
                if (!priorEvent.subtype.equals(event.subtype)) continue;
                Datum d = this.corefFeatures(priorEvent, event, anchor);
                d.setOutcome(iEvent == systemEventIndex ? "merge" : "dontMerge");
                this.corefFeatureWriter.println(d.toString());
            }
            if (systemEventIndex >= 0) {
                AceEvent priorEvent = (AceEvent)systemEvents.get(systemEventIndex);
                priorEvent.arguments = this.mergeArguments(event.arguments, priorEvent.arguments);
                AceEventMention m = event.mentions.get(0);
                priorEvent.addMention(m);
                m.setId(priorEvent.id + "-" + priorEvent.mentions.size());
                continue;
            }
            systemEvents.add(event);
            keyIdToSystemEventMap.put(keyEventId, new Integer(systemEvents.size() - 1));
            ++aceEventNo;
        }
    }

    private Datum corefFeatures(AceEvent priorEvent, AceEvent event, String anchor) {
        Datum d = new Datum();
        d.addFV("subtype", event.subtype);
        d.addFV("anchor", anchor);
        if (anchor.endsWith("/n")) {
            d.addF("nomAnchor");
        }
        AceEventMention lastMentionPriorEvent = priorEvent.mentions.get(priorEvent.mentions.size() - 1);
        int posnPriorEvent = lastMentionPriorEvent.anchorExtent.start();
        AceEventMention lastMentionOfEvent = event.mentions.get(event.mentions.size() - 1);
        int posnEvent = lastMentionOfEvent.anchorExtent.start();
        int distance = posnEvent - posnPriorEvent;
        d.addFV("distance", Integer.toString(Math.min(distance / 100, 9)));
        if (lastMentionOfEvent.anchorText.equals(lastMentionPriorEvent.anchorText)) {
            d.addF("anchorMatch");
        }
        ArrayList<AceEventArgument> priorArgs = priorEvent.arguments;
        ArrayList<AceEventArgument> args = event.arguments;
        for (int i = 0; i < priorArgs.size(); ++i) {
            AceEventArgument arg1 = priorArgs.get(i);
            if (arg1.confidence < COREF_CONFIDENCE) continue;
            String role1 = arg1.role;
            String id1 = arg1.value.id;
            for (int j = 0; j < args.size(); ++j) {
                AceEventArgument arg2 = args.get(j);
                if (arg2.confidence < COREF_CONFIDENCE) continue;
                String role2 = arg2.role;
                String id2 = arg2.value.id;
                int confidence = (int)(Math.min(arg1.confidence, arg2.confidence) * 5.0);
                if (!role1.equals(role2)) continue;
                if (id1.equals(id2)) {
                    d.addFV("overlap", role1 + ":" + confidence);
                    continue;
                }
                d.addFV("conflict", role1 + ":" + confidence);
            }
        }
        return d;
    }

    public void tag(Document doc, AceDocument aceDoc, String currentDocPath, String docId) {
        SyntacticRelationSet relations = new SyntacticRelationSet();
        if (DepParser.isInitialized()) {
            relations = DepParser.parseDocument(doc);
        } else if (usePA) {
            relations.readRelations(glarfDir + currentDocPath + triplesSuffix);
        } else {
            relations.addRelations(doc);
        }
        int aceEventNo = 1;
        Vector<Annotation> constituents = doc.annotationsOfType("constit");
        HashSet<Span> matchedAnchors = new HashSet<Span>();
        if (constituents != null) {
            for (Annotation constit : constituents) {
                Span anchorExtent;
                String cat = (String)constit.get("cat");
                if (cat != "n" && cat != "v" && cat != "tv" && cat != "ven" && cat != "ving" && cat != "adj" || matchedAnchors.contains(anchorExtent = constit.span())) continue;
                AceEvent event = this.eventAnchoredByConstituent(constit, doc, aceDoc, docId, relations, aceEventNo);
                if ((event = this.pruneEvent(event, constit, doc, relations)) == null) continue;
                aceDoc.addEvent(event);
                ++aceEventNo;
                matchedAnchors.add(anchorExtent);
            }
        }
        this.eventCoref(aceDoc, doc, relations);
    }

    AceEvent eventAnchoredByConstituent(Annotation constit, Document doc, AceDocument aceDoc, String docId, SyntacticRelationSet relations, int aceEventNo) {
        String anchor = EventPattern.normalizedAnchor(constit, doc, relations);
        Span anchorExtent = constit.span();
        List<EventPattern> patterns = this.anchorMap.get(anchor);
        if (patterns == null) {
            return null;
        }
        AceEvent bestEvent = this.matchPatternSet(patterns, anchorExtent, anchor, doc, relations, aceDoc);
        if (bestEvent == null) {
            return null;
        }
        Annotation sentence = EventPattern.containingSentence(doc, anchorExtent);
        int slash = docId.lastIndexOf(47);
        if (slash >= 0) {
            docId = docId.substring(slash + 1);
        }
        String eventId = docId + "-EV" + aceEventNo;
        bestEvent.setId(eventId);
        AceEventMention bestMention = bestEvent.mentions.get(0);
        bestMention.setId(eventId + "-1");
        if (useArgumentModel) {
            this.collectArguments(bestEvent, bestMention, doc, aceDoc, relations);
        }
        return bestEvent;
    }

    AceEvent pruneEvent(AceEvent event, Annotation constit, Document doc, SyntacticRelationSet relations) {
        Object ea;
        if (event == null) {
            return null;
        }
        String anchor = EventPattern.normalizedAnchor(constit, doc, relations);
        EventPattern pattern = this.patternMatched;
        Datum d = this.eventFeatures(doc, anchor, constit, event, pattern);
        double eventProb = eventModel.eval(d.toArray())[eventModel.getIndex("event")];
        logger.trace("event maxent model p = {}", (Object)eventProb);
        AceEventMention emention = event.mentions.get(0);
        emention.confidence = eventProb;
        if (eventProb < EVENT_PROBABILITY_THRESHOLD) {
            logger.trace("probability below threshold, event rejected");
            return null;
        }
        logger.trace("probability above threshold, event accepted");
        ArrayList<Object> args = event.arguments;
        Iterator<Object> it = args.iterator();
        while (it.hasNext()) {
            ea = it.next();
            if (!(((AceEventArgument)ea).confidence * eventProb < ARGUMENT_PROBABILITY_THRESHOLD)) continue;
            it.remove();
        }
        args = emention.arguments;
        it = args.iterator();
        while (it.hasNext()) {
            ea = (AceEventMentionArgument)it.next();
            if (!(((AceEventMentionArgument)ea).confidence * eventProb < ARGUMENT_PROBABILITY_THRESHOLD)) continue;
            it.remove();
        }
        return event;
    }

    AceEvent matchPatternSet(List patterns, Span anchorExtent, String anchor, Document doc, SyntacticRelationSet relations, AceDocument aceDoc) {
        this.patternMatched = null;
        AceEvent bestEvent = null;
        EventPattern bestPattern = null;
        int bestMatchScore = 0;
        for (int j = 0; j < patterns.size(); ++j) {
            EventPattern ep = (EventPattern)patterns.get(j);
            AceEvent event = ep.match(anchorExtent, anchor, doc, relations, aceDoc);
            if (event == null || ep.evaluation.test(event.arguments, 0.5) <= 0) continue;
            int score = ep.getMatchScore() + ep.evaluation.test(event.arguments, 0.5);
            if (ep.patternType != null && ep.patternType.equals("SYNTAX")) {
                score += 50;
            }
            if (score <= bestMatchScore) continue;
            bestMatchScore = score;
            bestEvent = event;
            bestPattern = ep;
        }
        this.patternMatched = bestPattern;
        if (bestPattern != null) {
            logger.trace("");
            logger.trace("For anchor   = {}", (Object)anchor);
            Annotation sentence = this.findContainingSentence(doc, anchorExtent);
            if (sentence != null) {
                logger.trace("in {}", (Object)doc.normalizedText(sentence));
            }
            logger.trace("best pattern = {}", (Object)bestPattern);
            logger.trace("best event = {}", (Object)bestEvent);
            logger.trace("match score  = {}", (Object)bestMatchScore);
            logger.trace("event generation score  = {}", (Object)bestPattern.evaluation.test(bestEvent.arguments, 0.5));
        }
        return bestEvent;
    }

    private Set<String> rolesFilledInEvent(AceEvent event) {
        ArrayList<AceEventArgument> args = event.arguments;
        HashSet<String> roles = new HashSet<String>();
        for (int i = 0; i < args.size(); ++i) {
            AceEventArgument arg = args.get(i);
            roles.add(arg.role);
        }
        return roles;
    }

    private int confidentRoleCount(AceEvent event, double threshold) {
        ArrayList<AceEventArgument> args = event.arguments;
        int count = 0;
        for (int i = 0; i < args.size(); ++i) {
            AceEventArgument arg = args.get(i);
            if (!(arg.confidence > threshold)) continue;
            ++count;
        }
        return count;
    }

    private HashSet<AceEventArgumentValue> argumentValues(AceEvent event) {
        ArrayList<AceEventArgument> args = event.arguments;
        HashSet<AceEventArgumentValue> values = new HashSet<AceEventArgumentValue>();
        for (int i = 0; i < args.size(); ++i) {
            AceEventArgument arg = args.get(i);
            values.add(arg.value);
        }
        return values;
    }

    public void tag(String fileList) throws IOException {
        String currentDocPath;
        BufferedReader reader = new BufferedReader(new FileReader(fileList));
        boolean docCount = false;
        while ((currentDocPath = reader.readLine()) != null) {
            System.out.println("\nProcessing file " + currentDocPath);
            String textFile = docDir + currentDocPath + ".sgm";
            String xmlFile = docDir + currentDocPath + ".apf.xml";
            String outputFile = outputDir + currentDocPath + ".apf";
            ExternalDocument doc = new ExternalDocument("sgml", textFile);
            doc.setAllTags(true);
            doc.open();
            doc.stretchAll();
            Control.processDocument(doc, null, false, 0);
            AceDocument aceDoc = new AceDocument(textFile, xmlFile);
            aceDoc.events.clear();
            this.tag(doc, aceDoc, currentDocPath.replaceFirst(".sgm", ""), aceDoc.docID);
            aceDoc.write(new PrintWriter(new FileWriter(outputFile)), doc);
        }
    }

    public void eventCoref(AceDocument aceDoc, Document doc, SyntacticRelationSet relations) {
        ArrayList<AceEvent> events = aceDoc.events;
        logger.info("eventCoref:  {} event mentions", (Object)events.size());
        ArrayList<AceEvent> newEvents = new ArrayList<AceEvent>();
        for (int i = 0; i < events.size(); ++i) {
            AceEvent event = events.get(i);
            int priorEventIndex = -1;
            double priorEventProb = 0.0;
            for (int j = newEvents.size() - 1; j >= 0; --j) {
                AceEvent newEvent = (AceEvent)newEvents.get(j);
                if (!event.type.equals(newEvent.type) || !event.subtype.equals(newEvent.subtype)) continue;
                AceEventMention m = event.mentions.get(0);
                String anchor = EventPattern.normalizedAnchor(m.anchorExtent, m.anchorText, doc, relations);
                Datum d = this.corefFeatures(newEvent, event, anchor);
                double prob = corefModel.eval(d.toArray())[corefModel.getIndex("merge")];
                if (!(prob > COREF_THRESHOLD) || !(prob > priorEventProb)) continue;
                priorEventIndex = j;
                priorEventProb = prob;
            }
            if (priorEventIndex >= 0) {
                AceEvent priorEvent = (AceEvent)newEvents.get(priorEventIndex);
                priorEvent.arguments = this.mergeArguments(event.arguments, priorEvent.arguments);
                AceEventMention m = event.mentions.get(0);
                priorEvent.addMention(m);
                m.setId(priorEvent.id + "-" + priorEvent.mentions.size());
                continue;
            }
            newEvents.add(event);
        }
        aceDoc.events = newEvents;
        logger.info("eventCoref:  {} events", (Object)events.size());
    }

    private boolean compatibleArguments(ArrayList args1, ArrayList args2) {
        boolean intersect = false;
        for (int i = 0; i < args1.size(); ++i) {
            AceEventArgument arg1 = (AceEventArgument)args1.get(i);
            if (arg1.confidence < COREF_CONFIDENCE) continue;
            String role1 = arg1.role;
            String id1 = arg1.value.id;
            for (int j = 0; j < args2.size(); ++j) {
                AceEventArgument arg2 = (AceEventArgument)args2.get(j);
                if (arg2.confidence < COREF_CONFIDENCE) continue;
                String role2 = arg2.role;
                String id2 = arg2.value.id;
                if (!role1.equals(role2)) continue;
                if (id1.equals(id2)) {
                    intersect = true;
                    continue;
                }
                return false;
            }
        }
        return intersect;
    }

    private ArrayList<AceEventArgument> mergeArguments(ArrayList<AceEventArgument> args1, ArrayList<AceEventArgument> args2) {
        ArrayList<AceEventArgument> result = new ArrayList<AceEventArgument>(args1);
        block0: for (int i = 0; i < args2.size(); ++i) {
            AceEventArgument arg2 = args2.get(i);
            String role2 = arg2.role;
            String id2 = arg2.value.id;
            for (int j = 0; j < args1.size(); ++j) {
                AceEventArgument arg1 = args1.get(j);
                String role1 = arg1.role;
                String id1 = arg1.value.id;
                if (role1.equals(role2) && id1.equals(id2)) continue block0;
            }
            result.add(arg2);
        }
        return result;
    }

    public void report(String reportFile) throws IOException {
        PrintWriter reportWriter = new PrintWriter(new FileWriter(reportFile));
        Set<String> anchors = this.anchorMap.keySet();
        for (String anchor : anchors) {
            reportWriter.println("\n" + anchor + " ================================");
            List<EventPattern> patterns = this.anchorMap.get(anchor);
            for (int j = 0; j < patterns.size(); ++j) {
                EventPattern ep = patterns.get(j);
                reportWriter.println(ep.toString());
            }
        }
        reportWriter.close();
    }

    public void save(String fileName) throws IOException {
        PrintWriter writer = new PrintWriter(new FileWriter(fileName));
        Set<String> anchors = this.anchorMap.keySet();
        for (String anchor : anchors) {
            List<EventPattern> patterns = this.anchorMap.get(anchor);
            for (int j = 0; j < patterns.size(); ++j) {
                EventPattern ep = patterns.get(j);
                ep.write(writer);
            }
        }
        writer.close();
    }

    public void load(String fileName) throws IOException {
        BufferedReader reader = new BufferedReader(new FileReader(fileName));
        int patternCount = 0;
        String line = reader.readLine();
        while (line != null) {
            EventPattern ep = new EventPattern(reader);
            this.addBasicPattern(ep.anchor, ep);
            ++patternCount;
            line = reader.readLine();
        }
        System.out.println(patternCount + " patterns loaded");
    }

    public void loadAllModels(String modelDir) throws IOException {
        eventModel = EventTagger.loadClassifierModel(modelDir + "eventModel.log");
        argModel = EventTagger.loadClassifierModel(modelDir + "argModel.log");
        roleModel = EventTagger.loadClassifierModel(modelDir + "roleModel.log");
        corefModel = EventTagger.loadClassifierModel(modelDir + "corefModel.log");
    }

    public static void main(String[] args) throws IOException {
        System.out.println("Starting ACE event tagger.");
        if (args.length != 5 && args.length != 7) {
            System.out.println("EventTagger must take 5 or 7 arguments:");
            System.out.println("    properties filelist documentDir modelDir outputDir [glarfDir glarfSuffix]");
            System.exit(1);
        }
        String propertyFile = args[0];
        String fileListTest = args[1];
        docDir = args[2];
        if (!docDir.endsWith("/")) {
            docDir = docDir + "/";
        }
        if (!(modelDir = args[3]).endsWith("/")) {
            modelDir = modelDir + "/";
        }
        if (!(outputDir = args[4]).endsWith("/")) {
            outputDir = outputDir + "/";
        }
        glarfDir = null;
        if (args.length == 7) {
            glarfDir = args[5];
            if (!glarfDir.endsWith("/")) {
                glarfDir = glarfDir + "/";
            }
            triplesSuffix = args[6];
            usePA = true;
        }
        JetTest.initializeFromConfig(propertyFile);
        Pat.trace = false;
        Resolve.trace = false;
        Resolve.ACE = true;
        AceDocument.ace2005 = true;
        Ace.writeEventConfidence = JetTest.getConfigFile("Ace.writeEventConfidence") != null;
        EVENT_PROBABILITY_THRESHOLD = Ace.getConfigDouble("Ace.EventModels.eventProbabilityThreshold", EVENT_PROBABILITY_THRESHOLD);
        ARGUMENT_PROBABILITY_THRESHOLD = Ace.getConfigDouble("Ace.EventModels.argumentProbabilityThreshold", ARGUMENT_PROBABILITY_THRESHOLD);
        EventTagger et = new EventTagger();
        et.load(modelDir + "eventPatterns.log");
        et.loadAllModels(modelDir);
        et.tag(fileListTest);
    }

    static {
        usePA = false;
        evalTrace = false;
        eventWeight = 100;
        CONFIDENT_ARG = 0.2;
    }
}

