/*
 * Decompiled with CFR 0.152.
 */
package edu.nyu.jet.aceJet;

import edu.nyu.jet.Control;
import edu.nyu.jet.JetTest;
import edu.nyu.jet.aceJet.Ace;
import edu.nyu.jet.aceJet.AceDocument;
import edu.nyu.jet.aceJet.AceEntity;
import edu.nyu.jet.aceJet.AceEntityMention;
import edu.nyu.jet.aceJet.AceRelation;
import edu.nyu.jet.aceJet.AceRelationMention;
import edu.nyu.jet.aceJet.ChunkPath;
import edu.nyu.jet.aceJet.RelationMention;
import edu.nyu.jet.aceJet.RelationPattern;
import edu.nyu.jet.lisp.FeatureSet;
import edu.nyu.jet.parser.ParseTreeNode;
import edu.nyu.jet.parser.SynFun;
import edu.nyu.jet.pat.Pat;
import edu.nyu.jet.refres.Resolve;
import edu.nyu.jet.tipster.Annotation;
import edu.nyu.jet.tipster.Document;
import edu.nyu.jet.tipster.ExternalDocument;
import edu.nyu.jet.tipster.Span;
import edu.nyu.jet.zoner.SentenceSet;
import java.io.BufferedReader;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;

public class LearnRelations {
    static boolean useParser = false;
    static boolean useParseCollection = true;
    public static boolean relationTrace = false;
    static String textFileSuffix = ".sgm";
    static String apfFileSuffix = ".apf.xml";
    static Document doc;
    static String currentDoc;
    static SentenceSet sentences;
    static final String[] relations;
    static int maxDistance;
    static HashMap mentionIDMap;
    static HashMap mentionStartMap;
    static TreeSet<AceEntityMention> mentionSet;
    static TreeSet<AceEntityMention> allMentionSet;
    static ArrayList<RelationMention> relMentionList;
    static ArrayList candidates;
    static ArrayList<AceRelation> relationList;
    static TreeMap<String, Integer> patternSet;
    static PrintStream writer;
    static String docName;
    static boolean writingRelations;
    static final boolean expandConjuncts = true;
    static HashMap conjunctf;
    static HashMap conjunctb;
    private static final int mentionWindow = 3;
    private static final int maxPatternLength = 8;
    public static boolean mergeMultipleRelations;

    LearnRelations(String configFile, String patternFile) throws IOException {
        writingRelations = true;
        System.out.println("Learning relations ...");
        JetTest.initializeFromConfig(configFile);
        Pat.trace = false;
        Resolve.trace = false;
        Resolve.ACE = true;
        writer = new PrintStream(new FileOutputStream(patternFile));
    }

    void finish() {
        LearnRelations.reportPatterns();
        writer.close();
    }

    void learnFromFileList(String fileList, String textDir, String apfDir) throws IOException {
        BufferedReader reader = new BufferedReader(new FileReader(fileList));
        int docCount = 0;
        while ((currentDoc = reader.readLine()) != null) {
            System.out.println("\nProcessing document " + ++docCount + ": " + currentDoc);
            String textFile = textDir + currentDoc + textFileSuffix;
            ExternalDocument xdoc = new ExternalDocument("sgml", textFile);
            xdoc.setAllTags(true);
            xdoc.open();
            doc = xdoc;
            LearnRelations.readACErelations(textFile, apfDir + currentDoc + apfFileSuffix);
            Ace.monocase = Ace.allLowerCase(doc);
            System.out.println(">>> Monocase is " + Ace.monocase);
            Control.processDocument(doc, null, docCount < 0, docCount);
            sentences = new SentenceSet(doc);
            candidates = new ArrayList();
            LearnRelations.findSyntacticPatterns(doc);
            LearnRelations.findAdjacencyPatterns();
            LearnRelations.processCandidates();
            LearnRelations.processLeftovers();
        }
    }

    public static void findRelations(String currentDoc, Document d, AceDocument aceDoc) {
        doc = d;
        docName = currentDoc;
        sentences = new SentenceSet(doc);
        candidates = new ArrayList();
        LearnRelations.findConjuncts(doc);
        LearnRelations.findSyntacticPatterns(doc);
        LearnRelations.findAdjacencyPatterns();
        LearnRelations.predictRelations();
        LearnRelations.relationCoref(aceDoc);
    }

    private static void findSyntacticPatterns(Document doc) {
        Vector<Annotation> constits = doc.annotationsOfType("constit");
        if (constits != null) {
            for (int j = 0; j < constits.size(); ++j) {
                Annotation[] ppChildren;
                Annotation ann = constits.elementAt(j);
                for (int r = 0; r < relations.length; ++r) {
                    String relation = relations[r];
                    if (ann.get(relation) == null) continue;
                    Annotation value = (Annotation)ann.get(relation);
                    LearnRelations.checkSyntacticRelation(ann, relation, value);
                }
                String verb = SynFun.getImmediateHead(ann);
                if (verb == null) continue;
                Annotation subject = (Annotation)ann.get("subject");
                Annotation object = (Annotation)ann.get("object");
                Annotation pp = (Annotation)ann.get("pp");
                if (subject != null && object != null) {
                    LearnRelations.checkSyntacticRelation(subject, verb, object);
                }
                if (pp == null || !((ppChildren = ParseTreeNode.children(pp)) != null & ppChildren.length == 2)) continue;
                Annotation pNode = ppChildren[0];
                Annotation pObject = ppChildren[1];
                String p = SynFun.getHead(doc, pNode);
                if (subject != null) {
                    LearnRelations.checkSyntacticRelation(subject, "s-" + verb + "-" + p, pObject);
                }
                if (object == null) continue;
                LearnRelations.checkSyntacticRelation(object, "o-" + verb + "-" + p, pObject);
            }
        }
    }

    private static void checkSyntacticRelation(Annotation arg1, String relation, Annotation arg2) {
        Annotation arg1Head = Resolve.getHeadC(arg1);
        Span span1 = arg1Head.span();
        int start1 = span1.start();
        AceEntityMention m1 = (AceEntityMention)mentionStartMap.get(new Integer(start1));
        if (m1 == null) {
            return;
        }
        Annotation arg2Head = Resolve.getHeadC(arg2);
        Span span2 = arg2Head.span();
        int start2 = span2.start();
        AceEntityMention m2 = (AceEntityMention)mentionStartMap.get(new Integer(start2));
        if (m2 == null) {
            return;
        }
        if (!LearnRelations.canBeRelated(m1, m2)) {
            return;
        }
        if (m1.compareTo(m2) < 0) {
            ArrayList rels = LearnRelations.recordCandidateWithConjuncts(m1, m2);
            LearnRelations.recordSyntacticLink(rels, relation);
        } else {
            ArrayList rels = LearnRelations.recordCandidateWithConjuncts(m2, m1);
            LearnRelations.recordSyntacticLink(rels, relation + "-1");
        }
    }

    private static boolean canBeRelated(AceEntityMention m1, AceEntityMention m2) {
        return !m1.entity.id.equals(m2.entity.id);
    }

    private static void findAdjacencyPatterns() {
        if (mentionSet.isEmpty()) {
            return;
        }
        ArrayList<AceEntityMention> mentionList = new ArrayList<AceEntityMention>(mentionSet);
        for (int i = 0; i < mentionList.size() - 1; ++i) {
            for (int j = 1; j <= 3 && i + j < mentionList.size(); ++j) {
                ChunkPath chunkPath;
                AceEntityMention m2;
                AceEntityMention m1 = mentionList.get(i);
                if (!LearnRelations.canBeRelated(m1, m2 = mentionList.get(i + j)) || !sentences.inSameSentence(m1.jetHead.start(), m2.jetHead.start()) || (chunkPath = new ChunkPath(doc, m1, m2)).size() < 0 || chunkPath.size() > 8 || chunkPath.contains("]")) continue;
                ArrayList rels = LearnRelations.recordCandidateWithConjuncts(m1, m2);
                LearnRelations.recordLinearLink(rels, chunkPath);
            }
        }
    }

    private static RelationMention recordCandidate(AceEntityMention m1, AceEntityMention m2) {
        for (int i = 0; i < candidates.size(); ++i) {
            RelationMention r = (RelationMention)candidates.get(i);
            if (r.mention1 != m1 || r.mention2 != m2) continue;
            return r;
        }
        RelationMention r = new RelationMention(m1, m2);
        candidates.add(r);
        return r;
    }

    private static void processCandidates() {
        for (int i = 0; i < candidates.size(); ++i) {
            RelationMention r = (RelationMention)candidates.get(i);
            AceEntityMention m1 = r.mention1;
            AceEntityMention m2 = r.mention2;
            if (m1.entity.generic || m2.entity.generic) continue;
            String type1 = m1.entity.type;
            String type2 = m2.entity.type;
            String subtype1 = m1.entity.subtype.equals("") ? "*" : m1.entity.subtype;
            String subtype2 = m2.entity.subtype.equals("") ? "*" : m2.entity.subtype;
            String pattern = type1 + " " + subtype1 + " " + LearnRelations.getHead(m1) + " [ " + r.syntacticLink + " : " + LearnRelations.concat(r.linearLink) + " ] " + type2 + " " + subtype2 + " " + LearnRelations.getHead(m2);
            LearnRelations.checkRelation(m1, pattern, m2);
        }
    }

    private static void checkRelation(AceEntityMention m1, String pattern, AceEntityMention m2) {
        if (!LearnRelations.canBeRelated(m1, m2)) {
            return;
        }
        boolean found = false;
        for (int i = 0; i < relMentionList.size(); ++i) {
            boolean match = false;
            String prefix = null;
            RelationMention rel = relMentionList.get(i);
            if (rel.mention1.equals(m1) && rel.mention2.equals(m2)) {
                match = true;
                prefix = "arg1-arg2";
            } else if (rel.mention1.equals(m2) && rel.mention2.equals(m1)) {
                match = true;
                prefix = "arg2-arg1";
            }
            if (!match) continue;
            System.out.println("For " + doc.text(m1.jetHead) + " and " + doc.text(m2.jetHead));
            LearnRelations.recordPattern(prefix + " " + pattern + " --> " + rel.relationType + " " + rel.relationSubtype);
            rel.setAnalyzed();
            found = true;
        }
        if (!found) {
            LearnRelations.recordPattern("arg1-arg2 " + pattern + " --> 0");
        }
    }

    private static void processLeftovers() {
        for (int i = 0; i < relMentionList.size(); ++i) {
            String pattern;
            String subtype2;
            RelationMention rel = relMentionList.get(i);
            if (rel.analyzed) continue;
            AceEntityMention m1 = rel.mention1;
            AceEntityMention m2 = rel.mention2;
            String type1 = m1.entity.type;
            String type2 = m2.entity.type;
            String subtype1 = m1.entity.subtype.equals("") ? "*" : m1.entity.subtype;
            String string = subtype2 = m2.entity.subtype.equals("") ? "*" : m2.entity.subtype;
            if (m1.compareTo(m2) < 0) {
                pattern = "arg1-arg2 " + type1 + " " + subtype1 + " " + LearnRelations.getHead(m1) + " [ " + "0 : " + new ChunkPath(doc, m1, m2) + " ] " + type2 + " " + subtype2 + " " + LearnRelations.getHead(m2);
            } else if (m1.compareTo(m2) > 0) {
                pattern = "arg2-arg1 " + type2 + " " + subtype2 + " " + LearnRelations.getHead(m2) + " [ " + "0 : " + new ChunkPath(doc, m2, m1) + " ] " + type1 + " " + subtype1 + " " + LearnRelations.getHead(m1);
            } else {
                System.err.println("*** Relation with two identical arguments -- ignored.");
                return;
            }
            System.out.println("Leftover -- for " + doc.text(m1.jetHead) + " and " + doc.text(m2.jetHead));
            LearnRelations.recordPattern(pattern + " --> " + rel.relationType + " " + rel.relationSubtype);
        }
    }

    static String concat(ArrayList strings) {
        if (strings == null) {
            return null;
        }
        if (strings.size() == 0) {
            return "";
        }
        StringBuffer result = new StringBuffer((String)strings.get(0));
        for (int i = 1; i < strings.size(); ++i) {
            result.append(" ");
            result.append((String)strings.get(i));
        }
        return result.toString();
    }

    static String getHead(AceEntityMention m) {
        Vector<Annotation> anns = doc.annotationsAt(m.jetHead.start(), "constit");
        if (anns != null) {
            for (int i = anns.size() - 1; i >= 0; --i) {
                String head;
                FeatureSet pa;
                Annotation ann = anns.get(i);
                String cat = (String)ann.get("cat");
                if (cat != "n" && cat != "pro" && cat != "name" && cat != "adj" && cat != "ven" && (cat != "det" || ann.get("tposs") != "t")) continue;
                if (cat == "name") {
                    String[] name = Resolve.getNameTokens(doc, ann);
                    if (Ace.gazetteer.isCountry(name)) {
                        return "country";
                    }
                    if (Ace.gazetteer.isNationality(name)) {
                        return "nationality";
                    }
                }
                if ((pa = (FeatureSet)ann.get("pa")) == null || (head = (String)pa.get("head")) == null) continue;
                return head.replace(' ', '-').replace('\n', '-');
            }
        }
        return doc.text(m.jetHead).trim().replace(' ', '-').replace('\n', '-');
    }

    static void findConjuncts(Document doc) {
        Vector<Annotation> constits = doc.annotationsOfType("constit");
        if (constits != null) {
            for (int j = 0; j < constits.size(); ++j) {
                Annotation ann = constits.elementAt(j);
                Annotation conj = (Annotation)ann.get("conj");
                if (conj == null) continue;
                ArrayList<Annotation> conjuncts = new ArrayList<Annotation>();
                conjuncts.add(ann);
                while (conj != null) {
                    conjuncts.add(conj);
                    conj = (Annotation)conj.get("conj");
                }
                LearnRelations.recordConjunct(conjuncts);
            }
        }
    }

    static void recordConjunct(ArrayList conjuncts) {
        int i;
        String type = "";
        ArrayList<AceEntityMention> mentions = new ArrayList<AceEntityMention>();
        for (i = 0; i < conjuncts.size(); ++i) {
            Annotation ann = (Annotation)conjuncts.get(i);
            AceEntityMention m = LearnRelations.mentionForAnnotation(ann);
            if (m == null) {
                return;
            }
            mentions.add(m);
            if (i == 0) {
                type = m.type;
                continue;
            }
            if (type.equals(m.type)) continue;
            return;
        }
        for (i = 0; i < mentions.size() - 1; ++i) {
            AceEntityMention m1 = (AceEntityMention)mentions.get(i);
            AceEntityMention m2 = (AceEntityMention)mentions.get(i + 1);
            conjunctf.put(m1, m2);
            conjunctb.put(m2, m1);
            if (!relationTrace) continue;
            System.out.println("Found conjuncts " + doc.text(m1.jetHead) + " and " + doc.text(m2.jetHead));
        }
    }

    static AceEntityMention mentionForAnnotation(Annotation a) {
        Annotation argHead = Resolve.getHeadC(a);
        Span span = argHead.span();
        int start = span.start();
        return (AceEntityMention)mentionStartMap.get(new Integer(start));
    }

    static ArrayList getConjuncts(AceEntityMention m) {
        ArrayList<AceEntityMention> a = new ArrayList<AceEntityMention>();
        a.add(m);
        AceEntityMention n = m;
        while (conjunctf.get(n) != null) {
            n = (AceEntityMention)conjunctf.get(n);
            a.add(n);
        }
        n = m;
        while (conjunctb.get(n) != null) {
            n = (AceEntityMention)conjunctb.get(n);
            a.add(n);
        }
        return a;
    }

    static ArrayList recordCandidateWithConjuncts(AceEntityMention m1, AceEntityMention m2) {
        ArrayList<RelationMention> relations = new ArrayList<RelationMention>();
        if (m1.jetExtent.end() < m2.jetExtent.start() || m2.jetExtent.end() < m1.jetExtent.start()) {
            ArrayList a1 = LearnRelations.getConjuncts(m1);
            ArrayList a2 = LearnRelations.getConjuncts(m2);
            if (a1.contains(m2)) {
                return relations;
            }
            for (int i = 0; i < a1.size(); ++i) {
                for (int j = 0; j < a2.size(); ++j) {
                    AceEntityMention c1 = (AceEntityMention)a1.get(i);
                    AceEntityMention c2 = (AceEntityMention)a2.get(j);
                    RelationMention r = LearnRelations.recordCandidate(c1, c2);
                    relations.add(r);
                }
            }
        } else {
            RelationMention r = LearnRelations.recordCandidate(m1, m2);
            relations.add(r);
        }
        return relations;
    }

    static void recordSyntacticLink(ArrayList r, String link) {
        for (int i = 0; i < r.size(); ++i) {
            RelationMention rm = (RelationMention)r.get(i);
            rm.syntacticLink = link;
        }
    }

    static void recordLinearLink(ArrayList r, ChunkPath chunkPath) {
        ArrayList<String> chunks = chunkPath.getChunks();
        for (int i = 0; i < r.size(); ++i) {
            RelationMention rm = (RelationMention)r.get(i);
            if (rm.linearLink.size() <= chunkPath.size() && (rm.linearLink.size() <= 0 || !rm.linearLink.get(0).equals("0"))) continue;
            rm.linearLink = chunks;
        }
    }

    private static void readACErelations(String textFile, String apfFile) {
        AceDocument aceDoc = new AceDocument(textFile, apfFile);
        LearnRelations.findEntityMentions(aceDoc);
        LearnRelations.findRelationMentions(aceDoc);
    }

    static void findEntityMentions(AceDocument aceDoc) {
        LearnRelations.resetMentions();
        ArrayList<AceEntity> entities = aceDoc.entities;
        for (int i = 0; i < entities.size(); ++i) {
            AceEntity entity = entities.get(i);
            String type = entity.type;
            String subtype = entity.subtype;
            ArrayList<AceEntityMention> mentions = entity.mentions;
            for (int j = 0; j < mentions.size(); ++j) {
                AceEntityMention mention = mentions.get(j);
                LearnRelations.addMention(mention);
            }
        }
    }

    static void resetMentions() {
        mentionStartMap = new HashMap();
        mentionIDMap = new HashMap();
        mentionSet = new TreeSet();
        allMentionSet = new TreeSet();
    }

    static void addMention(AceEntityMention m) {
        if (!m.entity.generic) {
            mentionSet.add(m);
        }
        allMentionSet.add(m);
        mentionStartMap.put(new Integer(m.jetHead.start()), m);
        mentionIDMap.put(m.id, m);
    }

    private static void findRelationMentions(AceDocument aceDoc) {
        relMentionList = new ArrayList();
        ArrayList<AceRelation> relations = aceDoc.relations;
        for (int i = 0; i < relations.size(); ++i) {
            AceRelation relation = relations.get(i);
            String relationClass = relation.relClass;
            if (relationClass.equals("IMPLICIT")) continue;
            ArrayList relationMentions = relation.mentions;
            for (int j = 0; j < relationMentions.size(); ++j) {
                AceRelationMention relationMention = (AceRelationMention)relationMentions.get(j);
                RelationMention acerel = new RelationMention(relation.type, relation.subtype);
                acerel.setArg(1, relationMention.arg1);
                acerel.setArg(2, relationMention.arg2);
                relMentionList.add(acerel);
            }
        }
    }

    private static void recordPattern(String pattern) {
        Integer countI;
        if (!pattern.endsWith("--> 0")) {
            System.out.println(">> " + pattern);
        }
        int count = (countI = patternSet.get(pattern)) == null ? 0 : countI;
        patternSet.put(pattern, new Integer(count + 1));
        writer.println(pattern);
    }

    private static void reportPatterns() {
        for (String pattern : patternSet.keySet()) {
            int count = patternSet.get(pattern);
            if (count <= 1) continue;
            System.out.println(count + "X: " + pattern);
        }
    }

    private static void predictRelations() {
        relMentionList = new ArrayList();
        for (int i = 0; i < candidates.size(); ++i) {
            RelationMention rm = (RelationMention)candidates.get(i);
            if (relationTrace) {
                System.out.println("For relation mention " + i + " = " + rm);
            }
            if (rm.mention1.entity.generic || rm.mention2.entity.generic) {
                if (!relationTrace) continue;
                System.out.println(" mention is generic -- suppressed");
                continue;
            }
            RelationPattern match = Ace.eve.findMatch(rm, maxDistance);
            rm.confidence = Ace.eve.getMatchConfidence();
            String predictedType = "0";
            String predictedSubtype = "";
            if (match != null) {
                if (relationTrace) {
                    System.out.println("Best corpus pattern = " + match.string);
                }
                predictedType = match.relationType;
                predictedSubtype = match.relationSubtype;
            }
            if (!predictedType.equals("0")) {
                if (predictedType.endsWith("-1")) {
                    rm.swapArgs();
                    predictedType = predictedType.substring(0, predictedType.length() - 2);
                }
                rm.relationType = predictedType;
                rm.relationSubtype = predictedSubtype;
                relMentionList.add(rm);
                rm.id = relMentionList.size() + "";
            }
            if (!relationTrace) continue;
            System.out.println("     Predicting ACE relation " + predictedType + " " + predictedSubtype);
        }
    }

    private static void relationCoref(AceDocument aceDoc) {
        relationList = new ArrayList();
        System.out.println("RelationCoref: " + relMentionList.size() + " relation mentions");
        block0: for (int i = 0; i < relMentionList.size(); ++i) {
            RelationMention rm = relMentionList.get(i);
            String eid1 = rm.mention1.entity.id;
            String eid2 = rm.mention2.entity.id;
            for (AceRelation r : relationList) {
                if (eid1 != r.arg1.id || eid2 != r.arg2.id || !mergeMultipleRelations && (!rm.relationType.equals(r.type) || !rm.relationSubtype.equals(r.subtype))) continue;
                int mentionIndex = r.mentions.size() + 1;
                r.addMention(rm.toAce(r.id + "-" + mentionIndex, doc, aceDoc));
                continue block0;
            }
            String relID = docName + "-R" + (relationList.size() + 1);
            AceRelation newr = new AceRelation(relID, rm.relationType, rm.relationSubtype, "EXPLICIT", aceDoc.findEntity(eid1), aceDoc.findEntity(eid2));
            newr.addMention(rm.toAce(relID + "-1", doc, aceDoc));
            relationList.add(newr);
            aceDoc.addRelation(newr);
        }
        System.out.println("RelationCoref: " + relationList.size() + " relations");
    }

    static {
        relations = new String[]{"of", "poss", "nameMod"};
        maxDistance = 21;
        patternSet = new TreeMap();
        writingRelations = false;
        conjunctf = new HashMap();
        conjunctb = new HashMap();
        mergeMultipleRelations = false;
    }
}

