/*
 * Decompiled with CFR 0.152.
 */
package edu.nyu.jet.aceJet;

import edu.nyu.jet.JetTest;
import edu.nyu.jet.aceJet.AceDocument;
import edu.nyu.jet.aceJet.AceEntity;
import edu.nyu.jet.aceJet.AceEntityName;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import opennlp.maxent.BasicEventStream;
import opennlp.maxent.GIS;
import opennlp.maxent.GISModel;
import opennlp.maxent.PlainTextByLineDataStream;
import opennlp.maxent.io.SuffixSensitiveGISModelReader;
import opennlp.maxent.io.SuffixSensitiveGISModelWriter;

public class NameSubtyper {
    static PrintStream writer;
    static String featureFile;
    static String modelFile;
    static GISModel model;

    public static void main(String[] args) throws IOException {
        String year;
        if (args.length < 5 || args.length % 2 == 0) {
            System.err.println("NameSubtyper requires 3+2n arguments");
            System.err.println("  year feature-file model-file (apfDirectory apfFileList)+");
            System.exit(1);
        }
        if ((year = args[0]).equals("2004")) {
            AceDocument.ace2004 = true;
            AceDocument.ace2005 = false;
        } else if (year.equals("2005")) {
            AceDocument.ace2004 = true;
            AceDocument.ace2005 = true;
        } else {
            System.err.println("Invalid year (must be 2004 or 2005)");
            System.exit(1);
        }
        featureFile = args[1];
        modelFile = args[2];
        writer = new PrintStream(new FileOutputStream(featureFile));
        for (int iarg = 3; iarg < args.length; iarg += 2) {
            NameSubtyper.processFileList(args[iarg], args[iarg + 1]);
        }
        NameSubtyper.createModel();
        NameSubtyper.store(modelFile);
        System.out.println("Finished.");
    }

    private static void processFileList(String directory, String fileList) throws IOException {
        String currentDoc;
        if (!directory.endsWith("/")) {
            directory = directory + "/";
        }
        BufferedReader reader = new BufferedReader(new FileReader(fileList));
        int docCount = 0;
        while ((currentDoc = reader.readLine()) != null) {
            System.out.println("\nProcessing document " + ++docCount + ": " + currentDoc);
            String textFileName = directory + currentDoc + ".sgm";
            String APFfileName = directory + currentDoc + ".apf.xml";
            NameSubtyper.analyzeDocument(textFileName, APFfileName);
        }
    }

    private static void analyzeDocument(String textFileName, String APFfileName) {
        AceDocument aceDoc = new AceDocument(textFileName, APFfileName);
        ArrayList<AceEntity> entities = aceDoc.entities;
        for (int ientity = 0; ientity < entities.size(); ++ientity) {
            AceEntity entity = entities.get(ientity);
            String type = entity.type;
            String subtype = entity.subtype;
            ArrayList<AceEntityName> names = entity.names;
            for (int iname = 0; iname < names.size(); ++iname) {
                AceEntityName name = names.get(iname);
                String text = name.text;
                String[] tokens = text.split("\\s");
                String[] features = NameSubtyper.NEfeatures(tokens, type);
                for (int ifeat = 0; ifeat < features.length; ++ifeat) {
                    writer.print(features[ifeat] + " ");
                }
                writer.println(subtype);
            }
        }
    }

    private static String[] NEfeatures(String[] tokens, String type) {
        String[] features = new String[tokens.length + 1];
        features[0] = type = type.substring(0, 3);
        for (int i = 0; i < tokens.length; ++i) {
            features[i + 1] = type + "=" + tokens[i].toLowerCase();
        }
        return features;
    }

    public static void createModel() {
        boolean USE_SMOOTHING = false;
        boolean PRINT_MESSAGES = true;
        try {
            FileReader datafr = new FileReader(new File(featureFile));
            BasicEventStream es = new BasicEventStream(new PlainTextByLineDataStream(datafr));
            GIS.SMOOTHING_OBSERVATION = 0.1;
            model = GIS.trainModel(es, 100, 2, USE_SMOOTHING, PRINT_MESSAGES);
        }
        catch (Exception e) {
            System.err.print("Unable to create model due to exception: ");
            System.err.println(e);
        }
    }

    public static void store(String modelFileName) {
        try {
            File outputFile = new File(modelFileName);
            SuffixSensitiveGISModelWriter writer = new SuffixSensitiveGISModelWriter(model, outputFile);
            writer.persist();
        }
        catch (IOException e) {
            System.err.println("MaxEntNE.saveModel: unable to save model");
            System.err.println(e);
        }
    }

    public static void load() {
        String fileName = JetTest.getConfigFile("Ace.NameSubtypeModel.fileName");
        if (fileName != null) {
            NameSubtyper.load(fileName);
        } else {
            System.err.println("NameSubtyper.load:  no file name specified in config file");
        }
    }

    public static void load(String modelFileName) {
        try {
            model = (GISModel)new SuffixSensitiveGISModelReader(new File(modelFileName)).getModel();
            System.err.println("GIS model loaded.");
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(0);
        }
    }

    public static String classify(String name, String type) {
        if (model == null) {
            NameSubtyper.load();
        }
        String[] tokens = name.split("\\s");
        String[] features = NameSubtyper.NEfeatures(tokens, type);
        String subtype = model.getBestOutcome(model.eval(features));
        return subtype;
    }
}

