/*
 * Decompiled with CFR 0.152.
 */
package edu.nyu.jet.aceJet;

import edu.nyu.jet.Control;
import edu.nyu.jet.JetTest;
import edu.nyu.jet.MaxEntModel;
import edu.nyu.jet.aceJet.Ace;
import edu.nyu.jet.aceJet.AceDocument;
import edu.nyu.jet.aceJet.AceEvent;
import edu.nyu.jet.aceJet.AceEventAnchor;
import edu.nyu.jet.aceJet.AceEventArgument;
import edu.nyu.jet.aceJet.AceEventArgumentValue;
import edu.nyu.jet.aceJet.AceEventMention;
import edu.nyu.jet.aceJet.AceEventMentionArgument;
import edu.nyu.jet.aceJet.AceMention;
import edu.nyu.jet.aceJet.ChunkPath;
import edu.nyu.jet.aceJet.Datum;
import edu.nyu.jet.aceJet.EventPattern;
import edu.nyu.jet.aceJet.EventSyntacticPattern;
import edu.nyu.jet.aceJet.Gazetteer;
import edu.nyu.jet.aceJet.LearnRelations;
import edu.nyu.jet.parser.SyntacticRelation;
import edu.nyu.jet.parser.SyntacticRelationSet;
import edu.nyu.jet.pat.Pat;
import edu.nyu.jet.refres.Resolve;
import edu.nyu.jet.tipster.Annotation;
import edu.nyu.jet.tipster.Document;
import edu.nyu.jet.tipster.ExternalDocument;
import edu.nyu.jet.tipster.Span;
import java.io.BufferedReader;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NewEventTagger {
    MaxEntModel eventModel;
    MaxEntModel argModel;
    MaxEntModel roleModel;
    MaxEntModel corefModel;
    Set<String> anchorSet;
    String eventDirectory;
    static final String home = "C:/Documents and Settings/Ralph Grishman/My Documents/";
    static final String ace = "C:/Documents and Settings/Ralph Grishman/My Documents/Ace 05/V4/";
    static String triplesDir = "C:/Documents and Settings/Ralph Grishman/My Documents/Ace 05/V4/011306-fast-tuples/";
    static String triplesSuffix = ".sent.txt.ns-2005-fast-ace-n-tuple92";
    static boolean usePA = true;
    static boolean useParser = true;
    static boolean train = false;
    static double MIN_ARG_PROBABILITY = 0.35;
    static double COREF_THRESHOLD = 0.1;
    static double COREF_CONFIDENCE = 0.35;
    static final String fileListTrain1 = "C:/Documents and Settings/Ralph Grishman/My Documents/Ace 05/V4/perfect-parses/nw-tail.txt";
    static final String fileListTrain2 = "C:/Documents and Settings/Ralph Grishman/My Documents/Ace 05/V4/perfect-parses/bn-tail.txt";
    static final String fileListTrain3 = "C:/Documents and Settings/Ralph Grishman/My Documents/Ace 05/V4/perfect-parses/bc-tail.txt";
    static final String fileListTrain4 = "C:/Documents and Settings/Ralph Grishman/My Documents/Ace 05/V4/perfect-parses/wl-tail.txt";
    static final String fileListTrain5 = "C:/Documents and Settings/Ralph Grishman/My Documents/Ace 05/V4/perfect-parses/cts-tail.txt";
    static final String fileListTrain6 = "C:/Documents and Settings/Ralph Grishman/My Documents/Ace 05/V4/perfect-parses/un-tail.txt";
    static final String fileListTest = "C:/Documents and Settings/Ralph Grishman/My Documents/Ace 05/V4/perfect-parses/head6.txt";
    private AceEventMention eventMentionAtAnchor;
    private ArrayList<AceEvent> priorEvents;

    NewEventTagger(String dir) {
        this.eventDirectory = dir;
        this.eventModel = new MaxEntModel(dir + "eventFeatureFile.log", dir + "eventModel.log");
        this.argModel = new MaxEntModel(dir + "argFeatureFile.log", dir + "argModel.log");
        this.roleModel = new MaxEntModel(dir + "roleFeatureFile.log", dir + "roleModel.log");
        this.corefModel = new MaxEntModel(dir + "corefFeatureFile.log", dir + "corefModel.log");
    }

    public static void main(String[] args) throws IOException {
        if (useParser) {
            JetTest.initializeFromConfig("props/ace use parses.properties");
        } else {
            JetTest.initializeFromConfig("props/ME ace 05.properties");
        }
        Ace.gazetteer = new Gazetteer();
        Ace.gazetteer.load("data/loc.dict");
        Pat.trace = false;
        Resolve.trace = false;
        AceDocument.ace2005 = true;
        NewEventTagger et = new NewEventTagger("eventTemp/");
        if (train) {
            String[] filelists = new String[]{fileListTrain1, fileListTrain2, fileListTrain3, fileListTrain4, fileListTrain5, fileListTrain6};
            et.train(filelists);
        } else {
            et.loadModels();
            et.tag(fileListTest);
        }
    }

    public void train(String[] fileLists) throws IOException {
        this.anchorSet = new HashSet<String>();
        for (int pass = 1; pass <= 2; ++pass) {
            for (String filelist : fileLists) {
                this.trainOnFilelist(filelist, pass);
            }
        }
        this.saveAnchorSet();
        this.eventModel.setCutoff(1);
        this.eventModel.buildModel();
        this.eventModel.saveModel();
        this.argModel.setCutoff(2);
        this.argModel.buildModel();
        this.argModel.saveModel();
        this.roleModel.setCutoff(2);
        this.roleModel.buildModel();
        this.roleModel.saveModel();
        this.corefModel.buildModel();
        this.corefModel.saveModel();
    }

    private void saveAnchorSet() throws IOException {
        PrintStream writer = new PrintStream(new FileOutputStream(this.eventDirectory + "anchors.log"));
        for (String anchor : this.anchorSet) {
            writer.println(anchor);
        }
        writer.close();
    }

    public void trainOnFilelist(String fileList, int pass) throws IOException {
        String currentDocPath;
        BufferedReader reader = new BufferedReader(new FileReader(fileList));
        int docCount = 0;
        while ((currentDocPath = reader.readLine()) != null) {
            System.out.println("\nProcessing file " + ++docCount + ": " + currentDocPath + " (pass " + pass + ")");
            String textFile = ace + (useParser ? "perfect-parses/" : "") + currentDocPath;
            String xmlFile = ace + currentDocPath.replaceFirst(".sgm", ".apf.xml");
            ExternalDocument doc = new ExternalDocument("sgml", textFile);
            doc.setAllTags(true);
            doc.open();
            doc.stretchAll();
            Resolve.ACE = true;
            Control.processDocument(doc, null, false, 0);
            AceDocument aceDoc = new AceDocument(textFile, xmlFile);
            if (pass == 1) {
                this.collectAnchorsFromDocument(doc, aceDoc, currentDocPath.replaceFirst(".sgm", ""));
                continue;
            }
            this.trainOnDocument(doc, aceDoc, currentDocPath.replaceFirst(".sgm", ""));
        }
        reader.close();
    }

    public void collectAnchorsFromDocument(Document doc, AceDocument aceDoc, String docPath) {
        SyntacticRelationSet relations = new SyntacticRelationSet();
        if (usePA) {
            relations.readRelations(triplesDir + docPath + triplesSuffix);
        } else {
            relations.addRelations(doc);
        }
        ArrayList<AceEvent> events = aceDoc.events;
        for (int i = 0; i < events.size(); ++i) {
            AceEvent event = events.get(i);
            ArrayList<AceEventMention> mentions = event.mentions;
            for (int j = 0; j < mentions.size(); ++j) {
                AceEventMention m = mentions.get(j);
                Span anchorExtent = m.anchorJetExtent;
                String anchor = EventPattern.normalizedAnchor(anchorExtent, m.anchorText, doc, relations);
                this.anchorSet.add(anchor);
            }
        }
    }

    public void trainOnDocument(Document doc, AceDocument aceDoc, String docPath) {
        SyntacticRelationSet relations = new SyntacticRelationSet();
        if (usePA) {
            relations.readRelations(triplesDir + docPath + triplesSuffix);
        } else {
            relations.addRelations(doc);
        }
        this.trainCorefNewDocument();
        ArrayList<AceEvent> events = aceDoc.events;
        Vector<Annotation> constituents = doc.annotationsOfType("constit");
        for (int i = 0; i < constituents.size(); ++i) {
            String anchor;
            Annotation constit = constituents.get(i);
            if (!NewEventTagger.anchorConstit(constit) || !this.anchorSet.contains(anchor = EventPattern.normalizedAnchor(constit, doc, relations))) continue;
            Span anchorExtent = constit.span();
            String anchorText = doc.text(anchorExtent);
            Datum d = this.eventFeatures(anchorExtent, anchor, anchorText, doc, aceDoc, relations);
            AceEvent event = this.findEventAt(anchorExtent, events);
            boolean isEvent = event != null;
            d.setOutcome(isEvent ? event.type + ":" + event.subtype : "noEvent");
            this.eventModel.addEvent(d);
            if (!isEvent) continue;
            this.trainArgClassifier(event, this.eventMentionAtAnchor, doc, aceDoc, relations);
            this.trainCoref(this.eventMentionAtAnchor, anchor, event.id, event.type, event.subtype);
        }
    }

    private static boolean anchorConstit(Annotation constit) {
        String cat = (String)constit.get("cat");
        return cat == "n" || cat == "v" || cat == "tv" || cat == "ven" || cat == "ving" || cat == "adj";
    }

    private AceEvent findEventAt(Span anchorExtent, ArrayList keyEvents) {
        for (int i = 0; i < keyEvents.size(); ++i) {
            AceEvent keyEvent = (AceEvent)keyEvents.get(i);
            ArrayList<AceEventMention> keyMentions = keyEvent.mentions;
            for (int j = 0; j < keyMentions.size(); ++j) {
                AceEventMention keyMention = keyMentions.get(j);
                Span keyExtent = keyMention.anchorJetExtent;
                if (!anchorExtent.within(keyExtent)) continue;
                this.eventMentionAtAnchor = keyMention;
                return keyEvent;
            }
        }
        return null;
    }

    private Datum eventFeatures(Span anchorExtent, String anchor, String anchorText, Document doc, AceDocument aceDoc, SyntacticRelationSet relations) {
        Annotation sentence;
        Datum d = new Datum();
        d.addFV("anchor", anchor);
        int anchorPosition = anchorExtent.start();
        SyntacticRelation r = relations.getRelation(anchorPosition, "PRT");
        if (r != null) {
            String particle = r.targetWord;
            d.addFV("anchorWithParticle", anchor + "_" + particle);
        }
        if ((sentence = this.findContainingSentence(doc, anchorExtent)) == null) {
            return d;
        }
        for (AceMention mention : this.mentionsInSpan(aceDoc, sentence.span())) {
            String spath = EventSyntacticPattern.buildSyntacticPath(anchorPosition, mention.getJetHead().start(), relations);
            if (spath == null || spath.indexOf(58) >= 0) continue;
            d.addFV("arg", anchor + ":" + spath + ":" + mention.getType());
        }
        return d;
    }

    private void trainArgClassifier(AceEvent event, AceEventMention eventMention, Document doc, AceDocument aceDoc, SyntacticRelationSet relations) {
        Span anchorExtent = eventMention.anchorJetExtent;
        String anchorText = eventMention.anchorText;
        String anchor = EventPattern.normalizedAnchor(anchorExtent, anchorText, doc, relations);
        AceEventAnchor anchorMention = new AceEventAnchor(anchorExtent, anchorExtent, anchorText, doc);
        Annotation sentence = this.findContainingSentence(doc, anchorExtent);
        if (sentence == null) {
            return;
        }
        HashSet<String> rolesFilled = new HashSet<String>();
        for (AceMention mention : this.closestMentionsFirst(this.mentionsInSpan(aceDoc, sentence.span()), anchorExtent.start())) {
            ArrayList<AceEventMentionArgument> arguments = eventMention.arguments;
            String role = "noArg";
            for (int ia = 0; ia < arguments.size(); ++ia) {
                AceEventMentionArgument argument = arguments.get(ia);
                if (!argument.value.equals(mention)) continue;
                role = argument.role;
                break;
            }
            Datum d = this.argumentFeatures(doc, anchor, event, mention, anchorMention, rolesFilled, relations);
            if (role == "noArg") {
                d.setOutcome("noArg");
                this.argModel.addEvent(d);
                continue;
            }
            d.setOutcome("arg");
            this.argModel.addEvent(d);
            d.setOutcome(role);
            this.roleModel.addEvent(d);
            rolesFilled.add(role);
        }
    }

    private ArrayList<AceMention> mentionsInSpan(AceDocument aceDoc, Span span) {
        ArrayList<AceMention> mentions = new ArrayList<AceMention>();
        for (AceMention mention : aceDoc.getAllMentions()) {
            if (!mention.jetExtent.within(span)) continue;
            mentions.add(mention);
        }
        return mentions;
    }

    private ArrayList<AceMention> closestMentionsFirst(ArrayList<AceMention> mentions, int p) {
        ArrayList<AceMention> m = new ArrayList<AceMention>(mentions);
        for (int i = 0; i < mentions.size() - 1; ++i) {
            for (int j = i + 1; j < mentions.size(); ++j) {
                int jDistance;
                int iDistance = Math.abs(mentions.get(i).getJetHead().start() - p);
                if (iDistance <= (jDistance = Math.abs(mentions.get(j).getJetHead().start() - p))) continue;
                AceMention temp = mentions.get(i);
                mentions.set(i, mentions.get(j));
                mentions.set(j, temp);
            }
        }
        return mentions;
    }

    private Datum argumentFeatures(Document doc, String anchor, AceEvent event, AceMention mention, AceEventAnchor anchorMention, Set<String> rolesFilled, SyntacticRelationSet relations) {
        ChunkPath cpath;
        String direction;
        if (anchorMention.getJetHead().start() < mention.getJetHead().start()) {
            direction = "follow";
            cpath = new ChunkPath(doc, anchorMention, mention);
        } else {
            direction = "precede";
            cpath = new ChunkPath(doc, mention, anchorMention);
        }
        if (anchorMention.passive) {
            direction = direction + "/passive";
        }
        String spath = EventSyntacticPattern.buildSyntacticPath(anchorMention.getJetHead().start(), mention.getJetHead().start(), relations);
        Datum d = new Datum();
        d.addFV("anchor", anchor);
        d.addFV("evType", event.type);
        d.addFV("menType", mention.getType());
        String headText = Resolve.normalizeName(mention.getHeadText()).replace(' ', '_');
        d.addFV("arg", headText);
        d.addFV("evTypeArg", event.subtype + ":" + headText);
        int pos = mention.jetExtent.start();
        Annotation token = doc.tokenEndingAt(pos);
        if (token != null) {
            d.addFV("prevToken", doc.text(token).trim());
            d.addFV("prevTokenAndType", event.type + "_" + doc.text(token).trim());
        }
        if (cpath == null || cpath.toString() == null) {
            d.addFV("noChunkPath", null);
        } else {
            String cpathString = cpath.toString().replace(' ', '_');
            d.addFV("chunkPath", direction + "_" + cpathString);
            d.addFV("chunkPathAndType", event.type + "_" + direction + "_" + cpathString);
            d.addFV("dist", Integer.toString(cpath.size()));
        }
        if (spath == null) {
            d.addF("noSynPath");
        } else {
            d.addFV("synPath", spath);
            d.addFV("synPathEvType", event.type + "_" + spath);
            d.addFV("synPathTypes", event.type + "_" + mention.getType() + "_" + spath);
        }
        for (String role : rolesFilled) {
            d.addFV("filled", role);
        }
        return d;
    }

    private Annotation findContainingSentence(Document doc, Span span) {
        Vector<Annotation> sentences = doc.annotationsOfType("sentence");
        if (sentences == null) {
            System.err.println("findContainingSentence:  no sentences found");
            return null;
        }
        Annotation sentence = null;
        for (int i = 0; i < sentences.size(); ++i) {
            Annotation s = sentences.get(i);
            if (!span.within(s.span())) continue;
            sentence = s;
            break;
        }
        if (sentence == null) {
            System.err.println("findContainingSentence:  can't find sentence with span");
            return null;
        }
        return sentence;
    }

    public void loadModels() {
        this.eventModel.loadModel();
        this.argModel.loadModel();
        this.roleModel.loadModel();
        this.corefModel.loadModel();
        this.loadAnchorSet();
    }

    public void loadAnchorSet() {
        try {
            String anchor;
            this.anchorSet = new HashSet<String>();
            BufferedReader reader = new BufferedReader(new FileReader(this.eventDirectory + "anchors.log"));
            while ((anchor = reader.readLine()) != null) {
                this.anchorSet.add(anchor);
            }
        }
        catch (IOException e) {
            System.err.println("***** EventTagger:  cannot read anchors.log");
            System.err.println(e);
        }
    }

    public void tag(String fileList) throws IOException {
        String currentDocPath;
        BufferedReader reader = new BufferedReader(new FileReader(fileList));
        boolean docCount = false;
        while ((currentDocPath = reader.readLine()) != null) {
            System.out.println("\nProcessing file " + currentDocPath);
            String textFile = ace + (useParser ? "perfect-parses/" : "") + currentDocPath;
            String xmlFile = ace + currentDocPath.replaceFirst(".sgm", ".apf.xml");
            String outputFile = "C:/Documents and Settings/Ralph Grishman/My Documents/Ace 05/V4/output/" + currentDocPath.replaceFirst(".sgm", ".apf");
            ExternalDocument doc = new ExternalDocument("sgml", textFile);
            doc.setAllTags(true);
            doc.open();
            doc.stretchAll();
            Control.processDocument(doc, null, false, 0);
            AceDocument aceDoc = new AceDocument(textFile, xmlFile);
            aceDoc.events.clear();
            this.tag(doc, aceDoc, currentDocPath.replaceFirst(".sgm", ""), aceDoc.docID);
            aceDoc.write(new PrintWriter(new FileWriter(outputFile)), doc);
        }
    }

    public void tag(Document doc, AceDocument aceDoc, String currentDocPath, String docId) {
        SyntacticRelationSet relations = new SyntacticRelationSet();
        if (usePA) {
            relations.readRelations(triplesDir + currentDocPath + triplesSuffix);
        } else {
            relations.addRelations(doc);
        }
        LearnRelations.findEntityMentions(aceDoc);
        LearnRelations.findConjuncts(doc);
        int aceEventNo = 1;
        Vector<Annotation> constituents = doc.annotationsOfType("constit");
        HashSet<Span> matchedAnchors = new HashSet<Span>();
        if (constituents != null) {
            for (int i = 0; i < constituents.size(); ++i) {
                AceEvent event;
                Span anchorExtent;
                Annotation constit = constituents.get(i);
                if (!NewEventTagger.anchorConstit(constit) || matchedAnchors.contains(anchorExtent = constit.span()) || (event = this.eventAnchoredByConstituent(constit, doc, aceDoc, docId, relations, aceEventNo)) == null) continue;
                aceDoc.addEvent(event);
                ++aceEventNo;
                matchedAnchors.add(anchorExtent);
            }
        }
        this.eventCoref(aceDoc, doc, relations);
    }

    AceEvent eventAnchoredByConstituent(Annotation constit, Document doc, AceDocument aceDoc, String docId, SyntacticRelationSet relations, int aceEventNo) {
        String anchorText;
        String anchor = EventPattern.normalizedAnchor(constit, doc, relations);
        if (!this.anchorSet.contains(anchor)) {
            return null;
        }
        Span anchorExtent = constit.span();
        Datum d = this.eventFeatures(anchorExtent, anchor, anchorText = doc.text(anchorExtent), doc, aceDoc, relations);
        String eventType = this.eventModel.bestOutcome(d);
        if (eventType == "noEvent") {
            return null;
        }
        System.out.println("Generating " + eventType + " event for " + anchor);
        String[] eventTypeSubtype = eventType.split(":");
        if (eventTypeSubtype.length != 2) {
            System.err.println("*** EventTagger: Invalid event type:subtype " + eventType);
            return null;
        }
        String eventId = docId + "-EV" + aceEventNo;
        AceEventMention eventMention = new AceEventMention(eventId + "-1", anchorExtent, anchorExtent, doc.text());
        AceEvent event = new AceEvent(eventId, eventTypeSubtype[0], eventTypeSubtype[1]);
        event.addMention(eventMention);
        this.collectArguments(event, eventMention, doc, aceDoc, relations);
        return event;
    }

    private void collectArguments(AceEvent event, AceEventMention eventMention, Document doc, AceDocument aceDoc, SyntacticRelationSet relations) {
        Span anchorExtent = eventMention.anchorJetExtent;
        String anchorText = eventMention.anchorText;
        String anchor = EventPattern.normalizedAnchor(anchorExtent, anchorText, doc, relations);
        AceEventAnchor anchorMention = new AceEventAnchor(anchorExtent, eventMention.anchorJetExtent, anchorText, doc);
        HashSet<String> rolesFilled = new HashSet<String>();
        HashSet<AceEventArgumentValue> argumentsUsed = new HashSet<AceEventArgumentValue>();
        Annotation sentence = this.findContainingSentence(doc, anchorExtent);
        if (sentence == null) {
            return;
        }
        HashMap bestRoleProb = new HashMap();
        HashMap bestRoleFiller = new HashMap();
        for (AceMention mention : this.closestMentionsFirst(this.mentionsInSpan(aceDoc, sentence.span()), anchorExtent.start())) {
            AceEventArgumentValue argValue;
            if (mention.getJetHead().within(anchorExtent)) continue;
            Datum d = this.argumentFeatures(doc, anchor, event, mention, anchorMention, rolesFilled, relations);
            double argProb = this.argModel.prob(d, "arg");
            String role = this.roleModel.bestOutcome(d).intern();
            if (!AceEventArgument.isValid(event.subtype, role, mention) || !(argProb > MIN_ARG_PROBABILITY) || argumentsUsed.contains(argValue = mention.getParent())) continue;
            AceEventMentionArgument mentionArg = new AceEventMentionArgument(mention, role);
            mentionArg.confidence = argProb;
            eventMention.arguments.add(mentionArg);
            AceEventArgument eventArg = new AceEventArgument(argValue, role);
            eventArg.confidence = argProb;
            event.arguments.add(eventArg);
            argumentsUsed.add(argValue);
            rolesFilled.add(role);
        }
    }

    private void trainCorefNewDocument() {
        this.priorEvents = new ArrayList();
    }

    private void trainCoref(AceEventMention evMention, String anchor, String eventId, String eventType, String eventSubtype) {
        AceEvent event = this.buildEventFromMention(evMention, eventId, eventType, eventSubtype);
        boolean noAntecedent = true;
        for (AceEvent priorEvent : this.priorEvents) {
            Datum d = this.corefFeatures(priorEvent, event, anchor);
            if (priorEvent.id.equals(event.id)) {
                priorEvent.arguments = this.mergeArguments(event.arguments, priorEvent.arguments);
                priorEvent.addMention(evMention);
                d.setOutcome("merge");
                noAntecedent = false;
            } else {
                d.setOutcome("noMerge");
            }
            this.corefModel.addEvent(d);
        }
        if (noAntecedent) {
            this.priorEvents.add(event);
        }
    }

    private AceEvent buildEventFromMention(AceEventMention evMention, String eventId, String eventType, String eventSubtype) {
        AceEvent event = new AceEvent(eventId, eventType, eventSubtype);
        event.addMention(evMention);
        for (AceEventMentionArgument mentionArg : evMention.arguments) {
            String role = mentionArg.role;
            AceMention mention = mentionArg.value;
            AceEventArgumentValue argValue = mention.getParent();
            AceEventArgument eventArg = new AceEventArgument(argValue, role);
            eventArg.confidence = mentionArg.confidence;
            event.arguments.add(eventArg);
        }
        return event;
    }

    private Datum corefFeatures(AceEvent priorEvent, AceEvent event, String anchor) {
        Datum d = new Datum();
        d.addFV("subtype", event.subtype);
        d.addFV("anchor", anchor);
        if (anchor.endsWith("/n")) {
            d.addF("nomAnchor");
        }
        AceEventMention lastMentionPriorEvent = priorEvent.mentions.get(priorEvent.mentions.size() - 1);
        int posnPriorEvent = lastMentionPriorEvent.anchorExtent.start();
        AceEventMention lastMentionOfEvent = event.mentions.get(event.mentions.size() - 1);
        int posnEvent = lastMentionOfEvent.anchorExtent.start();
        int distance = posnEvent - posnPriorEvent;
        d.addFV("distance", Integer.toString(Math.min(distance / 100, 9)));
        if (lastMentionOfEvent.anchorText.equals(lastMentionPriorEvent.anchorText)) {
            d.addF("anchorMatch");
        }
        ArrayList<AceEventArgument> priorArgs = priorEvent.arguments;
        ArrayList<AceEventArgument> args = event.arguments;
        for (int i = 0; i < priorArgs.size(); ++i) {
            AceEventArgument arg1 = priorArgs.get(i);
            if (arg1.confidence < COREF_CONFIDENCE) continue;
            String role1 = arg1.role;
            String id1 = arg1.value.id;
            for (int j = 0; j < args.size(); ++j) {
                AceEventArgument arg2 = args.get(j);
                if (arg2.confidence < COREF_CONFIDENCE) continue;
                String role2 = arg2.role;
                String id2 = arg2.value.id;
                if (!role1.equals(role2)) continue;
                if (id1.equals(id2)) {
                    d.addFV("overlap", role1);
                    continue;
                }
                d.addFV("conflict", role1);
            }
        }
        return d;
    }

    public void eventCoref(AceDocument aceDoc, Document doc, SyntacticRelationSet relations) {
        ArrayList<AceEvent> events = aceDoc.events;
        System.out.println("eventCoref: " + events.size() + " event mentions");
        ArrayList<AceEvent> newEvents = new ArrayList<AceEvent>();
        for (int i = 0; i < events.size(); ++i) {
            AceEvent event = events.get(i);
            int priorEventIndex = -1;
            double priorEventProb = 0.0;
            for (int j = newEvents.size() - 1; j >= 0; --j) {
                AceEvent newEvent = (AceEvent)newEvents.get(j);
                if (!event.type.equals(newEvent.type) || !event.subtype.equals(newEvent.subtype)) continue;
                AceEventMention m = event.mentions.get(0);
                String anchor = EventPattern.normalizedAnchor(m.anchorExtent, m.anchorText, doc, relations);
                Datum d = this.corefFeatures(newEvent, event, anchor);
                double prob = this.corefModel.prob(d, "merge");
                if (!(prob > COREF_THRESHOLD) || !(prob > priorEventProb)) continue;
                priorEventIndex = j;
                priorEventProb = prob;
            }
            if (priorEventIndex >= 0) {
                AceEvent priorEvent = (AceEvent)newEvents.get(priorEventIndex);
                priorEvent.arguments = this.mergeArguments(event.arguments, priorEvent.arguments);
                AceEventMention m = event.mentions.get(0);
                priorEvent.addMention(m);
                m.setId(priorEvent.id + "-" + priorEvent.mentions.size());
                continue;
            }
            newEvents.add(event);
        }
        aceDoc.events = newEvents;
        System.out.println("eventCoref: " + newEvents.size() + " events");
    }

    private ArrayList<AceEventArgument> mergeArguments(ArrayList<AceEventArgument> args1, ArrayList<AceEventArgument> args2) {
        ArrayList<AceEventArgument> result = new ArrayList<AceEventArgument>(args1);
        block0: for (AceEventArgument arg2 : args2) {
            String role2 = arg2.role;
            String id2 = arg2.value.id;
            for (AceEventArgument arg1 : args1) {
                String role1 = arg1.role;
                String id1 = arg1.value.id;
                if (!role1.equals(role2) || !id1.equals(id2)) continue;
                continue block0;
            }
            result.add(arg2);
        }
        return result;
    }
}

