/*
 * Decompiled with CFR 0.152.
 */
package edu.nyu.jet.aceJet;

import edu.nyu.jet.aceJet.AceDocument;
import edu.nyu.jet.aceJet.AceEntity;
import edu.nyu.jet.aceJet.AceEntityMention;
import edu.nyu.jet.lisp.FeatureSet;
import edu.nyu.jet.scorer.NameTagger;
import edu.nyu.jet.tipster.Annotation;
import edu.nyu.jet.tipster.Document;
import edu.nyu.jet.tipster.Span;
import java.util.ArrayList;
import java.util.Vector;

public class PerfectNameTagger
implements NameTagger {
    AceDocument aceDoc;
    NameTagger realTagger;

    PerfectNameTagger(AceDocument aceDoc, NameTagger realTagger) {
        this.aceDoc = aceDoc;
        this.realTagger = realTagger;
    }

    public void tag(Document doc, Span span) {
        if (this.hasPreTags(span)) {
            this.realTagger.tag(doc, span);
        }
        for (AceEntity entity : this.aceDoc.entities) {
            ArrayList<AceEntityMention> perfectMentions = entity.mentions;
            for (int j = 0; j < perfectMentions.size(); ++j) {
                int start;
                Annotation enamex;
                Vector<Annotation> enamexes;
                AceEntityMention mention = perfectMentions.get(j);
                Span head = mention.jetHead;
                if (!head.within(span)) continue;
                String type = mention.type;
                if (type.equals("PRE") && (enamexes = doc.annotationsAt(head.start(), "ENAMEX")) != null && (enamex = enamexes.get(0)).end() == head.end()) {
                    type = "NAM";
                }
                if (!type.equals("NAM")) continue;
                int posn = start = head.start();
                int end = head.end();
                while (posn < end) {
                    Annotation token = doc.tokenAt(posn);
                    if (token == null) {
                        posn = end;
                        continue;
                    }
                    posn = token.end();
                }
                Span s = new Span(start, posn);
                Annotation name = new Annotation("ENAMEX", s, new FeatureSet("TYPE", entity.type));
                doc.addAnnotation(name);
            }
        }
    }

    private boolean hasPreTags(Span span) {
        for (AceEntity entity : this.aceDoc.entities) {
            ArrayList<AceEntityMention> perfectMentions = entity.mentions;
            for (int j = 0; j < perfectMentions.size(); ++j) {
                AceEntityMention mention = perfectMentions.get(j);
                Span head = mention.jetHead;
                if (!head.within(span) || !mention.type.equals("PRE")) continue;
                return true;
            }
        }
        return false;
    }

    public void tagDocument(Document doc) {
        this.tag(doc, doc.fullSpan());
    }

    public void load(String fileName) {
    }

    public void newDocument() {
    }
}

