/*
 * Decompiled with CFR 0.152.
 */
package edu.nyu.jet.aceJet;

import edu.nyu.jet.aceJet.BuildRelationModel;
import edu.nyu.jet.aceJet.RelationInstance;
import edu.nyu.jet.aceJet.RelationPattern;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.TreeMap;

class RelationPatternSet {
    TreeMap patternSet = new TreeMap();
    TreeMap patternIndex = new TreeMap();
    private double confidence = 1.0;

    RelationPatternSet() {
    }

    Iterator iterator() {
        return this.patternSet.keySet().iterator();
    }

    void load(String patternFile, int skipCount) throws IOException {
        String line;
        BufferedReader reader = new BufferedReader(new FileReader(patternFile));
        int count = 0;
        while ((line = reader.readLine()) != null) {
            if (++count < skipCount) continue;
            RelationPattern pattern = new RelationPattern(line);
            if (pattern.relationType.equals("")) continue;
            Integer freqI = (Integer)this.patternSet.get(pattern);
            int freq = freqI == null ? 0 : freqI;
            this.patternSet.put(pattern, new Integer(freq + 1));
            if (!pattern.syntacticLink.equals("0")) {
                String prep = RelationPattern.prepositionOfLink(pattern.syntacticLink);
                if (prep != null) {
                    this.indexPattern(pattern, prep);
                } else {
                    this.indexPattern(pattern, pattern.syntacticLink);
                }
            }
            if (pattern.linearLink.size() > 0) {
                String last = (String)pattern.linearLink.get(pattern.linearLink.size() - 1);
                if (last.equals("0")) continue;
                this.indexPattern(pattern, last);
                continue;
            }
            this.indexPattern(pattern, "**");
        }
        System.err.println(count - skipCount + " patterns loaded.");
        reader.close();
    }

    private void indexPattern(RelationPattern pattern, String key) {
        HashSet<RelationPattern> set = (HashSet<RelationPattern>)this.patternIndex.get(key);
        if (set == null) {
            set = new HashSet<RelationPattern>();
        }
        set.add(pattern);
        this.patternIndex.put(key, set);
    }

    RelationPattern findMatch(RelationInstance rp, int maxDistance) {
        int bestCount = -1;
        int bestDistance = 100;
        Object bestPattern = null;
        HashSet candidates = null;
        if (!rp.syntacticLink.equals("0")) {
            String prep = RelationPattern.prepositionOfLink(rp.syntacticLink);
            candidates = prep != null ? (HashSet)this.patternIndex.get(prep) : (HashSet)this.patternIndex.get(rp.syntacticLink);
        }
        if (candidates == null) {
            candidates = new HashSet();
        }
        if (rp.linearLink.size() > 0) {
            HashSet more;
            String last = (String)rp.linearLink.get(rp.linearLink.size() - 1);
            if (!last.equals("0") && (more = (HashSet)this.patternIndex.get(last)) != null) {
                candidates.addAll(more);
            }
        } else {
            HashSet more = (HashSet)this.patternIndex.get("**");
            if (more != null) {
                candidates.addAll(more);
            }
        }
        Iterator it = candidates.iterator();
        HashMap relationTypeCount = new HashMap();
        HashMap<String, RelationPattern> typeRelationMap = new HashMap<String, RelationPattern>();
        while (it.hasNext()) {
            RelationPattern pattern = (RelationPattern)it.next();
            int count = (Integer)this.patternSet.get(pattern);
            int dis = pattern.distance(rp);
            if (dis < bestDistance) {
                relationTypeCount.clear();
                typeRelationMap.clear();
                bestDistance = dis;
            }
            if (dis != bestDistance) continue;
            String typeSubType = pattern.relationType + ":" + pattern.relationSubtype;
            BuildRelationModel.incrementHashMap(relationTypeCount, typeSubType, count);
            typeRelationMap.put(typeSubType, pattern);
        }
        if (bestDistance <= maxDistance) {
            Iterator countIt = relationTypeCount.keySet().iterator();
            String bestTypeSubType = "";
            while (countIt.hasNext()) {
                String typeSubType = (String)countIt.next();
                Integer count = (Integer)relationTypeCount.get(typeSubType);
                int ct = count;
                if (ct <= bestCount) continue;
                bestCount = ct;
                bestTypeSubType = typeSubType;
            }
            this.confidence = (double)(maxDistance - bestDistance) / (double)maxDistance;
            return (RelationPattern)typeRelationMap.get(bestTypeSubType);
        }
        this.confidence = 0.0;
        return null;
    }

    public double getMatchConfidence() {
        return this.confidence;
    }
}

