/*
 * Decompiled with CFR 0.152.
 */
package edu.nyu.jet.aceJet;

import edu.nyu.jet.Control;
import edu.nyu.jet.JetTest;
import edu.nyu.jet.MaxEntModel;
import edu.nyu.jet.aceJet.Ace;
import edu.nyu.jet.aceJet.AceDocument;
import edu.nyu.jet.aceJet.AceEntity;
import edu.nyu.jet.aceJet.AceEntityMention;
import edu.nyu.jet.aceJet.AceRelation;
import edu.nyu.jet.aceJet.AceRelationMention;
import edu.nyu.jet.aceJet.ChunkPath;
import edu.nyu.jet.aceJet.Datum;
import edu.nyu.jet.aceJet.PerfectAce;
import edu.nyu.jet.aceJet.PerfectNameTagger;
import edu.nyu.jet.lisp.FeatureSet;
import edu.nyu.jet.parser.SynFun;
import edu.nyu.jet.pat.Pat;
import edu.nyu.jet.refres.Resolve;
import edu.nyu.jet.scorer.NameTagger;
import edu.nyu.jet.tipster.Annotation;
import edu.nyu.jet.tipster.Document;
import edu.nyu.jet.tipster.ExternalDocument;
import edu.nyu.jet.tipster.Span;
import edu.nyu.jet.zoner.SentenceSet;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RelationTagger {
    static final Logger logger = LoggerFactory.getLogger(RelationTagger.class);
    static boolean useParser = false;
    static Document doc;
    static AceDocument aceDoc;
    static String currentDoc;
    static NameTagger realNameTagger;
    static SentenceSet sentences;
    static final String[] relations;
    static HashMap mentionIDMap;
    static HashMap mentionHeadMap;
    static HashMap mentionStartMap;
    static Set<AceEntityMention> mentionSet;
    static TreeSet<AceEntityMention> allMentionSet;
    static ArrayList<AceRelationMention> relMentionList;
    static List<AceRelation> relationList;
    static String docName;
    static final boolean expandConjuncts = true;
    static HashMap conjunctf;
    static HashMap conjunctb;
    static MaxEntModel model0;
    static MaxEntModel model1;
    static MaxEntModel model2;
    static MaxEntModel model3;
    static Map<String, String> typeConstraints;
    static boolean tagSameSentence;
    static Map<String, String> syntacticRelationMap;
    private static final int mentionWindow = 4;
    static String[] relatives;
    static double threshold;
    public static boolean mergeMultipleRelations;

    public static void main(String[] args) throws IOException {
        if (args.length != 7 && args.length != 12) {
            logger.error("RelationTagger requires 5n+2 arguments:");
            logger.error("  configFile [docList textDir textSuffix apfDir apfSuffix]+ modelDirectory");
            System.exit(1);
        }
        String configFile = args[0];
        String modelDirectory = args[args.length - 1];
        logger.info("Learning relations ...");
        JetTest.initializeFromConfig(configFile);
        Ace.setAceYear();
        realNameTagger = JetTest.nameTagger;
        Pat.trace = false;
        Resolve.trace = false;
        Resolve.ACE = true;
        Ace.perfectMentions = true;
        Ace.perfectEntities = true;
        model0 = new MaxEntModel(modelDirectory + "/" + "featureFile-0", modelDirectory + "/" + "modelFile-0");
        model1 = new MaxEntModel(modelDirectory + "/" + "featureFile-1", modelDirectory + "/" + "modelFile-1");
        model2 = new MaxEntModel(modelDirectory + "/" + "featureFile-2", modelDirectory + "/" + "modelFile-2");
        model3 = new MaxEntModel(modelDirectory + "/" + "featureFile-3", modelDirectory + "/" + "modelFile-3");
        model0.initializeForTraining();
        model1.initializeForTraining();
        model2.initializeForTraining();
        model3.initializeForTraining();
        for (int iarg = 1; iarg < args.length - 1; iarg += 5) {
            String docList = args[iarg];
            String textDir = args[iarg + 1];
            String textSuffix = args[iarg + 2];
            String apfDir = args[iarg + 3];
            String apfSuffix = args[iarg + 4];
            RelationTagger.learnFromFileList(docList, textDir, textSuffix, apfDir, apfSuffix);
        }
        model0.buildModel();
        model1.buildModel();
        model2.buildModel();
        model3.buildModel();
        model0.saveModel();
        model1.saveModel();
        model2.saveModel();
        model3.saveModel();
    }

    static void learnFromFileList(String docList, String textDir, String textFileSuffix, String apfDir, String apfFileSuffix) throws IOException {
        BufferedReader reader = new BufferedReader(new FileReader(docList));
        int docCount = 0;
        while ((currentDoc = reader.readLine()) != null) {
            logger.info("\nProcessing document " + ++docCount + ": " + currentDoc);
            String textFile = textDir + "/" + currentDoc + "." + textFileSuffix;
            ExternalDocument xdoc = new ExternalDocument("sgml", textFile);
            xdoc.setAllTags(true);
            xdoc.open();
            doc = xdoc;
            RelationTagger.readACErelations(textFile, apfDir + "/" + currentDoc + "." + apfFileSuffix);
            Ace.monocase = Ace.allLowerCase(doc);
            PerfectAce.buildEntityMentionMap(xdoc, aceDoc);
            JetTest.nameTagger = new PerfectNameTagger(aceDoc, realNameTagger);
            Control.processDocument(doc, null, docCount < 0, docCount);
            sentences = new SentenceSet(doc);
            RelationTagger.findSyntacticRelations(doc);
            List<AceEntityMention[]> pairs = RelationTagger.findMentionPairs();
            for (AceEntityMention[] pair : pairs) {
                RelationTagger.addTrainingInstance(pair[0], pair[1]);
            }
            RelationTagger.reportLeftovers();
        }
    }

    public static void findRelations(String currentDoc, Document d, AceDocument ad) {
        doc = d;
        aceDoc = ad;
        docName = currentDoc;
        sentences = new SentenceSet(doc);
        relationList = new ArrayList<AceRelation>();
        RelationTagger.findEntityMentions(aceDoc);
        RelationTagger.findConjuncts(doc);
        RelationTagger.findSyntacticRelations(doc);
        List<AceEntityMention[]> pairs = RelationTagger.findMentionPairs();
        for (AceEntityMention[] pair : pairs) {
            boolean reln = RelationTagger.predictRelation(pair[0], pair[1]);
            if (reln || !tagSameSentence) continue;
            RelationTagger.linkNeighbors(pair[0], pair[1]);
        }
        RelationTagger.extendRelationsToConjuncts();
        RelationTagger.relationCoref(aceDoc);
        RelationTagger.removeRedundantMentions(aceDoc);
    }

    private static void linkNeighbors(AceEntityMention m1, AceEntityMention m2) {
        if (m1.type != "NAME" || m2.type != "NAME") {
            return;
        }
        String type = "sameSentence";
        String subtype = m1.entity.type + ":" + m2.entity.type;
        AceRelationMention mention = new AceRelationMention("", m1, m2, doc);
        AceRelation relation = new AceRelation("", type, subtype, "", m1.entity, m2.entity);
        relation.addMention(mention);
        relationList.add(relation);
    }

    static void loadModels(String modelDirectory) {
        model0 = new MaxEntModel();
        model1 = new MaxEntModel();
        model2 = new MaxEntModel();
        model3 = new MaxEntModel();
        model0.loadModel(modelDirectory + "/" + "modelFile-0");
        model1.loadModel(modelDirectory + "/" + "modelFile-1");
        model2.loadModel(modelDirectory + "/" + "modelFile-2");
        model3.loadModel(modelDirectory + "/" + "modelFile-3");
        RelationTagger.loadTypeConstraints(modelDirectory + "/" + "argTypes");
    }

    static void loadTypeConstraints(String fileName) {
        typeConstraints = new HashMap<String, String>();
        try {
            String line;
            BufferedReader reader = new BufferedReader(new FileReader(fileName));
            while ((line = reader.readLine()) != null) {
                String[] fields = line.split("\\s+", 3);
                typeConstraints.put(fields[0] + "." + fields[1], fields[2]);
            }
        }
        catch (IOException e) {
            logger.error("Error opening relation type constraint file");
            logger.error("  " + e);
            logger.error("  Type constraints will not be enforced for relations");
        }
    }

    static boolean satisfiesTypeConstraint(String relationType, String relationSubtype, String argNo, String argType) {
        if (typeConstraints.isEmpty()) {
            return true;
        }
        argType = argType.substring(0, 3);
        String key = relationType + "." + relationSubtype + "." + argNo;
        String allowedTypes = typeConstraints.get(key);
        if (allowedTypes == null) {
            logger.warn("No relation type constraint for " + key);
            return true;
        }
        boolean v = allowedTypes.contains(argType);
        if (!v) {
            logger.trace("Relation type violation for {}", (Object)key);
            logger.trace("  arg is {}, allowed types are {}", (Object)argType, (Object)allowedTypes);
        }
        return v;
    }

    private static void findSyntacticRelations(Document doc) {
        syntacticRelationMap = new HashMap<String, String>();
        Vector<Annotation> constits = doc.annotationsOfType("constit");
        if (constits != null) {
            for (Annotation ann : constits) {
                for (String relation : relations) {
                    if (ann.get(relation) == null) continue;
                    Annotation value = (Annotation)ann.get(relation);
                    RelationTagger.recordSyntacticRelation(ann, relation, value);
                }
                Annotation subject = (Annotation)ann.get("subject");
                Annotation vp = (Annotation)ann.get("headC");
                if (subject == null || vp == null || vp.get("object") == null) continue;
                Annotation object = (Annotation)vp.get("object");
                String verb = SynFun.getNameOrHead(doc, vp);
                RelationTagger.recordSyntacticRelation(subject, verb, object);
            }
        }
    }

    private static void recordSyntacticRelation(Annotation arg1, String relation, Annotation arg2) {
        logger.trace("recordSyntacticRelation relation = {}", (Object)relation);
        logger.trace("                        arg1 = {}  arg2 = {}", (Object)doc.normalizedText(arg1), (Object)doc.normalizedText(arg2));
        Annotation arg1Head = Resolve.getHeadC(arg1);
        Span span1 = arg1Head.span();
        int start1 = span1.start();
        AceEntityMention m1 = (AceEntityMention)mentionHeadMap.get(new Integer(start1));
        if (m1 == null) {
            return;
        }
        Annotation arg2Head = Resolve.getHeadC(arg2);
        Span span2 = arg2Head.span();
        int start2 = span2.start();
        AceEntityMention m2 = (AceEntityMention)mentionHeadMap.get(new Integer(start2));
        if (m2 == null) {
            return;
        }
        syntacticRelationMap.put(m1.id + ":" + m2.id, relation);
    }

    private static boolean canBeRelated(AceEntityMention m1, AceEntityMention m2) {
        return !m1.entity.id.equals(m2.entity.id);
    }

    static List<AceEntityMention[]> findMentionPairs() {
        ArrayList<AceEntityMention[]> pairs = new ArrayList<AceEntityMention[]>();
        if (mentionSet.isEmpty()) {
            return pairs;
        }
        ArrayList<AceEntityMention> mentionList = new ArrayList<AceEntityMention>(mentionSet);
        for (int i = 0; i < mentionList.size() - 1; ++i) {
            for (int j = 1; j <= 4 && i + j < mentionList.size(); ++j) {
                AceEntityMention m2;
                AceEntityMention m1 = mentionList.get(i);
                if (!RelationTagger.canBeRelated(m1, m2 = mentionList.get(i + j)) || !sentences.inSameSentence(m1.jetHead.start(), m2.jetHead.start())) continue;
                pairs.add(new AceEntityMention[]{m1, m2});
            }
        }
        return pairs;
    }

    private static void addTrainingInstance(AceEntityMention m1, AceEntityMention m2) {
        MaxEntModel classificationModel;
        boolean local;
        Datum d = RelationTagger.relationFeatures(m1, m2);
        String outcome = "nil";
        for (AceRelationMention mention : relMentionList) {
            if (mention.arg1 == m1 && mention.arg2 == m2) {
                outcome = mention.relation.type + ":" + mention.relation.subtype;
                relMentionList.remove(mention);
                break;
            }
            if (mention.arg1 != m2 || mention.arg2 != m1) continue;
            outcome = mention.relation.type + ":" + mention.relation.subtype + "-1";
            relMentionList.remove(mention);
            break;
        }
        MaxEntModel identificationModel = (local = RelationTagger.inSameBaseNP(m1.head, m2.head)) ? model0 : model2;
        MaxEntModel maxEntModel = classificationModel = local ? model1 : model3;
        if (outcome == "nil") {
            d.setOutcome("nil");
            identificationModel.addEvent(d);
        } else {
            d.setOutcome("t");
            identificationModel.addEvent(d);
            d.setOutcome(outcome);
            classificationModel.addEvent(d);
        }
    }

    private static Datum relationFeatures(AceEntityMention m1, AceEntityMention m2) {
        Annotation am2f;
        Datum d = new Datum();
        Span m1span = new Span(m1.jetExtent.start(), m1.jetHead.end());
        Span m2span = new Span(m2.jetExtent.start(), m2.jetHead.end());
        String[] headTokens1 = RelationTagger.tokensIn(m1.jetHead.start(), m1.jetHead.end()).toArray(new String[0]);
        String[] headTokens2 = RelationTagger.tokensIn(m2.jetHead.start(), m2.jetHead.end()).toArray(new String[0]);
        List<String> wb = RelationTagger.tokensIn(m1span.end(), m2span.start());
        int wbCount = wb.size();
        ChunkPath cp = new ChunkPath(doc, m1span.end(), m2span.start());
        int cpCount = cp.size();
        for (String s : headTokens1) {
            d.addFV("wm1", s);
        }
        d.addFV("hm1", m1.headText.replaceAll("\\s+", "_"));
        for (String s : headTokens2) {
            d.addFV("wm2", s);
        }
        d.addFV("hm2", m2.headText.replaceAll("\\s+", "_"));
        String hm12 = m1.headText.replaceAll("\\s+", "_") + ":" + m2.headText.replaceAll("\\s+", "_");
        d.addFV("hm12", hm12);
        if (wbCount == 0) {
            d.addF("wbnull");
        } else if (wbCount == 1) {
            d.addFV("wbfl", wb.get(0));
        } else {
            d.addFV("wbf", wb.get(0));
            for (int i = 1; i < wbCount - 1; ++i) {
                d.addFV("wbo", wb.get(i));
            }
            d.addFV("wbl", wb.get(wbCount - 1));
        }
        Annotation bm1f = doc.tokenEndingAt(m1span.start());
        if (bm1f != null) {
            d.addFV("bm1f", doc.text(bm1f).trim());
        }
        if ((am2f = doc.tokenAt(m2span.end())) != null) {
            d.addFV("am2f", doc.text(am2f).trim());
        }
        String et12 = m1.entity.type + ":" + m2.entity.type;
        d.addFV("et12", et12);
        d.addFV("et1sub2", m1.entity.subtype + ":" + m2.entity.type);
        d.addFV("et12sub", m1.entity.type + ":" + m2.entity.subtype);
        d.addFV("et1sub2sub", m1.entity.subtype + ":" + m2.entity.subtype);
        d.addFV("ml12", m1.type + ":" + m2.type);
        d.addFV("#wb", Integer.toString(wb.size()));
        String m1containsm2 = m1span.within(m2span) ? "true" : "false";
        String m2containsm1 = m2span.within(m1span) ? "true" : "false";
        d.addFV("et12+m1>m2", et12 + ":" + m1containsm2);
        d.addFV("et12+m1<m2", et12 + ":" + m2containsm1);
        d.addFV("hm12+m1>m2", et12 + ":" + m1containsm2);
        d.addFV("hm12+m1<m2", et12 + ":" + m2containsm1);
        if (Ace.gazetteer.isCountry(headTokens2)) {
            d.addFV("et1_country", m1.entity.type);
        } else if (Ace.gazetteer.isNationality(headTokens2)) {
            d.addFV("et1_nationality", m1.entity.type);
        } else if (Ace.gazetteer.isCountry(headTokens1)) {
            d.addFV("country_et2", m2.entity.type);
        } else if (Ace.gazetteer.isNationality(headTokens1)) {
            d.addFV("nationality_et2", m2.entity.type);
        }
        if (RelationTagger.isRelative(m2.headText)) {
            d.addFV("et1_relative", m1.entity.type);
        } else if (RelationTagger.isRelative(m1.headText)) {
            d.addFV("relative_et2", m2.entity.type);
        } else {
            d.addF("not_a_relative");
        }
        if (cpCount == 0) {
            d.addF("chpbnull");
        } else if (cpCount == 1) {
            d.addFV("chpbfl", cp.chunks.get(0));
        } else if (cpCount > 1) {
            d.addFV("chpbf", cp.chunks.get(0));
            for (int i = 1; i < cpCount - 1; ++i) {
                d.addFV("chpbo", cp.chunks.get(i));
            }
            d.addFV("chpbl", cp.chunks.get(cpCount - 1));
            d.addFV("cpp", cp.toString().replace(" ", "_"));
        }
        String hm1 = m1.headText.replaceAll("\\s+", "_");
        String hm2 = m2.headText.replaceAll("\\s+", "_");
        String et1 = m1.entity.type;
        String et2 = m2.entity.type;
        String synrel = "";
        if (syntacticRelationMap.get(m1.id + ":" + m2.id) != null) {
            synrel = syntacticRelationMap.get(m1.id + ":" + m2.id) + ":";
        } else if (syntacticRelationMap.get(m2.id + ":" + m1.id) != null) {
            synrel = syntacticRelationMap.get(m2.id + ":" + m1.id) + "-1:";
        }
        d.addFV("etet", synrel + et1 + ":" + et2);
        d.addFV("hmet", synrel + hm1 + ":" + et2);
        d.addFV("ethm", synrel + et1 + ":" + hm2);
        d.addFV("hmhm", synrel + hm1 + ":" + hm2);
        return d;
    }

    static List<String> tokensIn(int from, int to) {
        Annotation tok;
        ArrayList<String> tokens = new ArrayList<String>();
        int posn = from;
        while (posn < to && (tok = doc.tokenAt(posn)) != null) {
            tokens.add(doc.text(tok).trim());
            posn = tok.end();
        }
        return tokens;
    }

    static boolean isRelative(String s) {
        for (String r : relatives) {
            if (!r.equalsIgnoreCase(s)) continue;
            return true;
        }
        return false;
    }

    private static void reportLeftovers() {
        for (AceRelationMention mention : relMentionList) {
            logger.warn("Relation not used in training: {}", (Object)mention);
        }
    }

    static String getHead(AceEntityMention m) {
        Vector<Annotation> anns = doc.annotationsAt(m.jetHead.start(), "constit");
        if (anns != null) {
            for (int i = anns.size() - 1; i >= 0; --i) {
                String head;
                FeatureSet pa;
                Annotation ann = anns.get(i);
                String cat = (String)ann.get("cat");
                if (cat != "n" && cat != "pro" && cat != "name" && cat != "adj" && cat != "ven" && (cat != "det" || ann.get("tposs") != "t")) continue;
                if (cat == "name") {
                    String[] name = Resolve.getNameTokens(doc, ann);
                    if (Ace.gazetteer.isCountry(name)) {
                        return "country";
                    }
                    if (Ace.gazetteer.isNationality(name)) {
                        return "nationality";
                    }
                }
                if ((pa = (FeatureSet)ann.get("pa")) == null || (head = (String)pa.get("head")) == null) continue;
                return head.replace(' ', '-').replace('\n', '-');
            }
        }
        return doc.text(m.jetHead).trim().replace(' ', '-').replace('\n', '-');
    }

    static void findConjuncts(Document doc) {
        conjunctf.clear();
        conjunctb.clear();
        Vector<Annotation> constits = doc.annotationsOfType("constit");
        if (constits != null) {
            for (int j = 0; j < constits.size(); ++j) {
                Annotation ann = constits.elementAt(j);
                Annotation conj = (Annotation)ann.get("conj");
                if (conj == null) continue;
                ArrayList<Annotation> conjuncts = new ArrayList<Annotation>();
                conjuncts.add(ann);
                while (conj != null) {
                    conjuncts.add(conj);
                    conj = (Annotation)conj.get("conj");
                }
                RelationTagger.recordConjunct(conjuncts);
            }
        }
    }

    static void recordConjunct(ArrayList conjuncts) {
        int i;
        logger.trace("recordConjuncts: {}", (Object)conjuncts);
        String type = "";
        ArrayList<AceEntityMention> mentions = new ArrayList<AceEntityMention>();
        for (i = 0; i < conjuncts.size(); ++i) {
            Annotation ann = (Annotation)conjuncts.get(i);
            AceEntityMention m = RelationTagger.mentionForAnnotation(ann);
            if (m == null) {
                return;
            }
            mentions.add(m);
            if (i == 0) {
                type = m.type;
                continue;
            }
            if (type.equals(m.type)) continue;
            return;
        }
        for (i = 0; i < mentions.size() - 1; ++i) {
            AceEntityMention m1 = (AceEntityMention)mentions.get(i);
            AceEntityMention m2 = (AceEntityMention)mentions.get(i + 1);
            conjunctf.put(m1, m2);
            conjunctb.put(m2, m1);
            logger.trace("Found conjuncts {} and {}", (Object)doc.text(m1.jetHead), (Object)doc.text(m2.jetHead));
        }
    }

    static AceEntityMention mentionForAnnotation(Annotation a) {
        Annotation argHead = Resolve.getHeadC(a);
        Span span = argHead.span();
        int start = span.start();
        return (AceEntityMention)mentionHeadMap.get(new Integer(start));
    }

    static ArrayList getConjuncts(AceEntityMention m) {
        ArrayList<AceEntityMention> a = new ArrayList<AceEntityMention>();
        a.add(m);
        AceEntityMention n = m;
        while (conjunctf.get(n) != null) {
            n = (AceEntityMention)conjunctf.get(n);
            a.add(n);
            logger.trace("Processing conjunct {} of {}", (Object)n.text, (Object)m.text);
        }
        n = m;
        while (conjunctb.get(n) != null) {
            n = (AceEntityMention)conjunctb.get(n);
            a.add(n);
            logger.trace("Processing conjunct {} of {}", (Object)n.text, (Object)m.text);
        }
        return a;
    }

    static void extendRelationsToConjuncts() {
        ArrayList<AceRelation> originalRelations = new ArrayList<AceRelation>(relationList);
        for (AceRelation originalRelation : originalRelations) {
            AceRelationMention originalMention = (AceRelationMention)originalRelation.mentions.get(0);
            AceEntityMention m1 = originalMention.arg1;
            AceEntityMention m2 = originalMention.arg2;
            if (m1.jetExtent.end() >= m2.jetExtent.start() && m2.jetExtent.end() >= m1.jetExtent.start()) continue;
            ArrayList a1 = RelationTagger.getConjuncts(m1);
            ArrayList a2 = RelationTagger.getConjuncts(m2);
            if (a1.contains(m2)) continue;
            for (int i = 0; i < a1.size(); ++i) {
                block2: for (int j = 0; j < a2.size(); ++j) {
                    AceEntityMention c1 = (AceEntityMention)a1.get(i);
                    AceEntityMention c2 = (AceEntityMention)a2.get(j);
                    if (c1 == m1 && c2 == m2) continue;
                    logger.trace("Trying to add relation between {} and {}", (Object)c1.text, (Object)c2.text);
                    for (AceRelation r : relationList) {
                        AceRelationMention m = (AceRelationMention)r.mentions.get(0);
                        if (c1 != m.arg1 || c2 != m.arg2) continue;
                        continue block2;
                    }
                    AceRelationMention mention = new AceRelationMention("", c1, c2, doc);
                    String type = originalRelation.type;
                    String subtype = originalRelation.subtype;
                    AceRelation relation = new AceRelation("", type, subtype, "", c1.entity, c2.entity);
                    relation.addMention(mention);
                    relationList.add(relation);
                    logger.trace("Adding relation between {} and {}", (Object)c1.text, (Object)c2.text);
                }
            }
        }
    }

    private static void readACErelations(String textFile, String apfFile) {
        aceDoc = new AceDocument(textFile, apfFile);
        RelationTagger.findEntityMentions(aceDoc);
        RelationTagger.findRelationMentions(aceDoc);
    }

    static void findEntityMentions(AceDocument aceDoc) {
        RelationTagger.resetMentions();
        ArrayList<AceEntity> entities = aceDoc.entities;
        for (int i = 0; i < entities.size(); ++i) {
            AceEntity entity = entities.get(i);
            String type = entity.type;
            String subtype = entity.subtype;
            ArrayList<AceEntityMention> mentions = entity.mentions;
            for (int j = 0; j < mentions.size(); ++j) {
                AceEntityMention mention = mentions.get(j);
                RelationTagger.addMention(mention);
            }
        }
    }

    static void resetMentions() {
        mentionHeadMap = new HashMap();
        mentionStartMap = new HashMap();
        mentionIDMap = new HashMap();
        mentionSet = new TreeSet<AceEntityMention>();
        allMentionSet = new TreeSet();
    }

    static void addMention(AceEntityMention m) {
        mentionSet.add(m);
        allMentionSet.add(m);
        mentionHeadMap.put(new Integer(m.jetHead.start()), m);
        mentionStartMap.put(new Integer(m.jetExtent.start()), m);
        mentionIDMap.put(m.id, m);
    }

    private static void findRelationMentions(AceDocument aceDoc) {
        relMentionList = new ArrayList();
        ArrayList<AceRelation> relations = aceDoc.relations;
        for (int i = 0; i < relations.size(); ++i) {
            AceRelation relation = relations.get(i);
            String relationClass = relation.relClass;
            if (relationClass.equals("IMPLICIT")) continue;
            relMentionList.addAll(relation.mentions);
        }
    }

    private static boolean predictRelation(AceEntityMention m1, AceEntityMention m2) {
        boolean local = RelationTagger.inSameBaseNP(m1.head, m2.head);
        MaxEntModel identificationModel = local ? model0 : model2;
        MaxEntModel classificationModel = local ? model1 : model3;
        Datum d = RelationTagger.relationFeatures(m1, m2);
        double p = identificationModel.prob(d, "t");
        double pnil = identificationModel.prob(d, "nil");
        String outcome = identificationModel.bestOutcome(d);
        if (p / (p + pnil) < threshold) {
            return false;
        }
        if (!RelationTagger.blockingTest(m1, m2)) {
            return false;
        }
        if (!RelationTagger.blockingTest(m2, m1)) {
            return false;
        }
        outcome = classificationModel.bestOutcome(d);
        String[] typeSubtype = outcome.split(":");
        if (typeSubtype.length != 2) {
            logger.error("Invalid outcome in predictRelation:" + outcome);
            return false;
        }
        String type = typeSubtype[0];
        String subtype = typeSubtype[1];
        if (subtype.endsWith("-1")) {
            if (!RelationTagger.satisfiesTypeConstraint(type, subtype = subtype.replace("-1", ""), "arg1", m2.entity.type)) {
                return false;
            }
            if (!RelationTagger.satisfiesTypeConstraint(type, subtype, "arg2", m1.entity.type)) {
                return false;
            }
            AceRelationMention mention = new AceRelationMention("", m2, m1, doc);
            AceRelation relation = new AceRelation("", type, subtype, "", m2.entity, m1.entity);
            relation.addMention(mention);
            relationList.add(relation);
        } else {
            if (!RelationTagger.satisfiesTypeConstraint(type, subtype, "arg1", m1.entity.type)) {
                return false;
            }
            if (!RelationTagger.satisfiesTypeConstraint(type, subtype, "arg2", m2.entity.type)) {
                return false;
            }
            AceRelationMention mention = new AceRelationMention("", m1, m2, doc);
            AceRelation relation = new AceRelation("", type, subtype, "", m1.entity, m2.entity);
            relation.addMention(mention);
            relationList.add(relation);
        }
        return true;
    }

    static void relationCoref(AceDocument aceDoc) {
        ArrayList<AceRelation> resolvedRelationList = new ArrayList<AceRelation>();
        logger.info("RelationCoref: {} relation mentions", (Object)relationList.size());
        block0: for (AceRelation r : relationList) {
            String relID;
            AceRelationMention rm = (AceRelationMention)r.mentions.get(0);
            String eid1 = r.arg1.id;
            String eid2 = r.arg2.id;
            for (AceRelation rr : resolvedRelationList) {
                if (eid1 != rr.arg1.id || eid2 != rr.arg2.id || !mergeMultipleRelations && (!r.type.equals(rr.type) || !r.subtype.equals(rr.subtype))) continue;
                int mentionIndex = rr.mentions.size() + 1;
                rm.id = rr.id + "-" + mentionIndex;
                rr.addMention(rm);
                continue block0;
            }
            r.id = relID = docName + "-R" + (resolvedRelationList.size() + 1);
            rm.id = relID + "-1";
            resolvedRelationList.add(r);
            aceDoc.addRelation(r);
        }
        logger.info("RelationCoref: {} relations", (Object)resolvedRelationList.size());
    }

    static void removeRedundantMentions(AceDocument aceDoc) {
        ArrayList<AceRelation> relations = aceDoc.relations;
        for (AceRelation relation : relations) {
            ArrayList mentions = relation.mentions;
            HashSet duplicates = new HashSet();
            for (int i = 0; i < mentions.size() - 1; ++i) {
                for (int j = i + 1; j < mentions.size(); ++j) {
                    if (RelationTagger.widerMention((AceRelationMention)mentions.get(i), (AceRelationMention)mentions.get(j))) {
                        duplicates.add(mentions.get(i));
                        continue;
                    }
                    if (!RelationTagger.widerMention((AceRelationMention)mentions.get(j), (AceRelationMention)mentions.get(i))) continue;
                    duplicates.add(mentions.get(j));
                }
            }
            if (duplicates.isEmpty()) continue;
            for (AceRelationMention r : duplicates) {
                mentions.remove(r);
            }
            relation.mentions = mentions;
        }
    }

    private static boolean widerMention(AceRelationMention a, AceRelationMention b) {
        int a1 = a.arg1.head.end();
        int a2 = a.arg2.head.end();
        int min_a = Math.min(a1, a2);
        int max_a = Math.max(a1, a2);
        int b1 = b.arg1.head.end();
        int b2 = b.arg2.head.end();
        int min_b = Math.min(b1, b2);
        int max_b = Math.max(b1, b2);
        return min_a <= min_b && max_a >= max_b;
    }

    static boolean blockingTest(AceEntityMention m1, AceEntityMention m2) {
        Span span1 = m1.jetHead;
        Span span2 = m2.jetHead;
        Annotation baseNP = RelationTagger.containingBaseNP(span1);
        if (baseNP == null) {
            return true;
        }
        Span npSpan = baseNP.span();
        if (span1.end() == npSpan.end()) {
            return true;
        }
        if (conjunctf.get(m1) != null) {
            return true;
        }
        if (mentionStartMap.get(npSpan.start()) == null) {
            return true;
        }
        boolean v = span2.within(npSpan);
        if (!v) {
            logger.trace("Relation blocking test fails for {} - {}", (Object)m1.text, (Object)m2.text);
        }
        return v;
    }

    static Annotation containingBaseNP(Span s) {
        Annotation a2;
        int pos = s.start();
        Annotation np = null;
        block0: while (true) {
            Annotation t;
            Vector<Annotation> constits;
            if ((constits = doc.annotationsAt(pos, "constit")) != null) {
                for (Annotation a2 : constits) {
                    if (!RelationTagger.isBaseNp(a2)) continue;
                    break block0;
                }
            }
            if ((t = doc.tokenEndingAt(pos)) == null) {
                return null;
            }
            pos = t.start();
        }
        np = a2;
        if (np.end() >= s.end()) {
            return np;
        }
        return null;
    }

    static boolean isBaseNp(Annotation a) {
        if (a.get("cat") != "np") {
            return false;
        }
        Annotation h = (Annotation)a.get("headC");
        return h != null && h.get("cat") != "np";
    }

    static boolean inSameBaseNP(Span s1, Span s2) {
        Annotation np = RelationTagger.containingBaseNP(s1);
        if (np == null) {
            return false;
        }
        return s2.within(np.span());
    }

    static {
        relations = new String[]{"of", "poss", "nameMod"};
        conjunctf = new HashMap();
        conjunctb = new HashMap();
        model0 = null;
        model1 = null;
        model2 = null;
        model3 = null;
        typeConstraints = null;
        tagSameSentence = false;
        relatives = new String[]{"family", "parent", "parents", "father", "dad", "mother", "mom", "sibling", "brother", "brothers", "sister", "sisters", "sis", "spouse", "husband", "hubby", "wife", "child", "children", "baby", "daughter", "daughters", "son", "sons", "widow", "widower", "grandparent", "grandparents", "grandfather", "grandfathers", "grandmother", "grandmothers", "grandchild", "grandchildren", "grandson", "grandsons", "granddaughter", "granddaughters", "stepparent", "stepparents", "stepfather", "stepmother", "stepchild", "stepchildren", "stepson", "stepsons", "stepdaughter", "stepdaughters", "father-in-law", "mother-in-law", "brother-in-law", "sister-in-law", "daughter-in-law", "son-in-law", "cousin", "cousins", "nephew", "nephews", "uncle", "uncles", "aunt", "aunts", "niece", "nieces"};
        threshold = 0.25;
        mergeMultipleRelations = false;
    }
}

