/*
 * Decompiled with CFR 0.152.
 */
package edu.nyu.jet.chunk;

import java.io.BufferedReader;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.util.StringTokenizer;

class ChunkConvert {
    ChunkConvert() {
    }

    public static void main(String[] args) {
        String inFile = "C:/My Documents/HMM/Chunk/RM Data.txt";
        String textFile = "C:/My Documents/HMM/Chunk/chunk text.txt";
        String keyFile = "C:/My Documents/HMM/Chunk/chunk key.txt";
        try {
            String line;
            BufferedReader reader = new BufferedReader(new FileReader(inFile));
            PrintStream textWriter = new PrintStream(new FileOutputStream(textFile));
            PrintStream keyWriter = new PrintStream(new FileOutputStream(keyFile));
            StringBuffer sent = new StringBuffer(200);
            StringBuffer key = new StringBuffer(300);
            textWriter.println("<TEXT>");
            keyWriter.println("<TEXT>");
            sent.append("<S>");
            key.append("<S>");
            boolean inGroup = false;
            boolean firstToken = true;
            while ((line = reader.readLine()) != null) {
                StringTokenizer st = new StringTokenizer(line);
                int count = st.countTokens();
                if (count == 0) {
                    if (inGroup) {
                        key.append("</NG>");
                    }
                    sent.append("</S>");
                    textWriter.println(sent);
                    sent.setLength(0);
                    sent.append("<S>");
                    key.append("</S>");
                    keyWriter.println(key);
                    key.setLength(0);
                    key.append("<S>");
                    firstToken = true;
                    inGroup = false;
                    continue;
                }
                if (count >= 3) {
                    String token = st.nextToken();
                    String pos = st.nextToken();
                    String iob = st.nextToken();
                    if (iob.equals("I")) {
                        if (!firstToken) {
                            sent.append(" ");
                            key.append(" ");
                        }
                        if (!inGroup) {
                            key.append("<NG>");
                        }
                        inGroup = true;
                        sent.append(token);
                        key.append(token);
                    } else if (iob.equals("O")) {
                        if (inGroup) {
                            key.append("</NG>");
                        }
                        inGroup = false;
                        if (!firstToken) {
                            sent.append(" ");
                            key.append(" ");
                        }
                        sent.append(token);
                        key.append(token);
                    } else if (iob.equals("B")) {
                        if (!inGroup) {
                            System.out.println("Error:  B tag with inGroup=false");
                            inGroup = true;
                        }
                        if (firstToken) {
                            System.out.println("Error:  B tag at start of sentence");
                        }
                        sent.append(" ");
                        sent.append(token);
                        key.append("</NG>");
                        key.append(" ");
                        key.append("<NG>");
                        key.append(token);
                    } else {
                        System.out.println("Error:  unknown IOB tag " + iob);
                    }
                    firstToken = false;
                    continue;
                }
                System.out.println("Error:  invalid input line: " + line);
            }
            if (!firstToken) {
                if (inGroup) {
                    key.append("</NG>");
                }
                sent.append("</S>");
                textWriter.println(sent);
                key.append("</S>");
                keyWriter.println(key);
            }
            textWriter.println("</TEXT>");
            keyWriter.println("</TEXT>");
        }
        catch (IOException e) {
            System.out.println(e);
        }
    }
}

