/*
 * Decompiled with CFR 0.152.
 */
package edu.nyu.jet.chunk;

import java.io.File;
import java.io.FileReader;
import opennlp.maxent.BasicEventStream;
import opennlp.maxent.GIS;
import opennlp.maxent.GISModel;
import opennlp.maxent.PlainTextByLineDataStream;
import opennlp.maxent.io.SuffixSensitiveGISModelWriter;

public class CreateModel {
    static boolean USE_SMOOTHING = false;
    static double SMOOTHING_OBSERVATION = 0.1;
    static boolean PRINT_MESSAGES = true;

    public static void main(String[] args) {
        String home = "C:/Documents and Settings/Ralph Grishman/My Documents/";
        String dataFileName = home + "jet temp/coref features.txt";
        String modelFileName = home + "jet temp/coref model.txt";
        try {
            FileReader datafr = new FileReader(new File(dataFileName));
            BasicEventStream es = new BasicEventStream(new PlainTextByLineDataStream(datafr));
            GIS.SMOOTHING_OBSERVATION = SMOOTHING_OBSERVATION;
            GISModel model = GIS.trainModel(es, 100, 4, USE_SMOOTHING, PRINT_MESSAGES);
            File outputFile = new File(modelFileName);
            SuffixSensitiveGISModelWriter writer = new SuffixSensitiveGISModelWriter(model, outputFile);
            writer.persist();
        }
        catch (Exception e) {
            System.out.print("Unable to create model due to exception: ");
            System.out.println(e);
        }
    }
}

