/*
 * Decompiled with CFR 0.152.
 */
package edu.nyu.jet.chunk;

import edu.nyu.jet.tipster.Annotation;
import edu.nyu.jet.tipster.Document;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;

public class NameConstraints {
    boolean[][] validState = null;

    NameConstraints(Document doc, Annotation[] tokens, String[] state) {
        if (doc.annotationsOfType("isName") == null && doc.annotationsOfType("isExactName") == null) {
            return;
        }
        int nTokens = tokens.length;
        int nStates = state.length;
        this.validState = new boolean[nTokens][nStates];
        List<String> stateList = Arrays.asList(state);
        String type = null;
        int extent = -1;
        boolean exact = false;
        for (int iToken = 0; iToken < nTokens; ++iToken) {
            int posn = tokens[iToken].start();
            if (extent >= 0 && posn < extent) {
                for (int iState = 0; iState < nStates; ++iState) {
                    this.validState[iToken][iState] = type == null ? !state[iState].equals("other") : (type.equals("other") ? state[iState].equals("other") : state[iState].equals("I-" + type));
                }
                continue;
            }
            boolean endOfExact = exact;
            Vector<Annotation> isName = doc.annotationsAt(posn, "isName");
            Vector<Annotation> isExactName = doc.annotationsAt(posn, "isExactName");
            if (isExactName != null && isExactName.size() > 0) {
                Annotation a = isExactName.get(0);
                type = (String)a.get("type");
                if (type == null) {
                    System.err.println("NameConstraints: no type attribute in <isExactName>");
                } else if (!stateList.contains("B-" + type) && !type.equals("other")) {
                    System.err.println("NameConstraints: invalid type in <isExactName type=" + type + ">");
                }
                extent = a.end();
                exact = true;
            } else if (isName != null && isName.size() > 0) {
                Annotation a = isName.get(0);
                type = (String)a.get("type");
                if (type != null && !stateList.contains("B-" + type) && !type.equals("other")) {
                    System.err.println("NameConstraints: invalid type in <isName type=" + type + ">");
                }
                extent = a.end();
                exact = false;
            } else {
                extent = -1;
                exact = false;
            }
            for (int iState = 0; iState < nStates; ++iState) {
                String s = state[iState];
                if (extent >= 0) {
                    if (type == null) {
                        this.validState[iToken][iState] = !s.equals("other");
                        continue;
                    }
                    if (type.equals("other")) {
                        this.validState[iToken][iState] = s.equals("other");
                        continue;
                    }
                    if (exact || endOfExact) {
                        this.validState[iToken][iState] = s.equals("B-" + type);
                        continue;
                    }
                    this.validState[iToken][iState] = s.equals("B-" + type) || s.equals("I-" + type);
                    continue;
                }
                this.validState[iToken][iState] = endOfExact ? s.startsWith("B") || s.equals("other") : true;
            }
        }
    }

    private void printTable(boolean[][] v, String[] state, int nTokens, int nStates) {
        System.out.print("                    ");
        for (int iToken = 0; iToken < nTokens; ++iToken) {
            System.out.print(" " + iToken);
        }
        System.out.println();
        for (int iState = 0; iState < nStates; ++iState) {
            String stateName = state[iState];
            stateName = stateName + "                    ";
            stateName = stateName.substring(0, 20);
            System.out.print(stateName);
            for (int iToken = 0; iToken < nTokens; ++iToken) {
                System.out.print(v[iToken][iState] ? " T" : " F");
            }
            System.out.println();
        }
    }

    boolean allowedState(int itoken, int istate) {
        if (this.validState == null) {
            return true;
        }
        return this.validState[itoken][istate];
    }
}

