/*
 * Decompiled with CFR 0.152.
 */
package edu.nyu.jet.concepts;

import edu.nyu.jet.concepts.Word;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;

public class Concept
extends DefaultMutableTreeNode
implements Transferable {
    protected Vector subconcepts = new Vector();
    protected Vector words = new Vector();
    public static final DataFlavor DEFAULT_MUTABLE_TREENODE_FLAVOR = new DataFlavor(DefaultMutableTreeNode.class, "Default Mutable Tree Node");
    static DataFlavor[] flavors = new DataFlavor[]{DEFAULT_MUTABLE_TREENODE_FLAVOR};

    public Concept(Object conceptName) {
        super(conceptName, true);
    }

    public String getName() {
        return (String)super.getUserObject();
    }

    public boolean isLeaf() {
        return false;
    }

    public Vector getSubconcepts() {
        return this.subconcepts;
    }

    public Vector getWords() {
        return this.words;
    }

    public int getSubconceptCount() {
        return this.subconcepts.size();
    }

    public int getWordCount() {
        return this.words.size();
    }

    public Concept getSubconceptAt(int index) {
        return (Concept)this.subconcepts.get(index);
    }

    public Word getWordAt(int index) {
        return (Word)this.words.get(index);
    }

    public void addConcept(Concept newConcept) {
        super.add(newConcept);
        this.subconcepts.add(newConcept);
    }

    public void addWord(Word newWord) {
        if (this.children == null) {
            this.children = new Vector();
        }
        this.children.add(this.words.size(), newWord);
        this.words.add(newWord);
    }

    public void removeConcept(Concept oldConcept) {
        super.remove(oldConcept);
        this.subconcepts.remove(oldConcept);
    }

    public void removeWord(Word oldWord) {
        super.remove(oldWord);
        this.words.remove(oldWord);
    }

    public void removeAllChildren() {
        super.removeAllChildren();
        this.subconcepts.clear();
        this.words.clear();
    }

    public Enumeration breadthFirstEnumerationOfConcepts() {
        TreeNode o = null;
        Vector<TreeNode> v = new Vector<TreeNode>();
        Enumeration<TreeNode> e = super.breadthFirstEnumeration();
        while (e.hasMoreElements()) {
            o = e.nextElement();
            if (!(o instanceof Concept)) continue;
            v.add(o);
        }
        return v.elements();
    }

    public Enumeration breadthFirstEnumerationOfWords() {
        TreeNode o = null;
        Vector<TreeNode> v = new Vector<TreeNode>();
        Enumeration<TreeNode> e = super.breadthFirstEnumeration();
        while (e.hasMoreElements()) {
            o = e.nextElement();
            if (!(o instanceof Word)) continue;
            v.add(o);
        }
        return v.elements();
    }

    public Object getTransferData(DataFlavor flavor) throws IOException, UnsupportedFlavorException {
        if (flavor.equals(flavors[0])) {
            return this;
        }
        throw new UnsupportedFlavorException(flavor);
    }

    public DataFlavor[] getTransferDataFlavors() {
        return flavors;
    }

    public boolean isDataFlavorSupported(DataFlavor flavor) {
        for (int i = 0; i < flavors.length; ++i) {
            if (!flavor.equals(flavors[i])) continue;
            return true;
        }
        return false;
    }
}

