/*
 * Decompiled with CFR 0.152.
 */
package edu.nyu.jet.concepts;

import edu.nyu.jet.JetTest;
import edu.nyu.jet.concepts.Concept;
import edu.nyu.jet.concepts.TransferableTreeNode;
import edu.nyu.jet.concepts.Word;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceContext;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.swing.JOptionPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public class ConceptHierarchy
extends JTree
implements DragGestureListener,
DragSourceListener,
DropTargetListener {
    final boolean DEBUG = false;
    Hashtable concepts = new Hashtable();
    Hashtable conceptsInv = new Hashtable();
    Hashtable words = new Hashtable();
    Hashtable wordsInv = new Hashtable();
    private Component owner;
    private DragSource dragSource;
    private DropTarget dropTarget;
    private TreePath selectedTreePath = null;
    private DefaultMutableTreeNode selectedNode = null;
    private Point cursorLocation = null;

    public ConceptHierarchy() {
        super(new Concept("UNIVERSE"));
        this.setRootVisible(false);
        this.setShowsRootHandles(true);
        this.setEditable(true);
        if (!JetTest.batchFlag) {
            this.dragSource = DragSource.getDefaultDragSource();
            this.dragSource.createDefaultDragGestureRecognizer(this, 3, this);
            this.dropTarget = new DropTarget(this, this);
        }
    }

    public ConceptHierarchy(File file) {
        this();
        this.readHierarchy(file);
    }

    public void setOwner(Component owner) {
        this.owner = owner;
    }

    public Concept getConceptByName(String conceptName) {
        Object c = this.concepts.get(conceptName);
        if (c == null) {
            return null;
        }
        return (Concept)c;
    }

    public Concept getConceptByNameIgnoreCase(String conceptName) {
        Enumeration enu = this.concepts.keys();
        while (enu.hasMoreElements()) {
            String name = (String)enu.nextElement();
            if (!name.equalsIgnoreCase(conceptName)) continue;
            return (Concept)this.concepts.get(name);
        }
        return null;
    }

    public Concept getConceptFor(String word) {
        Word w = this.getWordByName(word);
        if (w != null) {
            return (Concept)w.getParent();
        }
        return null;
    }

    public Word getWordByName(String wordName) {
        Object w = this.words.get(wordName);
        if (w == null) {
            return null;
        }
        return (Word)w;
    }

    public Word getWordByNameIgnoreCase(String wordName) {
        Enumeration enu = this.words.keys();
        while (enu.hasMoreElements()) {
            String name = (String)enu.nextElement();
            if (!name.equalsIgnoreCase(wordName)) continue;
            return (Word)this.words.get(name);
        }
        return null;
    }

    public static boolean isa(Concept concept1, Concept concept2) {
        return concept2.isNodeChild(concept1);
    }

    public static boolean isaStar(Concept concept1, Concept concept2) {
        return concept1.isNodeAncestor(concept2);
    }

    public boolean addConcept(Concept newConcept, Concept parent) {
        if (!this.isDuplicateConcept(newConcept)) {
            parent.addConcept(newConcept);
            newConcept.setParent(parent);
            Enumeration enuConcept = newConcept.breadthFirstEnumerationOfConcepts();
            Enumeration enuWord = newConcept.breadthFirstEnumerationOfWords();
            this.concepts.put(newConcept.getName(), newConcept);
            this.conceptsInv.put(newConcept, newConcept.getName());
            while (enuConcept.hasMoreElements()) {
                Concept c = (Concept)enuConcept.nextElement();
                this.concepts.put(c.getName(), c);
                this.conceptsInv.put(c, c.getName());
            }
            while (enuWord.hasMoreElements()) {
                Word w = (Word)enuWord.nextElement();
                this.words.put(w.getName(), w);
                this.wordsInv.put(w, w.getName());
            }
            this.updateUI();
            return true;
        }
        return false;
    }

    public boolean addWord(Word newWord, Concept parent) {
        if (!this.isDuplicateWord(newWord)) {
            parent.addWord(newWord);
            newWord.setParent(parent);
            this.words.put(newWord.getName(), newWord);
            this.wordsInv.put(newWord, newWord.getName());
            this.updateUI();
            return true;
        }
        return false;
    }

    public void newConcept(Concept selectedConcept) {
        Concept newConcept = new Concept("NEW-CONCEPT");
        this.addConcept(newConcept, selectedConcept);
        this.setSelectionPath(new TreePath(newConcept.getPath()));
        this.startEditingAtPath(this.getSelectionPath());
    }

    public void newWord(Concept selectedConcept) {
        Word newWord = new Word("New Word");
        this.addWord(newWord, selectedConcept);
        this.setSelectionPath(new TreePath(newWord.getPath()));
        this.startEditingAtPath(this.getSelectionPath());
    }

    public void removeConcept(Concept oldConcept) {
        Concept parent = (Concept)oldConcept.getParent();
        parent.removeConcept(oldConcept);
        Enumeration enuConcept = oldConcept.breadthFirstEnumerationOfConcepts();
        Enumeration enuWord = oldConcept.breadthFirstEnumerationOfWords();
        this.concepts.remove(oldConcept.getName());
        this.conceptsInv.remove(oldConcept);
        while (enuConcept.hasMoreElements()) {
            Concept c = (Concept)enuConcept.nextElement();
            this.concepts.remove(c.getName());
            this.conceptsInv.remove(c);
        }
        while (enuWord.hasMoreElements()) {
            Word w = (Word)enuWord.nextElement();
            this.words.remove(w.getName());
            this.wordsInv.remove(w);
        }
        this.updateUI();
    }

    public void removeWord(Word oldWord) {
        Concept parent = (Concept)oldWord.getParent();
        parent.removeWord(oldWord);
        this.words.remove(oldWord.getName());
        this.wordsInv.remove(oldWord);
        this.updateUI();
    }

    public void clear() {
        Concept root = (Concept)this.getModel().getRoot();
        root.removeAllChildren();
        this.concepts.clear();
        this.conceptsInv.clear();
        this.words.clear();
        this.wordsInv.clear();
        this.updateUI();
    }

    public boolean isDuplicateConcept(Concept concept) {
        Concept c = concept;
        if (this.concepts.containsKey(concept.getName())) {
            final String message = "Concept '" + c.getName() + "' already exists.\nNo duplicate concepts allowed.";
            if (this.owner != null) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        JOptionPane.showMessageDialog(ConceptHierarchy.this.owner, message, "Error -- Duplicate Concept", 0);
                    }
                });
            } else {
                System.out.println(message);
            }
            return true;
        }
        return false;
    }

    public boolean isDuplicateWord(Word word) {
        Word w = word;
        if (this.words.containsKey(word.getName())) {
            final String message = "Word '" + w.getName() + "' already exists.\nNo duplicate words allowed.";
            if (this.owner != null) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        JOptionPane.showMessageDialog(ConceptHierarchy.this.owner, message, "Error -- Duplicate Word", 0);
                    }
                });
            } else {
                System.out.println(message);
            }
            return true;
        }
        return false;
    }

    public void readHierarchy(File file) {
        try {
            String line;
            BufferedReader in = new BufferedReader(new FileReader(file));
            this.clear();
            while ((line = in.readLine()) != null) {
                StringTokenizer stok = new StringTokenizer(line);
                if (!stok.hasMoreTokens() || line.substring(0, 2).equals("//")) continue;
                String conceptName = stok.nextToken();
                Concept concept = new Concept(conceptName);
                if (!stok.hasMoreTokens()) {
                    System.out.println("throw 01");
                    throw new IOException(line);
                }
                String key = stok.nextToken();
                if (key.equals("isa")) {
                    if (stok.hasMoreTokens()) {
                        String parentName = stok.nextToken();
                        Concept parent = this.getConceptByName(parentName);
                        if (parent == null) {
                            parent = new Concept(parentName);
                            this.addConcept(parent, (Concept)this.getModel().getRoot());
                        }
                        this.addConcept(concept, parent);
                        if (!stok.hasMoreTokens()) continue;
                        System.out.println("throw 02");
                        throw new IOException(line);
                    }
                    System.out.println("throw 03");
                    throw new IOException(line);
                }
                if (key.equals("words")) {
                    Word word;
                    int len;
                    if (!stok.hasMoreTokens()) {
                        System.out.println("throw 04");
                        throw new IOException(line);
                    }
                    concept = this.getConceptByName(conceptName);
                    if (concept == null) {
                        concept = new Concept(conceptName);
                        this.addConcept(concept, (Concept)this.getModel().getRoot());
                    }
                    StringBuffer wordBuffer = new StringBuffer();
                    while (stok.hasMoreTokens()) {
                        wordBuffer.append(stok.nextToken() + " ");
                        len = wordBuffer.length();
                        if (!wordBuffer.substring(len - 2, len).equals(", ")) continue;
                        word = new Word(wordBuffer.substring(0, len - 2));
                        this.addWord(word, concept);
                        wordBuffer = new StringBuffer();
                    }
                    len = wordBuffer.length();
                    if (wordBuffer.substring(len - 2, len).equals(", ")) continue;
                    word = new Word(wordBuffer.toString().trim());
                    this.addWord(word, concept);
                    continue;
                }
                System.out.println("throw 05");
                throw new IOException(line);
            }
        }
        catch (FileNotFoundException e) {
            System.err.println("Error: File " + file.toString() + " not found.");
        }
        catch (IOException e) {
            System.err.println("Error processing file " + file.toString() + " at the following line:\n" + e.getMessage());
        }
    }

    public void writeHierarchy(File file) {
        try {
            PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(file)));
            Concept root = (Concept)this.getModel().getRoot();
            for (int i = 0; i < root.getSubconceptCount(); ++i) {
                this.recursiveWrite(root.getSubconceptAt(i), out);
            }
        }
        catch (IOException e) {
            System.err.println("Error writing to file " + file.toString() + ".");
        }
    }

    private void recursiveWrite(Concept concept, PrintWriter out) {
        int i;
        Concept parent = (Concept)concept.getParent();
        if (!parent.equals((Concept)this.getModel().getRoot())) {
            out.println(concept.getName() + " isa " + parent.getName());
            out.flush();
        }
        StringBuffer words = new StringBuffer();
        for (i = 0; i < concept.getWordCount(); ++i) {
            if (i == 0) {
                words.append(concept.getWordAt(i).getName());
                continue;
            }
            words.append(", " + concept.getWordAt(i).getName());
        }
        if (words.length() > 0) {
            out.println(concept.getName() + " words " + words.toString());
            out.flush();
        }
        for (i = 0; i < concept.getSubconceptCount(); ++i) {
            Concept nextConcept = concept.getSubconceptAt(i);
            this.recursiveWrite(nextConcept, out);
        }
    }

    public void dragGestureRecognized(DragGestureEvent dge) {
        this.selectedTreePath = this.getSelectionPath();
        if (this.selectedTreePath != null) {
            this.selectedNode = (DefaultMutableTreeNode)this.selectedTreePath.getLastPathComponent();
            TransferableTreeNode tr = new TransferableTreeNode(this.selectedNode);
            Cursor cursor = DragSource.DefaultMoveDrop;
            int action = dge.getDragAction();
            if (action == 1) {
                cursor = DragSource.DefaultCopyDrop;
            }
            this.dragSource.startDrag(dge, cursor, tr, this);
        }
    }

    public void dragDropEnd(DragSourceDropEvent dsde) {
    }

    public void dragEnter(DragSourceDragEvent dsde) {
        this.setCursor(dsde);
    }

    public void dragOver(DragSourceDragEvent dsde) {
        this.setCursor(dsde);
    }

    public void dropActionChanged(DragSourceDragEvent dsde) {
    }

    public void dragExit(DragSourceEvent dsde) {
    }

    public void drop(DropTargetDropEvent e) {
        try {
            Transferable tr = e.getTransferable();
            if (!tr.isDataFlavorSupported(TransferableTreeNode.DEFAULT_MUTABLE_TREENODE_FLAVOR)) {
                e.rejectDrop();
            }
            Object userObject = tr.getTransferData(TransferableTreeNode.DEFAULT_MUTABLE_TREENODE_FLAVOR);
            Point loc = e.getLocation();
            TreePath destinationPath = this.getPathForLocation(loc.x, loc.y);
            final String msg = this.testDropTarget(destinationPath, this.selectedTreePath);
            if (msg != null) {
                e.rejectDrop();
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        JOptionPane.showMessageDialog(ConceptHierarchy.this.owner, msg, "Error Moving Node", 0);
                    }
                });
                return;
            }
            Concept newParent = (Concept)destinationPath.getLastPathComponent();
            Concept oldParent = (Concept)this.selectedNode.getParent();
            try {
                DefaultMutableTreeNode child;
                if (userObject instanceof Concept) {
                    child = (Concept)userObject;
                    this.removeConcept((Concept)this.selectedNode);
                    this.addConcept((Concept)child, newParent);
                    e.acceptDrop(2);
                } else {
                    child = (Word)userObject;
                    this.removeWord((Word)this.selectedNode);
                    this.addWord((Word)child, newParent);
                    e.acceptDrop(2);
                }
            }
            catch (IllegalStateException ils) {
                e.rejectDrop();
            }
            e.getDropTargetContext().dropComplete(true);
            DefaultTreeModel model = (DefaultTreeModel)this.getModel();
            model.reload(oldParent);
            model.reload(newParent);
            TreePath parentPath = new TreePath(newParent.getPath());
            this.expandPath(parentPath);
        }
        catch (IOException io) {
            e.rejectDrop();
        }
        catch (UnsupportedFlavorException ufe) {
            e.rejectDrop();
        }
    }

    public void dragEnter(DropTargetDragEvent e) {
    }

    public void dragOver(DropTargetDragEvent e) {
        this.cursorLocation = e.getLocation();
    }

    public void dragExit(DropTargetEvent e) {
    }

    public void dropActionChanged(DropTargetDragEvent e) {
    }

    private String testDropTarget(TreePath destination, TreePath dropper) {
        if (destination == null) {
            return "Invalid drop location.";
        }
        Object node = destination.getLastPathComponent();
        if (node instanceof Word) {
            return "A word does not allow children.";
        }
        if (destination.equals(dropper)) {
            return "Destination cannot be same as source.";
        }
        if (dropper.isDescendant(destination)) {
            return "Destination cannot be a descendant of source.";
        }
        if (dropper.getParentPath().equals(destination)) {
            return "Destination cannot be a parent of source.";
        }
        return null;
    }

    private void setCursor(DragSourceDragEvent dsde) {
        if (this.cursorLocation == null) {
            return;
        }
        TreePath destinationPath = this.getPathForLocation(this.cursorLocation.x, this.cursorLocation.y);
        DragSourceContext dsc = dsde.getDragSourceContext();
        if (this.testDropTarget(destinationPath, this.selectedTreePath) == null) {
            dsc.setCursor(DragSource.DefaultMoveDrop);
        } else {
            dsc.setCursor(DragSource.DefaultMoveNoDrop);
        }
    }

    void printHashtables() {
        System.out.println("\n***concepts***\n");
        Enumeration conceptEnu = this.concepts.elements();
        while (conceptEnu.hasMoreElements()) {
            System.out.println(conceptEnu.nextElement());
        }
        System.out.println("\n***conceptsInv***\n");
        Enumeration conceptInvEnu = this.conceptsInv.elements();
        while (conceptInvEnu.hasMoreElements()) {
            System.out.println(conceptInvEnu.nextElement());
        }
        System.out.println("\n***words***\n");
        Enumeration wordEnu = this.words.elements();
        while (wordEnu.hasMoreElements()) {
            System.out.println(wordEnu.nextElement());
        }
        System.out.println("\n***wordsInv***\n");
        Enumeration wordInvEnu = this.wordsInv.elements();
        while (wordInvEnu.hasMoreElements()) {
            System.out.println(wordInvEnu.nextElement());
        }
    }
}

