/*
 * Decompiled with CFR 0.152.
 */
package edu.nyu.jet.concepts;

import edu.nyu.jet.concepts.Concept;
import edu.nyu.jet.concepts.ConceptHierarchy;
import edu.nyu.jet.concepts.ConcreteFileFilter;
import edu.nyu.jet.concepts.Word;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import javax.swing.ButtonGroup;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreePath;

public class ConceptHierarchyWindow
extends JFrame
implements ActionListener {
    public static ConceptHierarchy conceptHierarchy;
    private JScrollPane jScrollPane = new JScrollPane();
    private final JFileChooser fcOpen = new JFileChooser(".");
    private final JFileChooser fcSave = new JFileChooser(".");
    private final JFileChooser fcSaveAs = new JFileChooser(".");
    private File currentFile = null;
    private FindDialog[] findDialog = new FindDialog[2];
    boolean dirty = false;

    public ConceptHierarchyWindow(ConceptHierarchy ch, File file) {
        try {
            conceptHierarchy = ch;
            this.currentFile = file;
            conceptHierarchy.setOwner(this);
            conceptHierarchy.getModel().addTreeModelListener(new TreeModelListener(){

                public void treeNodesChanged(TreeModelEvent e) {
                    Object changedNode = conceptHierarchy.getSelectionPath().getLastPathComponent();
                    if (changedNode instanceof Concept) {
                        Concept changedConcept = (Concept)changedNode;
                        if (changedConcept.getName().length() == 0) {
                            SwingUtilities.invokeLater(new Runnable(){

                                public void run() {
                                    JOptionPane.showMessageDialog(ConceptHierarchyWindow.this, "You must type a concept name.", "Error Renaming Concept", 0);
                                }
                            });
                            conceptHierarchy.startEditingAtPath(conceptHierarchy.getSelectionPath());
                        }
                        String oldConceptName = (String)ConceptHierarchyWindow.conceptHierarchy.conceptsInv.get(changedNode);
                        if (!changedConcept.getName().equals(oldConceptName) && conceptHierarchy.isDuplicateConcept(changedConcept)) {
                            conceptHierarchy.startEditingAtPath(conceptHierarchy.getSelectionPath());
                        } else {
                            ConceptHierarchyWindow.conceptHierarchy.concepts.remove(oldConceptName);
                            ConceptHierarchyWindow.conceptHierarchy.concepts.put(changedConcept.getName(), changedConcept);
                            ConceptHierarchyWindow.conceptHierarchy.conceptsInv.remove(changedNode);
                            ConceptHierarchyWindow.conceptHierarchy.conceptsInv.put(changedConcept, changedConcept.getName());
                        }
                    } else {
                        Word changedWord = (Word)changedNode;
                        if (changedWord.getName().length() == 0) {
                            SwingUtilities.invokeLater(new Runnable(){

                                public void run() {
                                    JOptionPane.showMessageDialog(ConceptHierarchyWindow.this, "You must type a word.", "Error Renaming Word", 0);
                                }
                            });
                            conceptHierarchy.startEditingAtPath(conceptHierarchy.getSelectionPath());
                        }
                        String oldWordName = (String)ConceptHierarchyWindow.conceptHierarchy.wordsInv.get(changedNode);
                        if (!changedWord.getName().equals(oldWordName) && conceptHierarchy.isDuplicateWord(changedWord)) {
                            conceptHierarchy.startEditingAtPath(conceptHierarchy.getSelectionPath());
                        } else {
                            ConceptHierarchyWindow.conceptHierarchy.words.remove(oldWordName);
                            ConceptHierarchyWindow.conceptHierarchy.words.put(changedWord.getName(), changedWord);
                            ConceptHierarchyWindow.conceptHierarchy.wordsInv.remove(changedNode);
                            ConceptHierarchyWindow.conceptHierarchy.wordsInv.put(changedWord, changedWord.getName());
                        }
                    }
                    ConceptHierarchyWindow.this.dirty = true;
                    ConceptHierarchyWindow.this.updateCaption();
                    conceptHierarchy.getClass();
                }

                public void treeNodesInserted(TreeModelEvent e) {
                    ConceptHierarchyWindow.this.dirty = true;
                    ConceptHierarchyWindow.this.updateCaption();
                }

                public void treeNodesRemoved(TreeModelEvent e) {
                    ConceptHierarchyWindow.this.dirty = true;
                    ConceptHierarchyWindow.this.updateCaption();
                }

                public void treeStructureChanged(TreeModelEvent e) {
                    ConceptHierarchyWindow.this.dirty = true;
                    ConceptHierarchyWindow.this.updateCaption();
                }
            });
            this.jbInit();
            ConcreteFileFilter filter = new ConcreteFileFilter("hrc", "Concept Hierarchy Files (*.hrc)");
            this.fcOpen.setFileFilter(filter);
            this.fcSave.setFileFilter(filter);
            this.fcSaveAs.setFileFilter(filter);
            this.findDialog[0] = new FindDialog(this, 0);
            this.findDialog[1] = new FindDialog(this, 1);
            this.findDialog[0].pack();
            this.findDialog[1].pack();
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            Dimension frameSize = this.getSize();
            if (frameSize.height > screenSize.height) {
                frameSize.height = screenSize.height;
            }
            if (frameSize.width > screenSize.width) {
                frameSize.width = screenSize.width;
            }
            this.setLocation((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.height) / 2);
            this.setVisible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        JMenuBar jmb = new JMenuBar();
        JMenu fileMenu = new JMenu("File");
        fileMenu.setMnemonic(70);
        JMenuItem item = new JMenuItem("Open ...");
        item.setMnemonic(79);
        item.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        fileMenu.add(item);
        item.addActionListener(this);
        item = new JMenuItem("Save");
        item.setMnemonic(83);
        item.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        fileMenu.add(item);
        item.addActionListener(this);
        item = new JMenuItem("Save As ...");
        item.setMnemonic(65);
        item.setAccelerator(KeyStroke.getKeyStroke(83, 10));
        fileMenu.add(item);
        item.addActionListener(this);
        item = new JMenuItem("Clear");
        item.setMnemonic(67);
        fileMenu.add(item);
        item.addActionListener(this);
        fileMenu.addSeparator();
        item = new JMenuItem("Exit");
        item.setMnemonic(88);
        fileMenu.add(item);
        item.addActionListener(this);
        JMenu editMenu = new JMenu("Edit");
        editMenu.setMnemonic(69);
        JMenu newSubmenu = new JMenu("New");
        newSubmenu.setMnemonic(78);
        editMenu.add(newSubmenu);
        item = new JMenuItem("Concept");
        item.setMnemonic(67);
        newSubmenu.add(item);
        item.addActionListener(this);
        item = new JMenuItem("Word");
        item.setMnemonic(87);
        newSubmenu.add(item);
        item.addActionListener(this);
        item = new JMenuItem("Delete");
        item.setMnemonic(68);
        item.setAccelerator(KeyStroke.getKeyStroke(127, 2));
        editMenu.add(item);
        item.addActionListener(this);
        item = new JMenuItem("Rename");
        item.setMnemonic(82);
        editMenu.add(item);
        item.addActionListener(this);
        editMenu.addSeparator();
        JMenu findSubmenu = new JMenu("Find ...");
        findSubmenu.setMnemonic(70);
        editMenu.add(findSubmenu);
        item = new JMenuItem("Concept ");
        item.setMnemonic(67);
        findSubmenu.add(item);
        item.addActionListener(this);
        item = new JMenuItem("Word ");
        item.setMnemonic(87);
        findSubmenu.add(item);
        item.addActionListener(this);
        jmb.add(fileMenu);
        jmb.add(editMenu);
        this.setJMenuBar(jmb);
        this.fcOpen.setDialogTitle("Open");
        this.fcOpen.setApproveButtonText("Open");
        this.fcOpen.setApproveButtonMnemonic(79);
        this.fcOpen.setApproveButtonToolTipText("Open Hierarchy");
        this.fcSave.setDialogTitle("Save");
        this.fcSave.setApproveButtonText("Save");
        this.fcSave.setApproveButtonMnemonic(83);
        this.fcSave.setApproveButtonToolTipText("Save Hierarchy");
        this.fcSaveAs.setDialogTitle("Save As");
        this.fcSaveAs.setApproveButtonText("Save");
        this.fcSaveAs.setApproveButtonMnemonic(83);
        this.fcSaveAs.setApproveButtonToolTipText("Save Hierarchy");
        conceptHierarchy.getSelectionModel().setSelectionMode(1);
        this.jScrollPane.getViewport().add((Component)conceptHierarchy, null);
        this.updateCaption();
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                if (ConceptHierarchyWindow.this.okToAbandon()) {
                    ConceptHierarchyWindow.this.dispose();
                }
            }
        });
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.jScrollPane, "Center");
        this.setSize(400, 600);
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("Open ...")) {
            int returnVal;
            if (this.okToAbandon() && (returnVal = this.fcOpen.showOpenDialog(this)) == 0) {
                this.currentFile = this.fcOpen.getSelectedFile();
                conceptHierarchy.readHierarchy(this.currentFile);
                this.dirty = false;
                this.updateCaption();
            }
        } else if (e.getActionCommand().equals("Save")) {
            if (!conceptHierarchy.isEditing()) {
                this.saveFile();
            }
        } else if (e.getActionCommand().equals("Save As ...")) {
            if (!conceptHierarchy.isEditing()) {
                int returnVal;
                if (this.currentFile == null) {
                    File tempFile = new File("Untitled Hierarchy.hrc");
                    this.fcSaveAs.setSelectedFile(tempFile);
                }
                if ((returnVal = this.fcSaveAs.showDialog(this, null)) == 0) {
                    this.currentFile = this.fcSaveAs.getSelectedFile();
                    conceptHierarchy.writeHierarchy(this.currentFile);
                    this.dirty = false;
                    this.updateCaption();
                }
            }
        } else if (e.getActionCommand().equals("Clear")) {
            conceptHierarchy.clear();
            this.dirty = true;
            this.updateCaption();
        } else if (e.getActionCommand().equals("Concept")) {
            if (!conceptHierarchy.isEditing()) {
                TreePath selectedPath = conceptHierarchy.getSelectionPath();
                if (selectedPath != null) {
                    Object selectedNode = selectedPath.getLastPathComponent();
                    if (selectedNode instanceof Concept) {
                        conceptHierarchy.newConcept((Concept)selectedNode);
                    }
                } else {
                    conceptHierarchy.newConcept((Concept)conceptHierarchy.getModel().getRoot());
                }
                this.dirty = true;
                this.updateCaption();
            }
        } else if (e.getActionCommand().equals("Word")) {
            if (!conceptHierarchy.isEditing()) {
                TreePath selectedPath = conceptHierarchy.getSelectionPath();
                if (selectedPath != null) {
                    Object selectedNode = selectedPath.getLastPathComponent();
                    if (selectedNode instanceof Concept) {
                        conceptHierarchy.newWord((Concept)selectedNode);
                    }
                } else {
                    conceptHierarchy.newWord((Concept)conceptHierarchy.getModel().getRoot());
                }
                this.dirty = true;
                this.updateCaption();
            }
        } else if (e.getActionCommand().equals("Delete")) {
            if (!conceptHierarchy.isEditing()) {
                TreePath selectedPath = conceptHierarchy.getSelectionPath();
                if (selectedPath != null) {
                    Object selectedNode = selectedPath.getLastPathComponent();
                    if (selectedNode instanceof Concept) {
                        conceptHierarchy.removeConcept((Concept)selectedNode);
                    } else {
                        conceptHierarchy.removeWord((Word)selectedNode);
                    }
                }
                this.dirty = true;
                this.updateCaption();
            }
        } else if (e.getActionCommand().equals("Rename")) {
            if (!conceptHierarchy.isEditing()) {
                conceptHierarchy.startEditingAtPath(conceptHierarchy.getSelectionPath());
                this.dirty = true;
                this.updateCaption();
            }
        } else if (e.getActionCommand().equals("Concept ")) {
            if (!conceptHierarchy.isEditing()) {
                this.find(0);
            }
        } else if (e.getActionCommand().equals("Word ")) {
            if (!conceptHierarchy.isEditing()) {
                this.find(1);
            }
        } else if (this.okToAbandon()) {
            this.dispose();
        }
    }

    private void find(int mode) {
        this.findDialog[mode].setLocationRelativeTo(this);
        this.findDialog[mode].setVisible(true);
        String query = this.findDialog[mode].getQuery();
        boolean caseSensitive = this.findDialog[mode].getCaseSensitivity();
        if (query == null) {
            return;
        }
        if (mode == 0) {
            Concept c = caseSensitive ? conceptHierarchy.getConceptByName(query) : conceptHierarchy.getConceptByNameIgnoreCase(query);
            if (c != null) {
                TreePath path = new TreePath(c.getPath());
                conceptHierarchy.setSelectionPath(path);
                conceptHierarchy.scrollPathToVisible(path);
            } else {
                JOptionPane.showMessageDialog(this.findDialog[0], "Concept '" + query + "' not found.", "Search Failed", 0);
            }
        } else {
            Word w = caseSensitive ? conceptHierarchy.getWordByName(query) : conceptHierarchy.getWordByNameIgnoreCase(query);
            if (w != null) {
                TreePath path = new TreePath(w.getPath());
                conceptHierarchy.setSelectionPath(path);
                conceptHierarchy.scrollPathToVisible(path);
            } else {
                JOptionPane.showMessageDialog(this.findDialog[1], "Word '" + query + "' not found.", "Search Failed", 0);
            }
        }
    }

    void updateCaption() {
        String caption = this.currentFile == null ? "Untitled Hierarchy.hrc" : this.currentFile.getAbsolutePath();
        if (this.dirty) {
            caption = caption + "*";
        }
        caption = "Concept Hierarchy - " + caption;
        this.setTitle(caption);
    }

    private boolean okToAbandon() {
        if (!this.dirty) {
            return true;
        }
        String currentFileName = this.currentFile != null ? this.currentFile.getName() : "Untitled Hierarchy.hrc";
        int value = JOptionPane.showConfirmDialog(this, "File modified: \"" + currentFileName + "\". Do you wish to save changes?", "Save Modified File?", 1);
        switch (value) {
            case 0: {
                this.saveFile();
                return true;
            }
            case 1: {
                return true;
            }
        }
        return false;
    }

    private void saveFile() {
        if (this.currentFile != null) {
            conceptHierarchy.writeHierarchy(this.currentFile);
            this.dirty = false;
            this.updateCaption();
        } else {
            File tempFile = new File("Untitled Hierarchy.hrc");
            this.fcSave.setSelectedFile(tempFile);
            int returnVal = this.fcSave.showSaveDialog(this);
            if (returnVal == 0) {
                this.currentFile = this.fcSave.getSelectedFile();
                conceptHierarchy.writeHierarchy(this.currentFile);
                this.dirty = false;
                this.updateCaption();
            }
        }
    }

    class FindDialog
    extends JDialog {
        private String query;
        private boolean caseSensitivity;
        private JOptionPane optionPane;
        private final int mode;

        public String getQuery() {
            return this.query;
        }

        public boolean getCaseSensitivity() {
            return this.caseSensitivity;
        }

        public FindDialog(Frame owner, int m) {
            super(owner, "Find", true);
            this.query = null;
            this.mode = m;
            String[] msgString = new String[]{"Enter a concept name to find.", "Enter a word to find"};
            JRadioButton[] radioButtons = new JRadioButton[2];
            final ButtonGroup group = new ButtonGroup();
            radioButtons[0] = new JRadioButton("Case Insensitive");
            radioButtons[0].setActionCommand("insensitive");
            radioButtons[1] = new JRadioButton("Case Sensitive");
            radioButtons[1].setActionCommand("sensitive");
            group.add(radioButtons[0]);
            group.add(radioButtons[1]);
            radioButtons[0].setSelected(true);
            final JTextField textField = new JTextField(10);
            Object[] array = new Object[]{msgString[this.mode], radioButtons[0], radioButtons[1], textField};
            String btnString1 = "Find";
            String btnString2 = "Cancel";
            Object[] options = new Object[]{"Find", "Cancel"};
            this.optionPane = new JOptionPane(array, 3, 0, null, options, options[0]);
            this.setContentPane(this.optionPane);
            this.setDefaultCloseOperation(0);
            this.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent we) {
                    FindDialog.this.optionPane.setValue(new Integer(-1));
                }
            });
            textField.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    FindDialog.this.optionPane.setValue("Find");
                }
            });
            this.optionPane.addPropertyChangeListener(new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent e) {
                    String prop = e.getPropertyName();
                    if (FindDialog.this.isVisible() && e.getSource() == FindDialog.this.optionPane && (prop.equals("value") || prop.equals("inputValue"))) {
                        Object value = FindDialog.this.optionPane.getValue();
                        if (value == JOptionPane.UNINITIALIZED_VALUE) {
                            return;
                        }
                        FindDialog.this.optionPane.setValue(JOptionPane.UNINITIALIZED_VALUE);
                        if (value.equals("Find")) {
                            FindDialog.this.query = textField.getText();
                            FindDialog.this.caseSensitivity = group.getSelection().getActionCommand().equals("sensitive");
                            if (FindDialog.this.query != null && !FindDialog.this.query.equals("")) {
                                textField.selectAll();
                                FindDialog.this.setVisible(false);
                            } else {
                                FindDialog.this.query = null;
                                String name = FindDialog.this.mode == 0 ? "concept name" : "word";
                                JOptionPane.showMessageDialog(FindDialog.this, "Nothing entered.\nPlease enter a " + name + ".", "Try again", 0);
                            }
                        } else {
                            FindDialog.this.query = null;
                            FindDialog.this.setVisible(false);
                        }
                    }
                }
            });
        }
    }
}

