/*
 * Decompiled with CFR 0.152.
 */
package edu.nyu.jet.format;

import edu.nyu.jet.parser.ParseTreeNode;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;

public class PTBWriter {
    private static final Map<String, String> TRANSFORM_TABLE = new HashMap<String, String>();

    public void save(ParseTreeNode tree, Writer out) throws IOException {
        out.write(40);
        out.write(this.buildTagName(tree));
        out.write(32);
        if (tree.children != null && tree.children.length != 0) {
            for (ParseTreeNode child : tree.children) {
                this.save(child, out);
                out.write(32);
            }
        } else {
            out.write(this.escape(tree.word));
        }
        out.write(41);
    }

    private String buildTagName(ParseTreeNode node) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(node.category.toString().toUpperCase());
        if (node.head != 0) {
            buffer.append('-');
            buffer.append(node.head);
        }
        return buffer.toString();
    }

    private String escape(String str) {
        StringBuilder buffer = new StringBuilder();
        int length = str.length();
        for (int i = 0; i < length; ++i) {
            char ch = str.charAt(i);
            if (ch == '*' || ch == '/') {
                buffer.append('\\');
            }
            buffer.append(ch);
        }
        String result = buffer.toString();
        if (TRANSFORM_TABLE.containsKey(result)) {
            return TRANSFORM_TABLE.get(result);
        }
        return result;
    }

    static {
        TRANSFORM_TABLE.put("(", "-LRB-");
        TRANSFORM_TABLE.put("{", "-LCB-");
        TRANSFORM_TABLE.put("[", "-LSB-");
        TRANSFORM_TABLE.put(")", "-RRB-");
        TRANSFORM_TABLE.put("}", "-RCB-");
        TRANSFORM_TABLE.put("]", "-RSB-");
    }
}

