/*
 * Decompiled with CFR 0.152.
 */
package edu.nyu.jet.hmm;

import edu.nyu.jet.hmm.HMMemitter;
import edu.nyu.jet.lisp.FeatureSet;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;

public class BasicHMMemitter
extends HMMemitter {
    private static final float VOCAB_SIZE = 40000.0f;
    int count;
    HashMap tokenCount;
    HashMap tokenProbability;
    double unseenTokenProbability;

    public void resetForTraining() {
        this.count = 0;
        this.tokenCount = new HashMap();
    }

    public void trainOnInstances(String token, String priorToken, int n) {
        this.count += n;
        Integer tcountI = (Integer)this.tokenCount.get(token);
        int tcount = tcountI == null ? 0 : tcountI;
        this.tokenCount.put(token, new Integer(tcount + n));
    }

    public void computeProbabilities() {
        this.tokenProbability = new HashMap();
        int singletonCount = 0;
        for (Map.Entry entry : this.tokenCount.entrySet()) {
            String token = (String)entry.getKey();
            int tokenCount = (Integer)entry.getValue();
            double probability = Math.log((double)tokenCount / (double)this.count);
            this.tokenProbability.put(token, new Double(probability));
            if (tokenCount != 1) continue;
            ++singletonCount;
        }
        this.unseenTokenProbability = Math.log((double)singletonCount / (double)this.count / 40000.0);
    }

    public double getProbability(String token, String priorToken, FeatureSet fs) {
        Double prob = (Double)this.tokenProbability.get(token);
        if (prob == null) {
            return this.unseenTokenProbability;
        }
        return prob;
    }

    public void print() {
        for (Map.Entry entry : this.tokenProbability.entrySet()) {
            String token = (String)entry.getKey();
            double probability = (Double)entry.getValue();
            System.out.println("EMIT " + token + " " + probability);
        }
    }

    public void store(PrintWriter stream) {
        for (Map.Entry entry : this.tokenCount.entrySet()) {
            String token = (String)entry.getKey();
            int count = (Integer)entry.getValue();
            stream.println("EMIT " + token + " " + count);
        }
    }
}

