/*
 * Decompiled with CFR 0.152.
 */
package edu.nyu.jet.hmm;

import edu.nyu.jet.aceJet.Ace;
import edu.nyu.jet.hmm.HMM;
import edu.nyu.jet.hmm.HMMemitter;
import edu.nyu.jet.lisp.FeatureSet;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;

public class BigramHMMemitter
extends HMMemitter {
    private static final float VOCAB_SIZE = 5000.0f;
    public static boolean useBigrams = true;
    int count;
    HashMap tokenCount;
    HashMap tokenProbability;
    HashMap priorTokenCount;
    HashMap bigramCount;
    HashMap LCbigramCount;
    HashMap bigramProbability;
    HashMap LCtokenCount;
    HashMap LCtokenProbability;
    HashMap featureCount;
    HashMap featureProbability;
    HashMap cacheCount;
    double[] inCacheProbability;
    double[] notInCacheProbability;
    double discount;
    double unseenTokenProbability;

    public void resetForTraining() {
        this.count = 0;
        this.tokenCount = new HashMap();
        this.priorTokenCount = new HashMap();
        this.bigramCount = new HashMap();
        this.LCbigramCount = new HashMap();
        this.LCtokenCount = new HashMap();
        this.featureCount = new HashMap();
        this.cacheCount = new HashMap();
    }

    public void setCacheCount(String type, int n) {
        this.cacheCount.put(type, new Integer(n));
    }

    public void trainOnInstances(String token, String priorToken, int n) {
        this.count += n;
        if (Ace.monocase && (this.stateName.startsWith("b-") || this.stateName.startsWith("m-") || this.stateName.startsWith("e-") || this.stateName.startsWith("i-"))) {
            token = this.capitalize(token);
        }
        BigramHMMemitter.incrementHashMap(this.tokenCount, token, n);
        BigramHMMemitter.incrementHashMap(this.priorTokenCount, priorToken.toLowerCase(), n);
        BigramHMMemitter.incrementTwoLevelHashMap(this.bigramCount, priorToken, token, n);
        BigramHMMemitter.incrementTwoLevelHashMap(this.LCbigramCount, priorToken.toLowerCase(), token.toLowerCase(), n);
        BigramHMMemitter.incrementHashMap(this.LCtokenCount, token.toLowerCase(), n);
        BigramHMMemitter.incrementHashMap(this.featureCount, BigramHMMemitter.wordFeature(token), n);
        if (this.hmm.tagsToCache != null) {
            for (int i = 0; i < this.hmm.tagsToCache.length; ++i) {
                if (!this.hmm.inCache(token, this.hmm.tagsToCache[i])) continue;
                BigramHMMemitter.incrementHashMap(this.cacheCount, this.hmm.tagsToCache[i], 1);
            }
        }
    }

    private String capitalize(String token) {
        if (Character.isLowerCase(token.charAt(0))) {
            return token.substring(0, 1).toUpperCase() + token.substring(1);
        }
        return token;
    }

    public void computeProbabilities() {
        Integer c2;
        this.tokenProbability = new HashMap();
        int singletonCount = 0;
        for (Map.Entry entry : this.tokenCount.entrySet()) {
            String token = (String)entry.getKey();
            int tokenCount = (Integer)entry.getValue();
            double probability = (double)tokenCount / (double)this.count;
            this.tokenProbability.put(token, new Double(probability));
            if (tokenCount != 1) continue;
            ++singletonCount;
        }
        this.bigramProbability = new HashMap();
        for (Map.Entry entry : this.LCbigramCount.entrySet()) {
            String priorToken = (String)entry.getKey();
            int priorTokenCt = (Integer)this.priorTokenCount.get(priorToken);
            HashMap countMap2 = (HashMap)entry.getValue();
            HashMap<String, Double> probMap2 = new HashMap<String, Double>();
            for (Map.Entry entry2 : countMap2.entrySet()) {
                String currentToken = (String)entry2.getKey();
                int bigramCt = (Integer)entry2.getValue();
                double probability = (double)bigramCt / (double)priorTokenCt;
                probMap2.put(currentToken, new Double(probability));
            }
            this.bigramProbability.put(priorToken, probMap2);
        }
        this.LCtokenProbability = new HashMap();
        for (Map.Entry entry : this.LCtokenCount.entrySet()) {
            String LCtoken = (String)entry.getKey();
            int LCtokenCount = (Integer)entry.getValue();
            double probability = (double)LCtokenCount / (double)this.count;
            this.LCtokenProbability.put(LCtoken, new Double(probability));
        }
        this.featureProbability = new HashMap();
        for (Map.Entry entry : this.featureCount.entrySet()) {
            String feature = (String)entry.getKey();
            int featureCount = (Integer)entry.getValue();
            double probability = Math.log((double)featureCount / (double)this.count);
            this.featureProbability.put(feature, new Double(probability));
        }
        Integer c1 = (Integer)this.featureCount.get("initCap");
        int c3 = (c1 == null ? 0 : c1) + ((c2 = (Integer)this.featureCount.get("lowerCase")) == null ? 0 : c2);
        if (c3 != 0) {
            double pfc = Math.log((double)c3 / (double)this.count);
            this.featureProbability.put("forcedCap", new Double(pfc));
        }
        this.unseenTokenProbability = Math.log((double)singletonCount / (double)this.count / 5000.0);
        if (this.hmm.tagsToCache != null) {
            this.inCacheProbability = new double[this.hmm.tagsToCache.length];
            this.notInCacheProbability = new double[this.hmm.tagsToCache.length];
            if (HMM.probReport) {
                System.out.println("For state " + this.stateName);
            }
            for (int i = 0; i < this.hmm.tagsToCache.length; ++i) {
                int cc;
                Integer cacheCt = (Integer)this.cacheCount.get(this.hmm.tagsToCache[i]);
                int n = cc = cacheCt == null ? 0 : cacheCt;
                if (HMM.probReport) {
                    System.out.println("Cache count[" + this.hmm.tagsToCache[i] + "]=" + cc);
                    System.out.println("inCacheProbability[" + this.hmm.tagsToCache[i] + "]=" + (double)cc / (double)this.count);
                }
                this.inCacheProbability[i] = Math.log((double)cc / (double)this.count);
                this.notInCacheProbability[i] = Math.log(1.0 - (double)cc / (double)this.count);
            }
        }
    }

    public double getProbability(String token, String priorToken, FeatureSet fs) {
        double prob;
        Double uncondProb;
        double unseenFeatureProbability = -8.0;
        boolean forcedCap = fs.get("case") == "forcedCap";
        double condProb = 0.0;
        double outcomesOfPriorToken = 0.0;
        HashMap m2 = (HashMap)this.bigramProbability.get(priorToken = priorToken.toLowerCase());
        if (m2 != null) {
            Double p = (Double)m2.get(token.toLowerCase());
            if (p != null) {
                condProb = p;
            }
            outcomesOfPriorToken = m2.size();
        }
        double lambda = 0.0;
        if (useBigrams && this.priorTokenCount.get(priorToken) != null) {
            int cY = (Integer)this.priorTokenCount.get(priorToken);
            if ((this.stateName.startsWith("m-") || this.stateName.startsWith("e-")) & condProb > 0.0) {
                lambda = 1.0 / (1.0 + outcomesOfPriorToken / (double)cY);
            }
        }
        if ((uncondProb = forcedCap || Ace.monocase ? (Double)this.LCtokenProbability.get(token.toLowerCase()) : (Double)this.tokenProbability.get(token)) != null) {
            prob = lambda * condProb + (1.0 - lambda) * uncondProb;
            prob = Math.log(prob);
        } else {
            Double fprob;
            String tokenForm = BigramHMMemitter.wordFeature(token);
            if (forcedCap && tokenForm == "initCap" || Ace.monocase) {
                tokenForm = "forcedCap";
            }
            prob = (fprob = (Double)this.featureProbability.get(tokenForm)) != null ? this.unseenTokenProbability + fprob : this.unseenTokenProbability + unseenFeatureProbability;
        }
        if (this.hmm.tagsToCache != null) {
            for (int i = 0; i < this.hmm.tagsToCache.length; ++i) {
                String tag = this.hmm.tagsToCache[i];
                boolean inCache = this.hmm.inCache(token, tag);
                if (inCache) {
                    prob += this.inCacheProbability[i];
                    continue;
                }
                prob += this.notInCacheProbability[i];
            }
        }
        return prob;
    }

    public void print() {
        for (Map.Entry entry : this.bigramCount.entrySet()) {
            String priorToken = (String)entry.getKey();
            HashMap map2 = (HashMap)entry.getValue();
            for (Map.Entry entry2 : map2.entrySet()) {
                String currentToken = (String)entry2.getKey();
                int bigramCt = (Integer)entry2.getValue();
                System.out.println("EMIT " + priorToken + " " + currentToken + " " + bigramCt);
            }
        }
    }

    public void store(PrintWriter stream) {
        for (Map.Entry entry : this.bigramCount.entrySet()) {
            String priorToken = (String)entry.getKey();
            HashMap map2 = (HashMap)entry.getValue();
            for (Map.Entry entry2 : map2.entrySet()) {
                String currentToken = (String)entry2.getKey();
                int bigramCt = (Integer)entry2.getValue();
                stream.println("EMIT " + priorToken + " " + currentToken + " " + bigramCt);
            }
        }
        for (Map.Entry entry : this.cacheCount.entrySet()) {
            String type = (String)entry.getKey();
            int count = (Integer)entry.getValue();
            stream.println("PREVTAGGED " + type + " " + count);
        }
    }

    static String wordFeature(String word) {
        int len = word.length();
        boolean allDigits = true;
        boolean allCaps = true;
        boolean initCap = true;
        boolean allLower = true;
        boolean hyphenated = true;
        for (int i = 0; i < len; ++i) {
            char c = word.charAt(i);
            if (!Character.isDigit(c)) {
                allDigits = false;
            }
            if (!Character.isUpperCase(c)) {
                allCaps = false;
            }
            if (!Character.isLowerCase(c)) {
                allLower = false;
            }
            if (!Character.isLetter(c) && c != '-') {
                hyphenated = false;
            }
            if ((i != 0 || Character.isUpperCase(c)) && (i <= 0 || Character.isLowerCase(c))) continue;
            initCap = false;
        }
        if (allDigits) {
            if (len == 2) {
                return "twoDigitNum";
            }
            if (len == 4) {
                return "fourDigitNum";
            }
            return "otherNum";
        }
        if (allCaps) {
            return "allCaps";
        }
        if (initCap) {
            return "initCap";
        }
        if (allLower) {
            return "lowerCase";
        }
        if (hyphenated) {
            return "hyphenated";
        }
        return "other";
    }

    private static void incrementHashMap(HashMap map, String key, int n) {
        Integer countI = (Integer)map.get(key);
        int count = countI == null ? 0 : countI;
        map.put(key, new Integer(count + n));
    }

    private static void incrementTwoLevelHashMap(HashMap map, String key1, String key2, int n) {
        HashMap map2 = (HashMap)map.get(key1);
        if (map2 == null) {
            map2 = new HashMap();
            map.put(key1, map2);
        }
        BigramHMMemitter.incrementHashMap(map2, key2, n);
    }
}

