/*
 * Decompiled with CFR 0.152.
 */
package edu.nyu.jet.hmm;

import edu.nyu.jet.JetTest;
import edu.nyu.jet.chunk.TokenClassifier;
import edu.nyu.jet.hmm.BasicHMMemitter;
import edu.nyu.jet.hmm.HMMarc;
import edu.nyu.jet.hmm.HMMstate;
import edu.nyu.jet.tipster.Annotation;
import edu.nyu.jet.tipster.Document;
import edu.nyu.jet.tipster.Span;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.StringTokenizer;
import java.util.TreeSet;

public class HMM
extends TokenClassifier {
    HashMap statesByName;
    ArrayList states = new ArrayList();
    ArrayList arcs;
    int startState = -1;
    int endState = -1;
    Class emitterClass;
    HashSet cache;
    String[] tagsToCache;
    double smallestDifference = 0.0;
    protected static final double UNLIKELY = -1.0E100;
    static boolean probReport = false;
    static boolean cacheTrace = false;
    private String excludedTag = null;
    int excludedTagStart = 0;
    int excludedTagEnd = 0;
    private int nTokens;
    private double[][] pathProb;
    private int[][] backPointer;
    private SortedSet deviationSet;
    HashMap allStateTokenCount;
    HashMap allStateLCtokenCount;
    public double viterbiProbability = 0.0;
    public double pathProbability = 0.0;
    private double margin;
    private boolean recordMargin = false;
    private boolean recordLocalMargin = false;
    private boolean Nbest = false;
    static final int NO_BACK_POINTER = -1;
    static final int MULTIPLE_BACK_POINTERS = -2;

    public HMM() {
        this(BasicHMMemitter.class);
    }

    public HMM(Class emitterClass) {
        this.statesByName = new HashMap();
        this.arcs = new ArrayList();
        this.emitterClass = emitterClass;
        this.tagsToCache = null;
        this.cache = new HashSet();
        this.allStateTokenCount = new HashMap();
        this.allStateLCtokenCount = new HashMap();
    }

    public void setTagsToCache(String[] tags) {
        this.tagsToCache = tags;
    }

    public void load(Reader HMMReader) throws IOException {
        String line;
        HMMstate currentState = null;
        BufferedReader reader = new BufferedReader(HMMReader);
        while ((line = reader.readLine()) != null) {
            try {
                String tag;
                String stateName;
                StringTokenizer st = new StringTokenizer(line);
                if (!st.hasMoreTokens()) continue;
                String token = st.nextToken();
                if (token.equalsIgnoreCase("state")) {
                    if (st.hasMoreTokens()) {
                        stateName = st.nextToken();
                        currentState = new HMMstate(stateName, "", this.emitterClass);
                        this.addState(currentState);
                        currentState.resetForTraining();
                        continue;
                    }
                    throw new HMMerror("state name missing");
                }
                if (token.equalsIgnoreCase("arc")) {
                    if (!st.hasMoreTokens() || !st.nextToken().equalsIgnoreCase("to")) {
                        throw new HMMerror("'to' missing");
                    }
                    if (!st.hasMoreTokens()) {
                        throw new HMMerror("state name missing");
                    }
                    stateName = st.nextToken();
                    int count = 1;
                    if (st.hasMoreTokens()) {
                        try {
                            count = Integer.parseInt(st.nextToken());
                        }
                        catch (NumberFormatException e) {
                            throw new HMMerror("invalid count for arc");
                        }
                    }
                    HMMarc arc = new HMMarc(stateName, count);
                    this.arcs.add(arc);
                    if (currentState == null) {
                        throw new HMMerror("no initial state for arc");
                    }
                    currentState.addArc(arc);
                    currentState.count += count;
                    continue;
                }
                if (token.equalsIgnoreCase("emit")) {
                    if (!st.hasMoreTokens()) {
                        throw new HMMerror("token missing");
                    }
                    String emit = st.nextToken();
                    String priorEmit = "";
                    if (currentState == null) {
                        throw new HMMerror("no state for emit");
                    }
                    if (st.countTokens() > 1) {
                        priorEmit = emit;
                        emit = st.nextToken();
                    }
                    if (st.hasMoreTokens()) {
                        try {
                            int count = Integer.parseInt(st.nextToken());
                            currentState.incrementEmitCount(emit, priorEmit, count);
                            continue;
                        }
                        catch (NumberFormatException e) {
                            throw new HMMerror("invalid count for token");
                        }
                    }
                    currentState.incrementEmitCount(emit, priorEmit, 1);
                    continue;
                }
                if (token.equalsIgnoreCase("feature")) {
                    if (!st.hasMoreTokens()) {
                        throw new HMMerror("feature name missing");
                    }
                    String type = st.nextToken();
                    if (currentState == null) {
                        throw new HMMerror("no state for allow");
                    }
                    currentState.setFeatureName(type);
                    while (st.hasMoreTokens()) {
                        currentState.addAllowedFeatureValue(st.nextToken());
                    }
                    continue;
                }
                if (token.equalsIgnoreCase("tag")) {
                    if (!st.hasMoreTokens()) {
                        throw new HMMerror("token missing");
                    }
                    tag = st.nextToken();
                    if (currentState == null) {
                        throw new HMMerror("no state for tag");
                    }
                    currentState.tag = tag;
                    continue;
                }
                if (token.equalsIgnoreCase("prevTagged")) {
                    if (!st.hasMoreTokens()) {
                        throw new HMMerror("token missing");
                    }
                    tag = st.nextToken();
                    if (st.hasMoreTokens()) {
                        try {
                            int count = Integer.parseInt(st.nextToken());
                            currentState.setCacheCount(tag, count);
                            continue;
                        }
                        catch (NumberFormatException e) {
                            throw new HMMerror("invalid count for token");
                        }
                    }
                    currentState.setCacheCount(tag, 1);
                    continue;
                }
                throw new HMMerror("unrecognized input line");
            }
            catch (HMMerror e) {
                System.out.println(">> " + line);
                System.out.println("Error:  " + e.getMessage());
            }
        }
        this.resolveNames();
        this.computeProbabilities();
    }

    public void load(String fileName) {
        try {
            this.load(new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(fileName), JetTest.encoding)));
        }
        catch (IOException e) {
            System.out.println("HMM.load:  Unable to load HMM");
            System.out.println(e);
        }
    }

    void resolveNames() {
        Iterator stateIterator = this.states.iterator();
        while (stateIterator.hasNext()) {
            ((HMMstate)stateIterator.next()).resolveNames(this.statesByName, this.states.size());
        }
    }

    public void addState(HMMstate state) {
        String stateName = state.name;
        state.setHMM(this);
        this.statesByName.put(stateName, new Integer(this.states.size()));
        if (stateName.equalsIgnoreCase("start")) {
            this.startState = this.states.size();
        }
        if (stateName.equalsIgnoreCase("end")) {
            this.endState = this.states.size();
        }
        this.states.add(state);
    }

    public HMMstate getState(String stateName) {
        Integer i = (Integer)this.statesByName.get(stateName);
        if (i == null) {
            return null;
        }
        return (HMMstate)this.states.get(i);
    }

    public void resetForTraining() {
        Iterator stateIterator = this.states.iterator();
        while (stateIterator.hasNext()) {
            ((HMMstate)stateIterator.next()).resetForTraining();
        }
    }

    public void newDocument() {
        this.cache = new HashSet();
    }

    void addToCache(String token, String type) {
        for (int i = 0; i < this.tagsToCache.length; ++i) {
            if (!type.equals(this.tagsToCache[i])) continue;
            this.cache.add(token + "|" + type);
            return;
        }
    }

    boolean inCache(String token, String type) {
        if (token.equalsIgnoreCase("the")) {
            return false;
        }
        if (token.equalsIgnoreCase("of")) {
            return false;
        }
        return this.cache.contains(token + "|" + type);
    }

    public void train0(Document doc, Annotation[] tokens, String[] tags) {
        int iState = this.startState;
        int nTokens = tokens.length;
        int nStates = this.states.size();
        String priorToken = "";
        for (int iToken = 0; iToken < nTokens; ++iToken) {
            Annotation tokenAnn = tokens[iToken];
            String token = doc.text(tokenAnn).trim();
            String tag = tags[iToken];
            HMMstate state = (HMMstate)this.states.get(iState);
            ++state.count;
            int iNext = -1;
            for (int is = 0; is < nStates; ++is) {
                if (state.arcs[is] == null) continue;
                HMMstate nextState = (HMMstate)this.states.get(is);
                if (!nextState.tag.equals(tag)) continue;
                if (iNext >= 0) {
                    System.out.println("Training error:  multiple successor states");
                    System.out.print("from state " + state.name);
                    System.out.println(" with tag " + tag);
                }
                iNext = is;
            }
            if (iNext < 0) {
                System.out.println("Training error:  no successor states");
                System.out.print("from state " + state.name);
                System.out.println(" with tag " + tag);
                return;
            }
            ++state.arcs[iNext].count;
            HMMstate nextState = (HMMstate)this.states.get(iNext);
            nextState.incrementEmitCount(token, priorToken, 1);
            if (this.tagsToCache != null) {
                this.addToCache(token, tag);
            }
            iState = iNext;
            priorToken = token;
        }
        HMMstate state = (HMMstate)this.states.get(iState);
        ++state.count;
        if (state.arcs[this.endState] == null) {
            System.out.println("Training error:  can't reach final state");
            System.out.println("from state " + state.name);
            return;
        }
        ++state.arcs[this.endState].count;
    }

    public void train(Document doc, Annotation[] tokens, String[] tags) {
        int nStates = this.states.size();
        int nTokens = tokens.length;
        int[][] backPointer = new int[nTokens + 1][nStates];
        for (int i = 0; i < nStates; ++i) {
            backPointer[0][i] = -1;
        }
        backPointer[0][this.startState] = 0;
        for (int iToken = 1; iToken <= nTokens; ++iToken) {
            Annotation token = tokens[iToken - 1];
            String tag = tags[iToken - 1];
            boolean successor = false;
            for (int iState = 0; iState < nStates; ++iState) {
                HMMstate state = (HMMstate)this.states.get(iState);
                int prior = -1;
                if (state.tag.equals(tag) && state.allowedToken(token)) {
                    for (int iPrior = 0; iPrior < nStates; ++iPrior) {
                        HMMstate priorState = (HMMstate)this.states.get(iPrior);
                        if (priorState.arcs[iState] == null || backPointer[iToken - 1][iPrior] == -1) continue;
                        successor = true;
                        prior = prior == -1 ? iPrior : -2;
                    }
                }
                backPointer[iToken][iState] = prior;
            }
            if (successor) continue;
            System.out.println("HMM.train:  training error:  no successor states");
            System.out.print("at token " + doc.text(token).trim());
            System.out.println(" with tag " + tag);
            return;
        }
        if (this.endState < 0) {
            System.out.println("No end state for HMM.");
            return;
        }
        int last = -1;
        for (int iPrior = 0; iPrior < nStates; ++iPrior) {
            HMMstate priorState = (HMMstate)this.states.get(iPrior);
            if (priorState.arcs[this.endState] == null || backPointer[nTokens][iPrior] == -1) continue;
            last = last == -1 ? iPrior : -2;
        }
        int[] path = new int[nTokens + 2];
        path[nTokens + 1] = this.endState;
        int iState = last;
        for (int iToken = nTokens; iToken >= 0; --iToken) {
            if (iState == -1) {
                System.out.println("HMM.train:  no back pointer");
                System.out.println("Error occurred at token " + iToken + " = " + doc.text(tokens[iToken - 1]).trim());
                return;
            }
            if (iState == -2) {
                System.out.println("HMM.train:  multiple back pointers");
                return;
            }
            path[iToken] = iState;
            iState = backPointer[iToken][iState];
        }
        String priorToken = "";
        for (int iToken = 0; iToken <= nTokens; ++iToken) {
            iState = path[iToken];
            int iNext = path[iToken + 1];
            HMMstate state = (HMMstate)this.states.get(iState);
            ++state.count;
            ++state.arcs[iNext].count;
            if (iToken <= 0) continue;
            String token = doc.text(tokens[iToken - 1]).trim();
            state.incrementEmitCount(token, priorToken, 1);
            if (this.tagsToCache != null) {
                String tag = tags[iToken - 1];
                this.addToCache(token, tag);
            }
            priorToken = token;
        }
    }

    public void computeProbabilities() {
        Iterator stateIterator = this.states.iterator();
        while (stateIterator.hasNext()) {
            ((HMMstate)stateIterator.next()).computeProbabilities();
        }
    }

    public void createModel() {
        this.computeProbabilities();
    }

    public void print() {
        Iterator stateIterator = this.states.iterator();
        while (stateIterator.hasNext()) {
            ((HMMstate)stateIterator.next()).print();
        }
    }

    public void store(PrintWriter stream) {
        Iterator stateIterator = this.states.iterator();
        while (stateIterator.hasNext()) {
            ((HMMstate)stateIterator.next()).store(stream);
        }
        stream.close();
    }

    public void store(String fileName) {
        try {
            this.store(new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(fileName), JetTest.encoding))));
        }
        catch (IOException e) {
            System.out.println("HMM.store:  unable to store HMM.");
            System.out.println(e);
        }
    }

    public int[] viterbiPath(Document doc, Annotation[] tokens) {
        this.viterbiProbability = 0.0;
        int nStates = this.states.size();
        this.nTokens = tokens.length;
        this.pathProb = new double[this.nTokens + 1][nStates];
        this.backPointer = new int[this.nTokens + 2][nStates];
        double[][] secondBest = null;
        if (this.recordMargin | this.recordLocalMargin) {
            secondBest = new double[this.nTokens + 1][nStates];
        }
        if (this.startState < 0) {
            System.out.println("No start state for HMM.");
            return null;
        }
        for (int i = 0; i < nStates; ++i) {
            this.pathProb[0][i] = i == this.startState ? 0.0 : -1.0E100;
        }
        String priorToken = "";
        for (int iToken = 1; iToken <= this.nTokens; ++iToken) {
            Annotation token = tokens[iToken - 1];
            String tokenText = doc.text(token).trim();
            for (int iState = 0; iState < nStates; ++iState) {
                HMMstate state = (HMMstate)this.states.get(iState);
                double emitProb = state.getEmissionProb(tokenText, priorToken, token);
                double bestProb = -1.0E100;
                double secondBestProb = -1.0E100;
                int bestPrior = -1;
                for (int iPrior = 0; iPrior < nStates; ++iPrior) {
                    double prob2;
                    HMMstate priorState = (HMMstate)this.states.get(iPrior);
                    double prob = this.pathProb[iToken - 1][iPrior] + priorState.getTransitionProb(iState) + emitProb;
                    if (prob > bestProb) {
                        if (!this.recordLocalMargin) {
                            secondBestProb = bestProb;
                        }
                        bestProb = prob;
                        bestPrior = iPrior;
                    }
                    if (!this.recordLocalMargin) continue;
                    if (this.violatesConstraint(iToken - 1, state)) {
                        if (!(prob > secondBestProb)) continue;
                        secondBestProb = prob;
                        continue;
                    }
                    if (iToken <= 1 || !((prob2 = secondBest[iToken - 1][iPrior] + priorState.getTransitionProb(iState) + emitProb) > secondBestProb)) continue;
                    secondBestProb = prob2;
                }
                this.pathProb[iToken][iState] = bestProb;
                this.backPointer[iToken][iState] = bestPrior;
                if (!(this.recordMargin | this.recordLocalMargin)) continue;
                secondBest[iToken][iState] = secondBestProb;
            }
            priorToken = tokenText;
        }
        if (this.endState < 0) {
            System.out.println("No end state for HMM.");
            return null;
        }
        double bestProb = -1.0E100;
        double secondBestProb = -1.0E100;
        int bestPrior = -1;
        for (int iPrior = 0; iPrior < nStates; ++iPrior) {
            double prob2;
            HMMstate priorState = (HMMstate)this.states.get(iPrior);
            double prob = this.pathProb[this.nTokens][iPrior] + priorState.getTransitionProb(this.endState);
            if (prob > bestProb) {
                bestProb = prob;
                bestPrior = iPrior;
            }
            if (!this.recordLocalMargin || !((prob2 = secondBest[this.nTokens][iPrior] + priorState.getTransitionProb(this.endState)) > secondBestProb)) continue;
            secondBestProb = prob2;
        }
        this.backPointer[this.nTokens + 1][this.endState] = bestPrior;
        int[] path = new int[this.nTokens + 2];
        path[this.nTokens + 1] = this.endState;
        int iState = bestPrior;
        this.margin = 2.0E100;
        for (int iToken = this.nTokens - 1; iToken >= 0; --iToken) {
            if (iState < 0) {
                return null;
            }
            path[iToken + 1] = iState;
            HMMstate state = (HMMstate)this.states.get(iState);
            String tag = state.tag;
            if (this.tagsToCache != null) {
                String token = doc.text(tokens[iToken]).trim();
                if (cacheTrace) {
                    System.out.println("Adding " + token + " to cache with tag " + tag);
                }
                this.addToCache(token, tag);
            }
            path[0] = this.startState;
            if (this.recordMargin && this.pathProb[iToken + 1][iState] - secondBest[iToken + 1][iState] < this.margin) {
                this.margin = this.pathProb[iToken + 1][iState] - secondBest[iToken + 1][iState];
            }
            iState = this.backPointer[iToken + 1][iState];
        }
        this.viterbiProbability = bestProb;
        if (this.recordLocalMargin) {
            this.margin = bestProb - secondBestProb;
        }
        this.pathProbability = this.viterbiProbability;
        if (this.Nbest) {
            this.deviationSet = new TreeSet();
            this.addDeviations(path, this.viterbiProbability, this.nTokens + 1);
        }
        return path;
    }

    public String[] viterbi(Document doc, Annotation[] tokens) {
        int[] path = this.viterbiPath(doc, tokens);
        if (path == null) {
            return null;
        }
        int len = tokens.length;
        String[] pathTags = new String[len];
        for (int i = 0; i < len; ++i) {
            HMMstate state = (HMMstate)this.states.get(path[i + 1]);
            pathTags[i] = state.tag;
        }
        return pathTags;
    }

    public double getPathProbability() {
        return this.pathProbability;
    }

    public void recordMargin() {
        this.recordMargin = true;
    }

    public double getMargin() {
        return this.margin;
    }

    public double getLocalMargin(Document doc, Annotation[] tokens, String excludedTag, int excludedTagStart, int excludedTagEnd) {
        this.excludedTag = excludedTag;
        this.excludedTagStart = excludedTagStart;
        this.excludedTagEnd = excludedTagEnd;
        this.recordLocalMargin = true;
        this.viterbi(doc, tokens);
        this.recordLocalMargin = false;
        return this.margin;
    }

    private boolean violatesConstraint(int iToken, HMMstate state) {
        return iToken == this.excludedTagStart - 1 && state.tag.equals(this.excludedTag) || iToken >= this.excludedTagStart && iToken <= this.excludedTagEnd && !state.tag.equals(this.excludedTag) || iToken == this.excludedTagEnd + 1 && state.tag.equals(this.excludedTag);
    }

    private void addDeviations(int[] currentPath, double currentCost, int lastToken) {
        for (int i = 2; i <= lastToken; ++i) {
            this.addDeviationsAtToken(currentPath, currentCost, i);
        }
    }

    private void addDeviationsAtToken(int[] currentPath, double currentCost, int token) {
        int state = currentPath[token];
        int bestPrior = this.backPointer[token][state];
        HMMstate bestPriorState = (HMMstate)this.states.get(bestPrior);
        for (int prior = 0; prior < this.states.size(); ++prior) {
            HMMstate priorState;
            if (prior == bestPrior || prior == this.startState || prior == this.endState || (priorState = (HMMstate)this.states.get(prior)).getTransitionProb(state) == -1.0E100) continue;
            double deviantCost = currentCost - this.pathProb[token - 1][bestPrior] - bestPriorState.getTransitionProb(state) + priorState.getTransitionProb(state) + this.pathProb[token - 1][prior];
            Deviation d = new Deviation(currentPath, token, prior, deviantCost);
            this.deviationSet.add(d);
        }
    }

    public void setNbest() {
        this.Nbest = true;
    }

    public int[] nextBestPath() {
        if (this.deviationSet == null || this.deviationSet.isEmpty()) {
            return null;
        }
        Deviation d = (Deviation)this.deviationSet.last();
        this.deviationSet.remove(d);
        int[] basePath = d.basePath;
        int token = d.token;
        int[] newPath = new int[this.nTokens + 2];
        for (int i = token; i < this.nTokens + 2; ++i) {
            newPath[i] = basePath[i];
        }
        int newPrior = d.prior;
        for (int i = token - 1; i >= 0; --i) {
            newPath[i] = newPrior;
            if ((newPrior = this.backPointer[i][newPrior]) >= 0) continue;
            return null;
        }
        this.addDeviations(newPath, d.cost, token - 1);
        this.pathProbability = d.cost;
        return newPath;
    }

    public String[] nextBest() {
        int[] path = this.nextBestPath();
        if (path == null) {
            return null;
        }
        String[] pathTags = new String[this.nTokens];
        for (int i = 0; i < this.nTokens; ++i) {
            HMMstate state = (HMMstate)this.states.get(path[i + 1]);
            pathTags[i] = state.tag;
        }
        return pathTags;
    }

    public static void main(String[] args) {
        HMM testHMM = HMM.makeTestHMM();
        Document d = new Document("big big cat nap");
        Annotation[] tokens = new Annotation[]{new Annotation("token", new Span(0, 4), null), new Annotation("token", new Span(4, 8), null), new Annotation("token", new Span(8, 12), null), new Annotation("token", new Span(12, 15), null)};
        d.addAnnotation(tokens[0]);
        d.addAnnotation(tokens[1]);
        d.addAnnotation(tokens[2]);
        d.addAnnotation(tokens[3]);
        testHMM.setNbest();
        int[] path = testHMM.viterbiPath(d, tokens);
        double prob = testHMM.getPathProbability();
        System.out.println("Best path:   " + HMM.pathString(path) + " with probability " + prob);
        int[] path2 = testHMM.nextBestPath();
        prob = testHMM.getPathProbability();
        System.out.println("Second path: " + HMM.pathString(path2) + " with probability " + prob);
        int[] path3 = testHMM.nextBestPath();
        prob = testHMM.getPathProbability();
        System.out.println("Third path:  " + HMM.pathString(path3) + " with probability " + prob);
        int[] path4 = testHMM.nextBestPath();
        prob = testHMM.getPathProbability();
        System.out.println("Fourth path: " + HMM.pathString(path4) + " with probability " + prob);
        int[] path5 = testHMM.nextBestPath();
        prob = testHMM.getPathProbability();
        System.out.println("Fifth path:  " + HMM.pathString(path5) + " with probability " + prob);
    }

    private static HMM makeTestHMM() {
        HMM testHMM = new HMM(BasicHMMemitter.class);
        HMMstate startState = new HMMstate("start", "", BasicHMMemitter.class);
        HMMstate adjState = new HMMstate("adj", "JJ", BasicHMMemitter.class);
        HMMstate nounState = new HMMstate("noun", "NN", BasicHMMemitter.class);
        HMMstate endState = new HMMstate("end", "", BasicHMMemitter.class);
        testHMM.addState(startState);
        testHMM.addState(adjState);
        testHMM.addState(nounState);
        testHMM.addState(endState);
        testHMM.resetForTraining();
        startState.addArc(new HMMarc("adj", 3));
        startState.addArc(new HMMarc("noun", 1));
        adjState.addArc(new HMMarc("noun", 3));
        adjState.addArc(new HMMarc("adj", 1));
        nounState.addArc(new HMMarc("noun", 1));
        nounState.addArc(new HMMarc("end", 4));
        adjState.incrementEmitCount("safe", "", 1);
        adjState.incrementEmitCount("big", "", 3);
        nounState.incrementEmitCount("cat", "", 2);
        nounState.incrementEmitCount("nap", "", 1);
        nounState.incrementEmitCount("safe", "", 1);
        nounState.incrementEmitCount("cracker", "", 1);
        startState.count = 4;
        adjState.count = 4;
        nounState.count = 5;
        testHMM.resolveNames();
        testHMM.computeProbabilities();
        return testHMM;
    }

    static String pathString(int[] path) {
        if (path == null) {
            return " null ";
        }
        String s = " [";
        for (int i = 0; i < path.length; ++i) {
            s = s + " " + path[i];
        }
        s = s + " ] ";
        return s;
    }

    class HMMerror
    extends Exception {
        HMMerror(String s) {
            super(s);
        }
    }

    private class Deviation
    implements Comparable {
        int[] basePath;
        int token;
        int prior;
        double cost;

        public Deviation(int[] basePath, int token, int prior, double cost) {
            this.basePath = basePath;
            this.token = token;
            this.prior = prior;
            this.cost = cost;
        }

        public int compareTo(Object o) {
            if (o instanceof Deviation) {
                Deviation d2 = (Deviation)o;
                double cost2 = d2.cost;
                if (this.cost < cost2) {
                    return -1;
                }
                if (this.cost > cost2) {
                    return 1;
                }
                return 0;
            }
            throw new ClassCastException();
        }

        public String toString() {
            return "Change prior of token " + this.token + " to " + this.prior + " in" + HMM.pathString(this.basePath);
        }
    }
}

