/*
 * Decompiled with CFR 0.152.
 */
package edu.nyu.jet.hmm;

import edu.nyu.jet.hmm.HMM;
import edu.nyu.jet.hmm.HMMannotator;
import edu.nyu.jet.hmm.HMMarc;
import edu.nyu.jet.hmm.HMMstate;
import edu.nyu.jet.hmm.Retagger;
import edu.nyu.jet.hmm.WordFeatureHMMemitter;
import edu.nyu.jet.lisp.FeatureSet;
import edu.nyu.jet.scorer.SGMLScorer;
import edu.nyu.jet.tipster.Annotation;
import edu.nyu.jet.tipster.Document;
import edu.nyu.jet.tipster.DocumentCollection;
import edu.nyu.jet.tipster.ExternalDocument;
import edu.nyu.jet.tipster.Span;
import java.io.BufferedReader;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Vector;

public class HMMTagger {
    public static boolean trace = false;
    static SGMLScorer scorer = null;
    static String[] posTable = new String[]{"CC", "CD", "DT", "EX", "FW", "IN", "JJ", "JJR", "JJS", "LS", "MD", "NN", "NNS", "NNP", "NNPS", "PDT", "POS", "PRP", "PRP$", "RB", "RBR", "RBS", "RP", "SYM", "TO", "UH", "VB", "VBD", "VBG", "VBN", "VBP", "VBZ", "WDT", "WP", "WP$", "WRB", "#", "$", ".", ",", ":", "(", ")", "`", "``", "'", "''", "-LRB-", "-RRB-"};
    HMM posh = new HMM(WordFeatureHMMemitter.class);
    HMMannotator annotator = null;
    String[][] tagTable = new String[posTable.length][];

    void train(String trainingCollection) {
        for (int i = 0; i < posTable.length; ++i) {
            this.tagTable[i] = new String[]{"constit", "cat", posTable[i], posTable[i]};
        }
        HMMstate startState = new HMMstate("start", "", WordFeatureHMMemitter.class);
        this.posh.addState(startState);
        for (int j = 0; j < posTable.length; ++j) {
            startState.addArc(new HMMarc(posTable[j], 0));
        }
        HMMstate endState = new HMMstate("end", "", WordFeatureHMMemitter.class);
        this.posh.addState(endState);
        for (int i = 0; i < posTable.length; ++i) {
            String pos = posTable[i];
            HMMstate state = new HMMstate(pos, pos, WordFeatureHMMemitter.class);
            this.posh.addState(state);
            for (int j = 0; j < posTable.length; ++j) {
                state.addArc(new HMMarc(posTable[j], 0));
            }
            state.addArc(new HMMarc("end", 0));
        }
        this.posh.resolveNames();
        this.posh.resetForTraining();
        this.annotator = new HMMannotator(this.posh);
        this.annotator.setTagTable(this.tagTable);
        this.annotator.setBItag(false);
        DocumentCollection col = new DocumentCollection(trainingCollection);
        col.open();
        for (int i = 0; i < col.size(); ++i) {
            Vector<Annotation> anns;
            int posn;
            ExternalDocument doc = col.get(i);
            doc.open();
            System.out.println("Training from " + doc.fileName());
            int start = posn = 0;
            while ((anns = doc.annotationsAt(posn, "constit")) != null) {
                Annotation ann = anns.get(0);
                posn = ann.span().end();
                String pos = (String)ann.get("cat");
                if (!pos.equals(".")) continue;
                doc.annotate("S", new Span(start, posn), new FeatureSet());
                start = posn;
            }
            this.annotator.train(doc);
            doc.clearAnnotations();
        }
        this.posh.computeProbabilities();
    }

    public void store(String fileName) throws IOException {
        this.posh.store(new PrintWriter(new FileOutputStream(fileName)));
    }

    public void load(String fileName) throws IOException {
        this.posh.load(new BufferedReader(new FileReader(fileName)));
    }

    public void tagPenn(Document doc, Span span) {
        this.annotate(doc, span, "constit");
    }

    public void annotate(Document doc, Span span, String type) {
        for (int i = 0; i < posTable.length; ++i) {
            this.tagTable[i] = new String[]{type, "cat", posTable[i], posTable[i]};
        }
        this.annotator = new HMMannotator(this.posh);
        this.annotator.setTagTable(this.tagTable);
        this.annotator.setBItag(false);
        this.annotator.setTrace(trace);
        this.annotator.annotateSpan(doc, span);
    }

    public void score(Document doc, Document key) {
        scorer = new SGMLScorer(doc, key);
        scorer.match("constit");
        System.out.println("Constit tags in response:  " + HMMTagger.scorer.numOfTagsInDoc1);
        System.out.println("Constit tags in key:       " + HMMTagger.scorer.numOfTagsInDoc2);
        System.out.println("Matching constit tags:  " + HMMTagger.scorer.numOfMatchingTags);
        System.out.println("Matching POS     tags:  " + HMMTagger.scorer.numOfMatchingAttrs);
        System.out.println("Accuracy:  " + (float)HMMTagger.scorer.numOfMatchingAttrs / (float)HMMTagger.scorer.numOfMatchingTags);
    }

    public void tagJet(Document doc, Span span) {
        this.annotate(doc, span, "tagger");
        Retagger.mapConstit(doc, span);
    }

    public void prune(Document doc, Span span) {
        this.annotate(doc, span, "tagger");
        Retagger.pruneConstit(doc, span);
    }
}

