/*
 * Decompiled with CFR 0.152.
 */
package edu.nyu.jet.hmm;

import edu.nyu.jet.hmm.HMM;
import java.io.PrintWriter;
import java.util.HashMap;

public class HMMarc {
    String targetStateName;
    int target;
    int count;
    double probability;

    HMMarc(String targetStateName, int count) {
        this.targetStateName = targetStateName;
        this.count = count;
    }

    void resolveTarget(HashMap statesByName) {
        if (statesByName.containsKey(this.targetStateName)) {
            this.target = (Integer)statesByName.get(this.targetStateName);
        } else {
            System.out.println("Undefined state " + this.targetStateName + " in HMM");
        }
    }

    void resetForTraining() {
        this.count = 0;
    }

    void computeProbabilities(int stateCount) {
        this.probability = stateCount > 0 ? Math.log(((double)this.count + 0.01) / (double)stateCount) : -1.0E100;
        if (HMM.probReport) {
            System.out.println("Arc to " + this.targetStateName + " " + this.probability);
        }
    }

    void print() {
        System.out.println("ARC TO " + this.targetStateName + " " + this.probability);
    }

    void store(PrintWriter stream) {
        stream.println("ARC TO " + this.targetStateName + " " + this.count);
    }
}

