/*
 * Decompiled with CFR 0.152.
 */
package edu.nyu.jet.hmm;

import edu.nyu.jet.Console;
import edu.nyu.jet.hmm.HMMTagger;
import edu.nyu.jet.lisp.FeatureSet;
import edu.nyu.jet.tipster.Annotation;
import edu.nyu.jet.tipster.Document;
import edu.nyu.jet.tipster.Span;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Vector;

public class Retagger {
    private static HashMap map = new HashMap();

    public static FeatureSet[] ptbToJetFS(String word, String pennPOS) {
        String w = word.toLowerCase().intern();
        if (w == "do" || w == "does" || w == "did" || w == "done") {
            return new FeatureSet[]{new FeatureSet("cat", "w")};
        }
        if (pennPOS == "IN") {
            return new FeatureSet[]{new FeatureSet("cat", "p"), new FeatureSet("cat", "sconj")};
        }
        if (pennPOS == "AUX") {
            if (w == "be") {
                return new FeatureSet[]{new FeatureSet("cat", "v")};
            }
            if (w == "been") {
                return new FeatureSet[]{new FeatureSet("cat", "ven")};
            }
            if (w == "have") {
                return new FeatureSet[]{new FeatureSet("cat", "tv"), new FeatureSet("cat", "v")};
            }
            if (w == "had") {
                return new FeatureSet[]{new FeatureSet("cat", "tv"), new FeatureSet("cat", "ven")};
            }
            return new FeatureSet[]{new FeatureSet("cat", "tv")};
        }
        if (pennPOS == "AUXG") {
            return new FeatureSet[]{new FeatureSet("cat", "ving")};
        }
        FeatureSet newFS = (FeatureSet)map.get(pennPOS);
        if (newFS != null) {
            return new FeatureSet[]{newFS};
        }
        return new FeatureSet[0];
    }

    public static String jetToPtbPos(FeatureSet fs) {
        for (String pennPOS : map.keySet()) {
            FeatureSet jetFS = (FeatureSet)map.get(pennPOS);
            if (!jetFS.subsetOf(fs)) continue;
            return pennPOS;
        }
        return null;
    }

    static void mapConstit(Document d, Span span) {
        Vector<Annotation> v = d.annotationsOfType("tagger", span);
        if (v == null) {
            return;
        }
        for (int i = 0; i < v.size(); ++i) {
            Annotation a = v.get(i);
            String textSpanned = d.text(a).trim();
            String cat = (String)a.get("cat");
            FeatureSet[] w = Retagger.ptbToJetFS(textSpanned, cat);
            for (int j = 0; j < w.length; ++j) {
                d.annotate("constit", a.span(), new FeatureSet(w[j]));
                if (!HMMTagger.trace) continue;
                Console.println("Annotating " + d.text(a.span()) + " as <constit" + w[j].toSGMLString() + ">");
            }
        }
    }

    public static void pruneConstit(Document d, Span zone) {
        Vector<Annotation> pennAnns;
        ArrayList<Annotation> bestJetAnns = new ArrayList<Annotation>();
        int posn = zone.start();
        int end = zone.end();
        while (d.annotationsAt(posn, "tagger") == null) {
            if (++posn < end) continue;
            return;
        }
        while (posn < end && (pennAnns = d.annotationsAt(posn, "tagger")) != null) {
            Annotation pa = pennAnns.get(0);
            boolean possessiveTag = pa.get("cat").equals("POS");
            Span span = pa.span();
            String token = d.text(span).trim();
            String cat = (String)pa.get("cat");
            FeatureSet[] FSpenn = Retagger.ptbToJetFS(token, cat);
            Vector<Annotation> jetAnns = d.annotationsAt(posn, "constit");
            if (jetAnns == null) {
                for (int i = 0; i < FSpenn.length; ++i) {
                    FeatureSet jetFS = new FeatureSet(FSpenn[i]);
                    String jetCat = (String)jetFS.get("cat");
                    if (jetCat == "n") {
                        jetFS.put("pa", new FeatureSet("head", token));
                    }
                    d.annotate("constit", span, jetFS);
                }
            } else {
                int i;
                Annotation firstJetAnn = jetAnns.get(0);
                if (firstJetAnn.end() > span.end()) {
                    posn = firstJetAnn.end();
                    continue;
                }
                bestJetAnns.clear();
                for (i = 0; i < jetAnns.size(); ++i) {
                    Annotation jetAnn = jetAnns.get(i);
                    FeatureSet fsJet = jetAnn.attributes();
                    for (int j = 0; j < FSpenn.length; ++j) {
                        if (FeatureSet.unify(FSpenn[j], fsJet) == null) continue;
                        bestJetAnns.add(jetAnn);
                    }
                }
                if (!bestJetAnns.isEmpty() || possessiveTag) {
                    for (i = 0; i < jetAnns.size(); ++i) {
                        Annotation a = jetAnns.get(i);
                        if (bestJetAnns.contains(a)) continue;
                        d.removeAnnotation(a);
                        if (!HMMTagger.trace) continue;
                        Console.println("Removing " + a + " on " + d.text(a.span()));
                    }
                }
            }
            posn = span.end();
        }
    }

    public static boolean compatible(String word, String pennPOS, Annotation jetDefn) {
        FeatureSet[] FSpenn = Retagger.ptbToJetFS(word.toLowerCase(), pennPOS);
        FeatureSet fsJet = jetDefn.attributes();
        for (int j = 0; j < FSpenn.length; ++j) {
            if (FeatureSet.unify(FSpenn[j], fsJet) == null) continue;
            return true;
        }
        return false;
    }

    static {
        map.put("CC", new FeatureSet("cat", "cconj"));
        map.put("CD", new FeatureSet("cat", "q"));
        map.put("DT", new FeatureSet("cat", "det"));
        map.put("JJ", new FeatureSet("cat", "adj"));
        map.put("JJR", new FeatureSet("cat", "adj"));
        map.put("JJS", new FeatureSet("cat", "adj"));
        map.put("MD", new FeatureSet("cat", "w"));
        map.put("NN", new FeatureSet("cat", "n", "number", "singular"));
        map.put("NNS", new FeatureSet("cat", "n", "number", "plural"));
        map.put("PDT", new FeatureSet("cat", "adv"));
        map.put("PRP", new FeatureSet("cat", "pro"));
        map.put("PRP$", new FeatureSet("cat", "det"));
        map.put("RB", new FeatureSet("cat", "adv"));
        map.put("RBR", new FeatureSet("cat", "adv"));
        map.put("RBS", new FeatureSet("cat", "adv"));
        map.put("RP", new FeatureSet("cat", "dp"));
        map.put("TO", new FeatureSet("cat", "p"));
        map.put("VB", new FeatureSet("cat", "v"));
        map.put("VBD", new FeatureSet("cat", "tv"));
        map.put("VBG", new FeatureSet("cat", "ving"));
        map.put("VBN", new FeatureSet("cat", "ven"));
        map.put("VBP", new FeatureSet("cat", "tv", "number", "plural"));
        map.put("VBZ", new FeatureSet("cat", "tv", "number", "singular"));
    }
}

