/*
 * Decompiled with CFR 0.152.
 */
package edu.nyu.jet.hmm;

import edu.nyu.jet.Console;
import edu.nyu.jet.Control;
import edu.nyu.jet.JetTest;
import edu.nyu.jet.MaxEntModel;
import edu.nyu.jet.aceJet.Ace;
import edu.nyu.jet.aceJet.AceDocument;
import edu.nyu.jet.aceJet.Datum;
import edu.nyu.jet.aceJet.EDTtype;
import edu.nyu.jet.aceJet.Gazetteer;
import edu.nyu.jet.aceJet.LearnRelations;
import edu.nyu.jet.hmm.BigramHMMemitter;
import edu.nyu.jet.hmm.HMM;
import edu.nyu.jet.hmm.HMMannotator;
import edu.nyu.jet.hmm.HMMemitter;
import edu.nyu.jet.hmm.WordFeatureHMMemitter;
import edu.nyu.jet.lex.Tokenizer;
import edu.nyu.jet.pat.Pat;
import edu.nyu.jet.refres.Resolve;
import edu.nyu.jet.scorer.SGMLScorer;
import edu.nyu.jet.tipster.Annotation;
import edu.nyu.jet.tipster.Document;
import edu.nyu.jet.tipster.DocumentCollection;
import edu.nyu.jet.tipster.ExternalDocument;
import edu.nyu.jet.tipster.Span;
import edu.nyu.jet.tipster.View;
import edu.nyu.jet.zoner.SentenceSplitter;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XNameTagger {
    public HMM nameHMM;
    public HMMannotator annotator;
    String[][] tagTable;
    String[] NEtypeTable;
    String[] tagsToRead;
    String[] tagsToCache;
    String[] tagsToScore;
    Class emitterClass;
    int N = 20;
    MaxEntModel model = new MaxEntModel("rerankTemp/features.log", "rerankTemp/model.log");
    static final String home = "C:/Documents and Settings/Ralph Grishman/My Documents/";
    static final boolean useAceBigrams = false;
    static final String oldACEdir = "C:/Documents and Settings/Ralph Grishman/My Documents/ACE/";
    static final String ACEdir = "C:/Documents and Settings/Ralph Grishman/My Documents/ACE 05/V4/";
    static final String dictFile = "C:/Documents and Settings/Ralph Grishman/My Documents/ACE 05/V4/EDT type dict.txt";
    static final String genericFile = "C:/Documents and Settings/Ralph Grishman/My Documents/ACE 05/V4/generic dict.txt";
    static final String patternFile = "C:/Documents and Settings/Ralph Grishman/My Documents/ACE/relations/patterns04.log";
    HashMap<String, Double> Fscore;
    HashMap<String, Integer> corefMentionCount;
    HashMap<String, Integer> relationCount;
    HashMap<String, Integer> NEprob;
    HashMap<String, StringBuffer> NEstring;
    HashMap<String, String> relString;
    int MARGIN_TO_SKIP_RESCORING = 3;
    static int NE_PROBABILITY_WINDOW = 6;

    public XNameTagger(Class emitterClass) {
        if (!HMMemitter.class.isAssignableFrom(emitterClass)) {
            System.out.println("XNameTagger constructor invoked with invalid class " + emitterClass);
            return;
        }
        this.emitterClass = emitterClass;
        this.nameHMM = new HMM(emitterClass);
        this.annotator = new HMMannotator(this.nameHMM);
        this.annotator.setBItag(false);
        this.annotator.setAnnotateEachToken(false);
        this.nameHMM.setNbest();
    }

    private void readTagTable(String tagFileName) {
        try {
            BufferedReader in = new BufferedReader(new FileReader(tagFileName));
            this.readTagTable(in);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void readTagTable(BufferedReader in) {
        this.annotator.readTagTable(in);
        HashSet<String> annotationTypes = new HashSet<String>();
        ArrayList<String> hmmTagList = new ArrayList<String>();
        String[][] tagTable = this.annotator.getTagTable();
        for (int i = 0; i < tagTable.length; ++i) {
            annotationTypes.add(tagTable[i][0]);
            hmmTagList.add(tagTable[i][3]);
        }
        this.NEtypeTable = hmmTagList.toArray(new String[0]);
        this.tagsToCache = this.NEtypeTable;
        this.tagsToScore = annotationTypes.toArray(new String[0]);
        annotationTypes.add("SENT");
        annotationTypes.add("TURN");
        this.tagsToRead = annotationTypes.toArray(new String[0]);
    }

    public void load(String fileName) throws IOException {
        BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(fileName), JetTest.encoding));
        this.readTagTable(in);
        this.nameHMM.load(in);
    }

    private void tagDocument(Document doc) {
        doc.annotateWithTag("TEXT");
        Vector<Annotation> textSegments = doc.annotationsOfType("TEXT");
        for (Annotation ann : textSegments) {
            Span textSpan = ann.span();
            Ace.monocase = Ace.allLowerCase(doc);
            SentenceSplitter.split(doc, textSpan);
        }
        Vector<Annotation> sentences = doc.annotationsOfType("sentence");
        int isent = 0;
        for (Annotation sentence : sentences) {
            Span sentenceSpan = sentence.span();
            Tokenizer.tokenize(doc, sentenceSpan);
            this.tag(doc, sentenceSpan, "H" + isent);
            ++isent;
        }
    }

    public ArrayList tag(Document doc, Span span, String sentno) {
        return this.annotator.annotateSpanNbest(doc, span, this.N, sentno);
    }

    public void scoreCollection(String testCollection, String keyCollection) {
        DocumentCollection testCol = new DocumentCollection(testCollection);
        testCol.open();
        DocumentCollection keyCol = new DocumentCollection(keyCollection);
        keyCol.open();
        if (testCol.size() != keyCol.size()) {
            System.out.println(" ** Test and key collections have different sizes, cannot evaluate.");
            return;
        }
        int tagsInResponses = 0;
        int tagsInKeys = 0;
        int matchingTags = 0;
        int matchingAttrs = 0;
        for (int i = 0; i < testCol.size(); ++i) {
            ExternalDocument testDoc = testCol.get(i);
            testDoc.setAllTags(true);
            testDoc.open();
            this.nameHMM.newDocument();
            System.out.println("Annotating document " + i + ": " + testDoc.fileName());
            Set<String> bestHypotheses = this.NbestTagDocument(testDoc);
            testDoc.setActiveHypotheses(bestHypotheses);
            ExternalDocument keyDoc = keyCol.get(i);
            keyDoc.setAllTags(true);
            keyDoc.open();
            keyDoc.stretch("ENAMEX");
            Vector<Annotation> textSpans = keyDoc.annotationsOfType("TEXT");
            if (textSpans == null) {
                System.out.println("No <TEXT> in " + testDoc.fileName() + ", cannot be scored.");
                continue;
            }
            SGMLScorer scorer = new SGMLScorer(testDoc, keyDoc);
            for (int itag = 0; itag < this.tagsToScore.length; ++itag) {
                scorer.match(this.tagsToScore[itag]);
                Console.println(scorer.report());
            }
            System.out.println("Tags in response:        " + scorer.totalTagsInDoc1);
            System.out.println("Tags in key:             " + scorer.totalTagsInDoc2);
            System.out.println("Matching tags:           " + scorer.totalMatchingTags);
            System.out.println("Matching attributes:     " + scorer.totalMatchingAttrs);
            System.out.println("Type recall:             " + (float)scorer.totalMatchingTags / (float)scorer.totalTagsInDoc2);
            System.out.println("Type precision:          " + (float)scorer.totalMatchingTags / (float)scorer.totalTagsInDoc1);
            System.out.println("Attribute recall:        " + (float)scorer.totalMatchingAttrs / (float)scorer.totalTagsInDoc2);
            System.out.println("Attribute precision:     " + (float)scorer.totalMatchingAttrs / (float)scorer.totalTagsInDoc1);
            tagsInResponses += scorer.totalTagsInDoc1;
            tagsInKeys += scorer.totalTagsInDoc2;
            matchingTags += scorer.totalMatchingTags;
            matchingAttrs += scorer.totalMatchingAttrs;
        }
        System.out.println("\nTotal counts:");
        System.out.println("      matchingTags =    " + matchingTags);
        System.out.println("      matchingAttrs =   " + matchingAttrs);
        System.out.println("      tagsInKeys =      " + tagsInKeys);
        System.out.println("      tagsInResponses = " + tagsInResponses);
        System.out.println("Overall Type Recall:          " + (float)matchingTags / (float)tagsInKeys);
        System.out.println("Overall Type Precision:       " + (float)matchingTags / (float)tagsInResponses);
        System.out.println("Overall Attribute Recall:     " + (float)matchingAttrs / (float)tagsInKeys);
        System.out.println("Overall Attribute Precision:  " + (float)matchingAttrs / (float)tagsInResponses);
    }

    public void scoreCollectionWithOracle(String testCollection, String keyCollection) {
        DocumentCollection testCol = new DocumentCollection(testCollection);
        testCol.open();
        DocumentCollection keyCol = new DocumentCollection(keyCollection);
        keyCol.open();
        if (testCol.size() != keyCol.size()) {
            System.out.println(" ** Test and key collections have different sizes, cannot evaluate.");
            return;
        }
        int tagsInResponses = 0;
        int tagsInBestResponses = 0;
        int tagsInKeys = 0;
        boolean matchingTags = false;
        int matchingAttrs = 0;
        int matchingAttrsNbest = 0;
        for (int i = 0; i < testCol.size(); ++i) {
            ExternalDocument testDoc = testCol.get(i);
            testDoc.setAllTags(true);
            testDoc.open();
            testDoc.stretchAll();
            this.nameHMM.newDocument();
            System.out.println("Annotating document " + i + ": " + testDoc.fileName());
            this.tagDocument(testDoc);
            if (i < 3) {
                new View(testDoc, i);
            }
            ExternalDocument keyDoc = keyCol.get(i);
            keyDoc.setAllTags(true);
            keyDoc.open();
            keyDoc.stretch("ENAMEX");
            Vector<Annotation> textSpans = keyDoc.annotationsOfType("TEXT");
            if (textSpans == null) {
                System.out.println("No <TEXT> in " + testDoc.fileName() + ", cannot be scored.");
                continue;
            }
            if (i < 3) {
                new View(keyDoc, i + 100);
            }
            HashSet<String> hypoSet = new HashSet<String>();
            int totalTagsInDoc1 = 0;
            int totalTagsInDoc2 = 0;
            int totalMatchingAttrs = 0;
            int totalTagsInDoc1Nbest = 0;
            int totalMatchingAttrsNbest = 0;
            SGMLScorer scorer = new SGMLScorer(testDoc, keyDoc);
            for (int itag = 0; itag < this.tagsToScore.length; ++itag) {
                Vector<Annotation> sentences = testDoc.annotationsOfType("sentence");
                if (sentences == null) continue;
                for (int isent = 0; isent < sentences.size(); ++isent) {
                    Annotation sentence = sentences.get(isent);
                    Span sentenceSpan = sentence.span();
                    int bestMatchingAttrs = -1;
                    int bestTagsInDoc1 = 0;
                    for (int ihyp = 0; ihyp < this.N; ++ihyp) {
                        String hypo = "H" + isent + "-" + ihyp;
                        hypoSet.clear();
                        hypoSet.add(hypo);
                        testDoc.setActiveHypotheses(hypoSet);
                        scorer.match(this.tagsToScore[itag], this.tagsToScore[itag], sentenceSpan);
                        testDoc.setActiveHypotheses(null);
                        if (ihyp == 0) {
                            totalTagsInDoc1 += scorer.numOfTagsInDoc1;
                            totalTagsInDoc2 += scorer.numOfTagsInDoc2;
                            totalMatchingAttrs += scorer.numOfMatchingAttrs;
                        }
                        if (scorer.numOfMatchingAttrs <= bestMatchingAttrs) continue;
                        bestTagsInDoc1 = scorer.numOfTagsInDoc1;
                        bestMatchingAttrs = scorer.numOfMatchingAttrs;
                    }
                    totalTagsInDoc1Nbest += bestTagsInDoc1;
                    totalMatchingAttrsNbest += bestMatchingAttrs;
                }
            }
            System.out.println("Total tags in baseline response:    " + totalTagsInDoc1);
            System.out.println("Total tags in best of N response:   " + totalTagsInDoc1Nbest);
            System.out.println("Total tags in key:                  " + totalTagsInDoc2);
            System.out.println("Matching attributes (baseline):     " + totalMatchingAttrs);
            System.out.println("Matching attributes (best of N):    " + totalMatchingAttrsNbest);
            System.out.println("Attribute recall (baseline):        " + (float)totalMatchingAttrs / (float)totalTagsInDoc2);
            System.out.println("Attribute precision (baseline):     " + (float)totalMatchingAttrs / (float)totalTagsInDoc1);
            System.out.println("Attribute recall (best of N):       " + (float)totalMatchingAttrsNbest / (float)totalTagsInDoc2);
            System.out.println("Attribute precision (best of N):    " + (float)totalMatchingAttrsNbest / (float)totalTagsInDoc1Nbest);
            tagsInResponses += totalTagsInDoc1;
            tagsInBestResponses += totalTagsInDoc1Nbest;
            tagsInKeys += totalTagsInDoc2;
            matchingAttrs += totalMatchingAttrs;
            matchingAttrsNbest += totalMatchingAttrsNbest;
        }
        System.out.println("\nTotal baseline counts:");
        System.out.println("      matchingAttrs =   " + matchingAttrs);
        System.out.println("      tagsInKeys =      " + tagsInKeys);
        System.out.println("      tagsInResponses = " + tagsInResponses);
        System.out.println("Overall Baseline Attribute Recall:           " + (float)matchingAttrs / (float)tagsInKeys);
        System.out.println("Overall Baseline Attribute Precision:        " + (float)matchingAttrs / (float)tagsInResponses);
        System.out.println("Overall Best of N Attribute Recall:          " + (float)matchingAttrsNbest / (float)tagsInKeys);
        System.out.println("Overall Best of N Attribute Precision:       " + (float)matchingAttrsNbest / (float)tagsInBestResponses);
    }

    public static void main(String[] args) throws IOException {
        JetTest.initializeFromConfig("props/Nbest.properties");
        Ace.gazetteer = new Gazetteer();
        Ace.gazetteer.load("data/loc.dict");
        EDTtype.readTypeDict(dictFile);
        EDTtype.readGenericDict(genericFile);
        Ace.setPatternSet(patternFile);
        Pat.trace = false;
        Resolve.trace = false;
        Resolve.ACE = true;
        Ace.entityTrace = false;
        LearnRelations.relationTrace = false;
        Resolve.nameTypeMatch = true;
        XNameTagger.NbestScore();
    }

    private static void NbestScore() throws IOException {
        XNameTagger nt = new XNameTagger(WordFeatureHMMemitter.class);
        nt.annotator.setRecordProb(true);
        nt.load("acedata/ACEname04HMM.txt");
        nt.model.loadModel();
        String testCollection = "C:/Documents and Settings/Ralph Grishman/My Documents/ACE/training04 nwire 20 sgm.txt";
        String keyCollection = "C:/Documents and Settings/Ralph Grishman/My Documents/ACE/training04 nwire 20 ne.txt";
        BigramHMMemitter.useBigrams = false;
        System.out.println("\nBaseline / upper bound\n");
        nt.scoreCollectionWithOracle(testCollection, keyCollection);
        System.out.println("\nN-Best\n");
        nt.scoreCollection(testCollection, keyCollection);
    }

    private static void NbestTrain() throws IOException {
        String testCollection = "C:/Documents and Settings/Ralph Grishman/My Documents/ACE/training04 nwire 20 sgm.txt";
        String keyCollection = "C:/Documents and Settings/Ralph Grishman/My Documents/ACE/training04 nwire 20 ne.txt";
        XNameTagger nt = new XNameTagger(WordFeatureHMMemitter.class);
        nt.annotator.setRecordProb(true);
        nt.load("acedata/ACEname04HMM.txt");
        BigramHMMemitter.useBigrams = false;
        nt.NbestTrainCollection(testCollection, keyCollection);
    }

    public void NbestTrainCollection(String testCollection, String keyCollection) throws IOException {
        DocumentCollection testCol = new DocumentCollection(testCollection);
        testCol.open();
        DocumentCollection keyCol = new DocumentCollection(keyCollection);
        keyCol.open();
        for (int i = 0; i < testCol.size(); ++i) {
            ExternalDocument testDoc = testCol.get(i);
            testDoc.setSGMLtags(this.tagsToRead);
            testDoc.open();
            this.nameHMM.newDocument();
            ExternalDocument keyDoc = keyCol.get(i);
            keyDoc.setSGMLtags(this.tagsToRead);
            keyDoc.open();
            keyDoc.stretch("ENAMEX");
            System.out.println("Annotating document " + i + ": " + testDoc.fileName());
            this.NbestTrainDocument(testDoc, keyDoc);
        }
        this.model.buildModel();
        this.model.saveModel();
    }

    private void NbestTrainDocument(Document doc, Document keyDoc) {
        this.Fscore = new HashMap();
        this.corefMentionCount = new HashMap();
        this.relationCount = new HashMap();
        this.NEstring = new HashMap();
        this.relString = new HashMap();
        this.NEprob = new HashMap();
        SGMLScorer scorer = new SGMLScorer(doc, keyDoc);
        doc.annotateWithTag("TEXT");
        Vector<Annotation> textSegments = doc.annotationsOfType("TEXT");
        for (Annotation ann : textSegments) {
            Span textSpan = ann.span();
            Ace.monocase = Ace.allLowerCase(doc);
            SentenceSplitter.split(doc, textSpan);
        }
        Vector<Annotation> sentences = doc.annotationsOfType("sentence");
        ArrayList[] hypotheses = new ArrayList[sentences.size()];
        this.NEchunkNbest(doc, sentences, hypotheses, true, scorer);
        doc.setActiveHypotheses(null);
        new View(doc, 0);
        for (int isent = 0; isent < sentences.size(); ++isent) {
            String hypoi;
            int ihypo;
            System.out.println("### Analyzing hypotheses for sentence " + isent);
            this.refresNbest(doc, isent, sentences, hypotheses, this.corefMentionCount);
            this.relationNbest(doc, isent, sentences, hypotheses, this.relationCount);
            ArrayList sentenceHypotheses = hypotheses[isent];
            String hypo0 = (String)sentenceHypotheses.get(0);
            double bestFscore = -1.0;
            for (ihypo = 0; ihypo < sentenceHypotheses.size(); ++ihypo) {
                hypoi = (String)sentenceHypotheses.get(ihypo);
                Double Fscorei = this.Fscore.get(hypoi);
                bestFscore = Math.max(bestFscore, Fscorei);
            }
            for (ihypo = 0; ihypo < sentenceHypotheses.size(); ++ihypo) {
                hypoi = (String)sentenceHypotheses.get(ihypo);
                Datum d = this.rescoringFeatures(hypo0, hypoi);
                Double Fscorei = this.Fscore.get(hypoi);
                boolean best = Fscorei + 0.01 > bestFscore;
                d.setOutcome(best ? "best" : "notBest");
                this.model.addEvent(d);
            }
        }
        doc.setActiveHypotheses(null);
    }

    private Datum rescoringFeatures(String hypo0, String hypoi) {
        Datum d = new Datum();
        int bestNEprob = this.NEprob.get(hypo0);
        int baseCorefScore = this.corefMentionCount.get(hypo0);
        int baseRelationScore = this.relationCount.get(hypo0);
        Integer NEprobi = this.NEprob.get(hypoi);
        int relativeNEprob = NEprobi - bestNEprob;
        d.addFV("NEprob", Integer.toString(relativeNEprob));
        Integer corefScorei = this.corefMentionCount.get(hypoi);
        int relativeCorefScore = corefScorei - baseCorefScore;
        d.addFV("coref", Integer.toString(relativeCorefScore));
        Integer relationScorei = this.relationCount.get(hypoi);
        int relativeRelationScore = relationScorei - baseRelationScore;
        if (relativeRelationScore > 0) {
            System.out.println("reln = " + relativeRelationScore + " ------------");
            System.out.println("base: " + this.NEstring.get(hypo0));
            System.out.println("base: " + this.relString.get(hypo0));
            System.out.println("hypo: " + this.NEstring.get(hypoi));
            System.out.println("hypo: " + this.relString.get(hypoi));
        }
        d.addFV("reln", Integer.toString(relativeRelationScore));
        return d;
    }

    private Set<String> NbestTagDocument(Document doc) {
        this.corefMentionCount = new HashMap();
        this.relationCount = new HashMap();
        this.NEprob = new HashMap();
        this.NEstring = new HashMap();
        this.relString = new HashMap();
        HashSet<String> bestHypotheses = new HashSet<String>();
        doc.annotateWithTag("TEXT");
        Vector<Annotation> textSegments = doc.annotationsOfType("TEXT");
        for (Annotation ann : textSegments) {
            Span textSpan = ann.span();
            Ace.monocase = Ace.allLowerCase(doc);
            SentenceSplitter.split(doc, textSpan);
        }
        Vector<Annotation> sentences = doc.annotationsOfType("sentence");
        ArrayList[] hypotheses = new ArrayList[sentences.size()];
        this.NEchunkNbest(doc, sentences, hypotheses, false, null);
        for (int isent = 0; isent < sentences.size(); ++isent) {
            int NEprob1;
            System.out.println("### Analyzing hypotheses for sentence " + isent);
            ArrayList sentenceHypotheses = hypotheses[isent];
            String hypo0 = (String)sentenceHypotheses.get(0);
            if (sentenceHypotheses.size() == 1) {
                System.out.println("    Only one hypothesis.");
                bestHypotheses.add(hypo0);
                continue;
            }
            String hypo1 = (String)sentenceHypotheses.get(1);
            int NEprob0 = this.NEprob.get(hypo0);
            int margin = NEprob0 - (NEprob1 = this.NEprob.get(hypo1).intValue());
            if (margin > this.MARGIN_TO_SKIP_RESCORING) {
                System.out.println("    Margin = " + margin + " (no rescoring)");
                bestHypotheses.add(hypo0);
                continue;
            }
            this.refresNbest(doc, isent, sentences, hypotheses, this.corefMentionCount);
            this.relationNbest(doc, isent, sentences, hypotheses, this.relationCount);
            String bestHypo = hypo0;
            double bestScore = 0.0;
            for (int ihypo = 0; ihypo < sentenceHypotheses.size(); ++ihypo) {
                String hypoi = (String)sentenceHypotheses.get(ihypo);
                Datum d = this.rescoringFeatures(hypo0, hypoi);
                double score = this.model.prob(d, "best");
                System.out.println("    Hypothesis " + hypoi + " score " + score);
                if (!(score > bestScore)) continue;
                bestScore = score;
                bestHypo = hypoi;
            }
            bestHypotheses.add(bestHypo);
            if (bestHypo.equals(hypo0)) continue;
            System.out.println("    Picked hypothesis " + bestHypo);
        }
        doc.setActiveHypotheses(null);
        return bestHypotheses;
    }

    private void NEchunkNbest(Document doc, Vector sentences, ArrayList[] hypotheses, boolean training, SGMLScorer scorer) {
        HashSet<String> activeHypotheses = new HashSet<String>();
        for (int isent = 0; isent < sentences.size(); ++isent) {
            Annotation sentence = (Annotation)sentences.get(isent);
            Span sentenceSpan = sentence.span();
            Tokenizer.tokenize(doc, sentenceSpan);
            ArrayList allSentenceHypotheses = this.tag(doc, sentenceSpan, "H" + isent);
            ArrayList<String> sentenceHypotheses = new ArrayList<String>();
            int prob0 = 0;
            for (int ihypo = 0; ihypo < allSentenceHypotheses.size(); ++ihypo) {
                String hypothesis = (String)allSentenceHypotheses.get(ihypo);
                doc.setCurrentHypothesis(hypothesis);
                activeHypotheses.clear();
                activeHypotheses.add(hypothesis);
                doc.setActiveHypotheses(activeHypotheses);
                Vector<Annotation> NEs = doc.annotationsAt(sentenceSpan.start(), "HMMtags");
                Annotation NE = NEs.get(0);
                Integer prob = (Integer)NE.get("prob");
                if (ihypo == 0) {
                    prob0 = prob;
                } else if (prob <= prob0 - NE_PROBABILITY_WINDOW) break;
                sentenceHypotheses.add(hypothesis);
                this.NEprob.put(hypothesis, prob);
                if (training) {
                    this.Fscore.put(hypothesis, XNameTagger.scoreSentence(scorer, sentenceSpan));
                }
                Control.processSentence(doc, sentenceSpan);
            }
            hypotheses[isent] = sentenceHypotheses;
        }
    }

    static Double scoreSentence(SGMLScorer scorer, Span span) {
        scorer.match("ENAMEX", "ENAMEX", span);
        double recall = scorer.numOfTagsInDoc2 == 0 ? 1.0 : (double)scorer.numOfMatchingAttrs / (double)scorer.numOfTagsInDoc2;
        double precision = scorer.numOfTagsInDoc1 == 0 ? 1.0 : (double)scorer.numOfMatchingAttrs / (double)scorer.numOfTagsInDoc1;
        double f = 2.0 / (1.0 / recall + 1.0 / precision);
        return new Double(f);
    }

    private void refresNbest(Document doc, int isent, Vector<Annotation> sentences, ArrayList[] hypotheses, HashMap<String, Integer> corefMentionCount) {
        Annotation sentence = sentences.get(isent);
        ArrayList sentenceHypotheses = hypotheses[isent];
        HashSet<String> activeHypotheses = new HashSet<String>();
        for (int ihypo = 0; ihypo < sentenceHypotheses.size(); ++ihypo) {
            int jsent;
            String hypo = (String)sentenceHypotheses.get(ihypo);
            System.out.println("### coref for hypothesis " + hypo);
            activeHypotheses.clear();
            for (jsent = 0; jsent < sentences.size(); ++jsent) {
                if (jsent == isent) {
                    activeHypotheses.add(hypo);
                    continue;
                }
                activeHypotheses.add((String)hypotheses[jsent].get(0));
            }
            doc.setActiveHypotheses(activeHypotheses);
            doc.setCurrentHypothesis(null);
            for (jsent = 0; jsent < sentences.size(); ++jsent) {
                Annotation jsentence = sentences.get(jsent);
                Span sentenceSpan = jsentence.span();
                Resolve.references(doc, sentenceSpan);
            }
            corefMentionCount.put(hypo, new Integer(XNameTagger.corefCount(doc, sentence.span())));
            doc.removeAnnotationsOfType("entity");
        }
    }

    static int corefCount(Document doc, Span sentence) {
        Vector<Annotation> entities = doc.annotationsOfType("entity");
        int mentionCount = 0;
        for (Annotation entity : entities) {
            Vector mentions = (Vector)entity.get("mentions");
            boolean relevantEntity = false;
            for (int imention = 0; imention < mentions.size(); ++imention) {
                Annotation mention = (Annotation)mentions.get(imention);
                Annotation head = Resolve.getHeadC(mention);
                if (!mention.span().within(sentence) || head.get("cat") != "name") continue;
                relevantEntity = true;
                break;
            }
            if (!relevantEntity) continue;
            mentionCount += Math.min(mentions.size() - 2, 1);
        }
        return mentionCount;
    }

    private void relationNbest(Document doc, int isent, Vector<Annotation> sentences, ArrayList[] hypotheses, HashMap<String, Integer> relationCount) {
        Annotation sentence = sentences.get(isent);
        Span sentenceSpan = sentence.span();
        ArrayList sentenceHypotheses = hypotheses[isent];
        HashSet<String> activeHypotheses = new HashSet<String>();
        for (int ihypo = 0; ihypo < sentenceHypotheses.size(); ++ihypo) {
            String hypo = (String)sentenceHypotheses.get(ihypo);
            System.out.println("### relations for hypothesis " + hypo);
            activeHypotheses.clear();
            activeHypotheses.add(hypo);
            doc.setActiveHypotheses(activeHypotheses);
            doc.setCurrentHypothesis(null);
            Resolve.references(doc, sentenceSpan);
            AceDocument aceDoc = new AceDocument(null, null, "X", doc.text());
            Ace.buildAceEntities(doc, "X", aceDoc);
            LearnRelations.findRelations(null, doc, aceDoc);
            int count = aceDoc.relations.size();
            relationCount.put(hypo, new Integer(count));
            doc.removeAnnotationsOfType("entity");
            this.NEstring.put(hypo, doc.writeSGML("ENAMEX", sentenceSpan));
            String rs = "";
            for (int i = 0; i < aceDoc.relations.size(); ++i) {
                rs = rs + aceDoc.relations.get(i).toString();
            }
            this.relString.put(hypo, rs);
        }
    }
}

