/*
 * Decompiled with CFR 0.152.
 */
package edu.nyu.jet.lex;

import edu.nyu.jet.lex.LexicalEntry;
import edu.nyu.jet.lisp.FeatureSet;
import edu.nyu.jet.tipster.Annotation;
import edu.nyu.jet.tipster.Document;
import edu.nyu.jet.tipster.Span;
import java.util.Hashtable;
import java.util.Vector;

public class Lexicon {
    static Hashtable lexiconIndex = new Hashtable();

    public static void clear() {
        lexiconIndex.clear();
    }

    public static boolean clearEntry(String[] words) {
        String key = words[0].toLowerCase();
        if (lexiconIndex.containsKey(key)) {
            Vector entries = (Vector)lexiconIndex.get(key);
            for (int i = 0; i < entries.size(); ++i) {
                LexicalEntry entry = (LexicalEntry)entries.get(i);
                if (!entry.matches(words)) continue;
                entries.remove(i);
                return true;
            }
        }
        return false;
    }

    public static void addEntry(String[] words, FeatureSet fs) {
        Lexicon.addEntry(words, fs, "constit");
    }

    public static void addEntry(String[] words, FeatureSet fs, String type) {
        String key = words[0].toLowerCase();
        if (lexiconIndex.containsKey(key)) {
            Vector entries = (Vector)lexiconIndex.get(key);
            for (int i = 0; i < entries.size(); ++i) {
                LexicalEntry entry = (LexicalEntry)entries.get(i);
                if (!entry.matches(words)) continue;
                entry.addDefinition(fs);
                return;
            }
            entries.addElement(new LexicalEntry(words, fs, type));
        } else {
            Vector<LexicalEntry> entries = new Vector<LexicalEntry>();
            entries.addElement(new LexicalEntry(words, fs, type));
            lexiconIndex.put(key, entries);
        }
    }

    public static FeatureSet[] lookUp(String[] words) {
        String key = words[0].toLowerCase();
        if (lexiconIndex.containsKey(key)) {
            Vector entries = (Vector)lexiconIndex.get(key);
            for (int i = 0; i < entries.size(); ++i) {
                LexicalEntry entry = (LexicalEntry)entries.get(i);
                if (!entry.matches(words)) continue;
                return entry.getDefinition();
            }
        }
        return null;
    }

    public static int annotateWithDefinitions(Document doc, int posn) {
        int furthest = 0;
        FeatureSet[] definition = null;
        String type = null;
        Annotation ann = doc.tokenAt(posn);
        if (ann == null) {
            return 0;
        }
        String key = doc.text(ann).trim().toLowerCase();
        if (lexiconIndex.containsKey(key)) {
            Vector entries = (Vector)lexiconIndex.get(key);
            for (int i = 0; i < entries.size(); ++i) {
                LexicalEntry entry = (LexicalEntry)entries.get(i);
                int newposn = entry.matches(doc, posn);
                if (newposn <= 0 || newposn <= furthest) continue;
                furthest = newposn;
                definition = entry.getDefinition();
                type = entry.type;
            }
        }
        if (definition != null) {
            for (int i = 0; i < definition.length; ++i) {
                doc.annotate(type, new Span(posn, furthest), new FeatureSet((FeatureSet)definition[i]));
            }
        }
        return furthest;
    }

    public static void annotateWithDefinitions(Document doc, int start, int end) {
        int posn = start;
        while (doc.tokenAt(posn) == null) {
            if (++posn < end) continue;
            return;
        }
        while (posn < end) {
            int newposn = Lexicon.annotateWithDefinitions(doc, posn);
            if (newposn == 0) {
                Annotation ann = doc.tokenAt(posn);
                if (ann == null) {
                    return;
                }
                posn = ann.span().end();
                continue;
            }
            posn = newposn;
        }
    }
}

