/*
 * Decompiled with CFR 0.152.
 */
package edu.nyu.jet.lex;

import edu.nyu.jet.tipster.Annotation;
import edu.nyu.jet.tipster.Document;
import edu.nyu.jet.tipster.Span;
import edu.nyu.jet.util.IOUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Vector;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Stemmer {
    private static final String DICT_ENCODING = "US-ASCII";
    private static Stemmer defaultStemmer = null;
    private HashMap<String, String> dict = new HashMap();

    public static Stemmer getDefaultStemmer() {
        if (defaultStemmer == null) {
            defaultStemmer = Stemmer.loadDefaultStemmer();
        }
        return defaultStemmer;
    }

    private static Stemmer loadDefaultStemmer() {
        Stemmer stemmer;
        InputStream in = null;
        try {
            in = Stemmer.class.getClassLoader().getResourceAsStream("edu/nyu/jet/lex/stem.dict");
            InputStreamReader reader = new InputStreamReader(in, DICT_ENCODING);
            Stemmer stemmer2 = new Stemmer();
            stemmer2.loadDictionary(reader);
            stemmer = stemmer2;
        }
        catch (IOException ex) {
            try {
                ex.printStackTrace();
                throw new RuntimeException(ex);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(in);
                throw throwable;
            }
        }
        IOUtils.closeQuietly(in);
        return stemmer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadDictionary(File file) throws IOException {
        BufferedReader in = IOUtils.getBufferedReader(file, DICT_ENCODING);
        try {
            this.loadDictionary(in);
        }
        finally {
            IOUtils.closeQuietly(in);
        }
    }

    public void loadDictionary(Reader reader) throws IOException {
        String line;
        BufferedReader in = null;
        in = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
        Pattern delimiter = Pattern.compile("\\s+");
        while ((line = in.readLine()) != null) {
            String[] splitted = delimiter.split(line);
            String stem = splitted[0].intern();
            for (int i = 1; i < splitted.length; ++i) {
                this.dict.put(splitted[i].intern(), stem);
            }
        }
    }

    public void tagStem(Document doc, Span span) {
        Vector<Annotation> tokens = doc.annotationsOfType("token", span);
        Vector<String> posTags = this.getPosTags(doc, tokens);
        assert (tokens.size() == posTags.size());
        for (int i = 0; i < tokens.size(); ++i) {
            String pos;
            Annotation token = tokens.get(i);
            String word = doc.text(token).trim();
            String stem = this.getStem(word, pos = posTags.get(i));
            if (stem == word) continue;
            token.put("stem", stem);
        }
    }

    public String getStem(String word, String pos) {
        if (word.equals("I") || pos.equals("NNP") || pos.equals("NNPS")) {
            return word;
        }
        String lower = word.toLowerCase();
        boolean allLower = lower.equals(word);
        String stem = this.dict.get(lower);
        if (stem != null) {
            return stem;
        }
        if (Stemmer.any(lower, "NNS", "VBZ")) {
            return this.getStemInternal(word, lower, "s", allLower);
        }
        if (Stemmer.any(lower, "VBD", "VBN")) {
            return this.getStemInternal(word, lower, "ed", allLower);
        }
        if (lower.equals("VBG")) {
            return this.getStemInternal(word, lower, "ing", allLower);
        }
        if (!allLower) {
            return lower;
        }
        return word;
    }

    private String getStemInternal(String word, String lowerWord, String suffix, boolean allLower) {
        if (lowerWord.endsWith(suffix)) {
            return lowerWord.substring(0, lowerWord.length() - suffix.length());
        }
        if (!allLower) {
            return lowerWord;
        }
        return word;
    }

    private Vector<String> getPosTags(Document doc, Vector<Annotation> tokens) {
        Vector<String> result = new Vector<String>();
        for (Annotation token : tokens) {
            Vector<Annotation> constitList = doc.annotationsOfType("constit", token.span());
            result.add(this.getPosTag(constitList));
        }
        return result;
    }

    private String getPosTag(Vector<Annotation> constitList) {
        if (constitList == null || constitList.size() == 0) {
            return null;
        }
        if (constitList.size() == 1) {
            return ((String)constitList.get(0).get("cat")).toUpperCase();
        }
        for (Annotation constit : constitList) {
            String cat;
            Annotation[] children = (Annotation[])constit.get("children");
            if (children != null || (cat = (String)constit.get("cat")) == null) continue;
            return cat.toUpperCase();
        }
        return null;
    }

    private static boolean any(String pos, String ... candidates) {
        for (String candidate : candidates) {
            if (!pos.equals(candidate)) continue;
            return true;
        }
        return false;
    }
}

