/*
 * Decompiled with CFR 0.152.
 */
package edu.nyu.jet.lisp;

import edu.nyu.jet.lisp.Variable;
import edu.nyu.jet.pat.FeatureTest;
import edu.nyu.jet.pat.PatternSyntaxError;
import edu.nyu.jet.tipster.Annotation;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Vector;

public class FeatureSet {
    protected Vector features;
    protected Vector values;

    public FeatureSet() {
        this.features = new Vector(1);
        this.values = new Vector(1);
    }

    public FeatureSet(String feat1, Object val1) {
        this.features = new Vector(1);
        this.values = new Vector(1);
        this.features.addElement(feat1);
        this.values.addElement(val1);
    }

    public FeatureSet(String feat1, Object val1, String feat2, Object val2) {
        this.features = new Vector(2);
        this.values = new Vector(2);
        this.features.addElement(feat1);
        this.values.addElement(val1);
        this.features.addElement(feat2);
        this.values.addElement(val2);
    }

    public FeatureSet(String feat1, Object val1, String feat2, Object val2, String feat3, Object val3) {
        this.features = new Vector(2);
        this.values = new Vector(2);
        this.features.addElement(feat1);
        this.values.addElement(val1);
        this.features.addElement(feat2);
        this.values.addElement(val2);
        this.features.addElement(feat3);
        this.values.addElement(val3);
    }

    public FeatureSet(FeatureSet fs) {
        int len = fs.size();
        this.features = new Vector(len);
        this.values = new Vector(len);
        this.putAll(fs);
    }

    public FeatureSet(StreamTokenizer tok, boolean allowVariables, char endChar) throws IOException, PatternSyntaxError {
        this.features = new Vector();
        this.values = new Vector();
        tok.wordChars(95, 95);
        tok.wordChars(45, 45);
        tok.wordChars(46, 46);
        while (tok.nextToken() != endChar) {
            Object value;
            if (tok.ttype == 44 & this.features.size() > 0) {
                tok.nextToken();
            }
            if (tok.ttype != -3) {
                throw new PatternSyntaxError("feature name or " + endChar + " expected, " + tok + " found");
            }
            String feature = tok.sval.intern();
            if (tok.nextToken() == 61) {
                if (tok.nextToken() == -3) {
                    value = tok.sval.intern();
                    if (Character.isUpperCase(((String)value).charAt(0))) {
                        if (allowVariables) {
                            this.put(feature, new Variable((String)value));
                            continue;
                        }
                        this.put(feature, value);
                        continue;
                    }
                    if (value == "null") {
                        this.put(feature, null);
                        continue;
                    }
                    this.put(feature, value);
                    continue;
                }
                if (tok.ttype == 34) {
                    value = tok.sval.intern();
                    this.put(feature, value);
                    continue;
                }
                if (tok.ttype == -2) {
                    value = new Integer((int)tok.nval);
                    this.put(feature, value);
                    continue;
                }
                if (tok.ttype == 91) {
                    value = new FeatureSet(tok, allowVariables, ']');
                    this.put(feature, value);
                    continue;
                }
                throw new PatternSyntaxError("feature value expected");
            }
            if (allowVariables && tok.ttype == 63) {
                value = new FeatureTest(tok);
                this.put(feature, value);
                continue;
            }
            throw new PatternSyntaxError("= or ? expected");
        }
    }

    public void put(String feat, Object val) {
        int i = this.features.indexOf(feat);
        if (i < 0) {
            this.features.addElement(feat);
            this.values.addElement(val);
        } else {
            this.values.set(i, val);
        }
    }

    public void putAll(FeatureSet fs) {
        if (fs == null) {
            return;
        }
        Enumeration features = fs.keys();
        while (features.hasMoreElements()) {
            String feature = (String)features.nextElement();
            Object value = fs.get(feature);
            this.put(feature, value);
        }
    }

    public Object get(String feat) {
        int i = this.features.indexOf(feat);
        if (i < 0) {
            return null;
        }
        return this.values.get(i);
    }

    public void remove(String feat) {
        int i = this.features.indexOf(feat);
        if (i >= 0) {
            this.features.remove(i);
            this.values.remove(i);
        }
    }

    public boolean containsFeature(String feat) {
        return this.features.indexOf(feat) >= 0;
    }

    public boolean subsetOf(FeatureSet fs) {
        if (fs == null) {
            return false;
        }
        int len = this.features.size();
        for (int i = 0; i < len; ++i) {
            String feat = (String)this.features.get(i);
            if (!fs.containsFeature(feat)) {
                return false;
            }
            if (this.values.get(i).equals(fs.get(feat))) continue;
            return false;
        }
        return true;
    }

    public boolean equals(FeatureSet fs) {
        if (fs == null) {
            return false;
        }
        int len = this.features.size();
        if (len != fs.size()) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            String feat = (String)this.features.get(i);
            if (!fs.containsFeature(feat)) {
                return false;
            }
            if (this.values.get(i).equals(fs.get(feat))) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof FeatureSet)) {
            return false;
        }
        return this.equals((FeatureSet)obj);
    }

    public Enumeration keys() {
        return this.features.elements();
    }

    public int size() {
        return this.features.size();
    }

    public FeatureSet substitute(HashMap bindings) {
        FeatureSet fs = new FeatureSet();
        int len = this.features.size();
        for (int i = 0; i < len; ++i) {
            Object value = this.values.get(i);
            if (value instanceof Variable) {
                value = bindings.get(((Variable)value).name);
            } else if (value instanceof FeatureSet) {
                value = ((FeatureSet)value).substitute(bindings);
            }
            fs.put((String)this.features.get(i), value);
        }
        return fs;
    }

    public static FeatureSet unify(FeatureSet a, FeatureSet b) {
        FeatureSet result = new FeatureSet(a);
        if (b == null) {
            return result;
        }
        Enumeration features = b.keys();
        while (features.hasMoreElements()) {
            String feature = (String)features.nextElement();
            Object aValue = a.get(feature);
            Object bValue = b.get(feature);
            if (aValue == null) {
                result.put(feature, bValue);
                continue;
            }
            if (aValue == bValue) continue;
            return null;
        }
        return result;
    }

    public String toString() {
        return "[" + this.toSGMLString() + "]";
    }

    public String toSGMLString() {
        return this.toSGMLString(2, false, false);
    }

    public String toSGMLString(int nestingLimit, boolean useIds, boolean quoteValues) {
        int len = this.features.size();
        String result = "";
        for (int i = 0; i < len; ++i) {
            if (((String)this.features.elementAt(i)).endsWith("-1")) continue;
            if (i > 0) {
                result = result + " ";
            }
            result = quoteValues ? result + this.features.elementAt(i) + "=" + "\"" + FeatureSet.valueToString(this.values.elementAt(i), nestingLimit, useIds, quoteValues).replaceAll("\"", "\\\\\"") + "\"" : result + this.features.elementAt(i) + "=" + FeatureSet.valueToString(this.values.elementAt(i), nestingLimit, useIds, quoteValues);
        }
        return result;
    }

    private static String valueToString(Object value, int nestingLimit, boolean useIds, boolean quoteValues) {
        if (value == null) {
            return "null";
        }
        if (value instanceof Object[]) {
            StringBuffer sb = new StringBuffer("{");
            Object[] array = (Object[])value;
            for (int i = 0; i < array.length; ++i) {
                if (i > 0) {
                    sb.append(" ");
                }
                sb.append(FeatureSet.valueToString(array[i], nestingLimit, useIds, quoteValues));
            }
            sb.append("}");
            return sb.toString();
        }
        if (value instanceof Annotation) {
            Annotation ann = (Annotation)value;
            if (nestingLimit > 1) {
                return ann.toSGMLString(nestingLimit - 1, useIds, quoteValues);
            }
            if (useIds) {
                return "#" + ann.getId();
            }
            return "...";
        }
        if (value instanceof FeatureSet) {
            return ((FeatureSet)value).embeddedFStoSGMLString(nestingLimit, useIds, quoteValues);
        }
        return value.toString();
    }

    private String embeddedFStoSGMLString(int nestingLimit, boolean useIds, boolean quoteValues) {
        int len = this.features.size();
        String result = "[";
        for (int i = 0; i < len; ++i) {
            if (((String)this.features.elementAt(i)).endsWith("-1")) continue;
            if (i > 0) {
                result = result + " ";
            }
            String value = FeatureSet.valueToString(this.values.elementAt(i), nestingLimit, useIds, quoteValues);
            result = quoteValues && !value.matches("\\A[a-zA-Z]*\\z") ? result + this.features.elementAt(i) + "=" + "\"" + value.replaceAll("\"", "\\\\\"") + "\"" : result + this.features.elementAt(i) + "=" + value;
        }
        result = result + "]";
        return result;
    }

    public void prepareToMakeString(int nestingLimit) {
        int len = this.features.size();
        String result = "";
        for (int i = 0; i < len; ++i) {
            this.prepareToMakeString(this.values.elementAt(i), nestingLimit);
        }
    }

    private void prepareToMakeString(Object value, int nestingLimit) {
        if (value != null) {
            if (value instanceof Object[]) {
                Object[] array = (Object[])value;
                for (int j = 0; j < array.length; ++j) {
                    this.prepareToMakeString(array[j], nestingLimit);
                }
            } else if (value instanceof Annotation) {
                Annotation ann = (Annotation)value;
                if (nestingLimit > 1) {
                    ann.prepareToMakeString(nestingLimit - 1);
                } else {
                    ann.assignId();
                }
            }
        }
    }
}

